/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.SdkInfo;
import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Beta
class DefaultSdkInfo
extends SdkInfo {
    private static final int CLASS_COUNT = 59;
    private static final int LAYOUT_COUNT = 20;
    private static final Map<String, String> PARENTS = Maps.newHashMapWithExpectedSize((int)59);
    private static final Set<String> LAYOUTS = Sets.newHashSetWithExpectedSize((int)59);
    @NonNull
    private static final Map<String, String> INTERFACES;

    DefaultSdkInfo() {
    }

    @Nullable
    public String getParentViewName(@NonNull String string) {
        string = DefaultSdkInfo.getRawType(string);
        return PARENTS.get(string);
    }

    @Nullable
    public String getParentViewClass(@NonNull String string) {
        String string2;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((string2 = PARENTS.get(string)) == null) {
            return null;
        }
        if (string2.equals("View") || string2.equals("ViewGroup") || string2.equals("SurfaceView")) {
            return "android.view." + string2;
        }
        return "android.widget." + string2;
    }

    public boolean isSubViewOf(@NonNull String string, @NonNull String string2) {
        String string3 = DefaultSdkInfo.getRawType(string);
        String string4 = DefaultSdkInfo.getRawType(string2);
        if (string3.indexOf(46) != -1) {
            string3 = string3.substring(string3.lastIndexOf(46) + 1);
        }
        if (string4.indexOf(46) != -1) {
            string4 = string4.substring(string4.lastIndexOf(46) + 1);
        }
        if (string3.equals("View")) {
            return true;
        }
        while (!string4.equals("View")) {
            if (string3.equals(string4)) {
                return true;
            }
            if (DefaultSdkInfo.implementsInterface(string4, string)) {
                return true;
            }
            if ((string4 = PARENTS.get(string4)) != null) continue;
            return true;
        }
        return false;
    }

    private static boolean implementsInterface(String string, String string2) {
        return string2.equals(INTERFACES.get(string));
    }

    private static String getRawType(String string) {
        int n;
        if (string != null && (n = string.indexOf(60)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public boolean isLayout(@NonNull String string) {
        if (super.isLayout(string)) {
            return true;
        }
        return LAYOUTS.contains(string);
    }

    static {
        PARENTS.put("CompoundButton", "Button");
        PARENTS.put("AbsSpinner", "AdapterView");
        PARENTS.put("AbsListView", "AdapterView");
        PARENTS.put("AbsSeekBar", "AdapterView");
        PARENTS.put("AdapterView", "ViewGroup");
        PARENTS.put("ViewGroup", "View");
        PARENTS.put("TextView", "View");
        PARENTS.put("CheckedTextView", "TextView");
        PARENTS.put("RadioButton", "CompoundButton");
        PARENTS.put("Spinner", "AbsSpinner");
        PARENTS.put("ImageButton", "ImageView");
        PARENTS.put("ImageView", "View");
        PARENTS.put("EditText", "TextView");
        PARENTS.put("ProgressBar", "View");
        PARENTS.put("ToggleButton", "CompoundButton");
        PARENTS.put("ViewStub", "View");
        PARENTS.put("Button", "TextView");
        PARENTS.put("SeekBar", "AbsSeekBar");
        PARENTS.put("CheckBox", "CompoundButton");
        PARENTS.put("Switch", "CompoundButton");
        PARENTS.put("Gallery", "AbsSpinner");
        PARENTS.put("SurfaceView", "View");
        PARENTS.put("AbsoluteLayout", "ViewGroup");
        PARENTS.put("LinearLayout", "ViewGroup");
        PARENTS.put("RelativeLayout", "ViewGroup");
        PARENTS.put("ListView", "AbsListView");
        PARENTS.put("ViewSwitcher", "ViewAnimator");
        PARENTS.put("FrameLayout", "ViewGroup");
        PARENTS.put("HorizontalScrollView", "FrameLayout");
        PARENTS.put("ViewAnimator", "FrameLayout");
        PARENTS.put("TabHost", "FrameLayout");
        PARENTS.put("TableRow", "LinearLayout");
        PARENTS.put("RadioGroup", "LinearLayout");
        PARENTS.put("TabWidget", "LinearLayout");
        PARENTS.put("ExpandableListView", "ListView");
        PARENTS.put("TableLayout", "LinearLayout");
        PARENTS.put("ScrollView", "FrameLayout");
        PARENTS.put("GridView", "AbsListView");
        PARENTS.put("WebView", "AbsoluteLayout");
        PARENTS.put("AutoCompleteTextView", "EditText");
        PARENTS.put("MultiAutoCompleteTextView", "AutoCompleteTextView");
        PARENTS.put("CheckedTextView", "TextView");
        PARENTS.put("MediaController", "FrameLayout");
        PARENTS.put("SlidingDrawer", "ViewGroup");
        PARENTS.put("DialerFilter", "RelativeLayout");
        PARENTS.put("DigitalClock", "TextView");
        PARENTS.put("Chronometer", "TextView");
        PARENTS.put("ImageSwitcher", "ViewSwitcher");
        PARENTS.put("TextSwitcher", "ViewSwitcher");
        PARENTS.put("AnalogClock", "View");
        PARENTS.put("TwoLineListItem", "RelativeLayout");
        PARENTS.put("ZoomControls", "LinearLayout");
        PARENTS.put("DatePicker", "FrameLayout");
        PARENTS.put("TimePicker", "FrameLayout");
        PARENTS.put("VideoView", "SurfaceView");
        PARENTS.put("ZoomButton", "ImageButton");
        PARENTS.put("RatingBar", "AbsSeekBar");
        PARENTS.put("ViewFlipper", "ViewAnimator");
        PARENTS.put("NumberPicker", "LinearLayout");
        assert (PARENTS.size() <= 59) : PARENTS.size();
        LAYOUTS.add("TabHost");
        LAYOUTS.add("HorizontalScrollView");
        LAYOUTS.add("ViewSwitcher");
        LAYOUTS.add("TabWidget");
        LAYOUTS.add("ViewAnimator");
        LAYOUTS.add("ScrollView");
        LAYOUTS.add("GridView");
        LAYOUTS.add("TableRow");
        LAYOUTS.add("RadioGroup");
        LAYOUTS.add("ListView");
        LAYOUTS.add("ExpandableListView");
        LAYOUTS.add("MediaController");
        LAYOUTS.add("DialerFilter");
        LAYOUTS.add("ViewFlipper");
        LAYOUTS.add("SlidingDrawer");
        LAYOUTS.add("StackView");
        LAYOUTS.add("SearchView");
        LAYOUTS.add("TextSwitcher");
        LAYOUTS.add("AdapterViewFlipper");
        LAYOUTS.add("ImageSwitcher");
        assert (LAYOUTS.size() <= 20) : LAYOUTS.size();
        INTERFACES = new HashMap<String, String>(2);
        INTERFACES.put("CheckedTextView", "Checkable");
        INTERFACES.put("CompoundButton", "Checkable");
    }
}

