/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.IJavaParser;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import java.io.File;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.MethodDeclaration;
import lombok.ast.Node;

public class JavaContext
extends Context {
    public Node compilationUnit;
    public IJavaParser parser;

    public JavaContext(@NonNull LintDriver lintDriver, @NonNull Project project, @Nullable Project project2, @NonNull File file) {
        super(lintDriver, project, project2, file);
    }

    @NonNull
    public Location getLocation(@NonNull Node node) {
        if (this.parser != null) {
            return this.parser.getLocation(this, node);
        }
        return new Location(this.file, null, null);
    }

    public void report(@NonNull Issue issue, @Nullable Location location, @NonNull String string, @Nullable Object object) {
        if (this.mDriver.isSuppressed(issue, this.compilationUnit)) {
            return;
        }
        super.report(issue, location, string, object);
    }

    public void report(@NonNull Issue issue, @Nullable Node node, @Nullable Location location, @NonNull String string, @Nullable Object object) {
        if (node != null && this.mDriver.isSuppressed(issue, node)) {
            return;
        }
        super.report(issue, location, string, object);
    }

    @Nullable
    public static Node findSurroundingMethod(Node node) {
        while (node != null) {
            Class<?> clazz = node.getClass();
            if (clazz == MethodDeclaration.class || clazz == ConstructorDeclaration.class) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }
}

