/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.io.File;
import java.util.EnumSet;
import lombok.ast.AstVisitor;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Select;

public class ColorUsageDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"ResourceAsColor", (String)"Looks for calls to setColor where a resource id is passed instead of a resolved color", (String)"Methods that take a color in the form of an integer should be passed an RGB triple, not the actual color resource id. You must call `getResources().getColor(resource)` to resolve the actual color value first.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.ERROR, ColorUsageDetector.class, (EnumSet)Scope.JAVA_FILE_SCOPE);

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public boolean appliesToResourceRefs() {
        return true;
    }

    public void visitResourceReference(@NonNull JavaContext javaContext, @Nullable AstVisitor astVisitor, @NonNull Node node, @NonNull String string, @NonNull String string2, boolean bl) {
        if (string.equals("color")) {
            MethodInvocation methodInvocation;
            String string3;
            while (node.getParent() instanceof Select) {
                node = node.getParent();
            }
            if (node.getParent() instanceof MethodInvocation && (string3 = (methodInvocation = (MethodInvocation)node.getParent()).astName().astValue()).endsWith("Color") && string3.startsWith("set")) {
                javaContext.report(ISSUE, node, javaContext.getLocation(node), String.format("Should pass resolved color instead of resource id here: getResources().getColor(%1$s)", node.toString()), null);
            }
        }
    }
}

