/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectMissingPrefix
extends LayoutDetector {
    public static final Issue MISSING_NAMESPACE = Issue.create((String)"MissingPrefix", (String)"Detect XML attributes not using the Android namespace", (String)"Most Android views have attributes in the Android namespace. When referencing these attributes you *must* include the namespace prefix, or your attribute will be interpreted by `aapt` as just a custom attribute.\n\nSimilarly, in manifest files, nearly all attributes should be in the `android:` namespace.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, DetectMissingPrefix.class, EnumSet.of(Scope.MANIFEST, Scope.RESOURCE_FILE)).addAnalysisScope(Scope.MANIFEST_SCOPE).addAnalysisScope(Scope.RESOURCE_FILE_SCOPE);
    private static final Set<String> NO_PREFIX_ATTRS = new HashSet<String>();

    public boolean appliesTo(@NonNull ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.LAYOUT || resourceFolderType == ResourceFolderType.MENU || resourceFolderType == ResourceFolderType.DRAWABLE || resourceFolderType == ResourceFolderType.ANIM || resourceFolderType == ResourceFolderType.ANIMATOR || resourceFolderType == ResourceFolderType.COLOR || resourceFolderType == ResourceFolderType.INTERPOLATOR;
    }

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    public void visitAttribute(@NonNull XmlContext xmlContext, @NonNull Attr attr) {
        String string = attr.getNamespaceURI();
        if (string == null || string.isEmpty()) {
            String string2 = attr.getName();
            if (string2 == null) {
                return;
            }
            if (NO_PREFIX_ATTRS.contains(string2)) {
                return;
            }
            Element element = attr.getOwnerElement();
            if (DetectMissingPrefix.isCustomView(element) && xmlContext.getResourceFolderType() != null) {
                return;
            }
            if (string2.startsWith("xmlns:")) {
                return;
            }
            xmlContext.report(MISSING_NAMESPACE, (Node)attr, xmlContext.getLocation((Node)attr), "Attribute is missing the Android namespace prefix", null);
        } else if (!("http://schemas.android.com/apk/res/android".equals(string) || "http://schemas.android.com/tools".equals(string) || xmlContext.getResourceFolderType() != ResourceFolderType.LAYOUT || DetectMissingPrefix.isCustomView(attr.getOwnerElement()) || attr.getLocalName().startsWith("layout_") || attr.getOwnerElement().getParentNode().getNodeType() != 1 || DetectMissingPrefix.isCustomView((Element)attr.getOwnerElement().getParentNode()))) {
            xmlContext.report(MISSING_NAMESPACE, (Node)attr, xmlContext.getLocation((Node)attr), String.format("Unexpected namespace prefix \"%1$s\" found for tag %2$s", attr.getPrefix(), attr.getOwnerElement().getTagName()), null);
        }
    }

    private static boolean isCustomView(Element element) {
        String string = element.getTagName();
        if (string.equals("view")) {
            return true;
        }
        return string.indexOf(46) != -1 && !string.startsWith("android.");
    }

    static {
        NO_PREFIX_ATTRS.add("class");
        NO_PREFIX_ATTRS.add("style");
        NO_PREFIX_ATTRS.add("layout");
        NO_PREFIX_ATTRS.add("package");
        NO_PREFIX_ATTRS.add("coreApp");
    }
}

