/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.EnumSet;
import org.objectweb.asm.tree.ClassNode;

public class HandlerDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"HandlerLeak", (String)"Ensures that Handler classes do not hold on to a reference to an outer class", (String)"In Android, Handler classes should be static or leaks might occur. Messages enqueued on the application thread's MessageQueue also retain their target Handler. If the Handler is an inner class, its outer class will be retained as well. To avoid leaking the outer class, declare the Handler as a static nested class with a WeakReference to its outer class.", (Category)Category.PERFORMANCE, (int)4, (Severity)Severity.WARNING, HandlerDetector.class, (EnumSet)Scope.CLASS_FILE_SCOPE);

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void checkClass(@NonNull ClassContext classContext, @NonNull ClassNode classNode) {
        if (classNode.name.indexOf(36) == -1) {
            return;
        }
        if (classContext.getDriver().isSubclassOf(classNode, "android/os/Handler") && !LintUtils.isStaticInnerClass((ClassNode)classNode)) {
            Location location = classContext.getLocation(classNode);
            classContext.report(ISSUE, location, String.format("This Handler class should be static or leaks might occur (%1$s)", ClassContext.createSignature((String)classNode.name, null, null)), null);
        }
    }
}

