/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingClassDetector
extends LayoutDetector
implements Detector.ClassScanner {
    public static final Issue MISSING = Issue.create((String)"MissingRegistered", (String)"Ensures that classes referenced in the manifest are present in the project or libraries", (String)"If a class is referenced in the manifest, it must also exist in the project (or in one of the libraries included by the project. This check helps uncover typos in registration names, or attempts to rename or move classes without updating the manifest file properly.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, MissingClassDetector.class, EnumSet.of(Scope.MANIFEST, Scope.CLASS_FILE, Scope.JAVA_LIBRARIES, Scope.RESOURCE_FILE)).setMoreInfo("http://developer.android.com/guide/topics/manifest/manifest-intro.html");
    public static final Issue INSTANTIATABLE = Issue.create((String)"Instantiatable", (String)"Ensures that classes registered in the manifest file are instantiatable", (String)"Activities, services, broadcast receivers etc. registered in the manifest file must be \"instantiatable\" by the system, which means that the class must be public, it must have an empty public constructor, and if it's an inner class, it must be a static inner class.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, MissingClassDetector.class, (EnumSet)Scope.CLASS_FILE_SCOPE);
    public static final Issue INNERCLASS = Issue.create((String)"InnerclassSeparator", (String)"Ensures that inner classes are referenced using '$' instead of '.' in class names", (String)"When you reference an inner class in a manifest file, you must use '$' instead of '.' as the separator character, i.e. Outer$Inner instead of Outer.Inner.\n\n(If you get this warning for a class which is not actually an inner class, it's because you are using uppercase characters in your package name, which is not conventional.)", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, MissingClassDetector.class, (EnumSet)Scope.MANIFEST_SCOPE);
    private Map<String, Location.Handle> mReferencedClasses;
    private Set<String> mCustomViews;
    private boolean mHaveClasses;

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return ALL;
    }

    public boolean appliesTo(@NonNull ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.VALUES || resourceFolderType == ResourceFolderType.LAYOUT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        Object object;
        String string;
        Object object2;
        String string2 = null;
        String string3 = element.getTagName();
        ResourceFolderType resourceFolderType = xmlContext.getResourceFolderType();
        if (resourceFolderType == ResourceFolderType.VALUES) {
            if (!string3.equals("string")) {
                return;
            }
            object2 = element.getAttributeNode("name");
            if (object2 == null) {
                return;
            }
            string = object2.getValue();
            object = object2;
        } else if (resourceFolderType == ResourceFolderType.LAYOUT) {
            if (string3.indexOf(46) > 0) {
                string = string3;
                object = element;
            } else {
                if (!string3.equals("fragment") && !string3.equals("view")) return;
                object2 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (object2 == null) {
                    object2 = element.getAttributeNode("class");
                }
                if (object2 == null) {
                    return;
                }
                string = object2.getValue();
                object = object2;
            }
        } else {
            if (!"application".equals(string3) && !"activity".equals(string3) && !"service".equals(string3) && !"receiver".equals(string3) && !"provider".equals(string3)) return;
            object2 = element.getOwnerDocument().getDocumentElement();
            string2 = object2.getAttribute("package");
            Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            if (attr == null) {
                return;
            }
            string = attr.getValue();
            object = attr;
        }
        if (string.isEmpty()) {
            return;
        }
        int n = string.indexOf(46);
        if (n <= 0) {
            if (string2 == null) {
                return;
            }
            object2 = n == 0 ? string2 + string : string2 + '.' + string;
        } else {
            object2 = string;
            if (resourceFolderType == ResourceFolderType.VALUES && !SdkUtils.endsWith((CharSequence)xmlContext.file.getPath(), (CharSequence)"analytics.xml")) {
                return;
            }
        }
        String string4 = ClassContext.getInternalName((String)object2);
        if (string4.isEmpty() || string4.startsWith("android.")) {
            return;
        }
        if (!xmlContext.getProject().getReportIssues()) {
            return;
        }
        Location.Handle handle = null;
        if (!xmlContext.getDriver().isSuppressed(MISSING, (Node)element)) {
            if (this.mReferencedClasses == null) {
                this.mReferencedClasses = Maps.newHashMapWithExpectedSize((int)16);
                this.mCustomViews = Sets.newHashSetWithExpectedSize((int)8);
            }
            handle = xmlContext.parser.createLocationHandle(xmlContext, (Node)element);
            this.mReferencedClasses.put(string4, handle);
            if (resourceFolderType == ResourceFolderType.LAYOUT && !string3.equals("fragment")) {
                this.mCustomViews.add(ClassContext.getInternalName((String)string));
            }
        }
        if (string4.indexOf(36) == -1 || string2 == null) return;
        if (string.indexOf(36) == -1 && string.indexOf(46, 1) > 0) {
            boolean bl = false;
            int n2 = string2.length();
            for (int i = 0; i < n2; ++i) {
                if (!Character.isUpperCase(string2.charAt(i))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                String string5 = "Use '$' instead of '.' for inner classes (or use only lowercase letters in package names)";
                Location location = xmlContext.getLocation((Node)object);
                xmlContext.report(INNERCLASS, (Node)element, location, string5, null);
            }
        }
        if (handle == null) return;
        string4 = string4.replace('$', '/');
        this.mReferencedClasses.put(string4, handle);
    }

    public void afterCheckProject(@NonNull Context context) {
        if (!context.getProject().isLibrary() && this.mHaveClasses && this.mReferencedClasses != null && !this.mReferencedClasses.isEmpty() && context.getDriver().getScope().contains(Scope.CLASS_FILE)) {
            ArrayList<String> arrayList = new ArrayList<String>(this.mReferencedClasses.keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                Location.Handle handle = this.mReferencedClasses.get(string);
                String string2 = ClassContext.getFqcn((String)string);
                String string3 = ClassContext.getInternalName((String)string2);
                if (!string3.equals(string) ? !this.mReferencedClasses.containsKey(string3) : !this.mReferencedClasses.containsKey(string3 = string3.replace('$', '/'))) continue;
                this.mReferencedClasses.remove(string);
                if (string.startsWith("android/")) continue;
                String string4 = String.format("Class referenced in the manifest, %1$s, was not found in the project or the libraries", string2);
                Location location = handle.resolve();
                File file = location.getFile().getParentFile();
                if (file != null) {
                    String string5 = file.getName();
                    ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)string5);
                    if (resourceFolderType == ResourceFolderType.LAYOUT) {
                        string4 = String.format("Class referenced in the layout file, %1$s, was not found in the project or the libraries", string2);
                    } else if (resourceFolderType == ResourceFolderType.VALUES) {
                        string4 = String.format("Class referenced in the analytics file, %1$s, was not found in the project or the libraries", string2);
                    }
                }
                context.report(MISSING, location, string4, null);
            }
        }
    }

    public void checkClass(@NonNull ClassContext classContext, @NonNull ClassNode classNode) {
        if (!this.mHaveClasses && !classContext.isFromClassLibrary() && classContext.getProject() == classContext.getMainProject()) {
            this.mHaveClasses = true;
        }
        String string = classNode.name;
        if (this.mReferencedClasses != null && this.mReferencedClasses.containsKey(string)) {
            boolean bl = this.mCustomViews.contains(string);
            this.mReferencedClasses.remove(string);
            if ((classNode.access & 1) == 0) {
                classContext.report(INSTANTIATABLE, classContext.getLocation(classNode), String.format("This class should be public (%1$s)", ClassContext.createSignature((String)classNode.name, null, null)), null);
                return;
            }
            if (classNode.name.indexOf(36) != -1 && !LintUtils.isStaticInnerClass((ClassNode)classNode)) {
                classContext.report(INSTANTIATABLE, classContext.getLocation(classNode), String.format("This inner class should be static (%1$s)", ClassContext.createSignature((String)classNode.name, null, null)), null);
                return;
            }
            boolean bl2 = false;
            List list = classNode.methods;
            for (Object e : list) {
                MethodNode methodNode = (MethodNode)e;
                if (!methodNode.name.equals("<init>") || !methodNode.desc.equals("()V")) continue;
                if ((methodNode.access & 1) != 0) {
                    bl2 = true;
                    continue;
                }
                classContext.report(INSTANTIATABLE, classContext.getLocation(methodNode, classNode), "The default constructor must be public", null);
                bl2 = true;
            }
            if (!bl2 && !bl && !classContext.isFromClassLibrary() && classContext.getProject().getReportIssues()) {
                classContext.report(INSTANTIATABLE, classContext.getLocation(classNode), String.format("This class should provide a default constructor (a public constructor with no arguments) (%1$s)", ClassContext.createSignature((String)classNode.name, null, null)), null);
            }
        }
    }
}

