/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TitleDetector
extends ResourceXmlDetector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"MenuTitle", (String)"Ensures that all menu items supply a title", (String)"From the action bar documentation:\n\"It's important that you always define android:title for each menu item \u2014 even if you don't declare that the title appear with the action item \u2014 for three reasons:\n\n* If there's not enough room in the action bar for the action item, the menu item appears in the overflow menu and only the title appears.\n* Screen readers for sight-impaired users read the menu item's title.\n* If the action item appears with only the icon, a user can long-press the item to reveal a tool-tip that displays the action item's title.\nThe android:icon is always optional, but recommended.", (Category)Category.USABILITY, (int)5, (Severity)Severity.WARNING, TitleDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE).setMoreInfo("http://developer.android.com/guide/topics/ui/actionbar.html");

    public boolean appliesTo(@NonNull ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.MENU;
    }

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Nullable
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("item");
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "title")) {
            return;
        }
        if (xmlContext.getMainProject().getTargetSdk() < 11) {
            return;
        }
        if ("false".equals(element.getAttributeNS("http://schemas.android.com/apk/res/android", "visible"))) {
            return;
        }
        String string = "Menu items should specify a title";
        xmlContext.report(ISSUE, (Node)element, xmlContext.getLocation((Node)element), string, null);
    }
}

