/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;

public class Utf8Detector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"EnforceUTF8", (String)"Checks that all XML resource files are using UTF-8 as the file encoding", (String)"XML supports encoding in a wide variety of character sets. However, not all tools handle the XML encoding attribute correctly, and nearly all Android apps use UTF-8, so by using UTF-8 you can protect yourself against subtle bugs when using non-ASCII characters.", (Category)Category.I18N, (int)2, (Severity)Severity.WARNING, Utf8Detector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);
    private static final Pattern ENCODING_PATTERN = Pattern.compile("encoding=['\"](\\S*)['\"]");

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void visitDocument(@NonNull XmlContext xmlContext, @NonNull Document document) {
        Matcher matcher;
        int n;
        int n2;
        String string = xmlContext.getContents();
        if (string == null) {
            return;
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && (n = (int)string.charAt(n2)) != 10 && n != 13; ++n2) {
        }
        for (n = 16; n < n2 - 5; ++n) {
            if (string.charAt(n) != 'u' && string.charAt(n) != 'U' || string.charAt(n + 1) != 't' && string.charAt(n + 1) != 'T' || string.charAt(n + 2) != 'f' && string.charAt(n + 2) != 'F' || string.charAt(n + 3) != '-' && string.charAt(n + 3) != '_' || string.charAt(n + 4) != '8') continue;
            return;
        }
        n = string.lastIndexOf("encoding", n2);
        if (n != -1 && (matcher = ENCODING_PATTERN.matcher(string)).find(n)) {
            String string2 = matcher.group(1);
            Location location = Location.create((File)xmlContext.file, (String)string, (int)matcher.start(1), (int)matcher.end(1));
            xmlContext.report(ISSUE, null, location, String.format("%1$s: Not using UTF-8 as the file encoding. This can lead to subtle bugs with non-ascii characters", string2), null);
        }
    }
}

