/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.ArrayCreation;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;

public class ArrayInitializer
extends AbstractNode
implements Expression {
    private List<Position> parensPositions = new ArrayList<Position>();
    ListAccessor<Expression, ArrayInitializer> expressions = ListAccessor.of(this, Expression.class, "ArrayInitializer.expressions");

    public ArrayCreation upToArrayCreation() {
        if (!(this.getParent() instanceof ArrayCreation)) {
            return null;
        }
        ArrayCreation out = (ArrayCreation)this.getParent();
        if (out.rawInitializer() != this) {
            return null;
        }
        return out;
    }

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public RawListAccessor<Expression, ArrayInitializer> rawExpressions() {
        return this.expressions.asRaw();
    }

    public StrictListAccessor<Expression, ArrayInitializer> astExpressions() {
        return this.expressions.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.expressions.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        return this.rawExpressions().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        return this.rawExpressions().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitArrayInitializer(this)) {
            return;
        }
        for (AbstractNode child : this.expressions.asIterable()) {
            child.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public ArrayInitializer copy() {
        ArrayInitializer result = new ArrayInitializer();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        for (AbstractNode n : this.expressions.backingList()) {
            result.rawExpressions().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean needsParentheses() {
        return ExpressionMixin.needsParentheses(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

