/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.grammar;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.ast.Node;
import lombok.ast.grammar.BasicsActions;
import lombok.ast.grammar.ParserGroup;
import lombok.ast.libs.org.parboiled.BaseParser;
import lombok.ast.libs.org.parboiled.MatcherContext;
import lombok.ast.libs.org.parboiled.Rule;
import lombok.ast.libs.org.parboiled.annotations.SuppressSubnodes;
import lombok.ast.libs.org.parboiled.matchers.CharSetMatcher;
import lombok.ast.libs.org.parboiled.support.Characters;

public class BasicsParser
extends BaseParser<Node> {
    final ParserGroup group;
    final BasicsActions actions;
    static final List<String> KEYWORDS = Collections.unmodifiableList(Arrays.asList("abstract", "class", "interface", "enum", "static", "final", "volatile", "transient", "strictfp", "native", "boolean", "byte", "short", "char", "int", "long", "float", "double", "void", "null", "this", "super", "true", "false", "continue", "break", "goto", "case", "default", "instanceof", "if", "do", "while", "for", "else", "synchronized", "switch", "assert", "throw", "try", "catch", "finally", "new", "return", "throws", "extends", "implements", "import", "package", "const", "public", "private", "protected"));

    public BasicsParser(ParserGroup group) {
        this.group = group;
        this.actions = new BasicsActions(group.getSource());
    }

    public Rule optWS() {
        return this.ZeroOrMore(this.FirstOf(this.comment(), this.whitespaceChar(), new Object[0])).label("ws");
    }

    public Rule mandatoryWS() {
        return this.OneOrMore(this.FirstOf(this.comment(), this.whitespaceChar(), new Object[0])).label("ws");
    }

    public Rule testLexBreak() {
        return this.TestNot(this.identifierPart());
    }

    public Rule identifier() {
        return this.Sequence(this.identifierRaw().label("identifier"), this.actions.checkIfKeyword(this.text("identifier")), this.set(this.actions.createIdentifier(this.text("identifier"), this.node("identifier"))), this.optWS());
    }

    public Rule dotIdentifier() {
        return this.Sequence(this.Ch('.'), this.optWS(), this.identifierRaw().label("identifier"), this.actions.checkIfKeyword(this.text("identifier")), this.set(this.actions.createIdentifier(this.text("identifier"), this.node("identifier"))), this.optWS());
    }

    @SuppressSubnodes
    public Rule identifierRaw() {
        return this.Sequence(new JavaIdentifierStartMatcher(), this.ZeroOrMore(new JavaIdentifierPartMatcher()), new Object[0]);
    }

    public Rule identifierPart() {
        return new JavaIdentifierPartMatcher();
    }

    public Rule comment() {
        return this.Sequence(this.FirstOf(this.lineComment(), this.blockComment(), new Object[0]), this.actions.logComment(this.lastText()), new Object[0]);
    }

    @SuppressSubnodes
    Rule lineComment() {
        return this.Sequence(this.String("//"), this.ZeroOrMore(this.Sequence(this.TestNot(this.CharSet("\r\n")), this.Any(), new Object[0])), this.FirstOf(this.String("\r\n"), this.Ch('\r'), this.Ch('\n'), this.Test(this.Eoi())));
    }

    @SuppressSubnodes
    Rule blockComment() {
        return this.Sequence("/*", this.ZeroOrMore(this.Sequence(this.TestNot("*/"), this.Any(), new Object[0])), "*/");
    }

    @SuppressSubnodes
    Rule whitespaceChar() {
        return this.FirstOf(this.Ch(' '), this.Ch('\t'), this.Ch('\f'), this.lineTerminator());
    }

    @SuppressSubnodes
    public Rule lineTerminator() {
        return this.FirstOf(this.String("\r\n").label("\\r\\n"), this.Ch('\r').label("\\r"), this.Ch('\n').label("\\n"));
    }

    private static class JavaIdentifierStartMatcher
    extends CharSetMatcher<Node> {
        public JavaIdentifierStartMatcher() {
            super(Characters.of("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$"));
        }

        @Override
        public boolean match(MatcherContext<Node> context) {
            char current = context.getCurrentChar();
            if (Character.isJavaIdentifierStart(current)) {
                context.advanceIndex();
                context.createNode();
                return true;
            }
            return false;
        }
    }

    private static class JavaIdentifierPartMatcher
    extends CharSetMatcher<Node> {
        public JavaIdentifierPartMatcher() {
            super(Characters.of("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_$"));
        }

        @Override
        public boolean match(MatcherContext<Node> context) {
            char current = context.getCurrentChar();
            if (Character.isJavaIdentifierPart(current)) {
                context.advanceIndex();
                context.createNode();
                return true;
            }
            return false;
        }
    }
}

