/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.google.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.google.collect.EmptyImmutableList;
import lombok.ast.libs.org.parboiled.google.collect.ImmutableCollection;
import lombok.ast.libs.org.parboiled.google.collect.Lists;
import lombok.ast.libs.org.parboiled.google.collect.RegularImmutableList;
import lombok.ast.libs.org.parboiled.google.collect.SingletonImmutableList;
import lombok.ast.libs.org.parboiled.google.collect.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    public static <E> ImmutableList<E> of() {
        return EmptyImmutableList.INSTANCE;
    }

    public static <E> ImmutableList<E> of(E element) {
        return new SingletonImmutableList<E>(element);
    }

    public static <E> ImmutableList<E> of(E e1, E e2) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e1, e2));
    }

    public static <E> ImmutableList<E> of(E ... elements) {
        Preconditions.checkNotNull(elements);
        switch (elements.length) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return new SingletonImmutableList<E>(elements[0]);
            }
        }
        return new RegularImmutableList(ImmutableList.copyIntoArray(elements));
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> elements) {
        if (elements instanceof ImmutableList) {
            ImmutableList list = (ImmutableList)elements;
            return list;
        }
        if (elements instanceof Collection) {
            Collection coll = (Collection)elements;
            return ImmutableList.copyOfInternal(coll);
        }
        return ImmutableList.copyOfInternal(Lists.newArrayList(elements));
    }

    private static <E> ImmutableList<E> copyOfInternal(ArrayList<? extends E> list) {
        switch (list.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return new SingletonImmutableList<E>(list.iterator().next());
            }
        }
        return new RegularImmutableList(ImmutableList.nullChecked(list.toArray()));
    }

    private static Object[] nullChecked(Object[] array) {
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] != null) continue;
            throw new NullPointerException("at index " + i);
        }
        return array;
    }

    private static <E> ImmutableList<E> copyOfInternal(Collection<? extends E> collection) {
        int size = collection.size();
        return size == 0 ? ImmutableList.of() : ImmutableList.createFromIterable(collection, size);
    }

    ImmutableList() {
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public abstract ImmutableList<E> subList(int var1, int var2);

    @Override
    public final boolean addAll(int index, Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E remove(int index) {
        throw new UnsupportedOperationException();
    }

    private static Object[] copyIntoArray(Object ... source) {
        Object[] array = new Object[source.length];
        int index = 0;
        for (Object element : source) {
            if (element == null) {
                throw new NullPointerException("at index " + index);
            }
            array[index++] = element;
        }
        return array;
    }

    private static <E> ImmutableList<E> createFromIterable(Iterable<? extends E> source, int estimatedSize) {
        Object[] array = new Object[estimatedSize];
        int index = 0;
        for (E element : source) {
            if (index == estimatedSize) {
                estimatedSize = (estimatedSize / 2 + 1) * 3;
                array = ImmutableList.copyOf(array, estimatedSize);
            }
            if (element == null) {
                throw new NullPointerException("at index " + index);
            }
            array[index++] = element;
        }
        if (index == 0) {
            return ImmutableList.of();
        }
        if (index == 1) {
            Object element = array[0];
            return ImmutableList.of(element);
        }
        if (index != estimatedSize) {
            array = ImmutableList.copyOf(array, index);
        }
        return new RegularImmutableList(array, 0, index);
    }

    private static Object[] copyOf(Object[] oldArray, int newSize) {
        Object[] newArray = new Object[newSize];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newSize));
        return newArray;
    }
}

