/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.IJavaParser;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import java.io.File;
import java.util.List;
import lombok.ast.CompilationUnit;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.grammar.Source;

public class LombokParser
implements IJavaParser {
    public Node parseJava(@NonNull JavaContext javaContext) {
        try {
            Source source = new Source(javaContext.getContents(), javaContext.file.getName());
            List list = source.getNodes();
            List list2 = source.getProblems();
            if (list2 != null && !list2.isEmpty()) {
                javaContext.getDriver().setHasParserErrors(true);
                return null;
            }
            for (Node node : list) {
                if (!(node instanceof CompilationUnit)) continue;
                return node;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @NonNull
    public Location getLocation(@NonNull JavaContext javaContext, @NonNull Node node) {
        Position position = node.getPosition();
        return Location.create(javaContext.file, javaContext.getContents(), position.getStart(), position.getEnd());
    }

    @NonNull
    public Location.Handle createLocationHandle(@NonNull JavaContext javaContext, @NonNull Node node) {
        return new LocationHandle(javaContext.file, node);
    }

    public void dispose(@NonNull JavaContext javaContext, @NonNull Node node) {
    }

    private static class LocationHandle
    implements Location.Handle {
        private final File mFile;
        private final Node mNode;
        private Object mClientData;

        public LocationHandle(File file, Node node) {
            this.mFile = file;
            this.mNode = node;
        }

        @NonNull
        public Location resolve() {
            Position position = this.mNode.getPosition();
            return Location.create(this.mFile, null, position.getStart(), position.getEnd());
        }

        public void setClientData(@Nullable Object object) {
            this.mClientData = object;
        }

        @Nullable
        public Object getClientData() {
            return this.mClientData;
        }
    }
}

