/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.prefs.AndroidLocation;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.Navigation;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceParser;
import com.android.sdklib.devices.DeviceWriter;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.PowerType;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.State;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.utils.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceManager {
    private static final String DEVICE_PROFILES_PROP = "DeviceProfiles";
    private static final Pattern PATH_PROPERTY_PATTERN = Pattern.compile("^Extra.Path=DeviceProfiles$");
    private ILogger mLog;
    private List<Device> mVendorDevices;
    private List<Device> mUserDevices;
    private List<Device> mDefaultDevices;
    private final Object mLock = new Object();
    private final List<DevicesChangedListener> sListeners = new ArrayList<DevicesChangedListener>();
    private final String mOsSdkPath;
    public static final int USER_DEVICES = 1;
    public static final int DEFAULT_DEVICES = 2;
    public static final int VENDOR_DEVICES = 4;
    public static final int ALL_DEVICES = 7;

    public static DeviceManager createInstance(@Nullable String string, @NonNull ILogger iLogger) {
        return new DeviceManager(string, iLogger);
    }

    private DeviceManager(@Nullable String string, @NonNull ILogger iLogger) {
        this.mOsSdkPath = string;
        this.mLog = iLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(DevicesChangedListener devicesChangedListener) {
        if (devicesChangedListener != null) {
            List<DevicesChangedListener> list = this.sListeners;
            synchronized (list) {
                if (!this.sListeners.contains(devicesChangedListener)) {
                    this.sListeners.add(devicesChangedListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterListener(DevicesChangedListener devicesChangedListener) {
        List<DevicesChangedListener> list = this.sListeners;
        synchronized (list) {
            return this.sListeners.remove(devicesChangedListener);
        }
    }

    public DeviceStatus getDeviceStatus(String string, String string2, int n) {
        Device device = this.getDevice(string, string2);
        if (device == null) {
            return DeviceStatus.MISSING;
        }
        return device.hashCode() == n ? DeviceStatus.EXISTS : DeviceStatus.CHANGED;
    }

    public Device getDevice(String string, String string2) {
        this.initDevicesLists();
        for (List list : new List[]{this.mUserDevices, this.mDefaultDevices, this.mVendorDevices}) {
            if (list == null) continue;
            List list2 = list;
            for (Device device : list2) {
                if (!device.getName().equals(string) || !device.getManufacturer().equals(string2)) continue;
                return device;
            }
        }
        return null;
    }

    public List<Device> getDevices(int n) {
        this.initDevicesLists();
        ArrayList<Device> arrayList = new ArrayList<Device>();
        if (this.mUserDevices != null && (n & 1) != 0) {
            arrayList.addAll(this.mUserDevices);
        }
        if (this.mDefaultDevices != null && (n & 2) != 0) {
            arrayList.addAll(this.mDefaultDevices);
        }
        if (this.mVendorDevices != null && (n & 4) != 0) {
            arrayList.addAll(this.mVendorDevices);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private void initDevicesLists() {
        boolean bl = this.initDefaultDevices();
        bl |= this.initVendorDevices();
        if (bl |= this.initUserDevices()) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initDefaultDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDefaultDevices == null) {
                try {
                    this.mDefaultDevices = DeviceParser.parse(DeviceManager.class.getResourceAsStream("devices.xml"));
                    return true;
                }
                catch (IllegalStateException illegalStateException) {
                    this.mLog.error(illegalStateException, null, new Object[0]);
                    this.mDefaultDevices = new ArrayList<Device>();
                }
                catch (Exception exception) {
                    this.mLog.error(null, "Error reading default devices", new Object[0]);
                    this.mDefaultDevices = new ArrayList<Device>();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initVendorDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVendorDevices == null) {
                this.mVendorDevices = new ArrayList<Device>();
                if (this.mOsSdkPath != null) {
                    File file = new File(this.mOsSdkPath, SdkConstants.OS_SDK_TOOLS_LIB_FOLDER + File.separator + "devices.xml");
                    if (file.isFile()) {
                        this.mVendorDevices.addAll(this.loadDevices(file));
                    }
                    File file2 = new File(this.mOsSdkPath, "extras");
                    List<File> list = this.getExtraDirs(file2);
                    for (File file3 : list) {
                        File file4 = new File(file3, "devices.xml");
                        if (!file4.isFile()) continue;
                        this.mVendorDevices.addAll(this.loadDevices(file4));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initUserDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.mUserDevices = new ArrayList<Device>();
                File file = null;
                try {
                    file = new File(AndroidLocation.getFolder(), "devices.xml");
                    if (file.exists()) {
                        this.mUserDevices.addAll(DeviceParser.parse(file));
                        return true;
                    }
                }
                catch (AndroidLocation.AndroidLocationException androidLocationException) {
                    this.mLog.warning("Couldn't load user devices: %1$s", androidLocationException.getMessage());
                }
                catch (SAXException sAXException) {
                    if (file != null) {
                        String string = file.getAbsoluteFile() + ".old";
                        File file2 = new File(string);
                        int n = 0;
                        while (file2.exists()) {
                            file2 = new File(string + '.' + n++);
                        }
                        this.mLog.error(null, "Error parsing %1$s, backing up to %2$s", file.getAbsolutePath(), file2.getAbsolutePath());
                        file.renameTo(file2);
                    }
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    this.mLog.error(null, "Error parsing %1$s", file == null ? "(null)" : file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    this.mLog.error(null, "Error parsing %1$s", file == null ? "(null)" : file.getAbsolutePath());
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserDevice(Device device) {
        boolean bl = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
                assert (this.mUserDevices != null);
            }
            if (this.mUserDevices != null) {
                this.mUserDevices.add(device);
            }
            bl = true;
        }
        if (bl) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserDevice(Device device) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
                assert (this.mUserDevices != null);
            }
            if (this.mUserDevices != null) {
                Iterator<Device> iterator = this.mUserDevices.iterator();
                while (iterator.hasNext()) {
                    Device device2 = iterator.next();
                    if (!device2.getName().equals(device.getName()) || !device2.getManufacturer().equals(device.getManufacturer())) continue;
                    iterator.remove();
                    this.notifyListeners();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceUserDevice(Device device) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
            }
            this.removeUserDevice(device);
            this.addUserDevice(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserDevices() {
        if (this.mUserDevices == null) {
            return;
        }
        File file = null;
        try {
            file = new File(AndroidLocation.getFolder(), "devices.xml");
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            this.mLog.warning("Couldn't find user directory: %1$s", androidLocationException.getMessage());
            return;
        }
        if (this.mUserDevices.size() == 0) {
            file.delete();
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices.size() > 0) {
                try {
                    DeviceWriter.writeToXml(new FileOutputStream(file), this.mUserDevices);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.mLog.warning("Couldn't open file: %1$s", fileNotFoundException.getMessage());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    this.mLog.warning("Error writing file: %1$s", parserConfigurationException.getMessage());
                }
                catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                    this.mLog.warning("Error writing file: %1$s", transformerFactoryConfigurationError.getMessage());
                }
                catch (TransformerException transformerException) {
                    this.mLog.warning("Error writing file: %1$s", transformerException.getMessage());
                }
            }
        }
    }

    public static Map<String, String> getHardwareProperties(State state) {
        Hardware hardware = state.getHardware();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("hw.mainKeys", DeviceManager.getBooleanVal(hardware.getButtonType().equals((Object)ButtonType.HARD)));
        hashMap.put("hw.trackBall", DeviceManager.getBooleanVal(hardware.getNav().equals(Navigation.TRACKBALL)));
        hashMap.put("hw.keyboard", DeviceManager.getBooleanVal(hardware.getKeyboard().equals(Keyboard.QWERTY)));
        hashMap.put("hw.dPad", DeviceManager.getBooleanVal(hardware.getNav().equals(Navigation.DPAD)));
        Set<Sensor> set = hardware.getSensors();
        hashMap.put("hw.gps", DeviceManager.getBooleanVal(set.contains((Object)Sensor.GPS)));
        hashMap.put("hw.battery", DeviceManager.getBooleanVal(hardware.getChargeType().equals((Object)PowerType.BATTERY)));
        hashMap.put("hw.accelerometer", DeviceManager.getBooleanVal(set.contains((Object)Sensor.ACCELEROMETER)));
        hashMap.put("hw.sensors.orientation", DeviceManager.getBooleanVal(set.contains((Object)Sensor.GYROSCOPE)));
        hashMap.put("hw.audioInput", DeviceManager.getBooleanVal(hardware.hasMic()));
        hashMap.put("hw.sdCard", DeviceManager.getBooleanVal(hardware.getRemovableStorage().size() > 0));
        hashMap.put("hw.lcd.density", Integer.toString(hardware.getScreen().getPixelDensity().getDpiValue()));
        hashMap.put("hw.sensors.proximity", DeviceManager.getBooleanVal(set.contains((Object)Sensor.PROXIMITY_SENSOR)));
        return hashMap;
    }

    public static Map<String, String> getHardwareProperties(Device device) {
        Map<String, String> map = DeviceManager.getHardwareProperties(device.getDefaultState());
        for (State state : device.getAllStates()) {
            if (!state.getKeyState().equals(KeyboardState.HIDDEN)) continue;
            map.put("hw.keyboard.lid", DeviceManager.getBooleanVal(true));
        }
        map.put("hw.device.hash", Integer.toString(device.hashCode()));
        map.put("hw.device.name", device.getName());
        map.put("hw.device.manufacturer", device.getManufacturer());
        return map;
    }

    private static String getBooleanVal(boolean bl) {
        if (bl) {
            return HardwareProperties.BOOLEAN_VALUES[0];
        }
        return HardwareProperties.BOOLEAN_VALUES[1];
    }

    private Collection<Device> loadDevices(File file) {
        try {
            return DeviceParser.parse(file);
        }
        catch (SAXException sAXException) {
            this.mLog.error(null, "Error parsing %1$s", file.getAbsolutePath());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.mLog.error(null, "Error parsing %1$s", file.getAbsolutePath());
        }
        catch (IOException iOException) {
            this.mLog.error(null, "Error reading %1$s", file.getAbsolutePath());
        }
        catch (IllegalStateException illegalStateException) {
            this.mLog.error(illegalStateException, null, new Object[0]);
        }
        return new ArrayList<Device>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        List<DevicesChangedListener> list = this.sListeners;
        synchronized (list) {
            for (DevicesChangedListener devicesChangedListener : this.sListeners) {
                devicesChangedListener.onDevicesChanged();
            }
        }
    }

    private List<File> getExtraDirs(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file != null && file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (!file2.isDirectory()) continue;
                for (File file3 : file2.listFiles()) {
                    if (!file3.isDirectory() || !this.isDevicesExtra(file3)) continue;
                    arrayList.add(file3);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDevicesExtra(File file) {
        File file2 = new File(file, "source.properties");
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            try {
                String string;
                Matcher matcher;
                do {
                    if ((string = bufferedReader.readLine()) == null) return false;
                } while (!(matcher = PATH_PROPERTY_PATTERN.matcher(string)).matches());
                boolean bl = true;
                return bl;
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static interface DevicesChangedListener {
        public void onDevicesChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeviceStatus {
        EXISTS,
        CHANGED,
        MISSING;

    }
}

