/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.annotations.Nullable;
import com.android.dvlib.DeviceSchema;
import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.BluetoothProfile;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Camera;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Meta;
import com.android.sdklib.devices.Multitouch;
import com.android.sdklib.devices.Network;
import com.android.sdklib.devices.PowerType;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.ScreenType;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.sdklib.devices.Storage;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceParser {
    private static final SAXParserFactory sParserFactory = SAXParserFactory.newInstance();

    public static List<Device> parse(File file) throws SAXException, ParserConfigurationException, IOException {
        SAXParser sAXParser = DeviceParser.getParser();
        DeviceHandler deviceHandler = new DeviceHandler(file.getAbsoluteFile().getParentFile());
        sAXParser.parse(file, (DefaultHandler)deviceHandler);
        return deviceHandler.getDevices();
    }

    public static List<Device> parse(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        SAXParser sAXParser = DeviceParser.getParser();
        DeviceHandler deviceHandler = new DeviceHandler(null);
        sAXParser.parse(inputStream, (DefaultHandler)deviceHandler);
        return deviceHandler.getDevices();
    }

    private static SAXParser getParser() throws ParserConfigurationException, SAXException {
        sParserFactory.setSchema(DeviceSchema.getSchema());
        return sParserFactory.newSAXParser();
    }

    static {
        sParserFactory.setNamespaceAware(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeviceHandler
    extends DefaultHandler {
        private static final String sSpaceRegex = "[\\s]+";
        private final List<Device> mDevices = new ArrayList<Device>();
        private final StringBuilder mStringAccumulator = new StringBuilder();
        private final File mParentFolder;
        private Meta mMeta;
        private Hardware mHardware;
        private Software mSoftware;
        private State mState;
        private Device.Builder mBuilder;
        private Camera mCamera;
        private Storage.Unit mUnit;

        public DeviceHandler(@Nullable File file) {
            this.mParentFolder = file;
        }

        public List<Device> getDevices() {
            return this.mDevices;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("device".equals(string2)) {
                this.mMeta = null;
                this.mHardware = null;
                this.mSoftware = null;
                this.mState = null;
                this.mCamera = null;
                this.mBuilder = new Device.Builder();
            } else if ("meta".equals(string2)) {
                this.mMeta = new Meta();
            } else if ("hardware".equals(string2)) {
                this.mHardware = new Hardware();
            } else if ("software".equals(string2)) {
                this.mSoftware = new Software();
            } else if ("state".equals(string2)) {
                this.mState = new State();
                this.mHardware = this.mHardware.deepCopy();
                String string4 = attributes.getValue("default");
                if ("true".equals(string4) || "1".equals(string4)) {
                    this.mState.setDefaultState(true);
                }
                this.mState.setName(attributes.getValue("name").trim());
            } else if ("camera".equals(string2)) {
                this.mCamera = new Camera();
            } else if ("ram".equals(string2) || "internal-storage".equals(string2) || "removable-storage".equals(string2)) {
                this.mUnit = Storage.Unit.getEnum(attributes.getValue("unit"));
            } else if ("frame".equals(string2)) {
                this.mMeta.setFrameOffsetLandscape(new Point());
                this.mMeta.setFrameOffsetPortrait(new Point());
            } else if ("screen".equals(string2)) {
                this.mHardware.setScreen(new Screen());
            }
            this.mStringAccumulator.setLength(0);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.mStringAccumulator.append(cArray, n, n2);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("device".equals(string2)) {
                this.mDevices.add(this.mBuilder.build());
            } else if ("name".equals(string2)) {
                this.mBuilder.setName(this.getString(this.mStringAccumulator));
            } else if ("manufacturer".equals(string2)) {
                this.mBuilder.setManufacturer(this.getString(this.mStringAccumulator));
            } else if ("meta".equals(string2)) {
                this.mBuilder.setMeta(this.mMeta);
            } else if ("software".equals(string2)) {
                this.mBuilder.addSoftware(this.mSoftware);
            } else if ("state".equals(string2)) {
                this.mState.setHardware(this.mHardware);
                this.mBuilder.addState(this.mState);
            } else if ("sixty-four".equals(string2)) {
                this.mMeta.setIconSixtyFour(new File(this.mParentFolder, this.getString(this.mStringAccumulator)));
            } else if ("sixteen".equals(string2)) {
                this.mMeta.setIconSixteen(new File(this.mParentFolder, this.getString(this.mStringAccumulator)));
            } else if ("path".equals(string2)) {
                this.mMeta.setFrame(new File(this.mParentFolder, this.mStringAccumulator.toString().trim()));
            } else if ("portrait-x-offset".equals(string2)) {
                this.mMeta.getFrameOffsetPortrait().x = this.getInteger(this.mStringAccumulator);
            } else if ("portrait-y-offset".equals(string2)) {
                this.mMeta.getFrameOffsetPortrait().y = this.getInteger(this.mStringAccumulator);
            } else if ("landscape-x-offset".equals(string2)) {
                this.mMeta.getFrameOffsetLandscape().x = this.getInteger(this.mStringAccumulator);
            } else if ("landscape-y-offset".equals(string2)) {
                this.mMeta.getFrameOffsetLandscape().y = this.getInteger(this.mStringAccumulator);
            } else if ("screen-size".equals(string2)) {
                this.mHardware.getScreen().setSize(ScreenSize.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("diagonal-length".equals(string2)) {
                this.mHardware.getScreen().setDiagonalLength(this.getDouble(this.mStringAccumulator));
            } else if ("pixel-density".equals(string2)) {
                this.mHardware.getScreen().setPixelDensity(Density.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("screen-ratio".equals(string2)) {
                this.mHardware.getScreen().setRatio(ScreenRatio.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("x-dimension".equals(string2)) {
                this.mHardware.getScreen().setXDimension(this.getInteger(this.mStringAccumulator));
            } else if ("y-dimension".equals(string2)) {
                this.mHardware.getScreen().setYDimension(this.getInteger(this.mStringAccumulator));
            } else if ("xdpi".equals(string2)) {
                this.mHardware.getScreen().setXdpi(this.getDouble(this.mStringAccumulator));
            } else if ("ydpi".equals(string2)) {
                this.mHardware.getScreen().setYdpi(this.getDouble(this.mStringAccumulator));
            } else if ("multitouch".equals(string2)) {
                this.mHardware.getScreen().setMultitouch(Multitouch.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("mechanism".equals(string2)) {
                this.mHardware.getScreen().setMechanism(TouchScreen.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("screen-type".equals(string2)) {
                this.mHardware.getScreen().setScreenType(ScreenType.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("networking".equals(string2)) {
                for (String string4 : this.getStringList(this.mStringAccumulator)) {
                    Network network = Network.getEnum(string4);
                    if (network == null) continue;
                    this.mHardware.addNetwork(network);
                }
            } else if ("sensors".equals(string2)) {
                for (String string5 : this.getStringList(this.mStringAccumulator)) {
                    Sensor sensor = Sensor.getEnum(string5);
                    if (sensor == null) continue;
                    this.mHardware.addSensor(sensor);
                }
            } else if ("mic".equals(string2)) {
                this.mHardware.setHasMic(this.getBool(this.mStringAccumulator));
            } else if ("camera".equals(string2)) {
                this.mHardware.addCamera(this.mCamera);
                this.mCamera = null;
            } else if ("location".equals(string2)) {
                this.mCamera.setLocation(CameraLocation.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("autofocus".equals(string2)) {
                this.mCamera.setFlash(this.getBool(this.mStringAccumulator));
            } else if ("flash".equals(string2)) {
                this.mCamera.setFlash(this.getBool(this.mStringAccumulator));
            } else if ("keyboard".equals(string2)) {
                this.mHardware.setKeyboard(Keyboard.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("nav".equals(string2)) {
                this.mHardware.setNav(Navigation.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("ram".equals(string2)) {
                int n = this.getInteger(this.mStringAccumulator);
                this.mHardware.setRam(new Storage(n, this.mUnit));
            } else if ("buttons".equals(string2)) {
                this.mHardware.setButtonType(ButtonType.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("internal-storage".equals(string2)) {
                for (String string6 : this.getStringList(this.mStringAccumulator)) {
                    int n = Integer.parseInt(string6);
                    this.mHardware.addInternalStorage(new Storage(n, this.mUnit));
                }
            } else if ("removable-storage".equals(string2)) {
                for (String string7 : this.getStringList(this.mStringAccumulator)) {
                    if (string7 == null || string7.isEmpty()) continue;
                    int n = Integer.parseInt(string7);
                    this.mHardware.addRemovableStorage(new Storage(n, this.mUnit));
                }
            } else if ("cpu".equals(string2)) {
                this.mHardware.setCpu(this.getString(this.mStringAccumulator));
            } else if ("gpu".equals(string2)) {
                this.mHardware.setGpu(this.getString(this.mStringAccumulator));
            } else if ("abi".equals(string2)) {
                for (String string8 : this.getStringList(this.mStringAccumulator)) {
                    Abi abi = Abi.getEnum(string8);
                    if (abi == null) continue;
                    this.mHardware.addSupportedAbi(abi);
                }
            } else if ("dock".equals(string2)) {
                for (String string9 : this.getStringList(this.mStringAccumulator)) {
                    UiMode uiMode = UiMode.getEnum(string9);
                    if (uiMode == null) continue;
                    this.mHardware.addSupportedUiMode(uiMode);
                }
            } else if ("power-type".equals(string2)) {
                this.mHardware.setChargeType(PowerType.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("api-level".equals(string2)) {
                String string10 = this.getString(this.mStringAccumulator);
                if (string10.charAt(0) == '-') {
                    if (string10.length() == 1) {
                        this.mSoftware.setMinSdkLevel(0);
                        this.mSoftware.setMaxSdkLevel(Integer.MAX_VALUE);
                    } else {
                        string10 = string10.substring(1).trim();
                        this.mSoftware.setMinSdkLevel(0);
                        this.mSoftware.setMaxSdkLevel(Integer.parseInt(string10));
                    }
                } else {
                    int n = string10.indexOf(45);
                    if (n > 0) {
                        if (n == string10.length() - 1) {
                            string10 = string10.substring(0, string10.length() - 1).trim();
                            this.mSoftware.setMinSdkLevel(Integer.parseInt(string10));
                            this.mSoftware.setMaxSdkLevel(Integer.MAX_VALUE);
                        } else {
                            String string11 = string10.substring(0, n).trim();
                            String string12 = string10.substring(n + 1);
                            this.mSoftware.setMinSdkLevel(Integer.parseInt(string11));
                            this.mSoftware.setMaxSdkLevel(Integer.parseInt(string12));
                        }
                    } else {
                        int n2 = Integer.parseInt(string10);
                        this.mSoftware.setMinSdkLevel(n2);
                        this.mSoftware.setMaxSdkLevel(n2);
                    }
                }
            } else if ("live-wallpaper-support".equals(string2)) {
                this.mSoftware.setLiveWallpaperSupport(this.getBool(this.mStringAccumulator));
            } else if ("bluetooth-profiles".equals(string2)) {
                for (String string13 : this.getStringList(this.mStringAccumulator)) {
                    BluetoothProfile bluetoothProfile = BluetoothProfile.getEnum(string13);
                    if (bluetoothProfile == null) continue;
                    this.mSoftware.addBluetoothProfile(bluetoothProfile);
                }
            } else if ("gl-version".equals(string2)) {
                this.mSoftware.setGlVersion(this.getString(this.mStringAccumulator));
            } else if ("gl-extensions".equals(string2)) {
                this.mSoftware.addAllGlExtensions(this.getStringList(this.mStringAccumulator));
            } else if ("description".equals(string2)) {
                this.mState.setDescription(this.getString(this.mStringAccumulator));
            } else if ("screen-orientation".equals(string2)) {
                this.mState.setOrientation(ScreenOrientation.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("keyboard-state".equals(string2)) {
                this.mState.setKeyState(KeyboardState.getEnum(this.getString(this.mStringAccumulator)));
            } else if ("nav-state".equals(string2)) {
                String string14 = this.getString(this.mStringAccumulator);
                if (string14.equals("nonav")) {
                    this.mState.setNavState(NavigationState.HIDDEN);
                } else {
                    this.mState.setNavState(NavigationState.getEnum(this.getString(this.mStringAccumulator)));
                }
            } else if ("status-bar".equals(string2)) {
                this.mSoftware.setStatusBar(this.getBool(this.mStringAccumulator));
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }

        private List<String> getStringList(StringBuilder stringBuilder) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.getString(this.mStringAccumulator).split(sSpaceRegex)) {
                if (string == null || string.isEmpty()) continue;
                arrayList.add(string.trim());
            }
            return arrayList;
        }

        private Boolean getBool(StringBuilder stringBuilder) {
            String string = this.getString(stringBuilder);
            return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1");
        }

        private double getDouble(StringBuilder stringBuilder) {
            return Double.parseDouble(this.getString(stringBuilder));
        }

        private String getString(StringBuilder stringBuilder) {
            return stringBuilder.toString().trim();
        }

        private int getInteger(StringBuilder stringBuilder) {
            return Integer.parseInt(this.getString(stringBuilder));
        }
    }
}

