/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.SdkConstants;
import com.android.sdklib.internal.repository.ITaskMonitor;
import java.io.File;
import java.io.IOException;

public class AdbWrapper {
    private final String mAdbOsLocation;
    private final ITaskMonitor mMonitor;

    public AdbWrapper(String string, ITaskMonitor iTaskMonitor) {
        this.mMonitor = iTaskMonitor;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        this.mAdbOsLocation = string + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.FN_ADB;
    }

    private void display(String string, Object ... objectArray) {
        this.mMonitor.log(string, objectArray);
    }

    private void displayError(String string, Object ... objectArray) {
        this.mMonitor.logError(string, objectArray);
    }

    public synchronized boolean startAdb() {
        if (this.mAdbOsLocation == null) {
            this.displayError("Error: missing path to ADB.", new Object[0]);
            return false;
        }
        int n = -1;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(this.mAdbOsLocation, "start-server");
            Process process = processBuilder.start();
            n = process.waitFor();
        }
        catch (IOException iOException) {
            this.displayError("Unable to run 'adb': %1$s.", iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            this.displayError("Unable to run 'adb': %1$s.", interruptedException.getMessage());
        }
        if (n != 0) {
            this.displayError(String.format("Starting ADB server failed (code %d).", n), new Object[0]);
            return false;
        }
        this.display("Starting ADB server succeeded.", new Object[0]);
        return true;
    }

    public synchronized boolean stopAdb() {
        if (this.mAdbOsLocation == null) {
            this.displayError("Error: missing path to ADB.", new Object[0]);
            return false;
        }
        int n = -1;
        try {
            String[] stringArray = new String[]{this.mAdbOsLocation, "kill-server"};
            Process process = Runtime.getRuntime().exec(stringArray);
            n = process.waitFor();
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (n != 0 && n != 1) {
            this.displayError(String.format("Stopping ADB server failed (code %d).", n), new Object[0]);
            return false;
        }
        this.display("Stopping ADB server succeeded.", new Object[0]);
        return true;
    }
}

