/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.internal.repository.CanceledByUserException;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.UserCredentials;
import com.android.utils.Pair;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UrlOpener {
    private static final boolean DEBUG = System.getenv("ANDROID_DEBUG_URL_OPENER") != null;
    private static Map<String, UserCredentials> sRealmCache = new HashMap<String, UserCredentials>();
    private static int sConnectionTimeoutMs;
    private static int sSocketTimeoutMs;

    private UrlOpener() {
    }

    @NonNull
    static Pair<InputStream, HttpResponse> openUrl(@NonNull String string, boolean bl, @NonNull ITaskMonitor iTaskMonitor, @Nullable Header[] headerArray) throws IOException, CanceledByUserException {
        InputStream inputStream;
        Pair<InputStream, Object> pair;
        block18: {
            Throwable throwable = null;
            pair = null;
            try {
                pair = UrlOpener.openWithHttpClient(string, iTaskMonitor, headerArray);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IOException("Unknown Host " + unknownHostException.getMessage(), unknownHostException);
            }
            catch (ClientProtocolException clientProtocolException) {
                throwable = clientProtocolException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (CanceledByUserException canceledByUserException) {
                throw canceledByUserException;
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.out.printf("[HttpClient Error] %s : %s\n", string, exception.toString());
                }
                throwable = exception;
            }
            if (throwable != null) {
                try {
                    pair = UrlOpener.openWithUrl(string, headerArray);
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    if (!DEBUG || throwable.equals(exception)) break block18;
                    System.out.printf("[Url Error] %s : %s\n", string, exception.toString());
                }
            }
        }
        if (pair != null && bl && (inputStream = pair.getFirst()) != null && !inputStream.markSupported()) {
            try {
                InputStream inputStream2 = UrlOpener.toByteArrayInputStream(inputStream);
                if (inputStream2 != null) {
                    pair = Pair.of(inputStream2, pair.getSecond());
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pair == null) {
            inputStream = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 0), 420, "");
            pair = Pair.of(null, inputStream);
        }
        return pair;
    }

    private static InputStream toByteArrayInputStream(InputStream inputStream) throws IOException {
        int n;
        int n2 = 4096;
        int n3 = 0;
        byte[] byArray = new byte[n2];
        while ((n = inputStream.read(byArray, n3, byArray.length - n3)) != -1) {
            if ((n3 += n) != byArray.length) continue;
            byte[] byArray2 = new byte[n3 + n2];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            byArray = byArray2;
        }
        return new ByteArrayInputStream(byArray, 0, n3);
    }

    private static Pair<InputStream, HttpResponse> openWithUrl(String string, Header[] headerArray) throws IOException {
        BufferedInputStream bufferedInputStream;
        int n;
        URLConnection uRLConnection;
        URL uRL;
        block6: {
            uRL = new URL(string);
            uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(sConnectionTimeoutMs);
            uRLConnection.setReadTimeout(sSocketTimeoutMs);
            if (headerArray != null) {
                for (Header object2 : headerArray) {
                    uRLConnection.setRequestProperty(object2.getName(), object2.getValue());
                }
            }
            n = 200;
            if (uRLConnection instanceof HttpURLConnection) {
                n = ((HttpURLConnection)uRLConnection).getResponseCode();
            }
            bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            }
            catch (Exception exception) {
                if (bufferedInputStream != null || n != 200) break block6;
                n = 404;
            }
        }
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(new ProtocolVersion(uRL.getProtocol(), 1, 0), n, "");
        Map<String, List<String>> map = uRLConnection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            List<String> list;
            String string2 = entry.getKey();
            if (string2 == null || (list = entry.getValue()).isEmpty()) continue;
            basicHttpResponse.setHeader(string2, list.get(0));
        }
        return Pair.of(bufferedInputStream, basicHttpResponse);
    }

    @NonNull
    private static Pair<InputStream, HttpResponse> openWithHttpClient(@NonNull String string, @NonNull ITaskMonitor iTaskMonitor, Header[] proxySelectorRoutePlanner) throws IOException, ClientProtocolException, CanceledByUserException {
        Object object2;
        UserCredentials userCredentials = null;
        String string2 = null;
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)sConnectionTimeoutMs);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)sSocketTimeoutMs);
        final DefaultHttpClient defaultHttpClient = new DefaultHttpClient((HttpParams)basicHttpParams);
        BasicHttpContext basicHttpContext = new BasicHttpContext();
        HttpGet httpGet = new HttpGet(string);
        if (proxySelectorRoutePlanner != null) {
            for (Object object2 : proxySelectorRoutePlanner) {
                httpGet.addHeader((Header)object2);
            }
        }
        ProxySelectorRoutePlanner proxySelectorRoutePlanner2 = new ProxySelectorRoutePlanner(defaultHttpClient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        defaultHttpClient.setRoutePlanner((HttpRoutePlanner)proxySelectorRoutePlanner2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Basic");
        arrayList.add("Digest");
        arrayList.add("NTLM");
        defaultHttpClient.getParams().setParameter("http.auth.proxy-scheme-pref", arrayList);
        defaultHttpClient.getParams().setParameter("http.auth.target-scheme-pref", arrayList);
        if (DEBUG) {
            try {
                URI uRI = new URI(string);
                object2 = proxySelectorRoutePlanner2.getProxySelector();
                if (object2 != null && uRI.getScheme().startsWith("httP")) {
                    List<Proxy> list = ((ProxySelector)object2).select(uRI);
                    System.out.printf("SdkLib.UrlOpener:\n  Connect to: %s\n  Proxy List: %s\n", string, list == null ? "(null)" : Arrays.toString(list.toArray()));
                }
            }
            catch (Exception exception) {
                System.out.printf("SdkLib.UrlOpener: Failed to get proxy info for %s: %s\n", string, exception.toString());
            }
        }
        int n = 1;
        while (n != 0) {
            Object object3;
            Object object4;
            AuthScope authScope;
            object2 = defaultHttpClient.execute((HttpUriRequest)httpGet, (HttpContext)basicHttpContext);
            int n2 = object2.getStatusLine().getStatusCode();
            if (DEBUG) {
                System.out.printf("  Status: %d\n", n2);
            }
            AuthState authState = null;
            if (n2 == 401) {
                authState = (AuthState)basicHttpContext.getAttribute("http.auth.target-scope");
            }
            if (n2 == 407) {
                authState = (AuthState)basicHttpContext.getAttribute("http.auth.proxy-scope");
            }
            if ((n2 == 200 || n2 == 304) && string2 != null && userCredentials != null) {
                sRealmCache.put(string2, userCredentials);
            }
            if (authState != null) {
                authScope = authState.getAuthScope();
                if (string2 != null && !string2.equals(authScope.getRealm())) {
                    sRealmCache.put(string2, userCredentials);
                }
                if (sRealmCache.containsKey(string2 = authScope.getRealm())) {
                    userCredentials = sRealmCache.get(string2);
                } else {
                    userCredentials = iTaskMonitor.displayLoginCredentialsPrompt("Site Authentication", "Please login to the following domain: " + string2 + "\n\nServer requiring authentication:\n" + authScope.getHost());
                    if (userCredentials == null) {
                        throw new CanceledByUserException("User canceled login dialog.");
                    }
                }
                object4 = userCredentials.getUserName();
                object3 = userCredentials.getPassword();
                String string3 = userCredentials.getWorkstation();
                String string4 = userCredentials.getDomain();
                if (object4 != null && ((String)object4).length() > 0) {
                    NTCredentials nTCredentials = new NTCredentials((String)object4, (String)object3, string3, string4);
                    defaultHttpClient.getCredentialsProvider().setCredentials(authScope, (Credentials)nTCredentials);
                    n = 1;
                } else {
                    n = 0;
                }
            } else {
                n = 0;
            }
            authScope = object2.getEntity();
            if (authScope != null) {
                if (n != 0) {
                    authScope.getContent().close();
                    continue;
                }
                object4 = new FilterInputStream(authScope.getContent()){

                    public void close() throws IOException {
                        defaultHttpClient.getConnectionManager().shutdown();
                        super.close();
                    }
                };
                object3 = new BasicHttpResponse(object2.getStatusLine());
                object3.setHeaders(object2.getAllHeaders());
                object3.setLocale(object2.getLocale());
                return Pair.of(object4, object3);
            }
            if (n2 != 304) continue;
            object4 = new BasicHttpResponse(object2.getStatusLine());
            object4.setHeaders(object2.getAllHeaders());
            object4.setLocale(object2.getLocale());
            return Pair.of(null, object4);
        }
        defaultHttpClient.getConnectionManager().shutdown();
        throw new FileNotFoundException(string);
    }

    static {
        if (DEBUG) {
            Properties properties = System.getProperties();
            for (String string : new String[]{"http.proxyHost", "http.proxyPort", "https.proxyHost", "https.proxyPort"}) {
                String string2 = properties.getProperty(string);
                if (string2 == null) continue;
                System.out.printf("SdkLib.UrlOpener Java.Prop %s='%s'\n", string, string2);
            }
        }
        try {
            sConnectionTimeoutMs = Integer.parseInt(System.getenv("ANDROID_SDKMAN_CONN_TIMEOUT"));
        }
        catch (Exception exception) {
            sConnectionTimeoutMs = 120000;
        }
        try {
            sSocketTimeoutMs = Integer.parseInt(System.getenv("ANDROID_SDKMAN_READ_TIMEOUT"));
        }
        catch (Exception exception) {
            sSocketTimeoutMs = 60000;
        }
    }
}

