/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.MajorRevisionPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocPackage
extends MajorRevisionPackage
implements IAndroidVersionProvider {
    private final AndroidVersion mVersion;

    public DocPackage(SdkSource sdkSource, Node node, String string, Map<String, String> map) {
        super(sdkSource, node, string, map);
        int n = PackageParserUtils.getXmlInt(node, "api-level", 0);
        String string2 = PackageParserUtils.getXmlString(node, "codename");
        if (string2.length() == 0) {
            string2 = null;
        }
        this.mVersion = new AndroidVersion(n, string2);
    }

    public static Package create(SdkSource sdkSource, Properties properties, int n, String string, int n2, String string2, String string3, String string4, Archive.Os os, Archive.Arch arch, String string5) {
        return new DocPackage(sdkSource, properties, n, string, n2, string2, string3, string4, os, arch, string5);
    }

    private DocPackage(SdkSource sdkSource, Properties properties, int n, String string, int n2, String string2, String string3, String string4, Archive.Os os, Archive.Arch arch, String string5) {
        super(sdkSource, properties, n2, string2, string3, string4, os, arch, string5);
        this.mVersion = new AndroidVersion(properties, n, string);
    }

    @Override
    public void saveProperties(Properties properties) {
        super.saveProperties(properties);
        this.mVersion.saveProperties(properties);
    }

    @Override
    @NonNull
    public AndroidVersion getAndroidVersion() {
        return this.mVersion;
    }

    @Override
    public String installId() {
        return "doc-" + this.mVersion.getApiString();
    }

    @Override
    public String getListDescription() {
        if (this.mVersion.isPreview()) {
            return String.format("Documentation for Android '%1$s' Preview SDK%2$s", this.mVersion.getCodename(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("Documentation for Android SDK%2$s", this.mVersion.getApiLevel(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        if (this.mVersion.isPreview()) {
            return String.format("Documentation for Android '%1$s' Preview SDK, revision %2$s%3$s", this.mVersion.getCodename(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("Documentation for Android SDK, API %1$d, revision %2$s%3$s", this.mVersion.getApiLevel(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String string = this.getDescription();
        if (string == null || string.length() == 0) {
            string = this.getShortDescription();
        }
        if (string.indexOf("revision") == -1) {
            string = string + String.format("\nRevision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return string;
    }

    @Override
    public File getInstallFolder(String string, SdkManager sdkManager) {
        return new File(string, "docs");
    }

    @Override
    public boolean sameItemAs(Package package_) {
        if (package_ instanceof DocPackage) {
            AndroidVersion androidVersion = ((DocPackage)package_).getAndroidVersion();
            return this.getAndroidVersion().equals(androidVersion);
        }
        return false;
    }

    @Override
    public Package.UpdateInfo canBeUpdatedBy(Package package_) {
        if (!(package_ instanceof DocPackage)) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        DocPackage docPackage = (DocPackage)package_;
        AndroidVersion androidVersion = docPackage.getAndroidVersion();
        if (androidVersion.equals(this.mVersion) ? package_.getRevision().compareTo(this.getRevision()) > 0 : androidVersion.getApiLevel() == this.mVersion.getApiLevel() && androidVersion.isPreview()) {
            return Package.UpdateInfo.UPDATE;
        }
        return Package.UpdateInfo.NOT_UPDATE;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.mVersion == null ? 0 : this.mVersion.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof DocPackage)) {
            return false;
        }
        DocPackage docPackage = (DocPackage)object;
        return !(this.mVersion == null ? docPackage.mVersion != null : !this.mVersion.equals(docPackage.mVersion));
    }
}

