/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.util;

import com.android.sdklib.util.ArrayUtils;

public class SparseIntArray {
    private int[] mKeys;
    private int[] mValues;
    private int mSize;

    public SparseIntArray() {
        this(10);
    }

    public SparseIntArray(int n) {
        n = ArrayUtils.idealIntArraySize(n);
        this.mKeys = new int[n];
        this.mValues = new int[n];
        this.mSize = 0;
    }

    public int get(int n) {
        return this.get(n, 0);
    }

    public int get(int n, int n2) {
        int n3 = SparseIntArray.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n3 < 0) {
            return n2;
        }
        return this.mValues[n3];
    }

    public void delete(int n) {
        int n2 = SparseIntArray.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n2 >= 0) {
            this.removeAt(n2);
        }
    }

    public void removeAt(int n) {
        System.arraycopy(this.mKeys, n + 1, this.mKeys, n, this.mSize - (n + 1));
        System.arraycopy(this.mValues, n + 1, this.mValues, n, this.mSize - (n + 1));
        --this.mSize;
    }

    public void put(int n, int n2) {
        int n3 = SparseIntArray.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n3 >= 0) {
            this.mValues[n3] = n2;
        } else {
            n3 ^= 0xFFFFFFFF;
            if (this.mSize >= this.mKeys.length) {
                int n4 = ArrayUtils.idealIntArraySize(this.mSize + 1);
                int[] nArray = new int[n4];
                int[] nArray2 = new int[n4];
                System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nArray2, 0, this.mValues.length);
                this.mKeys = nArray;
                this.mValues = nArray2;
            }
            if (this.mSize - n3 != 0) {
                System.arraycopy(this.mKeys, n3, this.mKeys, n3 + 1, this.mSize - n3);
                System.arraycopy(this.mValues, n3, this.mValues, n3 + 1, this.mSize - n3);
            }
            this.mKeys[n3] = n;
            this.mValues[n3] = n2;
            ++this.mSize;
        }
    }

    public int size() {
        return this.mSize;
    }

    public int keyAt(int n) {
        return this.mKeys[n];
    }

    public int valueAt(int n) {
        return this.mValues[n];
    }

    public int indexOfKey(int n) {
        return SparseIntArray.binarySearch(this.mKeys, 0, this.mSize, n);
    }

    public int indexOfValue(int n) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != n) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void append(int n, int n2) {
        if (this.mSize != 0 && n <= this.mKeys[this.mSize - 1]) {
            this.put(n, n2);
            return;
        }
        int n3 = this.mSize;
        if (n3 >= this.mKeys.length) {
            int n4 = ArrayUtils.idealIntArraySize(n3 + 1);
            int[] nArray = new int[n4];
            int[] nArray2 = new int[n4];
            System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nArray2, 0, this.mValues.length);
            this.mKeys = nArray;
            this.mValues = nArray2;
        }
        this.mKeys[n3] = n;
        this.mValues[n3] = n2;
        this.mSize = n3 + 1;
    }

    private static int binarySearch(int[] nArray, int n, int n2, int n3) {
        int n4 = n + n2;
        int n5 = n - 1;
        while (n4 - n5 > 1) {
            int n6 = (n4 + n5) / 2;
            if (nArray[n6] < n3) {
                n5 = n6;
                continue;
            }
            n4 = n6;
        }
        if (n4 == n + n2) {
            return ~(n + n2);
        }
        if (nArray[n4] == n3) {
            return n4;
        }
        return ~n4;
    }
}

