#
# Copyright (C) 2007 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Base configuration for communication-oriented android devices
# (phones, tablets, etc.).  If you want a change to apply to ALL
# devices (including non-phones and non-tablets), modify
# core_minimal.mk instead.

PRODUCT_PROPERTY_OVERRIDES := \
    ro.config.notification_sound=Proxima.ogg \
    ro.config.alarm_alert=Alarm_Classic.ogg \
    ro.config.ringtone=Backroad.ogg

PRODUCT_PACKAGES += \
    Browser \
    Contacts \
    DocumentsUI \
    DownloadProviderUi \
    ExternalStorageProvider \
    KeyChain \
    PicoTts \
    PacProcessor \
    ProxyHandler \
    SharedStorageBackup \
    VpnDialogs

# Lenovo-sw yangyang19 20140421 add for support romui 2.0 begin
LENOVO_ROMUI_SDK_VERSION := 2
LENOVO_THEME_PACKAGE_USE_PREBUILT_SYSTEMTHEME_JAR := false

PRODUCT_PROPERTY_OVERRIDES += \
    sys.lenovo.romui.version.sdk=$(LENOVO_ROMUI_SDK_VERSION)

PRODUCT_PACKAGES += lenovo-res

# enable this if sw blur lib is required
PRODUCT_PACKAGES += libblur_jni
 
# Lenovo-sw yangyang19 20140421 add for support romui 2.0 end

ifneq ($(strip $(MTK_LCA_RAM_OPTIMIZE)), yes)
  PRODUCT_PACKAGES += BasicDreams
endif

$(call inherit-product, $(SRC_TARGET_DIR)/product/core_base.mk)
