#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "libwifitest.h"

int main(void) {
    int i;
    uint32_t rxOk, rxErr;
    bool retval;

    printf("entering RF testing mode ..\n");

    retval = WIFI_TEST_OpenDUT();
    printf("(%d) entered RF testing mode ..\n", retval);

    retval = WIFI_TEST_SetMode(WIFI_TEST_MODE_80211N_ONLY);
    printf("(%d) changed mode to 802.11n ..\n", retval);

    retval = WIFI_TEST_SetFrequency(2412, 0);
    printf("(%d) changed channel to #1..\n", retval);

    retval = WIFI_TEST_SetRX(true, NULL, NULL);
    printf("(%d) RX test started..\n", retval);

    for(i = 0 ; i < 10 ; i++) {
        retval = WIFI_TEST_GetResult(&rxOk, &rxErr);
        printf("(%d) RX OK: %d / RX ERR: %d\n", retval, rxOk, rxErr);
        sleep(1);
    }

    retval = WIFI_TEST_SetRX(false, NULL, NULL);
    printf("(%d) RX test stopped ..\n", retval);

    retval = WIFI_TEST_CloseDUT();
    printf("(%d) left RF testing mode ..\n", retval);

    return 0;
}
