# Copyright 2006 The Android Open Source Project

ifeq ($(GOOGLE_RELEASE_RIL), yes)
#do nothing
else
LOCAL_PATH:= $(call my-dir)
include $(CLEAR_VARS)

LOCAL_SRC_FILES:= \
    ril.cpp \
    ril_event.cpp \
    ril_gsm_util.cpp

LOCAL_SHARED_LIBRARIES := \
    liblog \
    libutils \
    libbinder \
    libcutils \
    libhardware_legacy

LOCAL_STATIC_LIBRARIES := \
    librilmtk-prop-md1
    
ifeq ($(TELEPHONY_DFOSET),yes)
LOCAL_SHARED_LIBRARIES += libdfo
endif  
LOCAL_C_INCLUDES := $(KERNEL_HEADERS) $(LOCAL_PATH)/../../../external/dfo/featured $(TARGET_OUT_HEADERS)/dfo

LOCAL_CFLAGS := -DMTK_RIL

ifneq ($(MTK_SHARE_MODEM_CURRENT),1)
  LOCAL_CFLAGS += -DMTK_GEMINI     
endif

ifeq ($(MTK_EAP_SIM_AKA),yes)
  LOCAL_CFLAGS += -DMTK_EAP_SIM_AKA  
endif

ifneq ($(strip $(TARGET_BUILD_VARIANT)), eng)
  LOCAL_CFLAGS += -DFATAL_ERROR_HANDLE
endif

LOCAL_CFLAGS += -D__ATCI_CHANNEL_SUPPORT__

LOCAL_CFLAGS += -DMTK_RIL_MD1

LOCAL_MODULE:= librilmtk

LOCAL_LDLIBS += -lpthread

include $(BUILD_SHARED_LIBRARY)

# =========================================
include $(CLEAR_VARS)

LOCAL_SRC_FILES:= \
    ril.cpp \
    ril_event.cpp \
    ril_gsm_util.cpp

LOCAL_SHARED_LIBRARIES := \
    liblog \
    libutils \
    libbinder \
    libcutils \
    libhardware_legacy

LOCAL_STATIC_LIBRARIES := \
    librilmtk-prop-md2
    
ifeq ($(TELEPHONY_DFOSET),yes)
LOCAL_SHARED_LIBRARIES += libdfo
endif  
LOCAL_C_INCLUDES := $(KERNEL_HEADERS) $(LOCAL_PATH)/../../../external/dfo/featured $(TARGET_OUT_HEADERS)/dfo

LOCAL_CFLAGS := -DMTK_RIL

ifneq ($(MTK_SHARE_MODEM_CURRENT),1)
  LOCAL_CFLAGS += -DMTK_GEMINI     
endif

ifeq ($(MTK_EAP_SIM_AKA),yes)
  LOCAL_CFLAGS += -DMTK_EAP_SIM_AKA  
endif

ifneq ($(strip $(TARGET_BUILD_VARIANT)), eng)
  LOCAL_CFLAGS += -DFATAL_ERROR_HANDLE
endif

LOCAL_CFLAGS += -D__ATCI_CHANNEL_SUPPORT__

LOCAL_CFLAGS += -DMTK_RIL_MD2

LOCAL_MODULE:= librilmtkmd2

LOCAL_LDLIBS += -lpthread

include $(BUILD_SHARED_LIBRARY)

# SGLTE project
#===============================
ifeq ($(MTK_LTE_DC_SUPPORT),yes)
include $(CLEAR_VARS)

LOCAL_SRC_FILES:= \
    ril.cpp \
    ril_event.cpp \
    ril_gsm_util.cpp

LOCAL_SHARED_LIBRARIES := \
    liblog \
    libutils \
    libbinder \
    libcutils \
    libhardware_legacy

LOCAL_STATIC_LIBRARIES := \
    librilmtk-prop-md1-s
    
ifeq ($(TELEPHONY_DFOSET),yes)
LOCAL_SHARED_LIBRARIES += libdfo
endif  
LOCAL_C_INCLUDES := $(KERNEL_HEADERS) $(LOCAL_PATH)/../../../external/dfo/featured $(TARGET_OUT_HEADERS)/dfo

LOCAL_CFLAGS := -DMTK_RIL
LOCAL_CFLAGS += -DMTK_CSFB_IN_MMDC_PROJECT

ifeq ($(MTK_EAP_SIM_AKA),yes)
  LOCAL_CFLAGS += -DMTK_EAP_SIM_AKA  
endif

ifneq ($(strip $(TARGET_BUILD_VARIANT)), eng)
  LOCAL_CFLAGS += -DFATAL_ERROR_HANDLE
endif

LOCAL_CFLAGS += -DMTK_RIL_MD1
LOCAL_CFLAGS += -UMTK_LTE_DC_SUPPORT
LOCAL_CFLAGS += -D__ATCI_CHANNEL_SUPPORT__

LOCAL_MODULE:= librilmtk-s

LOCAL_LDLIBS += -lpthread

include $(BUILD_SHARED_LIBRARY)
endif # MTK_LTE_DC_SUPPORT

# For RdoServD which needs a static library
# =========================================
ifneq ($(ANDROID_BIONIC_TRANSITION),)
include $(CLEAR_VARS)

LOCAL_SRC_FILES:= \
    ril.cpp \
    ril_event.cpp \
    ril_gsm_util.cpp

LOCAL_STATIC_LIBRARIES := \
    libutils_static \
    libcutils \
    librilmtk-prop-md1

LOCAL_CFLAGS := -DMTK_RIL

ifneq ($(MTK_SHARE_MODEM_CURRENT),1)
  LOCAL_CFLAGS += -DMTK_GEMINI     
endif

ifeq ($(MTK_EAP_SIM_AKA),yes)
  LOCAL_CFLAGS += -DMTK_EAP_SIM_AKA  
endif

LOCAL_MODULE:= librilmtk_static

LOCAL_LDLIBS += -lpthread

include $(BUILD_STATIC_LIBRARY)
endif # ANDROID_BIONIC_TRANSITION

# =========================================
ifneq ($(ANDROID_BIONIC_TRANSITION),)
include $(CLEAR_VARS)

LOCAL_SRC_FILES:= \
    ril.cpp \
    ril_event.cpp \
    ril_gsm_util.cpp

LOCAL_STATIC_LIBRARIES := \
    libutils_static \
    libcutils \
    librilmtk-prop-md2

LOCAL_CFLAGS := -DMTK_RIL

ifneq ($(MTK_SHARE_MODEM_CURRENT),1)
  LOCAL_CFLAGS += -DMTK_GEMINI     
endif

ifeq ($(MTK_EAP_SIM_AKA),yes)
  LOCAL_CFLAGS += -DMTK_EAP_SIM_AKA  
endif

LOCAL_CFLAGS += -DMTK_RIL_MD2

LOCAL_MODULE:= librilmtk_staticmd2

LOCAL_LDLIBS += -lpthread

include $(BUILD_STATIC_LIBRARY)
endif # ANDROID_BIONIC_TRANSITION


endif # GOOGLE_RELEASE_RIL
