/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.resources.Density;
import com.android.resources.ScreenSize;

public abstract class RenderParams {
    public static final long DEFAULT_TIMEOUT = 250L;
    private final Object mProjectKey;
    private final HardwareConfig mHardwareConfig;
    private final RenderResources mRenderResources;
    private final IProjectCallback mProjectCallback;
    private final int mMinSdkVersion;
    private final int mTargetSdkVersion;
    private final LayoutLog mLog;
    private boolean mCustomBackgroundEnabled;
    private int mCustomBackgroundColor;
    private long mTimeout;
    private IImageFactory mImageFactory = null;
    private String mAppIcon = null;
    private String mAppLabel = null;
    private String mLocale = null;
    private boolean mForceNoDecor;

    public RenderParams(Object object, HardwareConfig hardwareConfig, RenderResources renderResources, IProjectCallback iProjectCallback, int n, int n2, LayoutLog layoutLog) {
        this.mProjectKey = object;
        this.mHardwareConfig = hardwareConfig;
        this.mRenderResources = renderResources;
        this.mProjectCallback = iProjectCallback;
        this.mMinSdkVersion = n;
        this.mTargetSdkVersion = n2;
        this.mLog = layoutLog;
        this.mCustomBackgroundEnabled = false;
        this.mTimeout = 250L;
    }

    public RenderParams(RenderParams renderParams) {
        this.mProjectKey = renderParams.mProjectKey;
        this.mHardwareConfig = renderParams.mHardwareConfig;
        this.mRenderResources = renderParams.mRenderResources;
        this.mProjectCallback = renderParams.mProjectCallback;
        this.mMinSdkVersion = renderParams.mMinSdkVersion;
        this.mTargetSdkVersion = renderParams.mTargetSdkVersion;
        this.mLog = renderParams.mLog;
        this.mCustomBackgroundEnabled = renderParams.mCustomBackgroundEnabled;
        this.mCustomBackgroundColor = renderParams.mCustomBackgroundColor;
        this.mTimeout = renderParams.mTimeout;
        this.mImageFactory = renderParams.mImageFactory;
        this.mAppIcon = renderParams.mAppIcon;
        this.mAppLabel = renderParams.mAppLabel;
        this.mLocale = renderParams.mLocale;
        this.mForceNoDecor = renderParams.mForceNoDecor;
    }

    public void setOverrideBgColor(int n) {
        this.mCustomBackgroundEnabled = true;
        this.mCustomBackgroundColor = n;
    }

    public void setTimeout(long l) {
        this.mTimeout = l;
    }

    public void setImageFactory(IImageFactory iImageFactory) {
        this.mImageFactory = iImageFactory;
    }

    public void setAppIcon(String string) {
        this.mAppIcon = string;
    }

    public void setAppLabel(String string) {
        this.mAppLabel = string;
    }

    public void setLocale(String string) {
        this.mLocale = string;
    }

    public void setForceNoDecor() {
        this.mForceNoDecor = true;
    }

    public Object getProjectKey() {
        return this.mProjectKey;
    }

    public HardwareConfig getHardwareConfig() {
        return this.mHardwareConfig;
    }

    public int getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public int getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    @Deprecated
    public int getScreenWidth() {
        return this.mHardwareConfig.getScreenWidth();
    }

    @Deprecated
    public int getScreenHeight() {
        return this.mHardwareConfig.getScreenHeight();
    }

    @Deprecated
    public Density getDensity() {
        return this.mHardwareConfig.getDensity();
    }

    @Deprecated
    public float getXdpi() {
        return this.mHardwareConfig.getXdpi();
    }

    @Deprecated
    public float getYdpi() {
        return this.mHardwareConfig.getYdpi();
    }

    public RenderResources getResources() {
        return this.mRenderResources;
    }

    public IProjectCallback getProjectCallback() {
        return this.mProjectCallback;
    }

    public LayoutLog getLog() {
        return this.mLog;
    }

    public boolean isBgColorOverridden() {
        return this.mCustomBackgroundEnabled;
    }

    public int getOverrideBgColor() {
        return this.mCustomBackgroundColor;
    }

    public long getTimeout() {
        return this.mTimeout;
    }

    public IImageFactory getImageFactory() {
        return this.mImageFactory;
    }

    @Deprecated
    public ScreenSize getConfigScreenSize() {
        return this.mHardwareConfig.getScreenSize();
    }

    public String getAppIcon() {
        return this.mAppIcon;
    }

    public String getAppLabel() {
        return this.mAppLabel;
    }

    public String getLocale() {
        return this.mLocale;
    }

    public boolean isForceNoDecor() {
        return this.mForceNoDecor;
    }
}

