/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.SdkConstants;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.util.SparseArray;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlatformTarget
implements IAndroidTarget {
    private static final String PLATFORM_HASH = "android-%s";
    private static final String PLATFORM_VENDOR = "Android Open Source Project";
    private static final String PLATFORM_NAME = "Android %s";
    private static final String PLATFORM_NAME_PREVIEW = "Android %s (Preview)";
    private final String mRootFolderOsPath;
    private final String mName;
    private final AndroidVersion mVersion;
    private final String mVersionName;
    private final int mRevision;
    private final Map<String, String> mProperties;
    private final SparseArray<String> mPaths = new SparseArray();
    private String[] mSkins;
    private final ISystemImage[] mSystemImages;
    private final SdkManager.LayoutlibVersion mLayoutlibVersion;

    PlatformTarget(String string, String string2, AndroidVersion androidVersion, String string3, int n, SdkManager.LayoutlibVersion layoutlibVersion, ISystemImage[] iSystemImageArray, Map<String, String> map) {
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        this.mRootFolderOsPath = string2;
        this.mProperties = Collections.unmodifiableMap(map);
        this.mVersion = androidVersion;
        this.mVersionName = string3;
        this.mRevision = n;
        this.mLayoutlibVersion = layoutlibVersion;
        this.mSystemImages = iSystemImageArray == null ? new ISystemImage[]{} : iSystemImageArray;
        Arrays.sort(this.mSystemImages);
        this.mName = this.mVersion.isPreview() ? String.format(PLATFORM_NAME_PREVIEW, this.mVersionName) : String.format(PLATFORM_NAME, this.mVersionName);
        this.mPaths.put(1, this.mRootFolderOsPath + "android.jar");
        this.mPaths.put(27, this.mRootFolderOsPath + "uiautomator.jar");
        this.mPaths.put(18, this.mRootFolderOsPath + "sources");
        this.mPaths.put(2, this.mRootFolderOsPath + "framework.aidl");
        this.mPaths.put(4, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_SAMPLES_FOLDER);
        this.mPaths.put(5, this.mRootFolderOsPath + SdkConstants.OS_SKINS_FOLDER);
        this.mPaths.put(6, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_TEMPLATES_FOLDER);
        this.mPaths.put(7, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER);
        this.mPaths.put(8, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_ATTRS_XML);
        this.mPaths.put(9, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_ATTRS_MANIFEST_XML);
        this.mPaths.put(11, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_RESOURCES_FOLDER);
        this.mPaths.put(12, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_FONTS_FOLDER);
        this.mPaths.put(10, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "layoutlib.jar");
        this.mPaths.put(13, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "widgets.txt");
        this.mPaths.put(14, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "activity_actions.txt");
        this.mPaths.put(15, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "broadcast_actions.txt");
        this.mPaths.put(16, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "service_actions.txt");
        this.mPaths.put(17, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "categories.txt");
        this.mPaths.put(24, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_ANT_FOLDER);
        this.mPaths.put(20, string + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.FN_AAPT);
        this.mPaths.put(21, string + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.FN_AIDL);
        this.mPaths.put(22, string + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.FN_DX);
        this.mPaths.put(23, string + SdkConstants.OS_SDK_PLATFORM_TOOLS_LIB_FOLDER + "dx.jar");
        this.mPaths.put(25, string + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.OS_FRAMEWORK_RS);
        this.mPaths.put(26, string + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.OS_FRAMEWORK_RS_CLANG);
    }

    public SdkManager.LayoutlibVersion getLayoutlibVersion() {
        return this.mLayoutlibVersion;
    }

    @Override
    public ISystemImage getSystemImage(String string) {
        for (ISystemImage iSystemImage : this.mSystemImages) {
            if (!iSystemImage.getAbiType().equals(string)) continue;
            return iSystemImage;
        }
        return null;
    }

    @Override
    public ISystemImage[] getSystemImages() {
        return this.mSystemImages;
    }

    @Override
    public String getLocation() {
        return this.mRootFolderOsPath;
    }

    @Override
    public String getVendor() {
        return PLATFORM_VENDOR;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getFullName() {
        return this.mName;
    }

    @Override
    public String getClasspathName() {
        return this.mName;
    }

    @Override
    public String getShortClasspathName() {
        return this.mName;
    }

    @Override
    public String getDescription() {
        return String.format("Standard Android platform %s", this.mVersionName);
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mVersion;
    }

    @Override
    public String getVersionName() {
        return this.mVersionName;
    }

    @Override
    public int getRevision() {
        return this.mRevision;
    }

    @Override
    public boolean isPlatform() {
        return true;
    }

    @Override
    public IAndroidTarget getParent() {
        return null;
    }

    @Override
    public String getPath(int n) {
        return this.mPaths.get(n);
    }

    @Override
    public boolean hasRenderingLibrary() {
        return true;
    }

    @Override
    public String[] getSkins() {
        return this.mSkins;
    }

    @Override
    public String getDefaultSkin() {
        if (this.mSkins.length == 1) {
            return this.mSkins[0];
        }
        String string = this.mProperties.get("sdk.skin.default");
        if (string != null) {
            return string;
        }
        if (this.mVersion.getApiLevel() >= 4) {
            return "WVGA800";
        }
        return "HVGA";
    }

    @Override
    public IAndroidTarget.IOptionalLibrary[] getOptionalLibraries() {
        return null;
    }

    @Override
    public String[] getPlatformLibraries() {
        return new String[]{"android.test.runner"};
    }

    @Override
    public int getUsbVendorId() {
        return 0;
    }

    @Override
    public boolean canRunOn(IAndroidTarget iAndroidTarget) {
        if (iAndroidTarget == this) {
            return true;
        }
        if (this.mVersion.getCodename() != null) {
            return this.mVersion.equals(iAndroidTarget.getVersion());
        }
        return iAndroidTarget.getVersion().getApiLevel() >= this.mVersion.getApiLevel();
    }

    @Override
    public String hashString() {
        return String.format(PLATFORM_HASH, this.mVersion.getApiString());
    }

    public int hashCode() {
        return this.hashString().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof PlatformTarget) {
            PlatformTarget platformTarget = (PlatformTarget)object;
            return this.mVersion.equals(platformTarget.getVersion());
        }
        return false;
    }

    @Override
    public int compareTo(IAndroidTarget iAndroidTarget) {
        if (this == iAndroidTarget) {
            return 0;
        }
        int n = this.mVersion.compareTo(iAndroidTarget.getVersion());
        if (n == 0 && !iAndroidTarget.isPlatform()) {
            return -1;
        }
        return n;
    }

    public String toString() {
        return String.format("PlatformTarget %1$s rev %2$d", this.getVersion(), this.getRevision());
    }

    @Override
    public String getProperty(String string) {
        return this.mProperties.get(string);
    }

    @Override
    public Integer getProperty(String string, Integer n) {
        try {
            String string2 = this.getProperty(string);
            if (string2 != null) {
                return Integer.decode(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public Boolean getProperty(String string, Boolean bl) {
        String string2 = this.getProperty(string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return bl;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.mProperties;
    }

    void setSkins(String[] stringArray) {
        this.mSkins = stringArray;
    }

    void setSamplesPath(String string) {
        this.mPaths.put(4, string);
    }
}

