/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.internal.repository.DownloadCache;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.io.NonClosingInputStream;
import com.android.sdklib.repository.SdkStatsConstants;
import com.android.sdklib.util.SparseArray;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLKeyException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SdkStats {
    private final SparseArray<PlatformStat> mStats = new SparseArray();

    public SparseArray<PlatformStat> getStats() {
        return this.mStats;
    }

    public void load(DownloadCache downloadCache, boolean bl, ITaskMonitor iTaskMonitor) {
        String string = "https://dl-ssl.google.com/android/repository/stats-1.xml";
        if (bl) {
            string = string.replaceAll("https://", "http://");
        }
        iTaskMonitor.setProgressMax(5);
        iTaskMonitor.setDescription("Fetching %1$s", string);
        iTaskMonitor.incProgress(1);
        Exception[] exceptionArray = new Exception[]{null};
        Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        String[] stringArray = new String[]{null};
        Document document = null;
        String string2 = null;
        InputStream inputStream = this.fetchXmlUrl(string, downloadCache, iTaskMonitor.createSubMonitor(1), exceptionArray);
        if (inputStream != null) {
            iTaskMonitor.setDescription("Validate XML", new Object[0]);
            int n = this.getXmlSchemaVersion(inputStream);
            if (n >= 1 && n <= 1) {
                String string3 = this.validateXml(inputStream, string, n, stringArray, booleanArray);
                if (string3 != null) {
                    document = this.getDocument(inputStream, iTaskMonitor);
                    string2 = string3;
                }
            } else if (n > 1) {
                this.closeStream(inputStream);
                return;
            }
        }
        if (exceptionArray[0] != null) {
            String string4 = null;
            string4 = exceptionArray[0] instanceof FileNotFoundException ? "File not found" : (exceptionArray[0] instanceof UnknownHostException && exceptionArray[0].getMessage() != null ? String.format("Unknown Host %1$s", exceptionArray[0].getMessage()) : (exceptionArray[0] instanceof SSLKeyException ? "HTTPS SSL error. You might want to force download through HTTP in the settings." : (exceptionArray[0].getMessage() != null ? exceptionArray[0].getMessage() : String.format("Unknown (%1$s)", exceptionArray[0].getClass().getName()))));
            iTaskMonitor.logError("Failed to fetch URL %1$s, reason: %2$s", string, string4);
        }
        if (stringArray[0] != null) {
            iTaskMonitor.logError("%s", stringArray[0]);
        }
        if (document == null) {
            this.closeStream(inputStream);
            return;
        }
        iTaskMonitor.incProgress(1);
        if (inputStream != null) {
            iTaskMonitor.setDescription("Parse XML", new Object[0]);
            iTaskMonitor.incProgress(1);
            this.parseStatsDocument(document, string2, iTaskMonitor);
        }
        iTaskMonitor.incProgress(1);
        this.closeStream(inputStream);
    }

    private InputStream fetchXmlUrl(String string, DownloadCache downloadCache, ITaskMonitor iTaskMonitor, Exception[] exceptionArray) {
        try {
            InputStream inputStream = downloadCache.openCachedUrl(string, iTaskMonitor);
            if (inputStream != null) {
                inputStream.mark(500000);
                inputStream = new NonClosingInputStream(inputStream);
                ((NonClosingInputStream)inputStream).setCloseBehavior(NonClosingInputStream.CloseBehavior.RESET);
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exceptionArray != null) {
                exceptionArray[0] = exception;
            }
            return null;
        }
    }

    private void closeStream(InputStream inputStream) {
        if (inputStream != null) {
            if (inputStream instanceof NonClosingInputStream) {
                ((NonClosingInputStream)inputStream).setCloseBehavior(NonClosingInputStream.CloseBehavior.CLOSE);
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected int getXmlSchemaVersion(InputStream inputStream) {
        Object object;
        Object object2;
        if (inputStream == null) {
            return 0;
        }
        Node node = null;
        try {
            inputStream.reset();
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setIgnoringComments(false);
            ((DocumentBuilderFactory)object2).setValidating(false);
            ((DocumentBuilderFactory)object2).setNamespaceAware(false);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            ((DocumentBuilder)object).setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException sAXParseException) throws SAXException {
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }

                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            });
            node = ((DocumentBuilder)object).parse(inputStream);
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (node == null) {
            return 0;
        }
        object2 = Pattern.compile("http://schemas.android.com/sdk/android/stats/([1-9][0-9]*)");
        object = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Matcher matcher;
            String string;
            Node node3;
            if (node2.getNodeType() != 1) continue;
            object = null;
            String string2 = node2.getNodeName();
            int n = string2.indexOf(58);
            if (n > 0 && n < string2.length() - 1) {
                object = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            }
            if (!"sdk-stats".equals(string2)) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            String string3 = "xmlns";
            if (object != null) {
                string3 = string3 + ":" + (String)object;
            }
            if ((node3 = namedNodeMap.getNamedItem(string3)) == null || (string = node3.getNodeValue()) == null || !(matcher = ((Pattern)object2).matcher(string)).matches()) continue;
            String string4 = matcher.group(1);
            try {
                return Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    protected String validateXml(InputStream inputStream, String string, int n, String[] stringArray, Boolean[] booleanArray) {
        if (inputStream == null) {
            return null;
        }
        try {
            Validator validator = this.getValidator(n);
            if (validator == null) {
                booleanArray[0] = Boolean.FALSE;
                stringArray[0] = String.format("XML verification failed for %1$s.\nNo suitable XML Schema Validator could be found in your Java environment. Please consider updating your version of Java.", string);
                return null;
            }
            booleanArray[0] = Boolean.TRUE;
            inputStream.reset();
            validator.validate(new StreamSource(inputStream));
            return SdkStatsConstants.getSchemaUri(n);
        }
        catch (SAXParseException sAXParseException) {
            stringArray[0] = String.format("XML verification failed for %1$s.\nLine %2$d:%3$d, Error: %4$s", string, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.toString());
        }
        catch (Exception exception) {
            stringArray[0] = String.format("XML verification failed for %1$s.\nError: %2$s", string, exception.toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Validator getValidator(int n) throws SAXException {
        Validator validator;
        InputStream inputStream = SdkStatsConstants.getXsdStream(n);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (schemaFactory == null) {
            Validator validator2 = null;
            return validator2;
        }
        Schema schema = schemaFactory.newSchema(new StreamSource(inputStream));
        Validator validator3 = validator = schema == null ? null : schema.newValidator();
        return validator3;
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected Document getDocument(InputStream inputStream, ITaskMonitor iTaskMonitor) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            inputStream.reset();
            Document document = documentBuilder.parse(new InputSource(inputStream));
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            iTaskMonitor.logError("Failed to create XML document builder", new Object[0]);
        }
        catch (SAXException sAXException) {
            iTaskMonitor.logError("Failed to parse XML document", new Object[0]);
        }
        catch (IOException iOException) {
            iTaskMonitor.logError("Failed to read XML document", new Object[0]);
        }
        return null;
    }

    protected SparseArray<PlatformStat> parseStatsDocument(Document document, String string, ITaskMonitor iTaskMonitor) {
        Object object;
        Object object2;
        String string2 = System.getenv("SDK_TEST_BASE_URL");
        if (!(string2 == null || string2.length() > 0 && string2.endsWith("/"))) {
            string2 = null;
        }
        SparseArray<PlatformStatBase> sparseArray = new SparseArray<PlatformStatBase>();
        int n = 0;
        Node node = this.getFirstChild(document, string, "sdk-stats");
        if (node != null) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 1 || !string.equals(node2.getNamespaceURI()) || !node2.getLocalName().equals("platform")) continue;
                try {
                    float f;
                    object2 = this.getFirstChild(node2, string, "api-level");
                    int n2 = Integer.parseInt(object2.getTextContent().trim());
                    if (n2 < 1 || sparseArray.indexOfKey(n2) >= 0) continue;
                    String string3 = this.getFirstChild(node2, string, "codename").getTextContent().trim();
                    object = this.getFirstChild(node2, string, "version").getTextContent().trim();
                    if (string3 == null || object == null || string3.length() == 0 || ((String)object).length() == 0 || (f = Float.parseFloat((object2 = this.getFirstChild(node2, string, "share")).getTextContent().trim())) < 0.0f || f > 100.0f) continue;
                    PlatformStatBase platformStatBase = new PlatformStatBase(n2, (String)object, string3, f);
                    sparseArray.put(n2, platformStatBase);
                    n = n2 > n ? n2 : n;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.mStats.clear();
        for (int i = 1; i <= n; ++i) {
            object2 = (PlatformStatBase)sparseArray.get(i);
            if (object2 == null) continue;
            float f = ((PlatformStatBase)object2).getShare();
            for (int j = i + 1; j <= n; ++j) {
                object = (PlatformStatBase)sparseArray.get(j);
                if (object == null) continue;
                f += ((PlatformStatBase)object).getShare();
            }
            this.mStats.put(i, new PlatformStat((PlatformStatBase)object2, f));
        }
        return this.mStats;
    }

    private Node getFirstChild(Node node, String string, String string2) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !string.equals(node2.getNamespaceURI()) || string2 != null && !node2.getLocalName().equals(string2)) continue;
            return node2;
        }
        return null;
    }

    public static class PlatformStat
    extends PlatformStatBase {
        private final float mAccumShare;

        public PlatformStat(int n, String string, String string2, float f, float f2) {
            super(n, string, string2, f);
            this.mAccumShare = f2;
        }

        public PlatformStat(PlatformStatBase platformStatBase, float f) {
            super(platformStatBase.getApiLevel(), platformStatBase.getVersionName(), platformStatBase.getCodeName(), platformStatBase.getShare());
            this.mAccumShare = f;
        }

        public float getAccumShare() {
            return this.mAccumShare;
        }

        public String toString() {
            return String.format("<Stat %s, accum=%.1f%%>", super.toString(), Float.valueOf(this.mAccumShare));
        }
    }

    public static class PlatformStatBase {
        private final int mApiLevel;
        private final String mVersionName;
        private final String mCodeName;
        private final float mShare;

        public PlatformStatBase(int n, String string, String string2, float f) {
            this.mApiLevel = n;
            this.mVersionName = string;
            this.mCodeName = string2;
            this.mShare = f;
        }

        public int getApiLevel() {
            return this.mApiLevel;
        }

        public String getCodeName() {
            return this.mCodeName;
        }

        public String getVersionName() {
            return this.mVersionName;
        }

        public float getShare() {
            return this.mShare;
        }

        public String toString() {
            return String.format("api=%d, code=%s, vers=%s, share=%.1f%%", this.mApiLevel, this.mCodeName, this.mVersionName, Float.valueOf(this.mShare));
        }
    }
}

