/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.grammar;

import lombok.ast.DanglingNodes;
import lombok.ast.Identifier;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.grammar.Source;
import lombok.ast.libs.org.parboiled.BaseActions;

class SourceActions
extends BaseActions<Node> {
    protected final Source source;

    SourceActions(Source source) {
        this.source = source;
    }

    Identifier createIdentifierIfNeeded(Node identifier, int pos) {
        if (identifier instanceof Identifier) {
            return (Identifier)identifier;
        }
        Identifier i = new Identifier();
        i.setPosition(new Position(pos, pos));
        DanglingNodes.addDanglingNode(i, identifier);
        return i;
    }

    Modifiers createModifiersIfNeeded(Node modifiers, int pos) {
        if (modifiers instanceof Modifiers) {
            return (Modifiers)modifiers;
        }
        Modifiers m = new Modifiers();
        m.setPosition(new Position(pos, pos));
        DanglingNodes.addDanglingNode(m, modifiers);
        return m;
    }

    <T extends Node> T posify(T node) {
        int start = this.startPos();
        int end = Math.max(start, this.currentPos());
        node.setPosition(new Position(start, end));
        return node;
    }

    int startPos() {
        return this.getContext().getStartIndex();
    }

    int currentPos() {
        return this.getContext().getCurrentIndex();
    }

    void positionSpan(Node target, lombok.ast.libs.org.parboiled.Node<Node> start, lombok.ast.libs.org.parboiled.Node<Node> end) {
        if (target == null || start == null || end == null) {
            return;
        }
        target.setPosition(new Position(start.getStartIndex(), end.getEndIndex()));
    }
}

