/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanupDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue RECYCLE_RESOURCE = Issue.create((String)"Recycle", (String)"Looks for missing recycle() calls on resources", (String)"Many resources, such as TypedArrays, VelocityTrackers, etc., should be recycled (with a `recycle()` call) after use. This lint check looks for missing `recycle()` calls.", (Category)Category.PERFORMANCE, (int)7, (Severity)Severity.WARNING, CleanupDetector.class, (EnumSet)Scope.CLASS_FILE_SCOPE);
    public static final Issue COMMIT_FRAGMENT = Issue.create((String)"CommitTransaction", (String)"Looks for missing commit() calls on FragmentTransactions", (String)"After creating a `FragmentTransaction`, you typically need to commit it as well", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.WARNING, CleanupDetector.class, (EnumSet)Scope.CLASS_FILE_SCOPE);
    private static final String RECYCLE = "recycle";
    private static final String OBTAIN = "obtain";
    private static final String OBTAIN_NO_HISTORY = "obtainNoHistory";
    private static final String OBTAIN_ATTRIBUTES = "obtainAttributes";
    private static final String OBTAIN_TYPED_ARRAY = "obtainTypedArray";
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    private static final String COMMIT = "commit";
    private static final String COMMIT_ALLOWING_LOSS = "commitAllowingStateLoss";
    private static final String VELOCITY_TRACKER_CLS = "android/view/VelocityTracker";
    private static final String TYPED_ARRAY_CLS = "android/content/res/TypedArray";
    private static final String CONTEXT_CLS = "android/content/Context";
    private static final String MOTION_EVENT_CLS = "android/view/MotionEvent";
    private static final String HANDLER_CLS = "android/os/Handler";
    private static final String RESOURCES_CLS = "android/content/res/Resources";
    private static final String PARCEL_CLS = "android/os/Parcel";
    private static final String FRAGMENT_MANAGER_CLS = "android/app/FragmentManager";
    private static final String FRAGMENT_MANAGER_V4_CLS = "android/support/v4/app/FragmentManager";
    private static final String FRAGMENT_TRANSACTION_CLS = "android/app/FragmentTransaction";
    private static final String FRAGMENT_TRANSACTION_V4_CLS = "android/support/v4/app/FragmentTransaction";
    private static final String TYPED_ARRAY_SIG = "Landroid/content/res/TypedArray;";
    private boolean mObtainsTypedArray;
    private boolean mRecyclesTypedArray;
    private boolean mObtainsTracker;
    private boolean mRecyclesTracker;
    private boolean mObtainsMotionEvent;
    private boolean mRecyclesMotionEvent;
    private boolean mObtainsParcel;
    private boolean mRecyclesParcel;
    private boolean mObtainsTransaction;
    private boolean mCommitsTransaction;

    public void afterCheckProject(@NonNull Context context) {
        int n = context.getDriver().getPhase();
        if (n == 1 && (this.mObtainsTypedArray && !this.mRecyclesTypedArray || this.mObtainsTracker && !this.mRecyclesTracker || this.mObtainsParcel && !this.mRecyclesParcel || this.mObtainsMotionEvent && !this.mRecyclesMotionEvent || this.mObtainsTransaction && !this.mCommitsTransaction)) {
            context.getDriver().requestRepeat((Detector)this, Scope.CLASS_FILE_SCOPE);
        }
    }

    @Nullable
    public List<String> getApplicableCallNames() {
        return Arrays.asList(RECYCLE, OBTAIN_STYLED_ATTRIBUTES, OBTAIN, OBTAIN_ATTRIBUTES, OBTAIN_TYPED_ARRAY, OBTAIN_NO_HISTORY, BEGIN_TRANSACTION, COMMIT, COMMIT_ALLOWING_LOSS);
    }

    public void checkCall(@NonNull ClassContext classContext, @NonNull ClassNode classNode, @NonNull MethodNode methodNode, @NonNull MethodInsnNode methodInsnNode) {
        String string = methodInsnNode.name;
        String string2 = methodInsnNode.owner;
        String string3 = methodInsnNode.desc;
        int n = classContext.getDriver().getPhase();
        if (RECYCLE.equals(string) && string3.equals("()V")) {
            if (string2.equals(TYPED_ARRAY_CLS)) {
                this.mRecyclesTypedArray = true;
            } else if (string2.equals(VELOCITY_TRACKER_CLS)) {
                this.mRecyclesTracker = true;
            } else if (string2.equals(MOTION_EVENT_CLS)) {
                this.mRecyclesMotionEvent = true;
            } else if (string2.equals(PARCEL_CLS)) {
                this.mRecyclesParcel = true;
            }
        } else if ((COMMIT.equals(string) || COMMIT_ALLOWING_LOSS.equals(string)) && string3.equals("()I")) {
            if (string2.equals(FRAGMENT_TRANSACTION_CLS) || string2.equals(FRAGMENT_TRANSACTION_V4_CLS)) {
                this.mCommitsTransaction = true;
            }
        } else if (string2.equals(MOTION_EVENT_CLS)) {
            if (OBTAIN.equals(string) || OBTAIN_NO_HISTORY.equals(string)) {
                this.mObtainsMotionEvent = true;
                if (n == 2 && !this.mRecyclesMotionEvent) {
                    classContext.report(RECYCLE_RESOURCE, methodNode, (AbstractInsnNode)methodInsnNode, classContext.getLocation((AbstractInsnNode)methodInsnNode), CleanupDetector.getErrorMessage(MOTION_EVENT_CLS), null);
                } else if (n == 1 && CleanupDetector.checkMethodFlow(classContext, classNode, methodNode, methodInsnNode, MOTION_EVENT_CLS)) {
                    this.mRecyclesMotionEvent = true;
                }
            }
        } else if (OBTAIN.equals(string)) {
            if (string2.equals(VELOCITY_TRACKER_CLS)) {
                this.mObtainsTracker = true;
                if (n == 2 && !this.mRecyclesTracker) {
                    classContext.report(RECYCLE_RESOURCE, methodNode, (AbstractInsnNode)methodInsnNode, classContext.getLocation((AbstractInsnNode)methodInsnNode), CleanupDetector.getErrorMessage(VELOCITY_TRACKER_CLS), null);
                }
            } else if (string2.equals(PARCEL_CLS)) {
                this.mObtainsParcel = true;
                if (n == 2 && !this.mRecyclesParcel) {
                    classContext.report(RECYCLE_RESOURCE, methodNode, (AbstractInsnNode)methodInsnNode, classContext.getLocation((AbstractInsnNode)methodInsnNode), CleanupDetector.getErrorMessage(PARCEL_CLS), null);
                } else if (n == 1 && CleanupDetector.checkMethodFlow(classContext, classNode, methodNode, methodInsnNode, PARCEL_CLS)) {
                    this.mRecyclesParcel = true;
                }
            }
        } else if (OBTAIN_STYLED_ATTRIBUTES.equals(string) || OBTAIN_ATTRIBUTES.equals(string) || OBTAIN_TYPED_ARRAY.equals(string)) {
            if ((string2.equals(CONTEXT_CLS) || string2.equals(RESOURCES_CLS)) && string3.endsWith(TYPED_ARRAY_SIG)) {
                this.mObtainsTypedArray = true;
                if (n == 2 && !this.mRecyclesTypedArray) {
                    classContext.report(RECYCLE_RESOURCE, methodNode, (AbstractInsnNode)methodInsnNode, classContext.getLocation((AbstractInsnNode)methodInsnNode), CleanupDetector.getErrorMessage(TYPED_ARRAY_CLS), null);
                } else if (n == 1 && CleanupDetector.checkMethodFlow(classContext, classNode, methodNode, methodInsnNode, TYPED_ARRAY_CLS)) {
                    this.mRecyclesTypedArray = true;
                }
            }
        } else if (BEGIN_TRANSACTION.equals(string) && (string2.equals(FRAGMENT_MANAGER_CLS) || string2.equals(FRAGMENT_MANAGER_V4_CLS))) {
            this.mObtainsTransaction = true;
            if (n == 2 && !this.mCommitsTransaction) {
                classContext.report(COMMIT_FRAGMENT, methodNode, (AbstractInsnNode)methodInsnNode, classContext.getLocation((AbstractInsnNode)methodInsnNode), CleanupDetector.getErrorMessage(FRAGMENT_MANAGER_CLS), null);
            } else if (n == 1 && CleanupDetector.checkMethodFlow(classContext, classNode, methodNode, methodInsnNode, string2.equals(FRAGMENT_MANAGER_CLS) ? FRAGMENT_TRANSACTION_CLS : FRAGMENT_TRANSACTION_V4_CLS)) {
                this.mCommitsTransaction = true;
            }
        }
    }

    private static String getErrorMessage(String string) {
        if (FRAGMENT_TRANSACTION_CLS.equals(string) || FRAGMENT_TRANSACTION_V4_CLS.equals(string)) {
            return "This transaction should be completed with a commit() call";
        }
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        return String.format("This %1$s should be recycled after use with #recycle()", string2);
    }

    private static boolean checkMethodFlow(ClassContext classContext, ClassNode classNode, MethodNode methodNode, MethodInsnNode methodInsnNode, String string) {
        CleanupTracker cleanupTracker = new CleanupTracker(classContext, methodNode, methodInsnNode, string);
        ResourceAnalyzer resourceAnalyzer = new ResourceAnalyzer(cleanupTracker);
        cleanupTracker.setAnalyzer(resourceAnalyzer);
        try {
            resourceAnalyzer.analyze(classNode.name, methodNode);
            if (!cleanupTracker.isCleanedUp() && !cleanupTracker.isEscaped()) {
                Location location = classContext.getLocation((AbstractInsnNode)methodInsnNode);
                String string2 = CleanupDetector.getErrorMessage(string);
                Issue issue = methodInsnNode.owner.equals(FRAGMENT_MANAGER_CLS) ? COMMIT_FRAGMENT : RECYCLE_RESOURCE;
                classContext.report(issue, methodNode, (AbstractInsnNode)methodInsnNode, location, string2, null);
                return true;
            }
        }
        catch (AnalyzerException analyzerException) {
            classContext.log((Throwable)analyzerException, null, new Object[0]);
        }
        return false;
    }

    static boolean hasReturnType(String string, String string2) {
        int n;
        int n2 = string2.length();
        if (n2 < (n = string.length()) + 3) {
            return false;
        }
        if (string2.charAt(n2 - 1) != ';') {
            return false;
        }
        int n3 = n2 - 2 - n;
        if (string2.charAt(n3 - 1) != ')' || string2.charAt(n3) != 'L') {
            return false;
        }
        return string2.regionMatches(n3 + 1, string, 0, n);
    }

    private static class ResourceAnalyzer
    extends Analyzer {
        private Frame mCurrent;
        private Frame mFrame1;
        private Frame mFrame2;

        public ResourceAnalyzer(Interpreter interpreter) {
            super(interpreter);
        }

        Frame getCurrentFrame() {
            return this.mCurrent;
        }

        protected void init(String string, MethodNode methodNode) throws AnalyzerException {
            this.mCurrent = this.mFrame2;
            super.init(string, methodNode);
        }

        protected Frame newFrame(int n, int n2) {
            Frame frame = super.newFrame(n, n2);
            this.mFrame2 = this.mFrame1;
            this.mFrame1 = frame;
            return frame;
        }
    }

    private static class CleanupTracker
    extends Interpreter {
        private static final Value INSTANCE = BasicValue.INT_VALUE;
        private static final Value RECYCLED = BasicValue.FLOAT_VALUE;
        private static final Value UNKNOWN = BasicValue.UNINITIALIZED_VALUE;
        private final ClassContext mContext;
        private final MethodNode mMethod;
        private final MethodInsnNode mObtainNode;
        private boolean mIsCleanedUp;
        private boolean mEscapes;
        private final String mRecycleOwner;
        private ResourceAnalyzer mAnalyzer;

        public CleanupTracker(@NonNull ClassContext classContext, @NonNull MethodNode methodNode, @NonNull MethodInsnNode methodInsnNode, @NonNull String string) {
            super(262144);
            this.mContext = classContext;
            this.mMethod = methodNode;
            this.mObtainNode = methodInsnNode;
            this.mRecycleOwner = string;
        }

        void setAnalyzer(ResourceAnalyzer resourceAnalyzer) {
            this.mAnalyzer = resourceAnalyzer;
        }

        public boolean isCleanedUp() {
            return this.mIsCleanedUp;
        }

        public boolean isEscaped() {
            return this.mEscapes;
        }

        public Value newOperation(AbstractInsnNode abstractInsnNode) throws AnalyzerException {
            return UNKNOWN;
        }

        public Value newValue(Type type) {
            if (type != null && type.getSort() == 0) {
                return null;
            }
            return UNKNOWN;
        }

        public Value copyOperation(AbstractInsnNode abstractInsnNode, Value value) throws AnalyzerException {
            return value;
        }

        public Value binaryOperation(AbstractInsnNode abstractInsnNode, Value value, Value value2) throws AnalyzerException {
            if (abstractInsnNode.getOpcode() == 181 && value2 == INSTANCE) {
                this.mEscapes = true;
            }
            return this.merge(value, value2);
        }

        public Value naryOperation(AbstractInsnNode abstractInsnNode, List list) throws AnalyzerException {
            if (abstractInsnNode == this.mObtainNode) {
                return INSTANCE;
            }
            MethodInsnNode methodInsnNode = null;
            if (abstractInsnNode.getType() == 5) {
                methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (abstractInsnNode.getOpcode() == 182) {
                    if (methodInsnNode.name.equals(CleanupDetector.RECYCLE) && methodInsnNode.owner.equals(this.mRecycleOwner)) {
                        if (list != null && list.size() == 1 && list.get(0) == INSTANCE) {
                            this.mIsCleanedUp = true;
                            Frame frame = this.mAnalyzer.getCurrentFrame();
                            if (frame != null) {
                                int n;
                                int n2 = frame.getLocals();
                                for (n = 0; n < n2; ++n) {
                                    Value value = frame.getLocal(n);
                                    if (value != INSTANCE) continue;
                                    frame.setLocal(n, RECYCLED);
                                }
                                n = frame.getStackSize();
                                if (n == 1 && frame.getStack(0) == INSTANCE) {
                                    frame.pop();
                                    frame.push(RECYCLED);
                                }
                            }
                            return RECYCLED;
                        }
                    } else if ((methodInsnNode.name.equals(CleanupDetector.COMMIT) || methodInsnNode.name.equals(CleanupDetector.COMMIT_ALLOWING_LOSS)) && methodInsnNode.owner.equals(this.mRecycleOwner)) {
                        if (list != null && list.size() == 1 && list.get(0) == INSTANCE) {
                            this.mIsCleanedUp = true;
                            return INSTANCE;
                        }
                    } else if (methodInsnNode.owner.equals(this.mRecycleOwner) && CleanupDetector.hasReturnType(this.mRecycleOwner, methodInsnNode.desc)) {
                        return INSTANCE;
                    }
                }
            }
            if (list != null && list.size() >= 1) {
                int n = abstractInsnNode.getOpcode() == 184 ? 0 : 1;
                int n3 = list.size();
                for (int i = 0; i < n3; ++i) {
                    Object e = list.get(i);
                    if (e == INSTANCE && i >= n) {
                        if (abstractInsnNode.getOpcode() == 184) {
                            assert (methodInsnNode != null);
                            if (methodInsnNode.name.equals(CleanupDetector.OBTAIN) && methodInsnNode.owner.equals(CleanupDetector.MOTION_EVENT_CLS)) {
                                return UNKNOWN;
                            }
                        }
                        this.mEscapes = true;
                        continue;
                    }
                    if (e != RECYCLED || methodInsnNode == null) continue;
                    Location location = this.mContext.getLocation((AbstractInsnNode)methodInsnNode);
                    String string = String.format("This %1$s has already been recycled", this.mRecycleOwner.substring(this.mRecycleOwner.lastIndexOf(47) + 1));
                    this.mContext.report(RECYCLE_RESOURCE, this.mMethod, (AbstractInsnNode)methodInsnNode, location, string, null);
                }
            }
            return UNKNOWN;
        }

        public Value unaryOperation(AbstractInsnNode abstractInsnNode, Value value) throws AnalyzerException {
            return value;
        }

        public Value ternaryOperation(AbstractInsnNode abstractInsnNode, Value value, Value value2, Value value3) throws AnalyzerException {
            if (value == RECYCLED || value2 == RECYCLED || value3 == RECYCLED) {
                return RECYCLED;
            }
            if (value == INSTANCE || value2 == INSTANCE || value3 == INSTANCE) {
                return INSTANCE;
            }
            return UNKNOWN;
        }

        public void returnOperation(AbstractInsnNode abstractInsnNode, Value value, Value value2) throws AnalyzerException {
            if (value == INSTANCE || value2 == INSTANCE) {
                this.mEscapes = true;
            }
        }

        public Value merge(Value value, Value value2) {
            if (value == RECYCLED || value2 == RECYCLED) {
                return RECYCLED;
            }
            if (value == INSTANCE || value2 == INSTANCE) {
                return INSTANCE;
            }
            return UNKNOWN;
        }
    }
}

