/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create((String)"DuplicateDefinition", (String)"Discovers duplicate definitions of resources", (String)"You can define a resource multiple times in different resource folders; that's how string translations are done, for example. However, defining the same resource more than once in the same resource folder is likely an error, for example attempting to add a new resource without realizing that the name is already used, and so on.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, DuplicateResourceDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE).addAnalysisScope(Scope.RESOURCE_FILE_SCOPE);
    private static final String PRODUCT = "product";
    private Map<ResourceType, Set<String>> mTypeMap;
    private Map<ResourceType, List<Pair<String, Location.Handle>>> mLocations;
    private File mParent;

    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    @Nullable
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("name");
    }

    public boolean appliesTo(@NonNull ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.VALUES;
    }

    public void beforeCheckFile(@NonNull Context context) {
        File file = context.file.getParentFile();
        if (!file.equals(this.mParent)) {
            this.mParent = file;
            this.mTypeMap = Maps.newEnumMap(ResourceType.class);
            this.mLocations = Maps.newEnumMap(ResourceType.class);
        }
    }

    public void visitAttribute(@NonNull XmlContext xmlContext, @NonNull Attr attr) {
        String string;
        ResourceType resourceType;
        String string2;
        Element element = attr.getOwnerElement();
        if (element.hasAttribute(PRODUCT)) {
            return;
        }
        String string3 = string2 = element.getTagName();
        if (string2.equals("item")) {
            string3 = element.getAttribute("type");
        }
        if ((resourceType = ResourceType.getEnum((String)string3)) == null) {
            return;
        }
        if (resourceType == ResourceType.ATTR && element.getParentNode().getNodeName().equals(ResourceType.DECLARE_STYLEABLE.getName())) {
            return;
        }
        HashSet hashSet = this.mTypeMap.get(resourceType);
        if (hashSet == null) {
            hashSet = Sets.newHashSetWithExpectedSize((int)40);
            this.mTypeMap.put(resourceType, hashSet);
        }
        if (hashSet.contains(string = attr.getValue())) {
            String string4 = String.format("%1$s has already been defined in this folder", string);
            Location location = xmlContext.getLocation((Node)attr);
            List<Pair<String, Location.Handle>> list = this.mLocations.get(resourceType);
            for (Pair<String, Location.Handle> pair : list) {
                if (!string.equals(pair.getFirst())) continue;
                Location location2 = ((Location.Handle)pair.getSecond()).resolve();
                location2.setMessage("Previously defined here");
                location.setSecondary(location2);
            }
            xmlContext.report(ISSUE, (Node)attr, location, string4, null);
        } else {
            hashSet.add(string);
            ArrayList arrayList = this.mLocations.get(resourceType);
            if (arrayList == null) {
                arrayList = Lists.newArrayList();
                this.mLocations.put(resourceType, arrayList);
            }
            Location.Handle handle = xmlContext.parser.createLocationHandle(xmlContext, (Node)attr);
            arrayList.add(Pair.of((Object)string, (Object)handle));
        }
    }
}

