/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HardcodedValuesDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"HardcodedText", (String)"Looks for hardcoded text attributes which should be converted to resource lookup", (String)"Hardcoding text attributes directly in layout files is bad for several reasons:\n\n* When creating configuration variations (for example for landscape or portrait)you have to repeat the actual text (and keep it up to date when making changes)\n\n* The application cannot be translated to other languages by just adding new translations for existing string resources.\n\nIn Eclipse there is a quickfix to automatically extract this hardcoded string into a resource lookup.", (Category)Category.I18N, (int)5, (Severity)Severity.WARNING, HardcodedValuesDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("text", "contentDescription", "hint", "label", "prompt", "title");
    }

    public boolean appliesTo(@NonNull ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.LAYOUT || resourceFolderType == ResourceFolderType.MENU;
    }

    public void visitAttribute(@NonNull XmlContext xmlContext, @NonNull Attr attr) {
        String string = attr.getValue();
        if (!string.isEmpty() && string.charAt(0) != '@' && string.charAt(0) != '?') {
            if (!"http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI())) {
                return;
            }
            xmlContext.report(ISSUE, (Node)attr, xmlContext.getLocation((Node)attr), String.format("[I18N] Hardcoded string \"%1$s\", should use @string resource", string), null);
        }
    }
}

