/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InefficientWeightDetector
extends LayoutDetector {
    public static final Issue INEFFICIENT_WEIGHT = Issue.create((String)"InefficientWeight", (String)"Looks for inefficient weight declarations in LinearLayouts", (String)"When only a single widget in a LinearLayout defines a weight, it is more efficient to assign a width/height of `0dp` to it since it will absorb all the remaining space anyway. With a declared width/height of `0dp` it does not have to measure its own size first.", (Category)Category.PERFORMANCE, (int)3, (Severity)Severity.WARNING, InefficientWeightDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);
    public static final Issue NESTED_WEIGHTS = Issue.create((String)"NestedWeights", (String)"Looks for nested layout weights, which are costly", (String)"Layout weights require a widget to be measured twice. When a LinearLayout with non-zero weights is nested inside another LinearLayout with non-zero weights, then the number of measurements increase exponentially.", (Category)Category.PERFORMANCE, (int)3, (Severity)Severity.WARNING, InefficientWeightDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);
    public static final Issue BASELINE_WEIGHTS = Issue.create((String)"DisableBaselineAlignment", (String)"Looks for LinearLayouts which should set android:baselineAligned=false", (String)"When a LinearLayout is used to distribute the space proportionally between nested layouts, the baseline alignment property should be turned off to make the layout computation faster.", (Category)Category.PERFORMANCE, (int)3, (Severity)Severity.WARNING, InefficientWeightDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);
    public static final Issue WRONG_0DP = Issue.create((String)"Suspicious0dp", (String)"Looks for 0dp as the width in a vertical LinearLayout or as the height in a horizontal", (String)"Using 0dp as the width in a horizontal LinearLayout with weights is a useful trick to ensure that only the weights (and not the intrinsic sizes) are used when sizing the children.\n\nHowever, if you use 0dp for the opposite dimension, the view will be invisible. This can happen if you change the orientation of a layout without also flipping the 0dp dimension in all the children.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, InefficientWeightDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);
    public static final Issue ORIENTATION = Issue.create((String)"Orientation", (String)"Checks that LinearLayouts with multiple children set the orientation", (String)"The default orientation of a LinearLayout is horizontal. It's pretty easy to believe that the layout is vertical, add multiple children to it, and wonder why only the first child is visible (when the subsequent children are off screen to the right). This lint rule helps pinpoint this issue by warning whenever a LinearLayout is used with an implicit orientation and multiple children.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.ERROR, InefficientWeightDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);
    private final Map<Node, Boolean> mInsideWeight = new IdentityHashMap<Node, Boolean>();

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("LinearLayout");
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        Object object;
        Iterator iterator;
        Object object2;
        List list = LintUtils.getChildren((Node)element);
        boolean bl = false;
        Element element2 = null;
        boolean bl2 = xmlContext.isEnabled(NESTED_WEIGHTS);
        for (Element element3 : list) {
            if (!element3.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight")) continue;
            if (element2 != null) {
                bl = true;
            } else if (!bl) {
                element2 = element3;
            }
            if (!bl2) continue;
            this.mInsideWeight.put(element3, Boolean.TRUE);
            object2 = this.mInsideWeight.get(element);
            if (object2 == null) {
                this.mInsideWeight.put(element, Boolean.FALSE);
                continue;
            }
            if (!((Boolean)object2).booleanValue()) continue;
            iterator = element3.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_weight");
            xmlContext.report(NESTED_WEIGHTS, iterator, xmlContext.getLocation(iterator), "Nested weights are bad for performance", null);
            bl2 = false;
        }
        String string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation");
        if (list.size() >= 2 && (string == null || string.isEmpty()) && xmlContext.isEnabled(ORIENTATION)) {
            boolean bl3 = false;
            object2 = list.iterator();
            while (object2.hasNext()) {
                iterator = (Element)object2.next();
                if (!object2.hasNext()) break;
                object = iterator.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_width");
                if (!"match_parent".equals(object) && !"fill_parent".equals(object) || iterator.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight")) continue;
                bl3 = true;
                break;
            }
            if (bl3 && !element.hasAttribute("style")) {
                iterator = "Wrong orientation? No orientation specified, and the default is horizontal, yet this layout has multiple children where at least one has layout_width=\"match_parent\"";
                xmlContext.report(ORIENTATION, (Node)element, xmlContext.getLocation((Node)element), iterator, null);
            }
        }
        if (xmlContext.isEnabled(BASELINE_WEIGHTS) && element2 != null && !"vertical".equals(string) && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "baselineAligned")) {
            boolean bl4 = !list.isEmpty();
            object2 = xmlContext.getClient().getSdkInfo(xmlContext.getProject());
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (Element)iterator.next();
                String string2 = object.getTagName();
                if (object2.isLayout(string2) && !string2.equals("RadioGroup") || "fragment".equals(string2) || "include".equals(string2)) continue;
                bl4 = false;
            }
            if (bl4) {
                xmlContext.report(BASELINE_WEIGHTS, (Node)element, xmlContext.getLocation((Node)element), "Set android:baselineAligned=\"false\" on this element for better performance", null);
            }
        }
        if (xmlContext.isEnabled(INEFFICIENT_WEIGHT) && element2 != null && !bl) {
            String string3 = "vertical".equals(string) ? "layout_height" : "layout_width";
            object2 = element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", string3);
            Iterator iterator2 = iterator = object2 != null ? object2.getValue() : "(undefined)";
            if (!((String)((Object)iterator)).startsWith("0")) {
                object = String.format("Use a %1$s of 0dip instead of %2$s for better performance", string3, iterator);
                xmlContext.report(INEFFICIENT_WEIGHT, (Node)element2, xmlContext.getLocation((Node)(object2 != null ? object2 : element2)), (String)object, null);
            }
        }
        if (xmlContext.isEnabled(WRONG_0DP)) {
            InefficientWeightDetector.checkWrong0Dp(xmlContext, element, list);
        }
    }

    private static void checkWrong0Dp(XmlContext xmlContext, Element element, List<Element> list) {
        boolean bl = false;
        String string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation");
        if ("vertical".equals(string)) {
            bl = true;
        }
        for (Element element2 : list) {
            String string2 = element2.getTagName();
            if (string2.equals("View")) {
                return;
            }
            if (string2.indexOf(46) != -1 || string2.equals("view")) {
                return;
            }
            boolean bl2 = element2.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight");
            Attr attr = element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_width");
            Attr attr2 = element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_height");
            boolean bl3 = false;
            boolean bl4 = false;
            if (attr != null && attr.getValue().startsWith("0")) {
                bl3 = true;
            }
            if (attr2 != null && attr2.getValue().startsWith("0")) {
                bl4 = true;
            } else if (!bl3) {
                return;
            }
            if (bl3 && bl4) {
                return;
            }
            assert (bl3 || bl4);
            if (bl3) {
                assert (attr != null);
                if (!bl2) {
                    xmlContext.report(WRONG_0DP, (Node)attr, xmlContext.getLocation((Node)attr), "Suspicious size: this will make the view invisible, should be used with layout_weight", null);
                    continue;
                }
                if (!bl) continue;
                xmlContext.report(WRONG_0DP, (Node)attr, xmlContext.getLocation((Node)attr), "Suspicious size: this will make the view invisible, probably intended for layout_height", null);
                continue;
            }
            assert (bl4);
            assert (attr2 != null);
            if (!bl2) {
                xmlContext.report(WRONG_0DP, (Node)attr, xmlContext.getLocation((Node)attr2), "Suspicious size: this will make the view invisible, should be used with layout_weight", null);
                continue;
            }
            if (bl) continue;
            xmlContext.report(WRONG_0DP, (Node)attr, xmlContext.getLocation((Node)attr2), "Suspicious size: this will make the view invisible, probably intended for layout_width", null);
        }
    }
}

