/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelForDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"LabelFor", (String)"Ensures that text fields are marked with a labelFor attribute", (String)"Text fields should be labelled with a `labelFor` attribute, provided your `minSdkVersion` is at least 17.\n\nIf your view is labeled but by a label in a different layout which includes this one, just suppress this warning from lint.", (Category)Category.A11Y, (int)2, (Severity)Severity.WARNING, LabelForDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);
    private Set<String> mLabels;
    private List<Element> mTextFields;

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Nullable
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("labelFor");
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("EditText", "AutoCompleteTextView", "MultiAutoCompleteTextView");
    }

    public void afterCheckFile(@NonNull Context context) {
        if (this.mTextFields != null) {
            if (this.mLabels == null) {
                this.mLabels = Collections.emptySet();
            }
            for (Element element : this.mTextFields) {
                if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "hint")) continue;
                String string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
                boolean bl = true;
                if (this.mLabels.contains(string)) {
                    bl = false;
                } else if (string.startsWith("@+id/")) {
                    bl = !this.mLabels.contains("@id/" + LintUtils.stripIdPrefix((String)string));
                } else if (string.startsWith("@id/")) {
                    boolean bl2 = bl = !this.mLabels.contains("@+id/" + LintUtils.stripIdPrefix((String)string));
                }
                if (!bl) continue;
                XmlContext xmlContext = (XmlContext)context;
                Location location = xmlContext.getLocation((Node)element);
                String string2 = string == null || string.isEmpty() ? "No label views point to this text field with a labelFor attribute" : String.format("No label views point to this text field with an android:labelFor=\"@+id/%1$s\" attribute", string);
                xmlContext.report(ISSUE, (Node)element, location, string2, null);
            }
        }
        this.mLabels = null;
        this.mTextFields = null;
    }

    public void visitAttribute(@NonNull XmlContext xmlContext, @NonNull Attr attr) {
        if (this.mLabels == null) {
            this.mLabels = Sets.newHashSet();
        }
        this.mLabels.add(attr.getValue());
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        if (xmlContext.getMainProject().getMinSdk() < 17) {
            return;
        }
        if (this.mTextFields == null) {
            this.mTextFields = new ArrayList<Element>();
        }
        this.mTextFields.add(element);
    }
}

