/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PxUsageDetector
extends LayoutDetector {
    public static final Issue PX_ISSUE = Issue.create((String)"PxUsage", (String)"Looks for use of the \"px\" dimension", (String)"For performance reasons and to keep the code simpler, the Android system uses pixels as the standard unit for expressing dimension or coordinate values. That means that the dimensions of a view are always expressed in the code using pixels, but always based on the current screen density. For instance, if `myView.getWidth()` returns 10, the view is 10 pixels wide on the current screen, but on a device with a higher density screen, the value returned might be 15. If you use pixel values in your application code to work with bitmaps that are not pre-scaled for the current screen density, you might need to scale the pixel values that you use in your code to match the un-scaled bitmap source.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.WARNING, PxUsageDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE).setMoreInfo("http://developer.android.com/guide/practices/screens_support.html#screen-independence");
    public static final Issue IN_MM_ISSUE = Issue.create((String)"InOrMmUsage", (String)"Looks for use of the \"mm\" or \"in\" dimensions", (String)"Avoid using `mm` (millimeters) or `in` (inches) as the unit for dimensions.\n\nWhile it should work in principle, unfortunately many devices do not report the correct true physical density, which means that the dimension calculations won't work correctly. You are better off using `dp` (and for font sizes, `sp`.)", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, PxUsageDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);
    public static final Issue DP_ISSUE = Issue.create((String)"SpUsage", (String)"Looks for uses of \"dp\" instead of \"sp\" dimensions for text sizes", (String)"When setting text sizes, you should normally use `sp`, or \"scale-independent pixels\". This is like the `dp` unit, but it is also scaled by the user's font size preference. It is recommend you use this unit when specifying font sizes, so they will be adjusted for both the screen density and the user's preference.\n\nThere *are* cases where you might need to use `dp`; typically this happens when the text is in a container with a specific dp-size. This will prevent the text from spilling outside the container. Note however that this means that the user's font size settings are not respected, so consider adjusting the layout itself to be more flexible.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, PxUsageDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE).setMoreInfo("http://developer.android.com/training/multiscreen/screendensities.html");
    public static final Issue SMALL_SP_ISSUE = Issue.create((String)"SmallSp", (String)"Looks for text sizes that are too small", (String)"Avoid using sizes smaller than 12sp.", (Category)Category.USABILITY, (int)4, (Severity)Severity.WARNING, PxUsageDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public boolean appliesTo(@NonNull ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.LAYOUT || resourceFolderType == ResourceFolderType.VALUES;
    }

    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Nullable
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("style");
    }

    public void visitAttribute(@NonNull XmlContext xmlContext, @NonNull Attr attr) {
        if (xmlContext.getResourceFolderType() != ResourceFolderType.LAYOUT) {
            return;
        }
        String string = attr.getValue();
        if (string.endsWith("px") && string.matches("\\d+px")) {
            if (string.charAt(0) == '0') {
                return;
            }
            if (xmlContext.isEnabled(PX_ISSUE)) {
                xmlContext.report(PX_ISSUE, (Node)attr, xmlContext.getLocation((Node)attr), "Avoid using \"px\" as units; use \"dp\" instead", null);
            }
        } else if (string.endsWith("mm") && string.matches("\\d+mm") || string.endsWith("in") && string.matches("\\d+in")) {
            if (string.charAt(0) == '0') {
                return;
            }
            if (xmlContext.isEnabled(IN_MM_ISSUE)) {
                String string2 = string.substring(string.length() - 2);
                xmlContext.report(IN_MM_ISSUE, (Node)attr, xmlContext.getLocation((Node)attr), String.format("Avoid using \"%1$s\" as units (it does not work accurately on all devices); use \"dp\" instead", string2), null);
            }
        } else if (string.endsWith("sp") && ("textSize".equals(attr.getLocalName()) || "layout_height".equals(attr.getLocalName())) && string.matches("\\d+sp")) {
            int n = PxUsageDetector.getSize(string);
            if (n > 0 && n < 12) {
                xmlContext.report(SMALL_SP_ISSUE, (Node)attr, xmlContext.getLocation((Node)attr), String.format("Avoid using sizes smaller than 12sp: %1$s", string), null);
            }
        } else if ("textSize".equals(attr.getLocalName()) && (string.endsWith("dp") || string.endsWith("dip")) && string.matches("\\d+di?p") && xmlContext.isEnabled(DP_ISSUE)) {
            xmlContext.report(DP_ISSUE, (Node)attr, xmlContext.getLocation((Node)attr), "Should use \"sp\" instead of \"dp\" for text sizes", null);
        }
    }

    private static int getSize(String string) {
        assert (string.matches("\\d+sp")) : string;
        return Integer.parseInt(string.substring(0, string.length() - 2));
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        if (xmlContext.getResourceFolderType() != ResourceFolderType.VALUES) {
            return;
        }
        assert (element.getTagName().equals("style"));
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"item".equals(node.getNodeName())) continue;
            Element element2 = (Element)node;
            NodeList nodeList2 = node.getChildNodes();
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 3) {
                    return;
                }
                PxUsageDetector.checkStyleItem(xmlContext, element2, node2);
            }
        }
    }

    private static void checkStyleItem(XmlContext xmlContext, Element element, Node node) {
        String string = node.getNodeValue();
        for (int i = string.length() - 1; i > 0; --i) {
            int n;
            String string2;
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c == 'x' && string.charAt(i - 1) == 'p') {
                if (!(string = string.trim()).matches("\\d+px") || string.charAt(0) == '0' || !xmlContext.isEnabled(PX_ISSUE)) break;
                xmlContext.report(PX_ISSUE, (Node)element, xmlContext.getLocation(node), "Avoid using \"px\" as units; use \"dp\" instead", null);
                break;
            }
            if (c == 'm' && string.charAt(i - 1) == 'm' || c == 'n' && string.charAt(i - 1) == 'i') {
                string = string.trim();
                String string3 = string.substring(string.length() - 2);
                if (!string.matches("\\d+" + string3) || string.charAt(0) == '0' || !xmlContext.isEnabled(IN_MM_ISSUE)) break;
                xmlContext.report(IN_MM_ISSUE, (Node)element, xmlContext.getLocation(node), String.format("Avoid using \"%1$s\" as units (it does not work accurately on all devices); use \"dp\" instead", string3), null);
                break;
            }
            if (c == 'p' && (string.charAt(i - 1) == 'd' || string.charAt(i - 1) == 'i')) {
                string = string.trim();
                String string4 = element.getAttribute("name");
                if (!string4.equals("textSize") && !string4.equals("android:textSize") || !string.matches("\\d+di?p") || !xmlContext.isEnabled(DP_ISSUE)) break;
                xmlContext.report(DP_ISSUE, (Node)element, xmlContext.getLocation(node), "Should use \"sp\" instead of \"dp\" for text sizes", null);
                break;
            }
            if (c != 'p' || string.charAt(i - 1) != 's' || !"textSize".equals(string2 = element.getAttribute("name")) && !"layout_height".equals(string2)) break;
            string = string.trim();
            String string5 = string.substring(string.length() - 2);
            if (!string.matches("\\d+" + string5) || !xmlContext.isEnabled(SMALL_SP_ISSUE) || (n = PxUsageDetector.getSize(string)) <= 0 || n >= 12) break;
            xmlContext.report(SMALL_SP_ISSUE, (Node)element, xmlContext.getLocation(node), String.format("Avoid using sizes smaller than 12sp: %1$s", string), null);
            break;
        }
    }
}

