/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFieldDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"TextFields", (String)"Looks for text fields missing inputType or hint settings", (String)"Providing an `inputType` attribute on a text field improves usability because depending on the data to be input, optimized keyboards can be shown to the user (such as just digits and parentheses for a phone number). Similarly,a hint attribute displays a hint to the user for what is expected in the text field.\n\nThe lint detector also looks at the `id` of the view, and if the id offers a hint of the purpose of the field (for example, the `id` contains the phrase `phone` or `email`), then lint will also ensure that the `inputType` contains the corresponding type attributes.\n\nIf you really want to keep the text field generic, you can suppress this warning by setting `inputType=\"text\"`.", (Category)Category.USABILITY, (int)5, (Severity)Severity.WARNING, TextFieldDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("EditText");
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        String string;
        Attr attr;
        String string2 = element.getAttribute("style");
        if (string2 != null && !string2.isEmpty()) {
            return;
        }
        Attr attr2 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "inputType");
        if (attr2 == null && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "hint")) {
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "inputMethod")) {
                return;
            }
            xmlContext.report(ISSUE, (Node)element, xmlContext.getLocation((Node)element), "This text field does not specify an inputType or a hint", null);
        }
        if ((attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "id")) == null) {
            return;
        }
        String string3 = attr.getValue();
        if (string3.isEmpty()) {
            return;
        }
        if (string3.startsWith("editText")) {
            return;
        }
        String string4 = "";
        if (attr2 != null) {
            string4 = attr2.getValue();
        }
        if (TextFieldDetector.containsWord(string3, "phone", true, true)) {
            if (!string4.contains("phone") && element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "phoneNumber") == null) {
                String string5 = String.format("The view name (%1$s) suggests this is a phone number, but it does not include 'phone' in the inputType", string3);
                TextFieldDetector.reportMismatch(xmlContext, attr, attr2, string5);
            }
            return;
        }
        if (TextFieldDetector.containsWord(string3, "width", false, true) || TextFieldDetector.containsWord(string3, "height", false, true) || TextFieldDetector.containsWord(string3, "size", false, true) || TextFieldDetector.containsWord(string3, "length", false, true) || TextFieldDetector.containsWord(string3, "weight", false, true) || TextFieldDetector.containsWord(string3, "number", false, true)) {
            if (!string4.contains("number") && !string4.contains("phone")) {
                String string6 = String.format("The view name (%1$s) suggests this is a number, but it does not include a numeric inputType (such as 'numberSigned')", string3);
                TextFieldDetector.reportMismatch(xmlContext, attr, attr2, string6);
            }
            return;
        }
        if (TextFieldDetector.containsWord(string3, "password", true, true)) {
            if (!string4.contains("Password") && element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "password") == null) {
                String string7 = String.format("The view name (%1$s) suggests this is a password, but it does not include 'textPassword' in the inputType", string3);
                TextFieldDetector.reportMismatch(xmlContext, attr, attr2, string7);
            }
            return;
        }
        if (TextFieldDetector.containsWord(string3, "email", true, true)) {
            if (!string4.contains("Email")) {
                String string8 = String.format("The view name (%1$s) suggests this is an e-mail address, but it does not include 'textEmail' in the inputType", string3);
                TextFieldDetector.reportMismatch(xmlContext, attr, attr2, string8);
            }
            return;
        }
        if (TextFieldDetector.endsWith(string3, "pin", false, true)) {
            if (!string4.contains("numberPassword") && element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "password") == null) {
                String string9 = String.format("The view name (%1$s) suggests this is a password, but it does not include 'numberPassword' in the inputType", string3);
                TextFieldDetector.reportMismatch(xmlContext, attr, attr2, string9);
            }
            return;
        }
        if ((TextFieldDetector.containsWord(string3, "uri") || TextFieldDetector.containsWord(string3, "url")) && !string4.contains("textUri")) {
            string = String.format("The view name (%1$s) suggests this is a URI, but it does not include 'textUri' in the inputType", string3);
            TextFieldDetector.reportMismatch(xmlContext, attr, attr2, string);
        }
        if (TextFieldDetector.containsWord(string3, "date") && !string4.contains("date")) {
            string = String.format("The view name (%1$s) suggests this is a date, but it does not include 'date' or 'datetime' in the inputType", string3);
            TextFieldDetector.reportMismatch(xmlContext, attr, attr2, string);
        }
    }

    private static void reportMismatch(XmlContext xmlContext, Attr attr, Attr attr2, String string) {
        Location location;
        if (attr2 != null) {
            location = xmlContext.getLocation((Node)attr2);
            Location location2 = xmlContext.getLocation((Node)attr);
            location2.setMessage("id defined here");
            location.setSecondary(location2);
        } else {
            location = xmlContext.getLocation((Node)attr);
        }
        xmlContext.report(ISSUE, (Node)attr.getOwnerElement(), location, string, null);
    }

    static boolean containsWord(String string, String string2) {
        return TextFieldDetector.containsWord(string, string2, false, false);
    }

    static boolean containsWord(String string, String string2, boolean bl, boolean bl2) {
        return TextFieldDetector.indexOfWord(string, string2, bl, bl2) != -1;
    }

    private static boolean endsWith(String string, String string2, boolean bl, boolean bl2) {
        int n = TextFieldDetector.indexOfWord(string, string2, bl, bl2);
        if (n != -1) {
            return n == string.length() - string2.length();
        }
        return false;
    }

    private static int indexOfWord(String string, String string2, boolean bl, boolean bl2) {
        if (string.isEmpty()) {
            return -1;
        }
        int n = string2.length();
        if (n > string.length()) {
            return -1;
        }
        char c = Character.toUpperCase(string2.charAt(0));
        char c2 = Character.toLowerCase(c);
        int n2 = 0;
        if (string.startsWith("@+id/")) {
            n2 += "@+id/".length();
        } else if (string.startsWith("@id/")) {
            n2 += "@id/".length();
        }
        int n3 = string.length();
        int n4 = n3 - (n - 1);
        for (int i = n2; i < n4; ++i) {
            char c3 = string.charAt(i);
            if (c3 != c && c3 != c2 || !string.regionMatches(true, i, string2, 0, n)) continue;
            if (i <= n2 && bl) {
                return i;
            }
            if (i == n4 - 1 && bl2) {
                return i;
            }
            if (i > n2 && string.charAt(i - 1) != '_' && !Character.isUpperCase(c3)) continue;
            if (i == n4 - 1) {
                return i;
            }
            char c4 = string.charAt(i + n);
            if (c4 != '_' && !Character.isUpperCase(c4)) continue;
            return i;
        }
        return -1;
    }
}

