/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationDetector
extends ResourceXmlDetector {
    static boolean sCompleteRegions = System.getenv("ANDROID_LINT_COMPLETE_REGIONS") != null;
    private static final Pattern LANGUAGE_PATTERN = Pattern.compile("^[a-z]{2}$");
    private static final Pattern REGION_PATTERN = Pattern.compile("^r([A-Z]{2})$");
    public static final Issue MISSING = Issue.create((String)"MissingTranslation", (String)"Checks for incomplete translations where not all strings are translated", (String)"If an application has more than one locale, then all the strings declared in one language should also be translated in all other languages.\n\nIf the string should *not* be translated, you can add the attribute `translatable=\"false\"` on the `<string>` element, or you can define all your non-translatable strings in a resource file called `donottranslate.xml`. Or, you can ignore the issue with a `tools:ignore=\"MissingTranslation\"` attribute.\n\nBy default this detector allows regions of a language to just provide a subset of the strings and fall back to the standard language strings. You can require all regions to provide a full translation by setting the environment variable `ANDROID_LINT_COMPLETE_REGIONS`.\n\nYou can tell lint (and other tools) which language is the default language in your `res/values/` folder by specifying `tools:locale=\"languageCode\"` for the root `<resources>` element in your resource file. (The `tools` prefix refers to the namespace declaration `http://schemas.android.com/tools`.)", (Category)Category.MESSAGES, (int)8, (Severity)Severity.FATAL, TranslationDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE);
    public static final Issue EXTRA = Issue.create((String)"ExtraTranslation", (String)"Checks for translations that appear to be unused (no default language string)", (String)"If a string appears in a specific language translation file, but there is no corresponding string in the default locale, then this string is probably unused. (It's technically possible that your application is only intended to run in a specific locale, but it's still a good idea to provide a fallback.).\n\nNote that these strings can lead to crashes if the string is looked up on any locale not providing a translation, so it's important to clean them up.", (Category)Category.MESSAGES, (int)6, (Severity)Severity.FATAL, TranslationDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE);
    private Set<String> mNames;
    private Set<String> mTranslatedArrays;
    private Set<String> mNonTranslatable;
    private boolean mIgnoreFile;
    private Map<File, Set<String>> mFileToNames;
    private Map<File, String> mFileToLocale;
    private Map<String, Location> mMissingLocations;
    private Map<String, Location> mExtraLocations;
    private Map<String, String> mDescriptions;

    public boolean appliesTo(@NonNull ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.VALUES;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("string", "string-array");
    }

    public void beforeCheckProject(@NonNull Context context) {
        if (context.getDriver().getPhase() == 1) {
            this.mFileToNames = new HashMap<File, Set<String>>();
        }
    }

    public void beforeCheckFile(@NonNull Context context) {
        if (context.getPhase() == 1) {
            this.mNames = new HashSet<String>();
        }
        boolean bl = this.mIgnoreFile = context.file.getName().startsWith("donottranslate") || UnusedResourceDetector.isAnalyticsFile(context);
        if (!context.getProject().getReportIssues()) {
            this.mIgnoreFile = true;
        }
    }

    public void afterCheckFile(@NonNull Context context) {
        if (context.getPhase() == 1) {
            if (context.getProject().getReportIssues() && this.mNames != null) {
                String string;
                this.mFileToNames.put(context.file, this.mNames);
                Element element = ((XmlContext)context).document.getDocumentElement();
                if (element != null && (string = element.getAttributeNS("http://schemas.android.com/tools", "locale")) != null && !string.isEmpty()) {
                    if (this.mFileToLocale == null) {
                        this.mFileToLocale = Maps.newHashMap();
                    }
                    this.mFileToLocale.put(context.file, string);
                }
            }
            this.mNames = null;
        }
    }

    public void afterCheckProject(@NonNull Context context) {
        if (context.getPhase() == 1) {
            this.checkTranslations(context);
            this.mFileToNames = null;
            if (this.mMissingLocations != null || this.mExtraLocations != null) {
                context.getDriver().requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
            }
        } else {
            assert (context.getPhase() == 2);
            this.reportMap(context, MISSING, this.mMissingLocations);
            this.reportMap(context, EXTRA, this.mExtraLocations);
            this.mMissingLocations = null;
            this.mExtraLocations = null;
            this.mDescriptions = null;
        }
    }

    private void reportMap(Context context, Issue issue, Map<String, Location> map) {
        if (map != null) {
            for (Map.Entry<String, Location> entry : map.entrySet()) {
                Location location = entry.getValue();
                String string = entry.getKey();
                String string2 = this.mDescriptions.get(string);
                location = Location.reverse((Location)location);
                context.report(issue, location, string2, null);
            }
        }
    }

    private void checkTranslations(Context context) {
        String string;
        Set set;
        Map.Entry entry2;
        int n;
        Object object;
        Object object2;
        Set<File> set2 = this.mFileToNames.keySet();
        if (set2.size() == 1) {
            return;
        }
        HashSet<File> hashSet = new HashSet<File>();
        for (File file : set2) {
            hashSet.add(file.getParentFile());
        }
        if (hashSet.size() == 1) {
            return;
        }
        boolean bl = context.isEnabled(MISSING);
        boolean bl2 = context.isEnabled(EXTRA);
        String string2 = "Default";
        HashMap<File, String> hashMap = new HashMap<File, String>();
        for (File serializable2 : hashSet) {
            object2 = serializable2.getName();
            object = TranslationDetector.getLanguage((String)object2);
            if (object == null) {
                object = string2;
            }
            hashMap.put(serializable2, (String)object);
        }
        int n2 = hashMap.values().size();
        if (n2 <= 1) {
            return;
        }
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>(n2);
        object2 = new HashSet(200);
        for (File n3 : set2) {
            Object object3;
            Object bl3 = null;
            if (this.mFileToLocale != null && (object3 = this.mFileToLocale.get(n3)) != null) {
                int n4 = ((String)object3).indexOf(45);
                if (n4 != -1) {
                    object3 = ((String)object3).substring(0, n4);
                }
                bl3 = object3;
            }
            if (bl3 == null) {
                bl3 = (String)hashMap.get(n3.getParentFile());
            }
            assert (bl3 != null) : n3.getParent();
            object3 = this.mFileToNames.get(n3);
            Map.Entry n32 = (Set)hashMap2.get(bl3);
            if (n32 == null) {
                hashMap2.put(bl3, object3);
            } else {
                n32.addAll(object3);
            }
            object2.addAll(object3);
        }
        object = (Set)hashMap2.get(string2);
        if (object == null) {
            object = new HashSet();
        }
        if ((n = object2.size()) == object.size()) {
            boolean bl3 = false;
            for (Map.Entry n32 : hashMap2.entrySet()) {
                entry2 = (Set)n32.getValue();
                if (n == entry2.size()) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                return;
            }
        }
        if (!sCompleteRegions) {
            for (Object object3 : hashMap2.keySet()) {
                if (((String)object3).indexOf(45) == -1) continue;
                for (Map.Entry entry2 : hashMap2.entrySet()) {
                    Set set3;
                    Iterator iterator;
                    int string3;
                    set = (Set)entry2.getValue();
                    if (n == set.size() || (string3 = ((String)((Object)(iterator = (String)entry2.getKey()))).indexOf(45)) == -1 || (set3 = (Set)hashMap2.get(string = ((String)((Object)iterator)).substring(0, string3))) == null) continue;
                    set.addAll(set3);
                }
            }
        }
        ArrayList arrayList = new ArrayList(hashMap2.keySet());
        Collections.sort(arrayList);
        for (Map.Entry n32 : arrayList) {
            entry2 = (Set)hashMap2.get(n32);
            if (string2.equals(n32) || n == entry2.size()) continue;
            if (bl && !(set = Sets.difference(object, (Set)((Object)entry2))).isEmpty()) {
                if (this.mMissingLocations == null) {
                    this.mMissingLocations = new HashMap<String, Location>();
                }
                if (this.mDescriptions == null) {
                    this.mDescriptions = new HashMap<String, String>();
                }
                for (String string3 : set) {
                    this.mMissingLocations.put(string3, null);
                    string = this.mDescriptions.get(string3);
                    string = string == null ? String.format("\"%1$s\" is not translated in %2$s", string3, n32) : string + ", " + n32;
                    this.mDescriptions.put(string3, string);
                }
            }
            if (!bl2 || (set = Sets.difference((Set)((Object)entry2), object)).isEmpty()) continue;
            if (this.mExtraLocations == null) {
                this.mExtraLocations = new HashMap<String, Location>();
            }
            if (this.mDescriptions == null) {
                this.mDescriptions = new HashMap<String, String>();
            }
            for (String string3 : set) {
                if (this.mTranslatedArrays != null && this.mTranslatedArrays.contains(string3)) continue;
                this.mExtraLocations.put(string3, null);
                string = String.format("\"%1$s\" is translated here but not found in default locale", string3);
                this.mDescriptions.put(string3, string);
            }
        }
    }

    private static String getLanguage(String string) {
        String[] stringArray = string.split("-");
        String string2 = null;
        for (String string3 : stringArray) {
            if (string2 == null && string3.length() == 2 && LANGUAGE_PATTERN.matcher(string3).matches()) {
                string2 = string3;
            }
            if (string2 == null || string3.length() != 3 || !REGION_PATTERN.matcher(string3).matches()) continue;
            string2 = string2 + '-' + string3;
            break;
        }
        return string2;
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        if (this.mIgnoreFile) {
            return;
        }
        Attr attr = element.getAttributeNode("name");
        if (xmlContext.getPhase() == 2) {
            String string;
            if (attr == null) {
                return;
            }
            String string2 = attr.getValue();
            if (this.mMissingLocations != null && this.mMissingLocations.containsKey(string2) && (string = TranslationDetector.getLanguage(xmlContext.file.getParentFile().getName())) == null) {
                if (xmlContext.getDriver().isSuppressed(MISSING, (Node)element)) {
                    this.mMissingLocations.remove(string2);
                    return;
                }
                Location location = xmlContext.getLocation((Node)attr);
                location.setClientData((Object)element);
                location.setSecondary(this.mMissingLocations.get(string2));
                this.mMissingLocations.put(string2, location);
            }
            if (this.mExtraLocations != null && this.mExtraLocations.containsKey(string2)) {
                if (xmlContext.getDriver().isSuppressed(EXTRA, (Node)element)) {
                    this.mExtraLocations.remove(string2);
                    return;
                }
                string = xmlContext.getLocation((Node)attr);
                string.setClientData((Object)element);
                string.setMessage("Also translated here");
                string.setSecondary(this.mExtraLocations.get(string2));
                this.mExtraLocations.put(string2, (Location)string);
            }
            return;
        }
        assert (xmlContext.getPhase() == 1);
        if (attr == null || attr.getValue().isEmpty()) {
            xmlContext.report(MISSING, (Node)element, xmlContext.getLocation((Node)element), "Missing name attribute in <string> declaration", null);
        } else {
            String string = attr.getValue();
            Attr attr2 = element.getAttributeNode("translatable");
            if (attr2 != null && !Boolean.valueOf(attr2.getValue()).booleanValue()) {
                String string3 = LintUtils.getLocaleAndRegion((String)xmlContext.file.getParentFile().getName());
                if (string3 != null) {
                    xmlContext.report(EXTRA, (Node)attr2, xmlContext.getLocation((Node)attr2), "Non-translatable resources should only be defined in the base values/ folder", null);
                } else {
                    if (this.mNonTranslatable == null) {
                        this.mNonTranslatable = new HashSet<String>();
                    }
                    this.mNonTranslatable.add(string);
                }
                return;
            }
            if (element.getTagName().equals("string-array") && TranslationDetector.allItemsAreReferences(element)) {
                if (this.mTranslatedArrays == null) {
                    this.mTranslatedArrays = new HashSet<String>();
                }
                this.mTranslatedArrays.add(string);
                return;
            }
            this.mNames.add(string);
            if (this.mNonTranslatable != null && this.mNonTranslatable.contains(string)) {
                String string4 = String.format("The resource string \"%1$s\" has been marked as translatable=\"false\"", string);
                xmlContext.report(EXTRA, (Node)attr, xmlContext.getLocation((Node)attr), string4, null);
            }
        }
    }

    private static boolean allItemsAreReferences(Element element) {
        assert (element.getTagName().equals("string-array"));
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"item".equals(node.getNodeName())) continue;
            NodeList nodeList2 = node.getChildNodes();
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                String string;
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 3 || (string = node2.getNodeValue().trim()).startsWith("@android:") || string.startsWith("@string/")) continue;
                return false;
            }
        }
        return true;
    }
}

