/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.TypoLookup;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypoDetector
extends ResourceXmlDetector {
    @Nullable
    private TypoLookup mLookup;
    @Nullable
    private String mLastLanguage;
    @Nullable
    private String mLastRegion;
    @Nullable
    private String mLanguage;
    @Nullable
    private String mRegion;
    public static final Issue ISSUE = Issue.create((String)"Typos", (String)"Looks for typos in messages", (String)"This check looks through the string definitions, and if it finds any words that look like likely misspellings, they are flagged.", (Category)Category.MESSAGES, (int)7, (Severity)Severity.WARNING, TypoDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);

    public boolean appliesTo(@NonNull ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.VALUES;
    }

    private void initLocale(@NonNull String string) {
        this.mLanguage = null;
        this.mRegion = null;
        if (string.equals("values")) {
            return;
        }
        for (String string2 : Splitter.on((char)'-').split((CharSequence)string)) {
            char c;
            char c2;
            int n = string2.length();
            if (n == 2) {
                c2 = string2.charAt(0);
                c = string2.charAt(1);
                if (c2 < 'a' || c2 > 'z' || c < 'a' || c > 'z') continue;
                this.mLanguage = string2;
                continue;
            }
            if (n != 3 || string2.charAt(0) != 'r') continue;
            c2 = string2.charAt(1);
            c = string2.charAt(2);
            if (c2 < 'A' || c2 > 'Z' || c < 'A' || c > 'Z') break;
            this.mRegion = new String(new char[]{c2, c});
            break;
        }
    }

    public void beforeCheckFile(@NonNull Context context) {
        this.initLocale(context.file.getParentFile().getName());
        if (this.mLanguage == null) {
            String string;
            Element element;
            if (context instanceof XmlContext && (element = ((XmlContext)context).document.getDocumentElement()) != null && (string = element.getAttributeNS("http://schemas.android.com/tools", "locale")) != null && !string.isEmpty()) {
                this.initLocale("values-" + string);
            }
            if (this.mLanguage == null) {
                this.mLanguage = "en";
            }
        }
        if (!Objects.equal((Object)this.mLastLanguage, (Object)this.mLanguage) || !Objects.equal((Object)this.mLastRegion, (Object)this.mRegion)) {
            this.mLookup = TypoLookup.get(context.getClient(), this.mLanguage, this.mRegion);
            this.mLastLanguage = this.mLanguage;
            this.mLastRegion = this.mRegion;
        }
    }

    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("string");
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        if (this.mLookup == null) {
            return;
        }
        this.visit(xmlContext, element);
    }

    private void visit(XmlContext xmlContext, Node node) {
        if (node.getNodeType() == 3) {
            this.check(xmlContext, node, node.getNodeValue());
        } else {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.visit(xmlContext, nodeList.item(i));
            }
        }
    }

    private void check(XmlContext xmlContext, Node node, String string) {
        int n = string.length();
        int n2 = 0;
        boolean bl = false;
        while (n2 < n) {
            List<String> list;
            int n3;
            int n4;
            while (n2 < n) {
                n4 = string.charAt(n2);
                if (n4 == 92) {
                    ++n2;
                } else if (Character.isLetter((char)n4)) break;
                ++n2;
            }
            if (n2 >= n) {
                return;
            }
            n4 = n2;
            while (n2 < n) {
                n3 = string.charAt(n2);
                if (n3 == 92) {
                    ++n2;
                    break;
                }
                if (!Character.isLetter((char)n3)) break;
                if (string.charAt(n2) >= '\u0080') {
                    if (bl) {
                        list = (List<String>)string.substring(n4).getBytes(Charsets.UTF_8);
                        this.check(xmlContext, node, (byte[])list, 0, ((Object)list).length, string, n4);
                    } else {
                        list = (List<String>)string.getBytes(Charsets.UTF_8);
                        this.check(xmlContext, node, (byte[])list, 0, ((Object)list).length, string, 0);
                    }
                    return;
                }
                ++n2;
            }
            n3 = n2;
            bl = true;
            list = this.mLookup.getTypos(string, n4, n3);
            if (list != null) {
                TypoDetector.reportTypo(xmlContext, node, string, n4, list);
            }
            n2 = n3 + 1;
        }
    }

    private void check(XmlContext xmlContext, Node node, byte[] byArray, int n, int n2, String string, int n3) {
        int n4 = n;
        while (n4 < n2) {
            List<String> list;
            int n5;
            int n6;
            while (n4 < n2) {
                n6 = byArray[n4];
                if (n6 == 92) {
                    ++n3;
                    if (++n4 < n2) {
                        n6 = byArray[n4];
                    }
                } else if (TypoLookup.isLetter((byte)n6)) break;
                ++n4;
                if ((n6 & 0x80) != 0 && (n6 & 0xC0) != 192) continue;
                ++n3;
            }
            if (n4 >= n2) {
                return;
            }
            n6 = n3;
            int n7 = n4;
            while (n4 < n2) {
                n5 = byArray[n4];
                if (n5 == 92) {
                    ++n6;
                    if (++n4 >= n2 || ((n5 = byArray[n4++]) & 0x80) != 0 && (n5 & 0xC0) != 192) break;
                    ++n6;
                    break;
                }
                if (!TypoLookup.isLetter((byte)n5)) break;
                ++n4;
                if ((n5 & 0x80) != 0 && (n5 & 0xC0) != 192) continue;
                ++n6;
            }
            if ((list = this.mLookup.getTypos(byArray, n7, n5 = n4)) != null) {
                TypoDetector.reportTypo(xmlContext, node, string, n3, list);
            }
            n3 = n6;
        }
    }

    private static void reportTypo(XmlContext xmlContext, Node node, String string, int n, List<String> list) {
        String string2;
        int n2;
        if (list.size() < 2) {
            return;
        }
        String string3 = list.get(0);
        String string4 = string.substring(n, n + string3.length());
        String string5 = null;
        boolean bl = Character.isUpperCase(string4.charAt(0));
        StringBuilder stringBuilder = new StringBuilder(40);
        int n3 = list.size();
        for (n2 = 1; n2 < n3; ++n2) {
            String string6 = list.get(n2);
            if (string5 == null) {
                string5 = string6;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" or ");
            }
            stringBuilder.append('\"');
            if (bl) {
                stringBuilder.append(Character.toUpperCase(string6.charAt(0)));
                stringBuilder.append(string6.substring(1));
            } else {
                stringBuilder.append(string6);
            }
            stringBuilder.append('\"');
        }
        if (string5 != null && string5.equalsIgnoreCase(string4)) {
            if (string5.equals(string4)) {
                return;
            }
            string2 = String.format("\"%1$s\" is usually capitalized as \"%2$s\"", string4, string5);
        } else {
            string2 = String.format("\"%1$s\" is a common misspelling; did you mean %2$s ?", string4, stringBuilder.toString());
        }
        n2 = n + string4.length();
        xmlContext.report(ISSUE, node, xmlContext.getLocation(node, n, n2), string2, null);
    }

    @Nullable
    public static List<String> getSuggestions(@NonNull String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf(34);
        n = string.indexOf(34, n + 1);
        ++n;
        while ((n = string.indexOf(34, n)) != -1) {
            int n2 = ++n;
            if ((n = string.indexOf(34, n)) == -1) {
                n = string.length();
            }
            arrayList.add(string.substring(n2, n));
            ++n;
        }
        return arrayList;
    }

    @Nullable
    public static String getTypo(@NonNull String string) {
        int n = string.indexOf(34);
        int n2 = n + 1;
        if ((n = string.indexOf(34, n2)) != -1) {
            return string.substring(n2, n);
        }
        return null;
    }
}

