/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.EnumSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WrongLocationDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"WrongFolder", (String)"Finds resource files that are placed in the wrong folders", (String)"Resource files are sometimes placed in the wrong folder, and it can lead to subtle bugs that are hard to understand. This check looks for problems in this area, such as attempting to place a layout \"alias\" file in a `layout/` folder rather than the `values/` folder where it belongs.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, WrongLocationDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void visitDocument(@NonNull XmlContext xmlContext, @NonNull Document document) {
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals("resources")) {
            xmlContext.report(ISSUE, (Node)element, xmlContext.getLocation((Node)element), "This file should be placed in a values/ folder, not a layout/ folder", null);
        }
    }
}

