/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class Context {
    public final File file;
    protected final LintDriver mDriver;
    @NonNull
    private final Project mProject;
    private final Project mMainProject;
    private final Configuration mConfiguration;
    private String mContents;
    @NonNull
    public final AtomicBoolean canceled = new AtomicBoolean();
    private Map<String, Object> mProperties;
    private static final Pattern VERSION_PATTERN = Pattern.compile("^v(\\d+)$");
    private static File sCachedFolder = null;
    private static int sCachedFolderVersion = -1;

    public Context(@NonNull LintDriver lintDriver, @NonNull Project project, @Nullable Project project2, @NonNull File file) {
        this.file = file;
        this.mDriver = lintDriver;
        this.mProject = project;
        this.mMainProject = project2;
        this.mConfiguration = project.getConfiguration();
    }

    @NonNull
    public EnumSet<Scope> getScope() {
        return this.mDriver.getScope();
    }

    @NonNull
    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    @NonNull
    public Project getProject() {
        return this.mProject;
    }

    @NonNull
    public Project getMainProject() {
        return this.mMainProject != null ? this.mMainProject : this.mProject;
    }

    @NonNull
    public LintClient getClient() {
        return this.mDriver.getClient();
    }

    @NonNull
    public LintDriver getDriver() {
        return this.mDriver;
    }

    @Nullable
    public String getContents() {
        if (this.mContents == null) {
            this.mContents = this.mDriver.getClient().readFile(this.file);
        }
        return this.mContents;
    }

    @Nullable
    public Object getProperty(String string) {
        if (this.mProperties == null) {
            return null;
        }
        return this.mProperties.get(string);
    }

    public void setProperty(@NonNull String string, @Nullable Object object) {
        if (object == null) {
            if (this.mProperties != null) {
                this.mProperties.remove(string);
            }
        } else {
            if (this.mProperties == null) {
                this.mProperties = new HashMap<String, Object>();
            }
            this.mProperties.put(string, object);
        }
    }

    @NonNull
    public SdkInfo getSdkInfo() {
        return this.mProject.getSdkInfo();
    }

    public boolean isEnabled(@NonNull Issue issue) {
        return this.mConfiguration.isEnabled(issue);
    }

    public void report(@NonNull Issue issue, @Nullable Location location, @NonNull String string, @Nullable Object object) {
        Object object2;
        Configuration configuration = this.mConfiguration;
        if (location != null && location.getFile() != null && (object2 = this.mDriver.findProjectFor(location.getFile())) != null) {
            configuration = ((Project)object2).getConfiguration();
        }
        if (configuration != this.mConfiguration && this.mConfiguration.getSeverity(issue) == Severity.IGNORE) {
            return;
        }
        object2 = configuration.getSeverity(issue);
        if (object2 == Severity.IGNORE) {
            return;
        }
        this.mDriver.getClient().report(this, issue, (Severity)((Object)object2), location, string, object);
    }

    public void log(@Nullable Throwable throwable, @Nullable String string, Object ... objectArray) {
        this.mDriver.getClient().log(throwable, string, objectArray);
    }

    public int getPhase() {
        return this.mDriver.getPhase();
    }

    public void requestRepeat(@NonNull Detector detector, @Nullable EnumSet<Scope> enumSet) {
        this.mDriver.requestRepeat(detector, enumSet);
    }

    public int getFolderVersion() {
        return Context.getFolderVersion(this.file);
    }

    public static int getFolderVersion(File file) {
        File file2 = file.getParentFile();
        if (file2.equals(sCachedFolder)) {
            return sCachedFolderVersion;
        }
        sCachedFolder = file2;
        sCachedFolderVersion = -1;
        for (String string : Splitter.on((char)'-').split((CharSequence)file2.getName())) {
            Matcher matcher = VERSION_PATTERN.matcher(string);
            if (!matcher.matches()) continue;
            sCachedFolderVersion = Integer.parseInt(matcher.group(1));
            break;
        }
        return sCachedFolderVersion;
    }
}

