/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jf.baksmali.Adaptors.AnnotationFormatter;
import org.jf.baksmali.Adaptors.BlankMethodItem;
import org.jf.baksmali.Adaptors.CatchMethodItem;
import org.jf.baksmali.Adaptors.CommentMethodItem;
import org.jf.baksmali.Adaptors.CommentedOutMethodItem;
import org.jf.baksmali.Adaptors.DebugMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItemFactory;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.PostInstructionRegisterInfoMethodItem;
import org.jf.baksmali.Adaptors.PreInstructionRegisterInfoMethodItem;
import org.jf.baksmali.Adaptors.SyntheticAccessCommentMethodItem;
import org.jf.baksmali.baksmali;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.MethodAnalyzer;
import org.jf.dexlib.Code.Analysis.SyntheticAccessorResolver;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.Debug.DebugInstructionIterator;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.SparseIntArray;
import org.jf.util.IndentingWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDefinition {
    private final ClassDataItem.EncodedMethod encodedMethod;
    private MethodAnalyzer methodAnalyzer;
    private final LabelCache labelCache = new LabelCache();
    private final SparseIntArray packedSwitchMap;
    private final SparseIntArray sparseSwitchMap;
    private final SparseIntArray instructionMap;

    public MethodDefinition(ClassDataItem.EncodedMethod encodedMethod) {
        try {
            this.encodedMethod = encodedMethod;
            if (encodedMethod.codeItem != null) {
                Instruction[] instructions = encodedMethod.codeItem.getInstructions();
                this.packedSwitchMap = new SparseIntArray(1);
                this.sparseSwitchMap = new SparseIntArray(1);
                this.instructionMap = new SparseIntArray(instructions.length);
                int currentCodeAddress = 0;
                for (int i = 0; i < instructions.length; ++i) {
                    Instruction instruction = instructions[i];
                    if (instruction.opcode == Opcode.PACKED_SWITCH) {
                        this.packedSwitchMap.append(currentCodeAddress + ((OffsetInstruction)((Object)instruction)).getTargetAddressOffset(), currentCodeAddress);
                    } else if (instruction.opcode == Opcode.SPARSE_SWITCH) {
                        this.sparseSwitchMap.append(currentCodeAddress + ((OffsetInstruction)((Object)instruction)).getTargetAddressOffset(), currentCodeAddress);
                    }
                    this.instructionMap.append(currentCodeAddress, i);
                    currentCodeAddress += instruction.getSize(currentCodeAddress);
                }
            } else {
                this.packedSwitchMap = null;
                this.sparseSwitchMap = null;
                this.instructionMap = null;
                this.methodAnalyzer = null;
            }
        }
        catch (Exception ex) {
            throw ExceptionWithContext.withContext(ex, String.format("Error while processing method %s", encodedMethod.method.getMethodString()));
        }
    }

    public void writeTo(IndentingWriter writer, AnnotationSetItem annotationSet, AnnotationSetRefList parameterAnnotations) throws IOException {
        CodeItem codeItem = this.encodedMethod.codeItem;
        writer.write(".method ");
        MethodDefinition.writeAccessFlags(writer, this.encodedMethod);
        writer.write(this.encodedMethod.method.getMethodName().getStringValue());
        writer.write(this.encodedMethod.method.getPrototype().getPrototypeString());
        writer.write(10);
        writer.indent(4);
        if (codeItem != null) {
            if (baksmali.useLocalsDirective) {
                writer.write(".locals ");
            } else {
                writer.write(".registers ");
            }
            writer.printSignedIntAsDec(MethodDefinition.getRegisterCount(this.encodedMethod));
            writer.write(10);
            MethodDefinition.writeParameters(writer, codeItem, parameterAnnotations);
            if (annotationSet != null) {
                AnnotationFormatter.writeTo(writer, annotationSet);
            }
            writer.write(10);
            for (MethodItem methodItem : this.getMethodItems()) {
                if (!methodItem.writeTo(writer)) continue;
                writer.write(10);
            }
        } else {
            MethodDefinition.writeParameters(writer, codeItem, parameterAnnotations);
            if (annotationSet != null) {
                AnnotationFormatter.writeTo(writer, annotationSet);
            }
        }
        writer.deindent(4);
        writer.write(".end method\n");
    }

    private static int getRegisterCount(ClassDataItem.EncodedMethod encodedMethod) {
        int totalRegisters = encodedMethod.codeItem.getRegisterCount();
        if (baksmali.useLocalsDirective) {
            int parameterRegisters = encodedMethod.method.getPrototype().getParameterRegisterCount();
            if ((encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) == 0) {
                ++parameterRegisters;
            }
            return totalRegisters - parameterRegisters;
        }
        return totalRegisters;
    }

    private static void writeAccessFlags(IndentingWriter writer, ClassDataItem.EncodedMethod encodedMethod) throws IOException {
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForMethod(encodedMethod.accessFlags)) {
            writer.write(accessFlag.toString());
            writer.write(32);
        }
    }

    private static void writeParameters(IndentingWriter writer, CodeItem codeItem, AnnotationSetRefList parameterAnnotations) throws IOException {
        AnnotationSetItem[] annotations;
        DebugInfoItem debugInfoItem = null;
        if (baksmali.outputDebugInfo && codeItem != null) {
            debugInfoItem = codeItem.getDebugInfo();
        }
        int parameterCount = 0;
        StringIdItem[] parameterNames = null;
        if (parameterAnnotations != null) {
            annotations = parameterAnnotations.getAnnotationSets();
            parameterCount = annotations.length;
        } else {
            annotations = new AnnotationSetItem[]{};
        }
        if (debugInfoItem != null) {
            parameterNames = debugInfoItem.getParameterNames();
        }
        if (parameterNames == null) {
            parameterNames = new StringIdItem[]{};
        }
        if (parameterCount < parameterNames.length) {
            parameterCount = parameterNames.length;
        }
        for (int i = 0; i < parameterCount; ++i) {
            AnnotationSetItem annotationSet = null;
            if (i < annotations.length) {
                annotationSet = annotations[i];
            }
            StringIdItem parameterName = null;
            if (i < parameterNames.length) {
                parameterName = parameterNames[i];
            }
            writer.write(".parameter");
            if (parameterName != null) {
                writer.write(" \"");
                writer.write(parameterName.getStringValue());
                writer.write(34);
            }
            writer.write(10);
            if (annotationSet == null) continue;
            writer.indent(4);
            AnnotationFormatter.writeTo(writer, annotationSet);
            writer.deindent(4);
            writer.write(".end parameter\n");
        }
    }

    public LabelCache getLabelCache() {
        return this.labelCache;
    }

    public ValidationException getValidationException() {
        if (this.methodAnalyzer == null) {
            return null;
        }
        return this.methodAnalyzer.getValidationException();
    }

    public int getPackedSwitchBaseAddress(int packedSwitchDataAddress) {
        int packedSwitchBaseAddress = this.packedSwitchMap.get(packedSwitchDataAddress, -1);
        if (packedSwitchBaseAddress == -1) {
            Instruction[] instructions = this.encodedMethod.codeItem.getInstructions();
            int index = this.instructionMap.get(packedSwitchDataAddress);
            if (instructions[index].opcode == Opcode.NOP) {
                packedSwitchBaseAddress = this.packedSwitchMap.get(packedSwitchDataAddress + 2, -1);
            }
        }
        return packedSwitchBaseAddress;
    }

    public int getSparseSwitchBaseAddress(int sparseSwitchDataAddress) {
        int sparseSwitchBaseAddress = this.sparseSwitchMap.get(sparseSwitchDataAddress, -1);
        if (sparseSwitchBaseAddress == -1) {
            Instruction[] instructions = this.encodedMethod.codeItem.getInstructions();
            int index = this.instructionMap.get(sparseSwitchDataAddress);
            if (instructions[index].opcode == Opcode.NOP) {
                sparseSwitchBaseAddress = this.packedSwitchMap.get(sparseSwitchDataAddress + 2, -1);
            }
        }
        return sparseSwitchBaseAddress;
    }

    private boolean isInstructionPaddingNop(List<AnalyzedInstruction> instructions, AnalyzedInstruction instruction) {
        if (instruction.getInstruction().opcode != Opcode.NOP || instruction.getInstruction().getFormat().variableSizeFormat) {
            return false;
        }
        if (instruction.getInstructionIndex() == instructions.size() - 1) {
            return false;
        }
        AnalyzedInstruction nextInstruction = instructions.get(instruction.getInstructionIndex() + 1);
        return nextInstruction.getInstruction().getFormat().variableSizeFormat;
    }

    private List<MethodItem> getMethodItems() {
        ArrayList<MethodItem> methodItems = new ArrayList<MethodItem>();
        if (this.encodedMethod.codeItem == null) {
            return methodItems;
        }
        if (baksmali.registerInfo != 0 || baksmali.deodex || baksmali.verify) {
            this.addAnalyzedInstructionMethodItems(methodItems);
        } else {
            this.addInstructionMethodItems(methodItems);
        }
        this.addTries(methodItems);
        if (baksmali.outputDebugInfo) {
            this.addDebugInfo(methodItems);
        }
        if (baksmali.useSequentialLabels) {
            this.setLabelSequentialNumbers();
        }
        for (LabelMethodItem labelMethodItem : this.labelCache.getLabels()) {
            methodItems.add(labelMethodItem);
        }
        Collections.sort(methodItems);
        return methodItems;
    }

    private void addInstructionMethodItems(List<MethodItem> methodItems) {
        Instruction[] instructions = this.encodedMethod.codeItem.getInstructions();
        int currentCodeAddress = 0;
        for (int i = 0; i < instructions.length; ++i) {
            SyntheticAccessorResolver.AccessedMember accessedMember;
            MethodIdItem methodIdItem;
            Instruction instruction = instructions[i];
            InstructionMethodItem methodItem = InstructionMethodItemFactory.makeInstructionFormatMethodItem(this, this.encodedMethod.codeItem, currentCodeAddress, instruction);
            methodItems.add(methodItem);
            if (i != instructions.length - 1) {
                methodItems.add(new BlankMethodItem(currentCodeAddress));
            }
            if (baksmali.addCodeOffsets) {
                methodItems.add(new MethodItem(currentCodeAddress){

                    public double getSortOrder() {
                        return -1000.0;
                    }

                    public boolean writeTo(IndentingWriter writer) throws IOException {
                        writer.write("#@");
                        writer.printUnsignedLongAsHex(this.codeAddress & 0xFFFFFFFF);
                        return true;
                    }
                });
            }
            if (!baksmali.noAccessorComments && instruction instanceof InstructionWithReference && (instruction.opcode == Opcode.INVOKE_STATIC || instruction.opcode == Opcode.INVOKE_STATIC_RANGE) && SyntheticAccessorResolver.looksLikeSyntheticAccessor(methodIdItem = (MethodIdItem)((InstructionWithReference)instruction).getReferencedItem()) && (accessedMember = baksmali.syntheticAccessorResolver.getAccessedMember(methodIdItem)) != null) {
                methodItems.add(new SyntheticAccessCommentMethodItem(accessedMember, currentCodeAddress));
            }
            currentCodeAddress += instruction.getSize(currentCodeAddress);
        }
    }

    private void addAnalyzedInstructionMethodItems(List<MethodItem> methodItems) {
        this.methodAnalyzer = new MethodAnalyzer(this.encodedMethod, baksmali.deodex, baksmali.inlineResolver);
        this.methodAnalyzer.analyze();
        ValidationException validationException = this.methodAnalyzer.getValidationException();
        if (validationException != null) {
            methodItems.add(new CommentMethodItem(String.format("ValidationException: %s", validationException.getMessage()), validationException.getCodeAddress(), -2.147483648E9));
        } else if (baksmali.verify) {
            this.methodAnalyzer.verify();
            validationException = this.methodAnalyzer.getValidationException();
            if (validationException != null) {
                methodItems.add(new CommentMethodItem(String.format("ValidationException: %s", validationException.getMessage()), validationException.getCodeAddress(), -2.147483648E9));
            }
        }
        List<AnalyzedInstruction> instructions = this.methodAnalyzer.getInstructions();
        int currentCodeAddress = 0;
        for (int i = 0; i < instructions.size(); ++i) {
            AnalyzedInstruction instruction = instructions.get(i);
            InstructionMethodItem methodItem = InstructionMethodItemFactory.makeInstructionFormatMethodItem(this, this.encodedMethod.codeItem, currentCodeAddress, instruction.getInstruction());
            methodItems.add(methodItem);
            if (instruction.getInstruction().getFormat() == Format.UnresolvedOdexInstruction) {
                methodItems.add(new CommentedOutMethodItem(InstructionMethodItemFactory.makeInstructionFormatMethodItem(this, this.encodedMethod.codeItem, currentCodeAddress, instruction.getOriginalInstruction())));
            }
            if (i != instructions.size() - 1) {
                methodItems.add(new BlankMethodItem(currentCodeAddress));
            }
            if (baksmali.addCodeOffsets) {
                methodItems.add(new MethodItem(currentCodeAddress){

                    public double getSortOrder() {
                        return -1000.0;
                    }

                    public boolean writeTo(IndentingWriter writer) throws IOException {
                        writer.write("#@");
                        writer.printUnsignedLongAsHex(this.codeAddress & 0xFFFFFFFF);
                        return true;
                    }
                });
            }
            if (baksmali.registerInfo != 0 && !instruction.getInstruction().getFormat().variableSizeFormat) {
                methodItems.add(new PreInstructionRegisterInfoMethodItem(instruction, this.methodAnalyzer, currentCodeAddress));
                methodItems.add(new PostInstructionRegisterInfoMethodItem(instruction, this.methodAnalyzer, currentCodeAddress));
            }
            currentCodeAddress += instruction.getInstruction().getSize(currentCodeAddress);
        }
    }

    private void addTries(List<MethodItem> methodItems) {
        if (this.encodedMethod.codeItem == null || this.encodedMethod.codeItem.getTries() == null) {
            return;
        }
        Instruction[] instructions = this.encodedMethod.codeItem.getInstructions();
        for (CodeItem.TryItem tryItem : this.encodedMethod.codeItem.getTries()) {
            int catchAllAddress;
            int lastInstructionAddress;
            Instruction lastInstruction;
            int startAddress = tryItem.getStartCodeAddress();
            int endAddress = tryItem.getStartCodeAddress() + tryItem.getTryLength();
            int index = this.instructionMap.get(endAddress, -1);
            if (index == -1) {
                lastInstruction = instructions[instructions.length - 1];
                lastInstructionAddress = this.instructionMap.keyAt(this.instructionMap.size() - 1);
                if (endAddress != lastInstructionAddress + lastInstruction.getSize(lastInstructionAddress)) {
                    throw new RuntimeException("Invalid code offset " + endAddress + " for the try block end address");
                }
            } else {
                if (index == 0) {
                    throw new RuntimeException("Unexpected instruction index");
                }
                lastInstruction = instructions[index - 1];
                if (lastInstruction.getFormat().variableSizeFormat) {
                    throw new RuntimeException("This try block unexpectedly ends on a switch/array data block.");
                }
                lastInstructionAddress = endAddress - lastInstruction.getSize(0);
            }
            if ((catchAllAddress = tryItem.encodedCatchHandler.getCatchAllHandlerAddress()) != -1) {
                CatchMethodItem catchAllMethodItem = new CatchMethodItem(this.labelCache, lastInstructionAddress, null, startAddress, endAddress, catchAllAddress);
                methodItems.add(catchAllMethodItem);
            }
            for (CodeItem.EncodedTypeAddrPair handler : tryItem.encodedCatchHandler.handlers) {
                CatchMethodItem catchMethodItem = new CatchMethodItem(this.labelCache, lastInstructionAddress, handler.exceptionType, startAddress, endAddress, handler.getHandlerAddress());
                methodItems.add(catchMethodItem);
            }
        }
    }

    private void addDebugInfo(final List<MethodItem> methodItems) {
        if (this.encodedMethod.codeItem == null || this.encodedMethod.codeItem.getDebugInfo() == null) {
            return;
        }
        final CodeItem codeItem = this.encodedMethod.codeItem;
        DebugInfoItem debugInfoItem = codeItem.getDebugInfo();
        DebugInstructionIterator.DecodeInstructions(debugInfoItem, codeItem.getRegisterCount(), new DebugInstructionIterator.ProcessDecodedDebugInstructionDelegate(){

            public void ProcessStartLocal(int codeAddress, int length, final int registerNum, final StringIdItem name, final TypeIdItem type) {
                methodItems.add(new DebugMethodItem(codeAddress, -1.0){

                    public boolean writeTo(IndentingWriter writer) throws IOException {
                        1.writeStartLocal(writer, codeItem, registerNum, name, type, null);
                        return true;
                    }
                });
            }

            public void ProcessStartLocalExtended(int codeAddress, int length, final int registerNum, final StringIdItem name, final TypeIdItem type, final StringIdItem signature) {
                methodItems.add(new DebugMethodItem(codeAddress, -1.0){

                    public boolean writeTo(IndentingWriter writer) throws IOException {
                        2.writeStartLocal(writer, codeItem, registerNum, name, type, signature);
                        return true;
                    }
                });
            }

            public void ProcessEndLocal(int codeAddress, int length, final int registerNum, final StringIdItem name, final TypeIdItem type, final StringIdItem signature) {
                methodItems.add(new DebugMethodItem(codeAddress, -1.0){

                    public boolean writeTo(IndentingWriter writer) throws IOException {
                        3.writeEndLocal(writer, codeItem, registerNum, name, type, signature);
                        return true;
                    }
                });
            }

            public void ProcessRestartLocal(int codeAddress, int length, final int registerNum, final StringIdItem name, final TypeIdItem type, final StringIdItem signature) {
                methodItems.add(new DebugMethodItem(codeAddress, -1.0){

                    public boolean writeTo(IndentingWriter writer) throws IOException {
                        4.writeRestartLocal(writer, codeItem, registerNum, name, type, signature);
                        return true;
                    }
                });
            }

            public void ProcessSetPrologueEnd(int codeAddress) {
                methodItems.add(new DebugMethodItem(codeAddress, -4.0){

                    public boolean writeTo(IndentingWriter writer) throws IOException {
                        5.writeEndPrologue(writer);
                        return true;
                    }
                });
            }

            public void ProcessSetEpilogueBegin(int codeAddress) {
                methodItems.add(new DebugMethodItem(codeAddress, -4.0){

                    public boolean writeTo(IndentingWriter writer) throws IOException {
                        6.writeBeginEpilogue(writer);
                        return true;
                    }
                });
            }

            public void ProcessSetFile(int codeAddress, int length, final StringIdItem name) {
                methodItems.add(new DebugMethodItem(codeAddress, -3.0){

                    public boolean writeTo(IndentingWriter writer) throws IOException {
                        7.writeSetFile(writer, name.getStringValue());
                        return true;
                    }
                });
            }

            public void ProcessLineEmit(int codeAddress, final int line) {
                methodItems.add(new DebugMethodItem(codeAddress, -2.0){

                    public boolean writeTo(IndentingWriter writer) throws IOException {
                        8.writeLine(writer, line);
                        return true;
                    }
                });
            }
        });
    }

    private void setLabelSequentialNumbers() {
        HashMap<String, Integer> nextLabelSequenceByType = new HashMap<String, Integer>();
        ArrayList<LabelMethodItem> sortedLabels = new ArrayList<LabelMethodItem>(this.labelCache.getLabels());
        Collections.sort(sortedLabels);
        for (LabelMethodItem labelMethodItem : sortedLabels) {
            Integer labelSequence = (Integer)nextLabelSequenceByType.get(labelMethodItem.getLabelPrefix());
            if (labelSequence == null) {
                labelSequence = 0;
            }
            labelMethodItem.setLabelSequence(labelSequence);
            nextLabelSequenceByType.put(labelMethodItem.getLabelPrefix(), labelSequence + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LabelCache {
        protected HashMap<LabelMethodItem, LabelMethodItem> labels = new HashMap();

        public LabelMethodItem internLabel(LabelMethodItem labelMethodItem) {
            LabelMethodItem internedLabelMethodItem = this.labels.get(labelMethodItem);
            if (internedLabelMethodItem != null) {
                return internedLabelMethodItem;
            }
            this.labels.put(labelMethodItem, labelMethodItem);
            return labelMethodItem;
        }

        public Collection<LabelMethodItem> getLabels() {
            return this.labels.values();
        }
    }
}

