/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.util.BitSet;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.baksmali.baksmali;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.MethodAnalyzer;
import org.jf.dexlib.Code.Analysis.RegisterType;
import org.jf.util.IndentingWriter;

public class PostInstructionRegisterInfoMethodItem
extends MethodItem {
    private final AnalyzedInstruction analyzedInstruction;
    private final MethodAnalyzer methodAnalyzer;

    public PostInstructionRegisterInfoMethodItem(AnalyzedInstruction analyzedInstruction, MethodAnalyzer methodAnalyzer, int codeAddress) {
        super(codeAddress);
        this.analyzedInstruction = analyzedInstruction;
        this.methodAnalyzer = methodAnalyzer;
    }

    public double getSortOrder() {
        return 100.1;
    }

    public boolean writeTo(IndentingWriter writer) throws IOException {
        int registerInfo = baksmali.registerInfo;
        int registerCount = this.analyzedInstruction.getRegisterCount();
        BitSet registers = new BitSet(registerCount);
        if ((registerInfo & 1) != 0) {
            registers.set(0, registerCount);
        } else if ((registerInfo & 4) != 0) {
            registers.set(0, registerCount);
        } else if ((registerInfo & 0x10) != 0) {
            this.addDestRegs(registers, registerCount);
        }
        return this.writeRegisterInfo(writer, registers);
    }

    private void addDestRegs(BitSet printPostRegister, int registerCount) {
        for (int registerNum = 0; registerNum < registerCount; ++registerNum) {
            if (this.analyzedInstruction.getPreInstructionRegisterType(registerNum) == this.analyzedInstruction.getPostInstructionRegisterType(registerNum)) continue;
            printPostRegister.set(registerNum);
        }
    }

    private boolean writeRegisterInfo(IndentingWriter writer, BitSet registers) throws IOException {
        ClassDataItem.EncodedMethod encodedMethod = this.methodAnalyzer.getMethod();
        int registerNum = registers.nextSetBit(0);
        if (registerNum < 0) {
            return false;
        }
        writer.write(35);
        while (registerNum >= 0) {
            RegisterType registerType = this.analyzedInstruction.getPostInstructionRegisterType(registerNum);
            RegisterFormatter.writeTo(writer, encodedMethod.codeItem, registerNum);
            writer.write(61);
            if (registerType == null) {
                writer.write("null");
            } else {
                registerType.writeTo(writer);
            }
            writer.write(59);
            registerNum = registers.nextSetBit(registerNum + 1);
        }
        return true;
    }
}

