/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction30t
extends Instruction
implements OffsetInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private int targetAddressOffset;

    public Instruction30t(Opcode opcode, int offA) {
        super(opcode);
        this.targetAddressOffset = offA;
    }

    private Instruction30t(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        assert (buffer[bufferIndex] == opcode.value);
        this.targetAddressOffset = NumberUtils.decodeInt(buffer, bufferIndex + 2);
    }

    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(0);
        out.writeInt(this.targetAddressOffset);
    }

    public void updateTargetAddressOffset(int targetAddressOffset) {
        this.targetAddressOffset = targetAddressOffset;
    }

    public Format getFormat() {
        return Format.Format30t;
    }

    public int getTargetAddressOffset() {
        return this.targetAddressOffset;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction30t(opcode, buffer, bufferIndex);
        }
    }
}

