#ifndef __RB_VRM_ERRORS__
#define __RB_VRM_ERRORS__



		/*********************************************************
	  **					C O N F I D E N T I A L             **
	 **						  Copyright  2002-2010             **
	  **                         Red Bend Software              **
		**********************************************************/

#include "RbErrors.h"

/*___________________ Values that are external errors ___________________*/

#define	E_RB_NOT_ENOUGH_ROM													RB_MAKE_ERROR(0x10001)
#define	E_RB_ERROR_FREEING_RAM												RB_MAKE_ERROR(0x10002)
#define	E_RB_INVALID_ROM_TYPE												RB_MAKE_ERROR(0x10003)
#define	E_RB_INVALID_COMPRESSION_TYPE										RB_MAKE_ERROR(0x10004)
#define	E_RB_UPDATE_ERROR													RB_MAKE_ERROR(0x10005)
#define	E_RB_OLD_SIGNATURE_MISMATCH											RB_MAKE_ERROR(0x10006)
#define	E_RB_TEMPORARY_SIS_FILE_ALREADY_EXISTS								RB_MAKE_ERROR(0x10007)
#define	E_RB_INVALID_DELTA_FIELD											RB_MAKE_ERROR(0x10008)
#define	E_RB_SCOUT_FAILED													RB_MAKE_ERROR(0x10009)
#define	E_RB_READ_ROFS_ERROR												RB_MAKE_ERROR(0x1000A)
#define	E_RB_WRITE_ROFS_ERROR												RB_MAKE_ERROR(0x1000B)
#define	E_RB_READ_CRAMFS_ERROR												RB_MAKE_ERROR(0x1000C)
#define	E_RB_WRITE_CRAMFS_ERROR												RB_MAKE_ERROR(0x1000D)
#define	E_RB_CANNOT_OPEN_DELTAS_FILE										RB_MAKE_ERROR(0x1000E)
#define	E_RB_PARTITION_SIZE_NOT_INTEGER_NUM_OF_SECTORS						RB_MAKE_ERROR(0x1000F)
#define	E_RB_DIRECTORY_TREE_BIGGER_THAN_BACKUP								RB_MAKE_ERROR(0x10010)
#define	E_RB_INVALID_DIRECTORY_TREE											RB_MAKE_ERROR(0x10011)
#define	E_RB_SIZE_PARAM_FOR_GET_DEPLOYMENT_DATA_TOO_SMALL					RB_MAKE_ERROR(0x10012)
#define	E_RB_NO_DEPLOYMENT_DATA_FOR_GIVEN_COMP_DELTA_ORDINAL				RB_MAKE_ERROR(0x10013)
#define	E_RB_INVALID_COMPONENT_DELTA_ORDINAL_PARAMETER						RB_MAKE_ERROR(0x10014)
#define	E_RB_PERFORM_UPDATE_FAILED_NOT_ENOUGH_BACKUP						RB_MAKE_ERROR(0x10015)
#define	E_RB_FEASIBILITY_TST_FAILED_NOT_ENOUGH_FLASH						RB_MAKE_ERROR(0x10016)
#define	E_RB_FEASIBILITY_TST_FAILED_NOT_ENOUGH_RAM							RB_MAKE_ERROR(0x10017)
#define	E_RB_FEASIBILITY_TST_FAILED_NOT_ENOUGH_BACKUP						RB_MAKE_ERROR(0x10018)
#define	E_RB_FOTA_DELTA_SHOULD_USE_ONE_PARTITION							RB_MAKE_ERROR(0x10019)
#define	E_RB_NON_DP_FORMAT_NOT_SUPPORTED									RB_MAKE_ERROR(0x1001A)
#define	E_RB_CANT_REMOVE_INSTALL_COMPONENT_MORE_THAN_ONCE					RB_MAKE_ERROR(0x1001B)
#define	E_RB_CANT_UPDATE_COMPONENT_MORE_THAN_ONCE							RB_MAKE_ERROR(0x1001C)
#define	E_RB_OLD_SIGNATURE_MATCHES_VER_B									RB_MAKE_ERROR(0x1001D)
#define	E_RB_INVALID_OPERATION												RB_MAKE_ERROR(0x1001E)
#define	E_RB_SCOUT_FOR_INSTALL_FILE											RB_MAKE_ERROR(0x1001F)
#define	E_RB_MULTIPLE_DELTAS_FOR_FOTA_PARTITION								RB_MAKE_ERROR(0x10020)
#define	E_RB_ONLY_UPDATE_SUPPORTED_FOR_FOTA_PARTITION						RB_MAKE_ERROR(0x10021)
#define	E_RB_PARTITION_NAME_FROM_DELTA_NOT_FOUND							RB_MAKE_ERROR(0x10022)
#define	E_RB_INVALID_INPUT_DELTA_PATH_APPEAR								RB_MAKE_ERROR(0x10023)
//
#define	E_RB_INVALID_DP_HEADER												RB_MAKE_ERROR(0x10025)
#define	E_RB_INVALID_DP_WRONG_SIGNATURE										RB_MAKE_ERROR(0x10026)
#define	E_RB_INVALID_DP														RB_MAKE_ERROR(0x10027)
#define	E_RB_UNALLOWED_MORE_THAN_ONE_DELTA_FOR_SAME_FILE					RB_MAKE_ERROR(0x10028)
#define	E_RB_UNALLOWED_MORE_THAN_TWO_DELTAS_FOR_SAME_FILE					RB_MAKE_ERROR(0x10029)
#define	E_RB_UNSUPPORTED_DP_VERSION											RB_MAKE_ERROR(0x1002A)
#define	E_RB_NOT_ALL_PARTITIONS_WITH_SAME_PAGE_SIZE							RB_MAKE_ERROR(0x1002B)
#define	E_RB_NOT_ALL_PARTITIONS_WITH_SAME_SECTOR_SIZE						RB_MAKE_ERROR(0x1002C)
#define	E_RB_MORE_THAN_ONE_PARTITION_CORRUPTED								RB_MAKE_ERROR(0x1002D)
#define	E_RB_BACKUP_FILE_FOUND_WITH_UNEXPECTED_SIZE							RB_MAKE_ERROR(0x1002E)
#define	E_RB_BACKUP_FILE_NOT_FOUND_THOUGH_IN_RECOVERY_RUN					RB_MAKE_ERROR(0x1002F)
#define	E_RB_BACKUP_BUFFERS_NOT_ALIGNED_TO_SECTOR_SIZE						RB_MAKE_ERROR(0x10030)
#define	E_RB_UNRECOGNIZED_FILE_SYSTEM_TYPE									RB_MAKE_ERROR(0x10031)
#define	E_RB_WRONG_RAM_SIZE_PARAMETER										RB_MAKE_ERROR(0x10032)
#define	E_RB_FAILED_READING_FOLDER_UNDER_ROOT_UNEXPECTEDLY					RB_MAKE_ERROR(0x10033)
#define	E_RB_FOLDER_DOESNT_EXIST											RB_MAKE_ERROR(0x10034)
#define	E_RB_NULL_FOLDER_AS_PARAMETER										RB_MAKE_ERROR(0x10035)
#define	E_RB_TEMP_PATH_DOESNT_BELONG_TO_ANY_PRT_MOUNT_POINT					RB_MAKE_ERROR(0x10036)
#define	E_RB_NEED_TMP_PATH_OR_NEED_BACKUP_BUFF								RB_MAKE_ERROR(0x10037)
#define	E_RB_IRRELEVANT_PORTING_FUNC_CALLED									RB_MAKE_ERROR(0x10038)
#define	E_RB_INVALID_INPUT_PARTITION_SRC_TRGT_PATHS_EQUAL					RB_MAKE_ERROR(0x10039)
#define	E_RB_INVALID_INPUT_SU_AND_PARTITION_SRC_TRGT_PATHS					RB_MAKE_ERROR(0x1003A)
#define	E_RB_SYMBOLIC_LINKS_NOT_SUPPORTED									RB_MAKE_ERROR(0x1003B)
#define	E_RB_ADVANCED_FILE_ATTRIBS_NOT_SUPPORTED							RB_MAKE_ERROR(0x1003C)
#define	E_RB_FILE_PATH_VER_A_NOT_WITHIN_SOURCE_PATH							RB_MAKE_ERROR(0x1003D)
#define	E_RB_FILE_PATH_VER_B_NOT_WITHIN_SOURCE_PATH							RB_MAKE_ERROR(0x1003E)
#define	E_RB_BAD_PARAMS_DELTA_TYPE											RB_MAKE_ERROR(0x1003F)
#define	E_RB_BAD_PARAMS_NUM_PAR_0											RB_MAKE_ERROR(0x10040)
#define	E_RB_BAD_PARAMS_NO_DEPLOYMENT_DATA_FILE								RB_MAKE_ERROR(0x10041)
#define	E_RB_BAD_PARAMS_SECTOR_SIZE_0										RB_MAKE_ERROR(0x10042)
#define	E_RB_BAD_PARAMS_NO_BACKUP_SECTORS									RB_MAKE_ERROR(0x10043)
#define	E_RB_BAD_PARAMS_CASE_SENSITIVE										RB_MAKE_ERROR(0x10044)
#define	E_RB_BAD_PARAMS_LANG_SUPPORT										RB_MAKE_ERROR(0x10045)
#define	E_RB_BAD_PARAMS_NO_LANG_FILE										RB_MAKE_ERROR(0x10046)
#define	E_RB_BAD_PARAMS_RAM_SIZE_0											RB_MAKE_ERROR(0x10047)
#define	E_RB_BAD_PARAMS_PARTITION_INDEX										RB_MAKE_ERROR(0x10048)
#define	E_RB_BAD_PARAMS_BASE_PARTITION_INDEX								RB_MAKE_ERROR(0x10049)
#define	E_RB_BAD_PARAMS_REG_SYMLINK											RB_MAKE_ERROR(0x1004A)
#define	E_RB_BAD_PARAMS_MISSING_SOURCE_ROOT									RB_MAKE_ERROR(0x1004B)
#define	E_RB_BAD_PARAMS_MISSING_SOURCE_ATTRIBS								RB_MAKE_ERROR(0x1004C)
#define	E_RB_BAD_PARAMS_MISSING_TARGET_ROOT									RB_MAKE_ERROR(0x1004D)
#define	E_RB_BAD_PARAMS_MISSING_TARGET_ATTRIBS								RB_MAKE_ERROR(0x1004E)
#define	E_RB_BAD_PARAMS_UNNECESSARY_SOURCE_ROOT								RB_MAKE_ERROR(0x1004F)
#define	E_RB_BAD_PARAMS_UNNECESSARY_SOURCE_ATTRIBS							RB_MAKE_ERROR(0x10050)
#define	E_RB_BAD_PARAMS_UNNECESSARY_TARGET_ROOT								RB_MAKE_ERROR(0x10051)
#define	E_RB_BAD_PARAMS_UNNECESSARY_TARGET_ATTRIBS							RB_MAKE_ERROR(0x10052)
#define	E_RB_BAD_PARAMS_FOTA_INSTALL_UNSUPPORTED							RB_MAKE_ERROR(0x10053)
#define	E_RB_BAD_PARAMS_FOTA_REMOVE_UNSUPPORTED								RB_MAKE_ERROR(0x10054)
#define	E_RB_FOUND_MULTIPLE_FILES_IN_GIVEN_ROOT								RB_MAKE_ERROR(0x10055)
#define	E_RB_FOUND_UNEXPECTED_FOLDER_IN_GIVEN_ROOT							RB_MAKE_ERROR(0x10056)
#define	E_RB_ATTRIB_FILE_GIVEN_FOR_FOTA_PARTITION							RB_MAKE_ERROR(0x10057)
#define	E_RB_CANNOT_COPY_FOTA_PARTITION_IMAGE								RB_MAKE_ERROR(0x10058)
#define	E_RB_INSTALL_USED_FOR_FOTA_PARTITION								RB_MAKE_ERROR(0x10059)
#define	E_RB_DELETE_USED_FOR_FOTA_PARTITION									RB_MAKE_ERROR(0x1005A)
#define	E_RB_MISSING_CONFIG_FILE											RB_MAKE_ERROR(0x1005B)
#define	E_RB_UNEXPECTED_END_OF_PATH_IN_INPUT_FILE							RB_MAKE_ERROR(0x1005C)
#define	E_RB_BAD_PARAMS_CLEAN_TEMP_FOLDER									RB_MAKE_ERROR(0x1005D)
#define	E_RB_BAD_PARAMS_VERIFY_CHANGED_ONLY									RB_MAKE_ERROR(0x1005E)
#define	E_RB_BAD_PARAMS_LITTLE_ENDIAN										RB_MAKE_ERROR(0x1005F)
#define	E_RB_BAD_PARAMS_MAKE_FOTA_DP										RB_MAKE_ERROR(0x10060)
#define	E_RB_BAD_PARAMS_FILE_NAMES_IN_UNICODE								RB_MAKE_ERROR(0x10061)
#define	E_RB_DEBUG_TRACE_SUPPORTS_ONLY_SINGLE_DELTA_UPDATE					RB_MAKE_ERROR(0x10062)
#define	E_RB_BAD_PARAMS_KEEP_INVALID_DELTA									RB_MAKE_ERROR(0x10063)
#define	E_RB_BAD_PARAMS_DEFAULT_TO_STANDARD									RB_MAKE_ERROR(0x10064)
#define	E_RB_ELF_DEVICE_NUMBER_OF_ENTRIES_DOES_NOT_MATCH_EXPECTED			RB_MAKE_ERROR(0x10065)
#define	E_RB_ELF_DEVICE_CAN_NOT_OPEN_ELF_FILE								RB_MAKE_ERROR(0x10066)
#define	E_RB_ELF_DEVICE_NOT_ELF												RB_MAKE_ERROR(0x10067)
#define	E_RB_ELF_DEVICE_ALLOC_FAIL											RB_MAKE_ERROR(0x10068)
#define	E_RB_ELF_DEVICE_READ_FAIL											RB_MAKE_ERROR(0x10069)
#define	E_RB_ELF_DEVICE_CORRUPTED_ELF										RB_MAKE_ERROR(0x1006A)
#define	E_RB_NO_MORE_FILE_DELTAS											RB_MAKE_ERROR(0x1006B)
#define E_RB_INVALID_COMPONENT_ORDINAL										RB_MAKE_ERROR(0X1006C)
#define	E_RB_INVALID_READ_ADDRESS											RB_MAKE_ERROR(0x1006D)
#define	E_RB_INVALID_WRITE_ADDRESS											RB_MAKE_ERROR(0x1006E)
#define	E_RB_INVALID_NEW_KEY_READ_ADDRESS									RB_MAKE_ERROR(0x1006F)
#define	E_RB_BOTH_DIRECTORIES_ARE_NULL										RB_MAKE_ERROR(0x10070)
#define	E_RB_MATCHING_ERROR													RB_MAKE_ERROR(0x10071)
#define	E_RB_UNEXPECTED_FILE_TYPE_AFTER_MATCH								RB_MAKE_ERROR(0x10072)
#define	E_RB_CANNOT_CREATE_TEMP_DIRECTORY									RB_MAKE_ERROR(0x10073)
#define	E_RB_INVALID_READ_ADDRESS_OR_REQUEST_READ_SIZE						RB_MAKE_ERROR(0x10074)
#define	E_RB_INVALID_WRITE_ADDRESS_OR_REQUEST_WRITE_SIZE					RB_MAKE_ERROR(0x10075)
#define	E_RB_PTRS_RELOCATION_ERROR											RB_MAKE_ERROR(0x10076)
#define	E_RB_INVALID_DELTA_ACTION											RB_MAKE_ERROR(0x10077)
#define	E_RB_INVALID_PARTITION_TYPE											RB_MAKE_ERROR(0x10078)
#define	E_RB_INVALID_PARTITION_FILE_SYSTEM_TYPE								RB_MAKE_ERROR(0x10079)
#define	E_RB_ONLY_INSTALL_ALLOWED_FOR_NON_EXISTING_FILES					RB_MAKE_ERROR(0x1007A)
#define	E_RB_ADDITIONAL_INFO_DOES_NOT_MATCH_VER_A							RB_MAKE_ERROR(0x1007B)
#define	E_RB_FILE_SIZE_DOES_NOT_MATCH_SOURCE_VER							RB_MAKE_ERROR(0x1007C)
#define	E_RB_VIRTUAL_SIZE_DOES_NOT_MATCH_VER_A								RB_MAKE_ERROR(0x1007D)
#define	E_RB_INVALID_COMPONENT_DELTA_TYPE									RB_MAKE_ERROR(0x1007E)
#define	E_RB_GENERATOR_FILE_ERROR											RB_MAKE_ERROR(0x1007F)
#define	E_RB_COPY_FILE_ERROR												RB_MAKE_ERROR(0x10080)
#define	E_RB_IMAGE_ENTRIES_DO_NOT_MATCH										RB_MAKE_ERROR(0x10081)
#define	E_RB_INCORRECT_NODE_FLAGS											RB_MAKE_ERROR(0x10082)
#define	E_RB_CANT_OPEN_CONFIGURATION_FILE									RB_MAKE_ERROR(0x10083)
#define	E_RB_UNEXPECTED_EOF													RB_MAKE_ERROR(0x10084)
#define	E_RB_CANNOT_COPY_PARTITION_ROOT										RB_MAKE_ERROR(0x10085)
#define	E_RB_PARTITION_ROOT_DOES_NOT_EXIST									RB_MAKE_ERROR(0x10086)
#define	E_RB_PARTITION_ROOT_IS_NOT_DIRECTORY								RB_MAKE_ERROR(0x10087)
#define	E_RB_CANNOT_COPY_PARTITION_ADD_INFO									RB_MAKE_ERROR(0x10088)
#define	E_RB_CANNOT_OPEN_ADDITIONAL_INFO_FILE								RB_MAKE_ERROR(0x10089)
#define	E_RB_STRING_NOT_ASCII_COMPATIBLE									RB_MAKE_ERROR(0x1008A)
#define	E_RB_CANNOT_FIND_ADDITIONAL_INFO_OF_FILE							RB_MAKE_ERROR(0x1008B)
#define	E_RB_CANNOT_CREATE_NULL_FILE										RB_MAKE_ERROR(0x1008C)
#define	E_RB_CANNOT_WRITE_TO_DELTA_FILE										RB_MAKE_ERROR(0x1008D)
#define	E_RB_CANNOT_OPEN_COMPONENT_DELTA_FILE								RB_MAKE_ERROR(0x1008E)
#define	E_RB_CANNOT_DELETE_COMPONENT_DELTA_FILE								RB_MAKE_ERROR(0x1008F)
#define	E_RB_CANNOT_OPEN_SUPPLEMENTARY_INFO_FILE							RB_MAKE_ERROR(0x10090)
#define	E_RB_CANNOT_DELETE_FILE_IN_TEMP_DIRECTORY							RB_MAKE_ERROR(0x10091)
#define	E_RB_CANNOT_COPY_FILE_TO_TEMP_DIRECTORY								RB_MAKE_ERROR(0x10092)
#define	E_RB_TRYING_TO_REMOVE_UNEXISTING_FILE								RB_MAKE_ERROR(0x10093)
#define	E_RB_UNEXPECTED_EMPTY_PATH_IN_DELTA									RB_MAKE_ERROR(0x10094)
#define	E_RB_ILLEGAL_PARTITION_IDX_IN_DELTA									RB_MAKE_ERROR(0x10095)
#define	E_RB_STRING_TOO_LONG												RB_MAKE_ERROR(0x10096)
#define	E_RB_ILLEGAL_COMPONENT_TYPE_IN_COMP_DELTA							RB_MAKE_ERROR(0x10097)
#define	E_RB_NO_MORE_COMPONENT_DELTAS										RB_MAKE_ERROR(0x10098)
#define	E_RB_INVALID_COMPONENT_HEADER										RB_MAKE_ERROR(0x10099)
#define	E_RB_PARSING_RB_COMPONENT_FAILED									RB_MAKE_ERROR(0x1009A)
#define	E_RB_ENDIANITY_MISMATCH												RB_MAKE_ERROR(0x1009B)
#define	E_RB_PARTITION_NAME_PREFIX_WASNT_FOUND								RB_MAKE_ERROR(0x1009C)
#define	E_RB_SOURCE_AND_TARGET_ARE_NOT_COMPATIBILE							RB_MAKE_ERROR(0x1009D)
#define	E_RB_CORRUPT_BACKUP_DA_NO_CHANGE									RB_MAKE_ERROR(0x1009E)
#define	E_RB_CORRUPT_BACKUP_DA_NO_CHANGE_HEADER								RB_MAKE_ERROR(0x1009F)
#define	E_RB_DA_NO_CHANGE_BACKUP_CRC_NOT_VALID								RB_MAKE_ERROR(0x100A0)
#define	E_RB_READ_ERR														RB_MAKE_ERROR(0x100A1)
#define	E_RB_PROGRESS_BAR_UPDATE											RB_MAKE_ERROR(0x100A3)
//
#define	E_RB_NOT_ENOUGH_DIFUNCT												RB_MAKE_ERROR(0x100A5)
#define	E_RB_NOT_ENOUGH_INITTAB												RB_MAKE_ERROR(0x100A6)
#define	E_RB_DEPENDENCY_ON_DELETED_COMPONENT								RB_MAKE_ERROR(0x100A7)
#define	E_RB_DIFUNCT_EXCEEDS_ROM											RB_MAKE_ERROR(0x100A8)
#define	E_RB_DEPENDENT_COMP_NOT_FOUND										RB_MAKE_ERROR(0x100A9)
#define	E_RB_INITTAB_EXCEEDS_ROM											RB_MAKE_ERROR(0x100AA)
#define	E_RB_INSTALLING_ENTRY_POINT_COMPONENT								RB_MAKE_ERROR(0x100AB)
#define	E_RB_DELETING_ENTRY_POINT_COMPONENT									RB_MAKE_ERROR(0x100AC)
#define	E_RB_EXPORTS_SIGS_DONT_MATCH										RB_MAKE_ERROR(0x100AD)
#define	E_RB_COMP_NAME_MISMTACH												RB_MAKE_ERROR(0x100AE)
#define	E_RB_OEM_COMP_WASNT_FOUND											RB_MAKE_ERROR(0x100AF)
#define	E_RB_ILLEGAL_ACTION_TYPE											RB_MAKE_ERROR(0x100B0)
#define	E_RB_FLAGS_FILE_FOUND_WITH_INVALID_SIZE								RB_MAKE_ERROR(0x100B1)
#define	E_RB_FLASH_BASED_BACKUP_UNEXPECTED_FLAG								RB_MAKE_ERROR(0x100B2)
#define	E_RB_READ_IMAGE_NEW_KEY_CALLED										RB_MAKE_ERROR(0x100B3)
#define	E_RB_IMAGE_ALREADY_IN_B												RB_MAKE_ERROR(0x100B4)
#define	E_RB_LAST_OPENED_FOLDER_WASNT_CLOSED								RB_MAKE_ERROR(0x100B5)
#define	E_RB_NOT_LAST_HANDLED_FOLDER_AS_PARAMETER							RB_MAKE_ERROR(0x100B6)
#define	E_RB_FAILED_DELETING_FOLDER											RB_MAKE_ERROR(0x100B7)
#define	E_RB_FAILED_CREATING_FOLDER											RB_MAKE_ERROR(0x100B8)
#define	E_RB_FAILED_GET_FILE_SIZE											RB_MAKE_ERROR(0x100B9)
#define	E_RB_BINARY_INPUT_OF_EMP_JEFF_COMP_FILES_NOT_SUPPORTED				RB_MAKE_ERROR(0x100BA)
#define	E_RB_FEASIBILITY_TST_CALLED_THOUGH_PARTITION_CORRUPTED				RB_MAKE_ERROR(0x100BB)
#define	E_RB_BINARY_INPUT_OF_JRFS_COMP_FILES_NOT_SUPPORTED					RB_MAKE_ERROR(0x100BC)
#define	E_RB_STRING_IN_CASE_SENSITIVE_FORMAT								RB_MAKE_ERROR(0x100BD)
#define	E_RB_CANNOT_MAKE_NON_ALPHA_AN_UPPER_CASE							RB_MAKE_ERROR(0x100BE)
#define	E_RB_VERIFY_LINK_REF_FAILED_NOT_A_LINK								RB_MAKE_ERROR(0x100BF)
#define	E_RB_VERIFY_LINK_REF_FAILED_GEN_ERR									RB_MAKE_ERROR(0x100C0)
#define	E_RB_FILE_ADDITIONAL_ATTR_INIT_FILE_DOESNT_EXIST					RB_MAKE_ERROR(0x100C1)
#define	E_RB_FILE_ADDITIONAL_ATTR_PRT_FILE_DOESNT_EXIST						RB_MAKE_ERROR(0x100C2)
#define	E_RB_PRT_FILE_ADDITIONAL_ATTR_READ_ERR								RB_MAKE_ERROR(0x100C3)
#define	E_RB_FILE_WAS_NOT_INIT_BY_ADDITIONAL_ATTR							RB_MAKE_ERROR(0x100C4)
#define	E_RB_FILE_ADDITIONAL_ATTR_DIFFER									RB_MAKE_ERROR(0x100C5)
#define	E_RB_CANNOT_SET_ATTRIBUTES_TO_NOT_EXISTING_FILE						RB_MAKE_ERROR(0x100C6)
#define	E_RB_DELTA_FROM_FILE_HANDLE_ALLREADY_OPEN							RB_MAKE_ERROR(0x100C7)
#define	E_RB_PATH_IS_A_FOLDER												RB_MAKE_ERROR(0x100C8)
#define	E_RB_FORBIDDEN_FUNC_CALLED_DELTA_FROM_FILE							RB_MAKE_ERROR(0x100C9)
#define	E_RB_FORBIDDEN_FUNC_CALLED_GET_AVAILABLE_FREE_SPACE					RB_MAKE_ERROR(0x100CA)
#define	E_RB_DECOMPRESS_LNG_FILE											RB_MAKE_ERROR(0x100CB)
#define	E_RB_COMPRESS_LNG_FILE												RB_MAKE_ERROR(0x100CC)
#define	E_RB_ELF_DEVICE_EMPTY_TABLE											RB_MAKE_ERROR(0x100CD)
#define	E_RB_DIFFERENT_USER_DATA_THAN_EXPECTED								RB_MAKE_ERROR(0x100CE)
#define	E_RB_COMPONENT_NAME_WASNT_FOUND										RB_MAKE_ERROR(0x100CF)
#define	E_RB_NOT_ENOUGH_PADDING												RB_MAKE_ERROR(0x100D0)
#define	E_RB_COMPONENT_ID_IS_ILLEGAL										RB_MAKE_ERROR(0x100D1)
#define	E_RB_ILLEGAL_SECTION_OFFSET											RB_MAKE_ERROR(0x100D2)
#define	E_RB_YAFFS_2_PARSE_ERROR											RB_MAKE_ERROR(0x100D3)
#define	E_RB_COMPRESSION_IDENTIFICATION_ERROR								RB_MAKE_ERROR(0x100D4)
#define E_RB_INVALID_INPUT_RW_INPUT_FOR_NON_RW_PRT							RB_MAKE_ERROR(0x100D5)
#define E_RB_BAD_PARAMS_MISSING_READ_PAGE_SIZE                              RB_MAKE_ERROR(0x100D6)
#define	E_RB_BAD_PARAMS_O_SCOUT_ONLY_IN_RECOVERY_RUN    					RB_MAKE_ERROR(0x100D7)
#define E_RB_VRM_UPI_VERSION_MISMATCH                                       RB_MAKE_ERROR(0x100D8)
#define E_RB_FILE_ADDITIONAL_ATTR_INVALID_STRUCTURE							RB_MAKE_ERROR(0x100D9)
#define	E_RB_CANNOT_CREATE_IMAGE_COMPRESSED_FILES_DETAILS_FILE				RB_MAKE_ERROR(0x100DA)
#define	E_RB_INVALID_IMAGE_COMPRESSED_FILES_DETAILS_FILE					RB_MAKE_ERROR(0x100DB)
#define	E_RB_MISSING_IMAGE_COMPRESSED_FILES_DETAILS_FILE					RB_MAKE_ERROR(0x100DC)
#define E_RB_SCOUT_FAILED_INSTALLER_RECREATION_IN_UNALLOWED_MODE			RB_MAKE_ERROR(0x100DD)
#define E_RB_SCOUT_FAILED_NOT_VALID_ENTRY_FLAGS								RB_MAKE_ERROR(0x100DE)
#define E_RB_SCOUT_FAILED_INSTALLER_RECREATION_SUBFILE_NOT_FOUND			RB_MAKE_ERROR(0x100DF)
#define E_RB_SCOUT_FAILED_INSTALLER_RECREATION_SUBFILE_SIG_DIFF				RB_MAKE_ERROR(0x100E0)
#define E_RB_INVALID_INPUT_INSTALLER_RECREATION_PLUS_SU						RB_MAKE_ERROR(0x100E1)
#define	E_RB_UPDATE_FAILED_NOT_ENOUGH_RAM									RB_MAKE_ERROR(0x100E2)
#define E_RB_FAILED_CREATING_SYMBOLIC_LINK									RB_MAKE_ERROR(0x100E3)
#define E_RB_INSTANT_UPDATED_UNSUPPORTED									RB_MAKE_ERROR(0x100E4)
#define	E_RB_BAD_PARAMS_ILLEGAL_ZLIB_PARAMS									RB_MAKE_ERROR(0x100E5)
#define	E_RB_BAD_PARAMS_PARTIAL_ZLIB_PARAMS									RB_MAKE_ERROR(0x100E6)
#define	E_RB_CANNOT_CREATE_IMAGE_COMPRESSION_PARAMETERS_FILE				RB_MAKE_ERROR(0x100E7)
#define	E_RB_INVALID_IMAGE_COMPRESSION_PARAMETERS_FILE						RB_MAKE_ERROR(0x100E8)
#define	E_RB_MISSING_IMAGE_COMPRESSION_PARAMETERS_FILE						RB_MAKE_ERROR(0x100E9)
#define	RB_E_INVALID_PARAMS_MEMORY_LEVEL_IN_COMPRESSION_CONTROL				RB_MAKE_ERROR(0x100EA)
#define	RB_E_INVALID_PARAMS_TRUNCATE_BLOCK_IN_COMPRESSION_CONTROL			RB_MAKE_ERROR(0x100EB)
//#define	RB_E_INVALID_PARAMS_USE_HEADER_IN_COMPRESSION_CONTROL				RB_MAKE_ERROR(0x100EC)
#define RB_E_COMPRESSION_PARAMS_DONT_FIT_COMPRESSION_PART_TOO_SMALL			RB_MAKE_ERROR(0x100EE)
#define RB_E_CANNOT_CREATE_DIRECTORY										RB_MAKE_ERROR(0x100EF)
#define E_RB_INVALID_LFS_FILE                       						RB_MAKE_ERROR(0x100F0)
#define E_RB_CANT_OPEN_COMPRESSION_CONTROL_FILE								RB_MAKE_ERROR(0x100F1)
#define E_RB_BAD_COMPRESSION_CONTROL_FILE									RB_MAKE_ERROR(0x100F2)
#define E_RB_FAILED_DURING_BACKGROUND_UPDATE								RB_MAKE_ERROR(0x100F3)
#define E_RB_READ_WRITE_DELTA_NOT_SUPPORTED									RB_MAKE_ERROR(0x100F4)
#define E_RB_IMAGE_DELTA_NOT_SUPPORTED										RB_MAKE_ERROR(0x100F5)

// installer file recreation errors
#define E_RB_BAD_INPUT_MISSING_INSTALLATION_FILE							RB_MAKE_ERROR(0x10100)
#define E_RB_GNRATOR_FUNC_FOR_INSTALLER_FILE_RECREATION_NOT_SUPPORTED		RB_MAKE_ERROR(0x10101)
#define E_RB_CANT_OPEN_CAB_SETUP_FILE										RB_MAKE_ERROR(0x10102)
#define E_RB_INVALID_CAB_SETUP_FILE											RB_MAKE_ERROR(0x10103)
#define E_RB_CAB_PARSING_OR_EXTRACTING_ERROR								RB_MAKE_ERROR(0x10104)
#define E_RB_UNSUPPORTED_COMPRESSION_FOR_CAB_FILE							RB_MAKE_ERROR(0x10105)
//#define	E_RB_BAD_PARAMS_ONLY_PART_PARTITIONS_ARE_INSTALLER_RECREATION		RB_MAKE_ERROR(0x10106)
#define	E_RB_BAD_PARAMS_INSTALLER_RECREATION_PRTS_SHOULD_BE_LAST_IN_CONFIG	RB_MAKE_ERROR(0x10107)

#define E_RB_INVALID_RB_FILE_DATA											RB_MAKE_ERROR(0x10108)

#define E_RB_FAILED_GETTING_FILE_FROM_FOLDER								RB_MAKE_ERROR(0x10109)
#define W_RB_INVALID_FILE_ATTRIBUTES										RB_MAKE_ERROR(0X1010A)
#define E_RB_FILE_SYSTEM_COMPATIBILITY_MODE_ALLOWD_ONLY_IN_WINDOWS			RB_MAKE_ERROR(0X1010B)
#define	E_RB_BAD_PARAMS_INVALID_SYNTAX										RB_MAKE_ERROR(0x1010C)
							

// android boot image errors
#define E_RB_INVALID_ANDROID_BOOT_IMAGE_FILE								RB_MAKE_ERROR(0x10150)

#define E_RB_FAILED_TO_UPDATE_STAT_FILE										RB_MAKE_ERROR(0x10160)


/*___________________Values that are not errors ___________________*/
// this return value is used for example, if we are running in full OS mode to update
// the RW partition, and we found out that we also have to update the ROFS partition,
// so we need to reboot to miniOS mode and update the ROFS
#define S_RB_NEED_ANOTHER_REBOOT									RB_MAKE_SUCCESS(0x100100)



#endif //__RB_VRM_ERRORS__
