/* DO NOT MODIFY - automatically generated by generate_builtins.py */
/*
 * Copyright © 2010 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include "main/core.h" /* for struct gl_shader */
#include "glsl_parser_extras.h"
#include "ir_reader.h"
#include "program.h"
#include "ast.h"

extern "C" struct gl_shader *
_mesa_new_shader(struct gl_context *ctx, GLuint name, GLenum type);

gl_shader *
read_builtins(GLenum target, const char *protos, const char **functions, unsigned count)
{
   struct gl_context fakeCtx;
   fakeCtx.API = API_OPENGL;
   fakeCtx.Const.GLSLVersion = 140;
   fakeCtx.Extensions.ARB_ES2_compatibility = true;
   fakeCtx.Const.ForceGLSLExtensionsWarn = false;
   gl_shader *sh = _mesa_new_shader(NULL, 0, target);
   struct _mesa_glsl_parse_state *st =
      new(sh) _mesa_glsl_parse_state(&fakeCtx, target, sh);

   st->language_version = 140;
   st->symbols->language_version = 140;
   st->ARB_texture_rectangle_enable = true;
   st->EXT_texture_array_enable = true;
   st->OES_EGL_image_external_enable = true;
   st->ARB_shader_bit_encoding_enable = true;
   _mesa_glsl_initialize_types(st);

   sh->ir = new(sh) exec_list;
   sh->symbols = st->symbols;

   /* Read the IR containing the prototypes */
   _mesa_glsl_read_ir(st, sh->ir, protos, true);

   /* Read ALL the function bodies, telling the IR reader not to scan for
    * prototypes (we've already created them).  The IR reader will skip any
    * signature that does not already exist as a prototype.
    */
   for (unsigned i = 0; i < count; i++) {
      _mesa_glsl_read_ir(st, sh->ir, functions[i], false);

      if (st->error) {
         printf("error reading builtin: %.35s ...\n", functions[i]);
         printf("Info log:\n%s\n", st->info_log);
         ralloc_free(sh);
         return NULL;
      }
   }

   reparent_ir(sh->ir, sh);
   delete st;

   return sh;
}

static const char builtin_abs[] =
   "((function abs\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float abs (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 abs (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 abs (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 abs (var_ref arg0)))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) int arg0))\n"
   "     ((return (expression int abs (var_ref arg0)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0))\n"
   "     ((return (expression ivec2 abs (var_ref arg0)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0))\n"
   "     ((return (expression ivec3 abs (var_ref arg0)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0))\n"
   "     ((return (expression ivec4 abs (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_acos[] =
   "((function acos\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((declare () float s)\n"
   "      (call asin (var_ref s) ((var_ref x)))\n"
   "      (return (expression float - (constant float (1.5707964)) (var_ref s)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((declare () vec2 s)\n"
   "      (call asin (var_ref s) ((var_ref x)))\n"
   "      (return (expression vec2 - (constant float (1.5707964)) (var_ref s)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((declare () vec3 s)\n"
   "      (call asin (var_ref s) ((var_ref x)))\n"
   "      (return (expression vec3 - (constant float (1.5707964)) (var_ref s)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((declare () vec4 s)\n"
   "      (call asin (var_ref s) ((var_ref x)))\n"
   "      (return (expression vec4 - (constant float (1.5707964)) (var_ref s)))))\n"
   "))\n"
   ""
;
static const char builtin_acosh[] =
   "((function acosh\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float log (expression float + (var_ref x) (expression float sqrt (expression float - (expression float * (var_ref x) (var_ref x)) (constant float (1)))))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 log (expression vec2 + (var_ref x) (expression vec2 sqrt (expression vec2 - (expression vec2 * (var_ref x) (var_ref x)) (constant float (1)))))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 log (expression vec3 + (var_ref x) (expression vec3 sqrt (expression vec3 - (expression vec3 * (var_ref x) (var_ref x)) (constant float (1)))))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 log (expression vec4 + (var_ref x) (expression vec4 sqrt (expression vec4 - (expression vec4 * (var_ref x) (var_ref x)) (constant float (1)))))))))\n"
   "))\n"
   ""
;
static const char builtin_all[] =
   "((function all\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) bvec2 arg0))\n"
   "     ((return (expression bool && (swiz x (var_ref arg0))(swiz y (var_ref arg0))))))\n"
   "\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) bvec3 arg0))\n"
   "     ((return (expression bool && (expression bool && (swiz x (var_ref arg0))(swiz y (var_ref arg0))) (swiz z (var_ref arg0))))))\n"
   "\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) bvec4 arg0))\n"
   "     ((return (expression bool && (expression bool && (expression bool && (swiz x (var_ref arg0))(swiz y (var_ref arg0))) (swiz z (var_ref arg0))) (swiz w (var_ref arg0))))))\n"
   "))\n"
   ""
;
static const char builtin_any[] =
   "((function any\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) bvec2 arg0))\n"
   "     ((return (expression bool any (var_ref arg0)))))\n"
   "\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) bvec3 arg0))\n"
   "     ((return (expression bool any (var_ref arg0)))))\n"
   "\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) bvec4 arg0))\n"
   "     ((return (expression bool any (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_asin[] =
   "((function asin\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float *\n"
   "	       (expression float sign (var_ref x))\n"
   "	       (expression float -\n"
   "		(constant float (1.5707964))\n"
   "		(expression float *\n"
   "		 (expression float sqrt\n"
   "		  (expression float -\n"
   "		   (constant float (1.0))\n"
   "		   (expression float abs (var_ref x))))\n"
   "		 (expression float +\n"
   "		  (constant float (1.5707964))\n"
   "		  (expression float *\n"
   "		   (expression float abs (var_ref x))\n"
   "		   (expression float +\n"
   "		    (constant float (-0.21460183))\n"
   "		    (expression float *\n"
   "		     (expression float abs (var_ref x))\n"
   "                     (expression float +\n"
   "                      (constant float (0.086566724))\n"
   "                      (expression float *\n"
   "                       (expression float abs (var_ref x))\n"
   "                       (constant float (-0.03102955))\n"
   "		     ))))))))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 *\n"
   "	       (expression vec2 sign (var_ref x))\n"
   "	       (expression vec2 -\n"
   "		(constant float (1.5707964))\n"
   "		(expression vec2 *\n"
   "		 (expression vec2 sqrt\n"
   "		  (expression vec2 -\n"
   "		   (constant float (1.0))\n"
   "		   (expression vec2 abs (var_ref x))))\n"
   "		 (expression vec2 +\n"
   "		  (constant float (1.5707964))\n"
   "		  (expression vec2 *\n"
   "		   (expression vec2 abs (var_ref x))\n"
   "		   (expression vec2 +\n"
   "		    (constant float (-0.21460183))\n"
   "		    (expression vec2 *\n"
   "		     (expression vec2 abs (var_ref x))\n"
   "                     (expression vec2 +\n"
   "                      (constant float (0.086566724))\n"
   "                      (expression vec2 *\n"
   "                       (expression vec2 abs (var_ref x))\n"
   "                       (constant float (-0.03102955))\n"
   "		     ))))))))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 *\n"
   "	       (expression vec3 sign (var_ref x))\n"
   "	       (expression vec3 -\n"
   "		(constant float (1.5707964))\n"
   "		(expression vec3 *\n"
   "		 (expression vec3 sqrt\n"
   "		  (expression vec3 -\n"
   "		   (constant float (1.0))\n"
   "		   (expression vec3 abs (var_ref x))))\n"
   "		 (expression vec3 +\n"
   "		  (constant float (1.5707964))\n"
   "		  (expression vec3 *\n"
   "		   (expression vec3 abs (var_ref x))\n"
   "		   (expression vec3 +\n"
   "		    (constant float (-0.21460183))\n"
   "		    (expression vec3 *\n"
   "		     (expression vec3 abs (var_ref x))\n"
   "                     (expression vec3 +\n"
   "                      (constant float (0.086566724))\n"
   "                      (expression vec3 *\n"
   "                       (expression vec3 abs (var_ref x))\n"
   "                       (constant float (-0.03102955))\n"
   "		     ))))))))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 *\n"
   "	       (expression vec4 sign (var_ref x))\n"
   "	       (expression vec4 -\n"
   "		(constant float (1.5707964))\n"
   "		(expression vec4 *\n"
   "		 (expression vec4 sqrt\n"
   "		  (expression vec4 -\n"
   "		   (constant float (1.0))\n"
   "		   (expression vec4 abs (var_ref x))))\n"
   "		 (expression vec4 +\n"
   "		  (constant float (1.5707964))\n"
   "		  (expression vec4 *\n"
   "		   (expression vec4 abs (var_ref x))\n"
   "		   (expression vec4 +\n"
   "		    (constant float (-0.21460183))\n"
   "		    (expression vec4 *\n"
   "		     (expression vec4 abs (var_ref x))\n"
   "                     (expression vec4 +\n"
   "                      (constant float (0.086566724))\n"
   "                      (expression vec4 *\n"
   "                       (expression vec4 abs (var_ref x))\n"
   "                       (constant float (-0.03102955))\n"
   "		     ))))))))))))\n"
   "))\n"
   ""
;
static const char builtin_asinh[] =
   "((function asinh\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float *\n"
   "               (expression float sign (var_ref x))\n"
   "               (expression float log\n"
   "                (expression float +\n"
   "                 (expression float abs (var_ref x))\n"
   "                 (expression float sqrt\n"
   "                  (expression float +\n"
   "                   (expression float * (var_ref x) (var_ref x))\n"
   "                   (constant float (1))))))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 *\n"
   "               (expression vec2 sign (var_ref x))\n"
   "               (expression vec2 log\n"
   "                (expression vec2 +\n"
   "                 (expression vec2 abs (var_ref x))\n"
   "                 (expression vec2 sqrt\n"
   "                  (expression vec2 +\n"
   "                   (expression vec2 * (var_ref x) (var_ref x))\n"
   "                   (constant float (1))))))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 *\n"
   "               (expression vec3 sign (var_ref x))\n"
   "               (expression vec3 log\n"
   "                (expression vec3 +\n"
   "                 (expression vec3 abs (var_ref x))\n"
   "                 (expression vec3 sqrt\n"
   "                  (expression vec3 +\n"
   "                   (expression vec3 * (var_ref x) (var_ref x))\n"
   "                   (constant float (1))))))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 *\n"
   "               (expression vec4 sign (var_ref x))\n"
   "               (expression vec4 log\n"
   "                (expression vec4 +\n"
   "                 (expression vec4 abs (var_ref x))\n"
   "                 (expression vec4 sqrt\n"
   "                  (expression vec4 +\n"
   "                   (expression vec4 * (var_ref x) (var_ref x))\n"
   "                   (constant float (1))))))))))\n"
   "))\n"
   ""
;
static const char builtin_atan[] =
   "((function atan\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float y_over_x))\n"
   "     ((declare () float s)\n"
   "      (call asin (var_ref s)\n"
   "			  ((expression float *\n"
   "			   (var_ref y_over_x)\n"
   "			   (expression float rsq\n"
   "			    (expression float +\n"
   "			     (expression float *\n"
   "			      (var_ref y_over_x)\n"
   "			      (var_ref y_over_x))\n"
   "			     (constant float (1.0)))))))\n"
   "      (return (var_ref s))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 y_over_x))\n"
   "     ((declare () vec2 s)\n"
   "      (call asin (var_ref s)\n"
   "			  ((expression vec2 *\n"
   "			   (var_ref y_over_x)\n"
   "			   (expression vec2 rsq\n"
   "			    (expression vec2 +\n"
   "			     (expression vec2 *\n"
   "			      (var_ref y_over_x)\n"
   "			      (var_ref y_over_x))\n"
   "			     (constant float (1.0)))))))\n"
   "      (return (var_ref s))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 y_over_x))\n"
   "     ((declare () vec3 s)\n"
   "      (call asin (var_ref s)\n"
   "			  ((expression vec3 *\n"
   "			   (var_ref y_over_x)\n"
   "			   (expression vec3 rsq\n"
   "			    (expression vec3 +\n"
   "			     (expression vec3 *\n"
   "			      (var_ref y_over_x)\n"
   "			      (var_ref y_over_x))\n"
   "			     (constant float (1.0)))))))\n"
   "      (return (var_ref s))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 y_over_x))\n"
   "     ((declare () vec4 s)\n"
   "      (call asin (var_ref s)\n"
   "			  ((expression vec4 *\n"
   "			   (var_ref y_over_x)\n"
   "			   (expression vec4 rsq\n"
   "			    (expression vec4 +\n"
   "			     (expression vec4 *\n"
   "			      (var_ref y_over_x)\n"
   "			      (var_ref y_over_x))\n"
   "			     (constant float (1.0)))))))\n"
   "      (return (var_ref s))))\n"
   "\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in ) float y)\n"
   "      (declare (in ) float x)\n"
   "    )\n"
   "    (\n"
   "      (declare () float r)\n"
   "      (if (expression bool >\n"
   "           (expression float abs (var_ref x))\n"
   "           (expression float * (constant float (1.0e-8)) (expression float abs (var_ref y)))) (\n"
   "        (call atan (var_ref r) ((expression float / (var_ref y) (var_ref x))))\n"
   "        (if (expression bool < (var_ref x) (constant float (0.000000)) ) (\n"
   "          (if (expression bool >= (var_ref y) (constant float (0.000000)) )\n"
   "              ((assign (x) (var_ref r) (expression float + (var_ref r) (constant float (3.141593)))))\n"
   "              ((assign (x) (var_ref r) (expression float - (var_ref r) (constant float (3.141593))))))\n"
   "        )\n"
   "        (\n"
   "        ))\n"
   "      )\n"
   "      (\n"
   "        (declare () float sgn)\n"
   "        (assign (x) (var_ref sgn) (expression float sign (var_ref y)))\n"
   "        (assign (x) (var_ref r) (expression float * (var_ref sgn) (constant float (1.5707965))))\n"
   "      ))\n"
   "\n"
   "      (return (var_ref r) )\n"
   "    ))\n"
   "\n"
   "\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 y)\n"
   "       (declare (in) vec2 x))\n"
   "     ((declare () vec2 r)\n"
   "      (declare () float temp)\n"
   "      (call atan (var_ref temp) ((swiz x (var_ref y)) (swiz x (var_ref x))))\n"
   "      (assign (x) (var_ref r) (var_ref temp))\n"
   "      (call atan (var_ref temp) ((swiz y (var_ref y)) (swiz y (var_ref x))))\n"
   "      (assign (y) (var_ref r) (var_ref temp))\n"
   "      (return (var_ref r))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 y)\n"
   "       (declare (in) vec3 x))\n"
   "     ((declare () vec3 r)\n"
   "      (declare () float temp)\n"
   "      (call atan (var_ref temp) ((swiz x (var_ref y)) (swiz x (var_ref x))))\n"
   "      (assign (x) (var_ref r) (var_ref temp))\n"
   "      (call atan (var_ref temp) ((swiz y (var_ref y)) (swiz y (var_ref x))))\n"
   "      (assign (y) (var_ref r) (var_ref temp))\n"
   "      (call atan (var_ref temp) ((swiz z (var_ref y)) (swiz z (var_ref x))))\n"
   "      (assign (z) (var_ref r) (var_ref temp))\n"
   "      (return (var_ref r))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 y)\n"
   "       (declare (in) vec4 x))\n"
   "     ((declare () vec4 r)\n"
   "      (declare () float temp)\n"
   "      (call atan (var_ref temp) ((swiz x (var_ref y)) (swiz x (var_ref x))))\n"
   "      (assign (x) (var_ref r) (var_ref temp))\n"
   "      (call atan (var_ref temp) ((swiz y (var_ref y)) (swiz y (var_ref x))))\n"
   "      (assign (y) (var_ref r) (var_ref temp))\n"
   "      (call atan (var_ref temp) ((swiz z (var_ref y)) (swiz z (var_ref x))))\n"
   "      (assign (z) (var_ref r) (var_ref temp))\n"
   "      (call atan (var_ref temp) ((swiz w (var_ref y)) (swiz w (var_ref x))))\n"
   "      (assign (w) (var_ref r) (var_ref temp))\n"
   "      (return (var_ref r))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_atanh[] =
   "((function atanh\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float * (constant float (0.5))\n"
   "                (expression float log\n"
   "		  (expression float /\n"
   "                    (expression float + (constant float (1)) (var_ref x))\n"
   "                    (expression float - (constant float (1)) (var_ref x))))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 * (constant float (0.5))\n"
   "                (expression vec2 log\n"
   "		  (expression vec2 /\n"
   "                    (expression vec2 + (constant float (1)) (var_ref x))\n"
   "                    (expression vec2 - (constant float (1)) (var_ref x))))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 * (constant float (0.5))\n"
   "                (expression vec3 log\n"
   "		  (expression vec3 /\n"
   "                    (expression vec3 + (constant float (1)) (var_ref x))\n"
   "                    (expression vec3 - (constant float (1)) (var_ref x))))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 * (constant float (0.5))\n"
   "                (expression vec4 log\n"
   "		  (expression vec4 /\n"
   "                    (expression vec4 + (constant float (1)) (var_ref x))\n"
   "                    (expression vec4 - (constant float (1)) (var_ref x))))))))\n"
   "))\n"
   ""
;
static const char builtin_ceil[] =
   "((function ceil\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float ceil (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 ceil (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 ceil (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 ceil (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_clamp[] =
   "((function clamp\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression float max (expression float min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1)\n"
   "       (declare (in) vec2 arg2))\n"
   "     ((return (expression vec2 max (expression vec2 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1)\n"
   "       (declare (in) vec3 arg2))\n"
   "     ((return (expression vec3 max (expression vec3 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1)\n"
   "       (declare (in) vec4 arg2))\n"
   "     ((return (expression vec4 max (expression vec4 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2  arg0)\n"
   "       (declare (in) float arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression vec2 max (expression vec2 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3  arg0)\n"
   "       (declare (in) float arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression vec3 max (expression vec3 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4  arg0)\n"
   "       (declare (in) float arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression vec4 max (expression vec4 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) int arg0)\n"
   "       (declare (in) int arg1)\n"
   "       (declare (in) int arg2))\n"
   "     ((return (expression int max (expression int min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1)\n"
   "       (declare (in) ivec2 arg2))\n"
   "     ((return (expression ivec2 max (expression ivec2 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1)\n"
   "       (declare (in) ivec3 arg2))\n"
   "     ((return (expression ivec3 max (expression ivec3 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1)\n"
   "       (declare (in) ivec4 arg2))\n"
   "     ((return (expression ivec4 max (expression ivec4 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) int arg1)\n"
   "       (declare (in) int arg2))\n"
   "     ((return (expression ivec2 max (expression ivec2 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) int arg1)\n"
   "       (declare (in) int arg2))\n"
   "     ((return (expression ivec3 max (expression ivec3 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) int arg1)\n"
   "       (declare (in) int arg2))\n"
   "     ((return (expression ivec4 max (expression ivec4 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uint\n"
   "     (parameters\n"
   "       (declare (in) uint arg0)\n"
   "       (declare (in) uint arg1)\n"
   "       (declare (in) uint arg2))\n"
   "     ((return (expression uint max (expression uint min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1)\n"
   "       (declare (in) uvec2 arg2))\n"
   "     ((return (expression uvec2 max (expression uvec2 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1)\n"
   "       (declare (in) uvec3 arg2))\n"
   "     ((return (expression uvec3 max (expression uvec3 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1)\n"
   "       (declare (in) uvec4 arg2))\n"
   "     ((return (expression uvec4 max (expression uvec4 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uint arg1)\n"
   "       (declare (in) uint arg2))\n"
   "     ((return (expression uvec2 max (expression uvec2 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uint arg1)\n"
   "       (declare (in) uint arg2))\n"
   "     ((return (expression uvec3 max (expression uvec3 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uint arg1)\n"
   "       (declare (in) uint arg2))\n"
   "     ((return (expression uvec4 max (expression uvec4 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char builtin_cos[] =
   "((function cos\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float angle))\n"
   "     ((return (expression float cos (var_ref angle)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 angle))\n"
   "     ((return (expression vec2 cos (var_ref angle)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 angle))\n"
   "     ((return (expression vec3 cos (var_ref angle)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 angle))\n"
   "     ((return (expression vec4 cos (var_ref angle)))))\n"
   "))\n"
   ""
;
static const char builtin_cosh[] =
   "((function cosh\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float * (constant float (0.5))\n"
   "                (expression float +\n"
   "		  (expression float exp (var_ref x))\n"
   "		  (expression float exp (expression float neg (var_ref x))))))))\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 * (constant float (0.5))\n"
   "                (expression vec2 +\n"
   "		  (expression vec2 exp (var_ref x))\n"
   "		  (expression vec2 exp (expression vec2 neg (var_ref x))))))))\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 * (constant float (0.5))\n"
   "                (expression vec3 +\n"
   "		  (expression vec3 exp (var_ref x))\n"
   "		  (expression vec3 exp (expression vec3 neg (var_ref x))))))))\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 * (constant float (0.5))\n"
   "                (expression vec4 +\n"
   "		  (expression vec4 exp (var_ref x))\n"
   "		  (expression vec4 exp (expression vec4 neg (var_ref x))))))))\n"
   "))\n"
   ""
;
static const char builtin_cross[] =
   "((function cross\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 a)\n"
   "       (declare (in) vec3 b))\n"
   "     ((return (expression vec3 -\n"
   "        (expression vec3 * (swiz yzx (var_ref a)) (swiz zxy (var_ref b)))\n"
   "        (expression vec3 * (swiz zxy (var_ref a)) (swiz yzx (var_ref b)))))))\n"
   "))\n"
   ""
;
static const char builtin_dFdx[] =
   "((function dFdx\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float p))\n"
   "     ((return (expression float dFdx (var_ref p)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 p))\n"
   "     ((return (expression vec2 dFdx (var_ref p)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 p))\n"
   "     ((return (expression vec3 dFdx (var_ref p)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 p))\n"
   "     ((return (expression vec4 dFdx (var_ref p)))))\n"
   "))\n"
   ""
;
static const char builtin_dFdy[] =
   "((function dFdy\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float p))\n"
   "     ((return (expression float dFdy (var_ref p)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 p))\n"
   "     ((return (expression vec2 dFdy (var_ref p)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 p))\n"
   "     ((return (expression vec3 dFdy (var_ref p)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 p))\n"
   "     ((return (expression vec4 dFdy (var_ref p)))))\n"
   "))\n"
   ""
;
static const char builtin_degrees[] =
   "((function degrees\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float * (var_ref arg0) (constant float (57.295780))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 * (var_ref arg0) (constant float (57.295780))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 * (var_ref arg0) (constant float (57.295780))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 * (var_ref arg0) (constant float (57.295780))))))\n"
   "))\n"
   ""
;
static const char builtin_distance[] =
   "((function distance\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float p0)\n"
   "       (declare (in) float p1))\n"
   "     ((return (expression float abs (expression float - (var_ref p0) (var_ref p1))))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec2 p0)\n"
   "       (declare (in) vec2 p1))\n"
   "     ((declare () vec2 p)\n"
   "      (assign (xy) (var_ref p) (expression vec2 - (var_ref p0) (var_ref p1)))\n"
   "      (return (expression float sqrt (expression float dot (var_ref p) (var_ref p))))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec3 p0)\n"
   "       (declare (in) vec3 p1))\n"
   "     ((declare () vec3 p)\n"
   "      (assign (xyz) (var_ref p) (expression vec3 - (var_ref p0) (var_ref p1)))\n"
   "      (return (expression float sqrt (expression float dot (var_ref p) (var_ref p))))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec4 p0)\n"
   "       (declare (in) vec4 p1))\n"
   "     ((declare () vec4 p)\n"
   "      (assign (xyzw) (var_ref p) (expression vec4 - (var_ref p0) (var_ref p1)))\n"
   "      (return (expression float sqrt (expression float dot (var_ref p) (var_ref p))))))\n"
   "))\n"
   ""
;
static const char builtin_dot[] =
   "((function dot\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression float * (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression float dot (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression float dot (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression float dot (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char builtin_equal[] =
   "((function equal\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression bvec2 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression bvec3 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression bvec4 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) bvec2 arg0)\n"
   "       (declare (in) bvec2 arg1))\n"
   "     ((return (expression bvec2 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) bvec3 arg0)\n"
   "       (declare (in) bvec3 arg1))\n"
   "     ((return (expression bvec3 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) bvec4 arg0)\n"
   "       (declare (in) bvec4 arg1))\n"
   "     ((return (expression bvec4 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression bvec2 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression bvec3 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression bvec4 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression bvec2 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression bvec3 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression bvec4 == (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char builtin_exp[] =
   "((function exp\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float exp (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 exp (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 exp (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 exp (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_exp2[] =
   "((function exp2\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float exp2 (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 exp2 (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 exp2 (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 exp2 (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_faceforward[] =
   "((function faceforward\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float N)\n"
   "       (declare (in) float I)\n"
   "       (declare (in) float Nref))\n"
   "     ((if (expression bool < (expression float * (var_ref Nref) (var_ref I)) (constant float (0)))\n"
   "          ((return (var_ref N)))\n"
   "	  ((return (expression float neg (var_ref N)))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 N)\n"
   "       (declare (in) vec2 I)\n"
   "       (declare (in) vec2 Nref))\n"
   "     ((if (expression bool < (expression float dot (var_ref Nref) (var_ref I)) (constant float (0)))\n"
   "          ((return (var_ref N)))\n"
   "	  ((return (expression vec2 neg (var_ref N)))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 N)\n"
   "       (declare (in) vec3 I)\n"
   "       (declare (in) vec3 Nref))\n"
   "     ((if (expression bool < (expression float dot (var_ref Nref) (var_ref I)) (constant float (0)))\n"
   "          ((return (var_ref N)))\n"
   "	  ((return (expression vec3 neg (var_ref N)))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 N)\n"
   "       (declare (in) vec4 I)\n"
   "       (declare (in) vec4 Nref))\n"
   "     ((if (expression bool < (expression float dot (var_ref Nref) (var_ref I)) (constant float (0)))\n"
   "          ((return (var_ref N)))\n"
   "	  ((return (expression vec4 neg (var_ref N)))))))\n"
   "))\n"
   ""
;
static const char builtin_floatBitsToInt[] =
   "((function floatBitsToInt\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) float arg))\n"
   "     ((return (expression int bitcast_f2i (var_ref arg)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg))\n"
   "     ((return (expression ivec2 bitcast_f2i (var_ref arg)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg))\n"
   "     ((return (expression ivec3 bitcast_f2i (var_ref arg)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg))\n"
   "     ((return (expression ivec4 bitcast_f2i (var_ref arg)))))\n"
   "))\n"
   ""
;
static const char builtin_floatBitsToUint[] =
   "((function floatBitsToUint\n"
   "   (signature uint\n"
   "     (parameters\n"
   "       (declare (in) float arg))\n"
   "     ((return (expression uint bitcast_f2u (var_ref arg)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg))\n"
   "     ((return (expression uvec2 bitcast_f2u (var_ref arg)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg))\n"
   "     ((return (expression uvec3 bitcast_f2u (var_ref arg)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg))\n"
   "     ((return (expression uvec4 bitcast_f2u (var_ref arg)))))\n"
   "))\n"
   ""
;
static const char builtin_floor[] =
   "((function floor\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float floor (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 floor (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 floor (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 floor (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_fract[] =
   "((function fract\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float fract (var_ref x)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 fract (var_ref x)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 fract (var_ref x)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 fract (var_ref x)))))\n"
   "))\n"
   "\n"
   ""
;
static const char builtin_ftransform[] =
   "((declare (uniform) mat4 gl_ModelViewProjectionMatrix)\n"
   " (declare (in) vec4 gl_Vertex)\n"
   " (function ftransform\n"
   "   (signature vec4\n"
   "     (parameters)\n"
   "    ((return (expression vec4 *\n"
   "	      (var_ref gl_ModelViewProjectionMatrix)\n"
   "	      (var_ref gl_Vertex)))))\n"
   "))\n"
   ""
;
static const char builtin_fwidth[] =
   "((function fwidth\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float p))\n"
   "     ((return (expression float +\n"
   "                (expression float abs (expression float dFdx (var_ref p)))\n"
   "                (expression float abs (expression float dFdy (var_ref p)))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 p))\n"
   "     ((return (expression vec2 +\n"
   "                (expression vec2 abs (expression vec2 dFdx (var_ref p)))\n"
   "                (expression vec2 abs (expression vec2 dFdy (var_ref p)))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 p))\n"
   "     ((return (expression vec3 +\n"
   "                (expression vec3 abs (expression vec3 dFdx (var_ref p)))\n"
   "                (expression vec3 abs (expression vec3 dFdy (var_ref p)))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 p))\n"
   "     ((return (expression vec4 +\n"
   "                (expression vec4 abs (expression vec4 dFdx (var_ref p)))\n"
   "                (expression vec4 abs (expression vec4 dFdy (var_ref p)))))))\n"
   "))\n"
   ""
;
static const char builtin_greaterThan[] =
   "((function greaterThan\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression bvec2 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression bvec3 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression bvec4 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression bvec2 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression bvec3 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression bvec4 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression bvec2 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression bvec3 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression bvec4 > (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char builtin_greaterThanEqual[] =
   "((function greaterThanEqual\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression bvec2 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression bvec3 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression bvec4 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression bvec2 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression bvec3 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression bvec4 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression bvec2 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression bvec3 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression bvec4 >= (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char builtin_intBitsToFloat[] =
   "((function intBitsToFloat\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) int arg))\n"
   "     ((return (expression float bitcast_i2f (var_ref arg)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg))\n"
   "     ((return (expression vec2 bitcast_i2f (var_ref arg)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg))\n"
   "     ((return (expression vec3 bitcast_i2f (var_ref arg)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg))\n"
   "     ((return (expression vec4 bitcast_i2f (var_ref arg)))))\n"
   "))\n"
   ""
;
static const char builtin_inverse[] =
   "(\n"
   "(function inverse\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 m))\n"
   "    (\n"
   "      (declare () float det)\n"
   "      (declare () mat2 adj)\n"
   "      (declare (temporary) float assignment_tmp)\n"
   "      (assign  (x) (var_ref assignment_tmp)  (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1)))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (0))) (constant int (0)))  (var_ref assignment_tmp)) \n"
   "      (declare (temporary) float assignment_tmp@2)\n"
   "      (assign  (x) (var_ref assignment_tmp@2)  (expression float neg (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (0))) (constant int (1)))  (var_ref assignment_tmp@2)) \n"
   "      (declare (temporary) float assignment_tmp@3)\n"
   "      (assign  (x) (var_ref assignment_tmp@3)  (expression float neg (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (1))) (constant int (0)))  (var_ref assignment_tmp@3)) \n"
   "      (declare (temporary) float assignment_tmp@4)\n"
   "      (assign  (x) (var_ref assignment_tmp@4)  (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0)))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (1))) (constant int (1)))  (var_ref assignment_tmp@4)) \n"
   "      (declare (temporary) float assignment_tmp@5)\n"
   "      (assign  (x) (var_ref assignment_tmp@5)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1)))))) \n"
   "      (assign  (x) (var_ref det)  (var_ref assignment_tmp@5)) \n"
   "      (return (expression mat2 / (var_ref adj) (var_ref det)))))\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 m))\n"
   "    (\n"
   "      (declare () float det)\n"
   "      (declare () mat3 adj)\n"
   "      (declare (temporary) float assignment_tmp)\n"
   "      (assign  (x) (var_ref assignment_tmp)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2)))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (0))) (constant int (0)))  (var_ref assignment_tmp)) \n"
   "      (declare (temporary) float assignment_tmp@6)\n"
   "      (assign  (x) (var_ref assignment_tmp@6)  (expression float neg (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2))))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (1))) (constant int (0)))  (var_ref assignment_tmp@6)) \n"
   "      (declare (temporary) float assignment_tmp@7)\n"
   "      (assign  (x) (var_ref assignment_tmp@7)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (1)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1)))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (2))) (constant int (0)))  (var_ref assignment_tmp@7)) \n"
   "      (declare (temporary) float assignment_tmp@8)\n"
   "      (assign  (x) (var_ref assignment_tmp@8)  (expression float neg (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (0))) (constant int (1)))  (var_ref assignment_tmp@8)) \n"
   "      (declare (temporary) float assignment_tmp@9)\n"
   "      (assign  (x) (var_ref assignment_tmp@9)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2)))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (1))) (constant int (1)))  (var_ref assignment_tmp@9)) \n"
   "      (declare (temporary) float assignment_tmp@10)\n"
   "      (assign  (x) (var_ref assignment_tmp@10)  (expression float neg (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (1)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (2))) (constant int (1)))  (var_ref assignment_tmp@10)) \n"
   "      (declare (temporary) float assignment_tmp@11)\n"
   "      (assign  (x) (var_ref assignment_tmp@11)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2)))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (0))) (constant int (2)))  (var_ref assignment_tmp@11)) \n"
   "      (declare (temporary) float assignment_tmp@12)\n"
   "      (assign  (x) (var_ref assignment_tmp@12)  (expression float neg (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (1))) (constant int (2)))  (var_ref assignment_tmp@12)) \n"
   "      (declare (temporary) float assignment_tmp@13)\n"
   "      (assign  (x) (var_ref assignment_tmp@13)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1)))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (2))) (constant int (2)))  (var_ref assignment_tmp@13)) \n"
   "      (declare (temporary) float assignment_tmp@14)\n"
   "      (assign  (x) (var_ref assignment_tmp@14)  (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (1)))))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (0))))))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))) (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (1)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (0)))))))) \n"
   "      (assign  (x) (var_ref det)  (var_ref assignment_tmp@14)) \n"
   "      (return (expression mat3 / (var_ref adj) (var_ref det)))))\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 m))\n"
   "    (\n"
   "      (declare () float det)\n"
   "      (declare () mat4 adj)\n"
   "      (declare () float SubFactor18)\n"
   "      (declare () float SubFactor17)\n"
   "      (declare () float SubFactor16)\n"
   "      (declare () float SubFactor15)\n"
   "      (declare () float SubFactor14)\n"
   "      (declare () float SubFactor13)\n"
   "      (declare () float SubFactor12)\n"
   "      (declare () float SubFactor11)\n"
   "      (declare () float SubFactor10)\n"
   "      (declare () float SubFactor09)\n"
   "      (declare () float SubFactor08)\n"
   "      (declare () float SubFactor07)\n"
   "      (declare () float SubFactor06)\n"
   "      (declare () float SubFactor05)\n"
   "      (declare () float SubFactor04)\n"
   "      (declare () float SubFactor03)\n"
   "      (declare () float SubFactor02)\n"
   "      (declare () float SubFactor01)\n"
   "      (declare () float SubFactor00)\n"
   "      (declare (temporary) float assignment_tmp)\n"
   "      (assign  (x) (var_ref assignment_tmp)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (2))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (3)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (2))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (3)))))) \n"
   "      (assign  (x) (var_ref SubFactor00)  (var_ref assignment_tmp)) \n"
   "      (declare (temporary) float assignment_tmp@15)\n"
   "      (assign  (x) (var_ref assignment_tmp@15)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (3)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (3)))))) \n"
   "      (assign  (x) (var_ref SubFactor01)  (var_ref assignment_tmp@15)) \n"
   "      (declare (temporary) float assignment_tmp@16)\n"
   "      (assign  (x) (var_ref assignment_tmp@16)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (2)))))) \n"
   "      (assign  (x) (var_ref SubFactor02)  (var_ref assignment_tmp@16)) \n"
   "      (declare (temporary) float assignment_tmp@17)\n"
   "      (assign  (x) (var_ref assignment_tmp@17)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (3)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (3)))))) \n"
   "      (assign  (x) (var_ref SubFactor03)  (var_ref assignment_tmp@17)) \n"
   "      (declare (temporary) float assignment_tmp@18)\n"
   "      (assign  (x) (var_ref assignment_tmp@18)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (2)))))) \n"
   "      (assign  (x) (var_ref SubFactor04)  (var_ref assignment_tmp@18)) \n"
   "      (declare (temporary) float assignment_tmp@19)\n"
   "      (assign  (x) (var_ref assignment_tmp@19)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (1)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (1)))))) \n"
   "      (assign  (x) (var_ref SubFactor05)  (var_ref assignment_tmp@19)) \n"
   "      (declare (temporary) float assignment_tmp@20)\n"
   "      (assign  (x) (var_ref assignment_tmp@20)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (3)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (2))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (3)))))) \n"
   "      (assign  (x) (var_ref SubFactor06)  (var_ref assignment_tmp@20)) \n"
   "      (declare (temporary) float assignment_tmp@21)\n"
   "      (assign  (x) (var_ref assignment_tmp@21)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (3)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (3)))))) \n"
   "      (assign  (x) (var_ref SubFactor07)  (var_ref assignment_tmp@21)) \n"
   "      (declare (temporary) float assignment_tmp@22)\n"
   "      (assign  (x) (var_ref assignment_tmp@22)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2)))))) \n"
   "      (assign  (x) (var_ref SubFactor08)  (var_ref assignment_tmp@22)) \n"
   "      (declare (temporary) float assignment_tmp@23)\n"
   "      (assign  (x) (var_ref assignment_tmp@23)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (3)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (3)))))) \n"
   "      (assign  (x) (var_ref SubFactor09)  (var_ref assignment_tmp@23)) \n"
   "      (declare (temporary) float assignment_tmp@24)\n"
   "      (assign  (x) (var_ref assignment_tmp@24)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2)))))) \n"
   "      (assign  (x) (var_ref SubFactor10)  (var_ref assignment_tmp@24)) \n"
   "      (declare (temporary) float assignment_tmp@25)\n"
   "      (assign  (x) (var_ref assignment_tmp@25)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (3)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (3)))))) \n"
   "      (assign  (x) (var_ref SubFactor11)  (var_ref assignment_tmp@25)) \n"
   "      (declare (temporary) float assignment_tmp@26)\n"
   "      (assign  (x) (var_ref assignment_tmp@26)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (1)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (3))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1)))))) \n"
   "      (assign  (x) (var_ref SubFactor12)  (var_ref assignment_tmp@26)) \n"
   "      (declare (temporary) float assignment_tmp@27)\n"
   "      (assign  (x) (var_ref assignment_tmp@27)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (3)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (2))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (3)))))) \n"
   "      (assign  (x) (var_ref SubFactor13)  (var_ref assignment_tmp@27)) \n"
   "      (declare (temporary) float assignment_tmp@28)\n"
   "      (assign  (x) (var_ref assignment_tmp@28)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (3)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (3)))))) \n"
   "      (assign  (x) (var_ref SubFactor14)  (var_ref assignment_tmp@28)) \n"
   "      (declare (temporary) float assignment_tmp@29)\n"
   "      (assign  (x) (var_ref assignment_tmp@29)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (1))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2)))))) \n"
   "      (assign  (x) (var_ref SubFactor15)  (var_ref assignment_tmp@29)) \n"
   "      (declare (temporary) float assignment_tmp@30)\n"
   "      (assign  (x) (var_ref assignment_tmp@30)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (3)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (3)))))) \n"
   "      (assign  (x) (var_ref SubFactor16)  (var_ref assignment_tmp@30)) \n"
   "      (declare (temporary) float assignment_tmp@31)\n"
   "      (assign  (x) (var_ref assignment_tmp@31)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (2)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2)))))) \n"
   "      (assign  (x) (var_ref SubFactor17)  (var_ref assignment_tmp@31)) \n"
   "      (declare (temporary) float assignment_tmp@32)\n"
   "      (assign  (x) (var_ref assignment_tmp@32)  (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (1)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (2))) (constant int (0))) (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1)))))) \n"
   "      (assign  (x) (var_ref SubFactor18)  (var_ref assignment_tmp@32)) \n"
   "      (declare (temporary) float assignment_tmp@33)\n"
   "      (assign  (x) (var_ref assignment_tmp@33)  (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1))) (var_ref SubFactor00)) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2))) (var_ref SubFactor01))) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (3))) (var_ref SubFactor02)))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (0))) (constant int (0)))  (var_ref assignment_tmp@33)) \n"
   "      (declare (temporary) float assignment_tmp@34)\n"
   "      (assign  (x) (var_ref assignment_tmp@34)  (expression float neg (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (var_ref SubFactor00)) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2))) (var_ref SubFactor03))) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (3))) (var_ref SubFactor04))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (1))) (constant int (0)))  (var_ref assignment_tmp@34)) \n"
   "      (declare (temporary) float assignment_tmp@35)\n"
   "      (assign  (x) (var_ref assignment_tmp@35)  (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (var_ref SubFactor01)) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1))) (var_ref SubFactor03))) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (3))) (var_ref SubFactor05)))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (2))) (constant int (0)))  (var_ref assignment_tmp@35)) \n"
   "      (declare (temporary) float assignment_tmp@36)\n"
   "      (assign  (x) (var_ref assignment_tmp@36)  (expression float neg (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (0))) (var_ref SubFactor02)) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (1))) (var_ref SubFactor04))) (expression float * (array_ref (array_ref (var_ref m) (constant int (1))) (constant int (2))) (var_ref SubFactor05))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (3))) (constant int (0)))  (var_ref assignment_tmp@36)) \n"
   "      (declare (temporary) float assignment_tmp@37)\n"
   "      (assign  (x) (var_ref assignment_tmp@37)  (expression float neg (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (var_ref SubFactor00)) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))) (var_ref SubFactor01))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (3))) (var_ref SubFactor02))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (0))) (constant int (1)))  (var_ref assignment_tmp@37)) \n"
   "      (declare (temporary) float assignment_tmp@38)\n"
   "      (assign  (x) (var_ref assignment_tmp@38)  (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (var_ref SubFactor00)) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))) (var_ref SubFactor03))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (3))) (var_ref SubFactor04)))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (1))) (constant int (1)))  (var_ref assignment_tmp@38)) \n"
   "      (declare (temporary) float assignment_tmp@39)\n"
   "      (assign  (x) (var_ref assignment_tmp@39)  (expression float neg (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (var_ref SubFactor01)) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (var_ref SubFactor03))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (3))) (var_ref SubFactor05))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (2))) (constant int (1)))  (var_ref assignment_tmp@39)) \n"
   "      (declare (temporary) float assignment_tmp@40)\n"
   "      (assign  (x) (var_ref assignment_tmp@40)  (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (var_ref SubFactor02)) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (var_ref SubFactor04))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))) (var_ref SubFactor05)))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (3))) (constant int (1)))  (var_ref assignment_tmp@40)) \n"
   "      (declare (temporary) float assignment_tmp@41)\n"
   "      (assign  (x) (var_ref assignment_tmp@41)  (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (var_ref SubFactor06)) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))) (var_ref SubFactor07))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (3))) (var_ref SubFactor08)))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (0))) (constant int (2)))  (var_ref assignment_tmp@41)) \n"
   "      (declare (temporary) float assignment_tmp@42)\n"
   "      (assign  (x) (var_ref assignment_tmp@42)  (expression float neg (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (var_ref SubFactor06)) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))) (var_ref SubFactor09))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (3))) (var_ref SubFactor10))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (1))) (constant int (2)))  (var_ref assignment_tmp@42)) \n"
   "      (declare (temporary) float assignment_tmp@43)\n"
   "      (assign  (x) (var_ref assignment_tmp@43)  (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (var_ref SubFactor11)) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (var_ref SubFactor09))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (3))) (var_ref SubFactor12)))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (2))) (constant int (2)))  (var_ref assignment_tmp@43)) \n"
   "      (declare (temporary) float assignment_tmp@44)\n"
   "      (assign  (x) (var_ref assignment_tmp@44)  (expression float neg (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (var_ref SubFactor08)) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (var_ref SubFactor10))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))) (var_ref SubFactor12))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (3))) (constant int (2)))  (var_ref assignment_tmp@44)) \n"
   "      (declare (temporary) float assignment_tmp@45)\n"
   "      (assign  (x) (var_ref assignment_tmp@45)  (expression float neg (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (var_ref SubFactor13)) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))) (var_ref SubFactor14))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (3))) (var_ref SubFactor15))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (0))) (constant int (3)))  (var_ref assignment_tmp@45)) \n"
   "      (declare (temporary) float assignment_tmp@46)\n"
   "      (assign  (x) (var_ref assignment_tmp@46)  (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (var_ref SubFactor13)) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))) (var_ref SubFactor16))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (3))) (var_ref SubFactor17)))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (1))) (constant int (3)))  (var_ref assignment_tmp@46)) \n"
   "      (declare (temporary) float assignment_tmp@47)\n"
   "      (assign  (x) (var_ref assignment_tmp@47)  (expression float neg (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (var_ref SubFactor14)) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (var_ref SubFactor16))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (3))) (var_ref SubFactor18))))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (2))) (constant int (3)))  (var_ref assignment_tmp@47)) \n"
   "      (declare (temporary) float assignment_tmp@48)\n"
   "      (assign  (x) (var_ref assignment_tmp@48)  (expression float + (expression float - (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (var_ref SubFactor15)) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (var_ref SubFactor17))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))) (var_ref SubFactor18)))) \n"
   "      (assign  (x) (array_ref (array_ref (var_ref adj) (constant int (3))) (constant int (3)))  (var_ref assignment_tmp@48)) \n"
   "      (declare (temporary) float assignment_tmp@49)\n"
   "      (assign  (x) (var_ref assignment_tmp@49)  (expression float + (expression float + (expression float + (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (0))) (array_ref (array_ref (var_ref adj) (constant int (0))) (constant int (0)))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (1))) (array_ref (array_ref (var_ref adj) (constant int (1))) (constant int (0))))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (2))) (array_ref (array_ref (var_ref adj) (constant int (2))) (constant int (0))))) (expression float * (array_ref (array_ref (var_ref m) (constant int (0))) (constant int (3))) (array_ref (array_ref (var_ref adj) (constant int (3))) (constant int (0)))))) \n"
   "      (assign  (x) (var_ref det)  (var_ref assignment_tmp@49)) \n"
   "      (return (expression mat4 / (var_ref adj) (var_ref det)))))))"
;
static const char builtin_inversesqrt[] =
   "((function inversesqrt\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float rsq (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 rsq (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 rsq (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 rsq (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_isinf[] =
   "((function isinf\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression bool == (expression float abs (var_ref x)) (constant float (+INF))))))\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression bvec2 == (expression vec2 abs (var_ref x)) (constant vec2 (+INF +INF))))))\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression bvec3 == (expression vec3 abs (var_ref x)) (constant vec3 (+INF +INF +INF))))))\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression bvec4 == (expression vec4 abs (var_ref x)) (constant vec4 (+INF +INF +INF +INF))))))))\n"
   ""
;
static const char builtin_isnan[] =
   "((function isnan\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression bool != (var_ref x) (var_ref x)))))\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression bvec2 != (var_ref x) (var_ref x)))))\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression bvec3 != (var_ref x) (var_ref x)))))\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression bvec4 != (var_ref x) (var_ref x)))))))\n"
   ""
;
static const char builtin_length[] =
   "((function length\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float abs (var_ref arg0)))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression float sqrt (expression float dot (var_ref arg0) (var_ref arg0))))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression float sqrt (expression float dot (var_ref arg0) (var_ref arg0))))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression float sqrt (expression float dot (var_ref arg0) (var_ref arg0))))))\n"
   "))\n"
   ""
;
static const char builtin_lessThan[] =
   "((function lessThan\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression bvec2 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression bvec3 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression bvec4 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression bvec2 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression bvec3 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression bvec4 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression bvec2 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression bvec3 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression bvec4 < (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char builtin_lessThanEqual[] =
   "((function lessThanEqual\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression bvec2 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression bvec3 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression bvec4 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression bvec2 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression bvec3 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression bvec4 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression bvec2 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression bvec3 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression bvec4 <= (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char builtin_log[] =
   "((function log\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float log (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 log (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 log (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 log (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_log2[] =
   "((function log2\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float log2 (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 log2 (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 log2 (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 log2 (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_matrixCompMult[] =
   "((function matrixCompMult\n"
   "   (signature mat2\n"
   "     (parameters\n"
   "       (declare (in) mat2 x)\n"
   "       (declare (in) mat2 y))\n"
   "     ((declare () mat2 z)\n"
   "      (assign (xy) (array_ref (var_ref z) (constant int (0)))  (expression vec2 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (xy) (array_ref (var_ref z) (constant int (1)))  (expression vec2 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat3\n"
   "     (parameters\n"
   "       (declare (in) mat3 x)\n"
   "       (declare (in) mat3 y))\n"
   "     ((declare () mat3 z)\n"
   "      (assign (xyz) (array_ref (var_ref z) (constant int (0)))  (expression vec3 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (xyz) (array_ref (var_ref z) (constant int (1)))  (expression vec3 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "      (assign (xyz) (array_ref (var_ref z) (constant int (2)))  (expression vec3 * (array_ref (var_ref x) (constant int (2))) (array_ref (var_ref y) (constant int (2)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat4\n"
   "     (parameters\n"
   "       (declare (in) mat4 x)\n"
   "       (declare (in) mat4 y))\n"
   "     ((declare () mat4 z)\n"
   "      (assign (xyzw) (array_ref (var_ref z) (constant int (0)))  (expression vec4 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (xyzw) (array_ref (var_ref z) (constant int (1)))  (expression vec4 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "      (assign (xyzw) (array_ref (var_ref z) (constant int (2)))  (expression vec4 * (array_ref (var_ref x) (constant int (2))) (array_ref (var_ref y) (constant int (2)))))\n"
   "      (assign (xyzw) (array_ref (var_ref z) (constant int (3)))  (expression vec4 * (array_ref (var_ref x) (constant int (3))) (array_ref (var_ref y) (constant int (3)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat2x3\n"
   "     (parameters\n"
   "       (declare (in) mat2x3 x)\n"
   "       (declare (in) mat2x3 y))\n"
   "     ((declare () mat2x3 z)\n"
   "      (assign (xyz) (array_ref (var_ref z) (constant int (0)))  (expression vec3 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (xyz) (array_ref (var_ref z) (constant int (1)))  (expression vec3 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat3x2\n"
   "     (parameters\n"
   "       (declare (in) mat3x2 x)\n"
   "       (declare (in) mat3x2 y))\n"
   "     ((declare () mat3x2 z)\n"
   "      (assign (xy) (array_ref (var_ref z) (constant int (0)))  (expression vec2 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (xy) (array_ref (var_ref z) (constant int (1)))  (expression vec2 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "      (assign (xy) (array_ref (var_ref z) (constant int (2)))  (expression vec2 * (array_ref (var_ref x) (constant int (2))) (array_ref (var_ref y) (constant int (2)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat2x4\n"
   "     (parameters\n"
   "       (declare (in) mat2x4 x)\n"
   "       (declare (in) mat2x4 y))\n"
   "     ((declare () mat2x4 z)\n"
   "      (assign (xyzw) (array_ref (var_ref z) (constant int (0)))  (expression vec4 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (xyzw) (array_ref (var_ref z) (constant int (1)))  (expression vec4 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat4x2\n"
   "     (parameters\n"
   "       (declare (in) mat4x2 x)\n"
   "       (declare (in) mat4x2 y))\n"
   "     ((declare () mat4x2 z)\n"
   "      (assign (xy) (array_ref (var_ref z) (constant int (0)))  (expression vec2 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (xy) (array_ref (var_ref z) (constant int (1)))  (expression vec2 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "      (assign (xy) (array_ref (var_ref z) (constant int (2)))  (expression vec2 * (array_ref (var_ref x) (constant int (2))) (array_ref (var_ref y) (constant int (2)))))\n"
   "      (assign (xy) (array_ref (var_ref z) (constant int (3)))  (expression vec2 * (array_ref (var_ref x) (constant int (3))) (array_ref (var_ref y) (constant int (3)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat3x4\n"
   "     (parameters\n"
   "       (declare (in) mat3x4 x)\n"
   "       (declare (in) mat3x4 y))\n"
   "     ((declare () mat3x4 z)\n"
   "      (assign (xyzw) (array_ref (var_ref z) (constant int (0)))  (expression vec4 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (xyzw) (array_ref (var_ref z) (constant int (1)))  (expression vec4 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "      (assign (xyzw) (array_ref (var_ref z) (constant int (2)))  (expression vec4 * (array_ref (var_ref x) (constant int (2))) (array_ref (var_ref y) (constant int (2)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat4x3\n"
   "     (parameters\n"
   "       (declare (in) mat4x3 x)\n"
   "       (declare (in) mat4x3 y))\n"
   "     ((declare () mat4x3 z)\n"
   "      (assign (xyz) (array_ref (var_ref z) (constant int (0)))  (expression vec3 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (xyz) (array_ref (var_ref z) (constant int (1)))  (expression vec3 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "      (assign (xyz) (array_ref (var_ref z) (constant int (2)))  (expression vec3 * (array_ref (var_ref x) (constant int (2))) (array_ref (var_ref y) (constant int (2)))))\n"
   "      (assign (xyz) (array_ref (var_ref z) (constant int (3)))  (expression vec3 * (array_ref (var_ref x) (constant int (3))) (array_ref (var_ref y) (constant int (3)))))\n"
   "(return (var_ref z))))\n"
   "))\n"
   ""
;
static const char builtin_max[] =
   "((function max\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression float max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression vec2 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression vec3 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression vec4 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec2 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec3 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec4 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) int arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression int max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression ivec2 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression ivec3 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression ivec4 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2  arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression ivec2 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3  arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression ivec3 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4  arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression ivec4 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uint\n"
   "     (parameters\n"
   "       (declare (in) uint arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uint max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression uvec2 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression uvec3 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression uvec4 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2  arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uvec2 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3  arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uvec3 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4  arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uvec4 max (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char builtin_min[] =
   "((function min\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression float min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression vec2 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression vec3 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression vec4 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec2 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec3 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec4 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) int arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression int min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression ivec2 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression ivec3 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression ivec4 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2  arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression ivec2 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3  arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression ivec3 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4  arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression ivec4 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uint\n"
   "     (parameters\n"
   "       (declare (in) uint arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uint min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression uvec2 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression uvec3 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression uvec4 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2  arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uvec2 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3  arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uvec3 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4  arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uvec4 min (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char builtin_mix[] =
   "((function mix\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression float + (expression float * (var_ref arg0) (expression float - (constant float (1.000000)) (var_ref arg2))) (expression float * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1)\n"
   "       (declare (in) vec2 arg2))\n"
   "     ((return (expression vec2 + (expression vec2 * (var_ref arg0) (expression vec2 - (constant float (1.000000)) (var_ref arg2))) (expression vec2 * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1)\n"
   "       (declare (in) vec3 arg2))\n"
   "     ((return (expression vec3 + (expression vec3 * (var_ref arg0) (expression vec3 - (constant float (1.000000)) (var_ref arg2))) (expression vec3 * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1)\n"
   "       (declare (in) vec4 arg2))\n"
   "     ((return (expression vec4 + (expression vec4 * (var_ref arg0) (expression vec4 - (constant float (1.000000)) (var_ref arg2))) (expression vec4 * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression vec2 + (expression vec2 * (var_ref arg0) (expression float - (constant float (1.000000)) (var_ref arg2))) (expression vec2 * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression vec3 + (expression vec3 * (var_ref arg0) (expression float - (constant float (1.000000)) (var_ref arg2))) (expression vec3 * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression vec4 + (expression vec4 * (var_ref arg0) (expression float - (constant float (1.000000)) (var_ref arg2))) (expression vec4 * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float v1)\n"
   "       (declare (in) float v2)\n"
   "       (declare (in) bool  a))\n"
   "     ((assign (var_ref a) (x) (var_ref v1) (var_ref v2))\n"
   "      (return (var_ref v1))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 v1)\n"
   "       (declare (in) vec2 v2)\n"
   "       (declare (in) bvec2 a))\n"
   "     ((assign (swiz x (var_ref a)) (x) (var_ref v1) (swiz x (var_ref v2)))\n"
   "      (assign (swiz y (var_ref a)) (y) (var_ref v1) (swiz y (var_ref v2)))\n"
   "      (return (var_ref v1))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 v1)\n"
   "       (declare (in) vec3 v2)\n"
   "       (declare (in) bvec3 a))\n"
   "     ((assign (swiz x (var_ref a)) (x) (var_ref v1) (swiz x (var_ref v2)))\n"
   "      (assign (swiz y (var_ref a)) (y) (var_ref v1) (swiz y (var_ref v2)))\n"
   "      (assign (swiz z (var_ref a)) (z) (var_ref v1) (swiz z (var_ref v2)))\n"
   "      (return (var_ref v1))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 v1)\n"
   "       (declare (in) vec4 v2)\n"
   "       (declare (in) bvec4 a))\n"
   "     ((assign (swiz x (var_ref a)) (x) (var_ref v1) (swiz x (var_ref v2)))\n"
   "      (assign (swiz y (var_ref a)) (y) (var_ref v1) (swiz y (var_ref v2)))\n"
   "      (assign (swiz z (var_ref a)) (z) (var_ref v1) (swiz z (var_ref v2)))\n"
   "      (assign (swiz w (var_ref a)) (w) (var_ref v1) (swiz w (var_ref v2)))\n"
   "      (return (var_ref v1))))\n"
   "))\n"
   ""
;
static const char builtin_mod[] =
   "((function mod\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression float % (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression vec2 % (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression vec3 % (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression vec4 % (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec2 % (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec3 % (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec4 % (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char builtin_modf[] =
   "((function modf\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in)  float x)\n"
   "       (declare (out) float i))\n"
   "     ((declare () float t)\n"
   "      (assign (x) (var_ref t) (expression float trunc (var_ref x)))\n"
   "      (assign (x) (var_ref i) (var_ref t))\n"
   "      (return (expression float - (var_ref x) (var_ref t)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in)  vec2 x)\n"
   "       (declare (out) vec2 i))\n"
   "     ((declare () vec2 t)\n"
   "      (assign (xy) (var_ref t) (expression vec2 trunc (var_ref x)))\n"
   "      (assign (xy) (var_ref i) (var_ref t))\n"
   "      (return (expression vec2 - (var_ref x) (var_ref t)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in)  vec3 x)\n"
   "       (declare (out) vec3 i))\n"
   "     ((declare () vec3 t)\n"
   "      (assign (xyz) (var_ref t) (expression vec3 trunc (var_ref x)))\n"
   "      (assign (xyz) (var_ref i) (var_ref t))\n"
   "      (return (expression vec3 - (var_ref x) (var_ref t)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in)  vec4 x)\n"
   "       (declare (out) vec4 i))\n"
   "     ((declare () vec4 t)\n"
   "      (assign (xyzw) (var_ref t) (expression vec4 trunc (var_ref x)))\n"
   "      (assign (xyzw) (var_ref i) (var_ref t))\n"
   "      (return (expression vec4 - (var_ref x) (var_ref t)))))\n"
   "))\n"
   ""
;
static const char builtin_noise1[] =
   "((function noise1\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float noise (var_ref x)))))\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression float noise (var_ref x)))))\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression float noise (var_ref x)))))\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression float noise (var_ref x)))))\n"
   "))\n"
   ""
;
static const char builtin_noise2[] =
   "((function noise2\n"
   "  (signature vec2\n"
   "    (parameters (declare (in) vec4 p))\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () vec2 t)\n"
   "\n"
   "      (assign (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (x) (var_ref b) (expression float noise (expression vec4 + (var_ref p) (constant vec4 (601.0 313.0 29.0 277.0)))))\n"
   "      (assign (x) (var_ref t) (var_ref a))\n"
   "      (assign (y) (var_ref t) (var_ref b))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "\n"
   "  (signature vec2\n"
   "    (parameters (declare (in) vec3 p))\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () vec2 t)\n"
   "\n"
   "      (assign (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (x) (var_ref b) (expression float noise (expression vec3 + (var_ref p) (constant vec3 (601.0 313.0 29.0)))))\n"
   "      (assign (x) (var_ref t) (var_ref a))\n"
   "      (assign (y) (var_ref t) (var_ref b))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in ) vec2 p)\n"
   "    )\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () vec2 t)\n"
   "\n"
   "      (assign (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (x) (var_ref b) (expression float noise (expression vec2 + (var_ref p) (constant vec2 (601.0 313.0)))))\n"
   "      (assign (x) (var_ref t) (var_ref a))\n"
   "      (assign (y) (var_ref t) (var_ref b))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in ) float p)\n"
   "    )\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () vec2 t)\n"
   "\n"
   "      (assign (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (x) (var_ref b) (expression float noise (expression float + (var_ref p) (constant float (601.0)))))\n"
   "      (assign (x) (var_ref t) (var_ref a))\n"
   "      (assign (y) (var_ref t) (var_ref b))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "))\n"
   ""
;
static const char builtin_noise3[] =
   "((function noise3\n"
   "  (signature vec3\n"
   "    (parameters (declare (in) vec4 p))\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () float c)\n"
   "      (declare () vec3 t)\n"
   "\n"
   "      (assign (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (x) (var_ref b) (expression float noise (expression vec4 + (var_ref p) (constant vec4 (601.0 313.0 29.0 277.0)))))\n"
   "      (assign (x) (var_ref c) (expression float noise (expression vec4 + (var_ref p) (constant vec4 (1559.0 113.0 1861.0 797.0)))))\n"
   "\n"
   "      (assign (x) (var_ref t) (var_ref a))\n"
   "      (assign (y) (var_ref t) (var_ref b))\n"
   "      (assign (z) (var_ref t) (var_ref c))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "\n"
   "  (signature vec3\n"
   "    (parameters (declare (in) vec3 p))\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () float c)\n"
   "      (declare () vec3 t)\n"
   "\n"
   "      (assign (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (x) (var_ref b) (expression float noise (expression vec3 + (var_ref p) (constant vec3 (601.0 313.0 29.0)))))\n"
   "      (assign (x) (var_ref c) (expression float noise (expression vec3 + (var_ref p) (constant vec3 (1559.0 113.0 1861.0)))))\n"
   "\n"
   "      (assign (x) (var_ref t) (var_ref a))\n"
   "      (assign (y) (var_ref t) (var_ref b))\n"
   "      (assign (z) (var_ref t) (var_ref c))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "\n"
   "  (signature vec3\n"
   "    (parameters (declare (in) vec2 p))\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () float c)\n"
   "      (declare () vec3 t)\n"
   "\n"
   "      (assign (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (x) (var_ref b) (expression float noise (expression vec2 + (var_ref p) (constant vec2 (601.0 313.0)))))\n"
   "      (assign (x) (var_ref c) (expression float noise (expression vec2 + (var_ref p) (constant vec2 (1559.0 113.0)))))\n"
   "\n"
   "      (assign (x) (var_ref t) (var_ref a))\n"
   "      (assign (y) (var_ref t) (var_ref b))\n"
   "      (assign (z) (var_ref t) (var_ref c))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "\n"
   "  (signature vec3\n"
   "    (parameters (declare (in) float p))\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () float c)\n"
   "      (declare () vec3 t)\n"
   "\n"
   "      (assign (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (x) (var_ref b) (expression float noise (expression float + (var_ref p) (constant float (601.0)))))\n"
   "      (assign (x) (var_ref c) (expression float noise (expression float + (var_ref p) (constant float (1559.0)))))\n"
   "\n"
   "      (assign (x) (var_ref t) (var_ref a))\n"
   "      (assign (y) (var_ref t) (var_ref b))\n"
   "      (assign (z) (var_ref t) (var_ref c))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "))\n"
   ""
;
static const char builtin_noise4[] =
   "((function noise4\n"
   "  (signature vec4\n"
   "    (parameters (declare (in) vec4 p))\n"
   "    (\n"
   "      (declare () float _x)\n"
   "      (declare () float _y)\n"
   "      (declare () float _z)\n"
   "      (declare () float _w)\n"
   "      (declare () vec4 _r)\n"
   "\n"
   "      (declare () vec4 _p)\n"
   "      (assign (xyzw) (var_ref _p) (expression vec4 + (var_ref p) (constant vec4 (1559.0 113.0 1861.0 797.0))) )\n"
   "\n"
   "      (assign (x) (var_ref _x) (expression float noise(var_ref p)))\n"
   "      (assign (x) (var_ref _y) (expression float noise(expression vec4 + (var_ref p) (constant vec4 (601.0 313.0 29.0 277.0)))))\n"
   "      (assign (x) (var_ref _z) (expression float noise(var_ref _p)))\n"
   "      (assign (x) (var_ref _w) (expression float noise(expression vec4 + (var_ref _p) (constant vec4 (601.0 313.0 29.0 277.0)))))\n"
   "\n"
   "      (assign (x) (var_ref _r) (var_ref _x))\n"
   "      (assign (y) (var_ref _r) (var_ref _y))\n"
   "      (assign (z) (var_ref _r) (var_ref _z))\n"
   "      (assign (w) (var_ref _r) (var_ref _w))\n"
   "      (return (var_ref _r))\n"
   "    ))\n"
   "\n"
   "  (signature vec4\n"
   "    (parameters (declare (in) vec3 p))\n"
   "    (\n"
   "      (declare () float _x)\n"
   "      (declare () float _y)\n"
   "      (declare () float _z)\n"
   "      (declare () float _w)\n"
   "      (declare () vec4 _r)\n"
   "\n"
   "      (declare () vec3 _p)\n"
   "      (assign (xyz) (var_ref _p) (expression vec3 + (var_ref p) (constant vec3 (1559.0 113.0 1861.0))) )\n"
   "\n"
   "      (assign (x) (var_ref _x) (expression float noise(var_ref p)))\n"
   "      (assign (x) (var_ref _y) (expression float noise(expression vec3 + (var_ref p) (constant vec3 (601.0 313.0 29.0)))))\n"
   "      (assign (x) (var_ref _z) (expression float noise(var_ref _p)))\n"
   "      (assign (x) (var_ref _w) (expression float noise(expression vec3 + (var_ref _p) (constant vec3 (601.0 313.0 29.0)))))\n"
   "\n"
   "      (assign (x) (var_ref _r) (var_ref _x))\n"
   "      (assign (y) (var_ref _r) (var_ref _y))\n"
   "      (assign (z) (var_ref _r) (var_ref _z))\n"
   "      (assign (w) (var_ref _r) (var_ref _w))\n"
   "      (return (var_ref _r))\n"
   "    ))\n"
   "\n"
   "  (signature vec4\n"
   "    (parameters (declare (in) vec2 p))\n"
   "    (\n"
   "      (declare () float _x)\n"
   "      (declare () float _y)\n"
   "      (declare () float _z)\n"
   "      (declare () float _w)\n"
   "      (declare () vec4 _r)\n"
   "\n"
   "      (declare () vec2 _p)\n"
   "      (assign (xy) (var_ref _p) (expression vec2 + (var_ref p) (constant vec2 (1559.0 113.0))) )\n"
   "\n"
   "      (assign (x) (var_ref _x) (expression float noise(var_ref p)))\n"
   "      (assign (x) (var_ref _y) (expression float noise(expression vec2 + (var_ref p) (constant vec2 (601.0 313.0)))))\n"
   "      (assign (x) (var_ref _z) (expression float noise(var_ref _p)))\n"
   "      (assign (x) (var_ref _w) (expression float noise(expression vec2 + (var_ref _p) (constant vec2 (601.0 313.0)))))\n"
   "\n"
   "      (assign (x) (var_ref _r) (var_ref _x))\n"
   "      (assign (y) (var_ref _r) (var_ref _y))\n"
   "      (assign (z) (var_ref _r) (var_ref _z))\n"
   "      (assign (w) (var_ref _r) (var_ref _w))\n"
   "      (return (var_ref _r))\n"
   "    ))\n"
   "\n"
   "  (signature vec4\n"
   "    (parameters (declare (in) float p))\n"
   "    (\n"
   "      (declare () float _x)\n"
   "      (declare () float _y)\n"
   "      (declare () float _z)\n"
   "      (declare () float _w)\n"
   "      (declare () vec4 _r)\n"
   "\n"
   "      (declare () float _p)\n"
   "      (assign (x) (var_ref _p) (expression float + (var_ref p) (constant float (1559.0))) )\n"
   "\n"
   "      (assign (x) (var_ref _x) (expression float noise(var_ref p)))\n"
   "      (assign (x) (var_ref _y) (expression float noise(expression float + (var_ref p) (constant float (601.0)))))\n"
   "      (assign (x) (var_ref _z) (expression float noise(var_ref _p)))\n"
   "      (assign (x) (var_ref _w) (expression float noise(expression float + (var_ref _p) (constant float (601.0)))))\n"
   "\n"
   "      (assign (x) (var_ref _r) (var_ref _x))\n"
   "      (assign (y) (var_ref _r) (var_ref _y))\n"
   "      (assign (z) (var_ref _r) (var_ref _z))\n"
   "      (assign (w) (var_ref _r) (var_ref _w))\n"
   "      (return (var_ref _r))\n"
   "    ))\n"
   "))\n"
   ""
;
static const char builtin_normalize[] =
   "((function normalize\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float sign (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 * (var_ref arg0) (expression float rsq (expression float dot (var_ref arg0) (var_ref arg0)))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 * (var_ref arg0) (expression float rsq (expression float dot (var_ref arg0) (var_ref arg0)))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 * (var_ref arg0) (expression float rsq (expression float dot (var_ref arg0) (var_ref arg0)))))))\n"
   "))\n"
   ""
;
static const char builtin_not[] =
   "((function not\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) bvec2 arg0))\n"
   "     ((return (expression bvec2 ! (var_ref arg0)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) bvec3 arg0))\n"
   "     ((return (expression bvec3 ! (var_ref arg0)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) bvec4 arg0))\n"
   "     ((return (expression bvec4 ! (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_notEqual[] =
   "((function notEqual\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression bvec2 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression bvec3 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression bvec4 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) bvec2 arg0)\n"
   "       (declare (in) bvec2 arg1))\n"
   "     ((return (expression bvec2 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) bvec3 arg0)\n"
   "       (declare (in) bvec3 arg1))\n"
   "     ((return (expression bvec3 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) bvec4 arg0)\n"
   "       (declare (in) bvec4 arg1))\n"
   "     ((return (expression bvec4 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression bvec2 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression bvec3 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression bvec4 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression bvec2 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression bvec3 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression bvec4 != (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char builtin_outerProduct[] =
   "((function outerProduct\n"
   "   (signature mat2\n"
   "     (parameters\n"
   "       (declare (in) vec2 u)\n"
   "       (declare (in) vec2 v))\n"
   "     ((declare () mat2 m)\n"
   "      (assign (xy) (array_ref (var_ref m) (constant int (0))) (expression vec2 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (xy) (array_ref (var_ref m) (constant int (1))) (expression vec2 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat2x3\n"
   "     (parameters\n"
   "       (declare (in) vec3 u)\n"
   "       (declare (in) vec2 v))\n"
   "     ((declare () mat2x3 m)\n"
   "      (assign (xyz) (array_ref (var_ref m) (constant int (0))) (expression vec3 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (xyz) (array_ref (var_ref m) (constant int (1))) (expression vec3 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat2x4\n"
   "     (parameters\n"
   "       (declare (in) vec4 u)\n"
   "       (declare (in) vec2 v))\n"
   "     ((declare () mat2x4 m)\n"
   "      (assign (xyzw) (array_ref (var_ref m) (constant int (0))) (expression vec4 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (xyzw) (array_ref (var_ref m) (constant int (1))) (expression vec4 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat3x2\n"
   "     (parameters\n"
   "       (declare (in) vec2 u)\n"
   "       (declare (in) vec3 v))\n"
   "     ((declare () mat3x2 m)\n"
   "      (assign (xy) (array_ref (var_ref m) (constant int (0))) (expression vec2 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (xy) (array_ref (var_ref m) (constant int (1))) (expression vec2 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (assign (xy) (array_ref (var_ref m) (constant int (2))) (expression vec2 * (var_ref u) (swiz z (var_ref v))))\n"
   "      (return (var_ref m))\n"
   " ))\n"
   "\n"
   "   (signature mat3\n"
   "     (parameters\n"
   "       (declare (in) vec3 u)\n"
   "       (declare (in) vec3 v))\n"
   "     ((declare () mat3 m)\n"
   "      (assign (xyz) (array_ref (var_ref m) (constant int (0))) (expression vec3 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (xyz) (array_ref (var_ref m) (constant int (1))) (expression vec3 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (assign (xyz) (array_ref (var_ref m) (constant int (2))) (expression vec3 * (var_ref u) (swiz z (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat3x4\n"
   "     (parameters\n"
   "       (declare (in) vec4 u)\n"
   "       (declare (in) vec3 v))\n"
   "     ((declare () mat3x4 m)\n"
   "      (assign (xyzw) (array_ref (var_ref m) (constant int (0))) (expression vec4 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (xyzw) (array_ref (var_ref m) (constant int (1))) (expression vec4 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (assign (xyzw) (array_ref (var_ref m) (constant int (2))) (expression vec4 * (var_ref u) (swiz z (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat4x2\n"
   "     (parameters\n"
   "       (declare (in) vec2 u)\n"
   "       (declare (in) vec4 v))\n"
   "     ((declare () mat4x2 m)\n"
   "      (assign (xy) (array_ref (var_ref m) (constant int (0))) (expression vec2 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (xy) (array_ref (var_ref m) (constant int (1))) (expression vec2 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (assign (xy) (array_ref (var_ref m) (constant int (2))) (expression vec2 * (var_ref u) (swiz z (var_ref v))))\n"
   "      (assign (xy) (array_ref (var_ref m) (constant int (3))) (expression vec2 * (var_ref u) (swiz w (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat4x3\n"
   "     (parameters\n"
   "       (declare (in) vec3 u)\n"
   "       (declare (in) vec4 v))\n"
   "     ((declare () mat4x3 m)\n"
   "      (assign (xyz) (array_ref (var_ref m) (constant int (0))) (expression vec3 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (xyz) (array_ref (var_ref m) (constant int (1))) (expression vec3 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (assign (xyz) (array_ref (var_ref m) (constant int (2))) (expression vec3 * (var_ref u) (swiz z (var_ref v))))\n"
   "      (assign (xyz) (array_ref (var_ref m) (constant int (3))) (expression vec3 * (var_ref u) (swiz w (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat4\n"
   "     (parameters\n"
   "       (declare (in) vec4 u)\n"
   "       (declare (in) vec4 v))\n"
   "     ((declare () mat4 m)\n"
   "      (assign (xyzw) (array_ref (var_ref m) (constant int (0))) (expression vec4 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (xyzw) (array_ref (var_ref m) (constant int (1))) (expression vec4 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (assign (xyzw) (array_ref (var_ref m) (constant int (2))) (expression vec4 * (var_ref u) (swiz z (var_ref v))))\n"
   "      (assign (xyzw) (array_ref (var_ref m) (constant int (3))) (expression vec4 * (var_ref u) (swiz w (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "))\n"
   ""
;
static const char builtin_pow[] =
   "((function pow\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression float pow (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression vec2 pow (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression vec3 pow (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression vec4 pow (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char builtin_radians[] =
   "((function radians\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float * (var_ref arg0) (constant float (0.0174532925))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 * (var_ref arg0) (constant float (0.0174532925))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 * (var_ref arg0) (constant float (0.0174532925))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 * (var_ref arg0) (constant float (0.0174532925))))))\n"
   "))\n"
   ""
;
static const char builtin_reflect[] =
   "((function reflect\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float i)\n"
   "       (declare (in) float n))\n"
   "     ((return (expression float -\n"
   "	       (var_ref i)\n"
   "	       (expression float *\n"
   "		(constant float (2.0))\n"
   "		(expression float *\n"
   "		 (expression float *\n"
   "		  (var_ref n)\n"
   "		  (var_ref i))\n"
   "		 (var_ref n)))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 i)\n"
   "       (declare (in) vec2 n))\n"
   "     ((return (expression vec2 -\n"
   "	       (var_ref i)\n"
   "	       (expression vec2 *\n"
   "		(constant float (2.0))\n"
   "		(expression vec2 *\n"
   "		 (expression float dot\n"
   "		  (var_ref n)\n"
   "		  (var_ref i))\n"
   "		 (var_ref n)))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 i)\n"
   "       (declare (in) vec3 n))\n"
   "     ((return (expression vec3 -\n"
   "	       (var_ref i)\n"
   "	       (expression vec3 *\n"
   "		(constant float (2.0))\n"
   "		(expression vec3 *\n"
   "		 (expression float dot\n"
   "		  (var_ref n)\n"
   "		  (var_ref i))\n"
   "		 (var_ref n)))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 i)\n"
   "       (declare (in) vec4 n))\n"
   "     ((return (expression vec4 -\n"
   "	       (var_ref i)\n"
   "	       (expression vec4 *\n"
   "		(constant float (2.0))\n"
   "		(expression vec4 *\n"
   "		 (expression float dot\n"
   "		  (var_ref n)\n"
   "		  (var_ref i))\n"
   "		 (var_ref n)))))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_refract[] =
   "((function refract\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float i)\n"
   "       (declare (in) float n)\n"
   "       (declare (in) float eta))\n"
   "     ((declare () float k)\n"
   "      (assign (x) (var_ref k)\n"
   "              (expression float - (constant float (1.0))\n"
   "	        (expression float * (var_ref eta)\n"
   "	          (expression float * (var_ref eta)\n"
   "		    (expression float - (constant float (1.0))\n"
   "		      (expression float * \n"
   "		        (expression float * (var_ref n) (var_ref i))\n"
   "		        (expression float * (var_ref n) (var_ref i))))))))\n"
   "      (if (expression bool < (var_ref k) (constant float (0.0)))\n"
   "          ((return (constant float (0.0))))\n"
   "	  ((return (expression float -\n"
   "	             (expression float * (var_ref eta) (var_ref i))\n"
   "		     (expression float *\n"
   "		       (expression float +\n"
   "		         (expression float * (var_ref eta)\n"
   "			   (expression float * (var_ref n) (var_ref i)))\n"
   "		         (expression float sqrt (var_ref k)))\n"
   "		       (var_ref n))))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 i)\n"
   "       (declare (in) vec2 n)\n"
   "       (declare (in) float eta))\n"
   "     ((declare () float k)\n"
   "      (assign (x) (var_ref k)\n"
   "              (expression float - (constant float (1.0))\n"
   "	        (expression float * (var_ref eta)\n"
   "	          (expression float * (var_ref eta)\n"
   "		    (expression float - (constant float (1.0))\n"
   "		      (expression float * \n"
   "		        (expression float dot (var_ref n) (var_ref i))\n"
   "		        (expression float dot (var_ref n) (var_ref i))))))))\n"
   "      (if (expression bool < (var_ref k) (constant float (0.0)))\n"
   "          ((return (constant vec2 (0.0 0.0))))\n"
   "	  ((return (expression vec2 -\n"
   "	             (expression vec2 * (var_ref eta) (var_ref i))\n"
   "		     (expression vec2 *\n"
   "		       (expression float +\n"
   "		         (expression float * (var_ref eta)\n"
   "			   (expression float dot (var_ref n) (var_ref i)))\n"
   "		         (expression float sqrt (var_ref k)))\n"
   "		       (var_ref n))))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 i)\n"
   "       (declare (in) vec3 n)\n"
   "       (declare (in) float eta))\n"
   "     ((declare () float k)\n"
   "      (assign (x) (var_ref k)\n"
   "              (expression float - (constant float (1.0))\n"
   "	        (expression float * (var_ref eta)\n"
   "	          (expression float * (var_ref eta)\n"
   "		    (expression float - (constant float (1.0))\n"
   "		      (expression float * \n"
   "		        (expression float dot (var_ref n) (var_ref i))\n"
   "		        (expression float dot (var_ref n) (var_ref i))))))))\n"
   "      (if (expression bool < (var_ref k) (constant float (0.0)))\n"
   "          ((return (constant vec3 (0.0 0.0 0.0))))\n"
   "	  ((return (expression vec3 -\n"
   "	             (expression vec3 * (var_ref eta) (var_ref i))\n"
   "		     (expression vec3 *\n"
   "		       (expression float +\n"
   "		         (expression float * (var_ref eta)\n"
   "			   (expression float dot (var_ref n) (var_ref i)))\n"
   "		         (expression float sqrt (var_ref k)))\n"
   "		       (var_ref n))))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 i)\n"
   "       (declare (in) vec4 n)\n"
   "       (declare (in) float eta))\n"
   "     ((declare () float k)\n"
   "      (assign (x) (var_ref k)\n"
   "              (expression float - (constant float (1.0))\n"
   "	        (expression float * (var_ref eta)\n"
   "	          (expression float * (var_ref eta)\n"
   "		    (expression float - (constant float (1.0))\n"
   "		      (expression float * \n"
   "		        (expression float dot (var_ref n) (var_ref i))\n"
   "		        (expression float dot (var_ref n) (var_ref i))))))))\n"
   "      (if (expression bool < (var_ref k) (constant float (0.0)))\n"
   "          ((return (constant vec4 (0.0 0.0 0.0 0.0))))\n"
   "	  ((return (expression vec4 -\n"
   "	             (expression vec4 * (var_ref eta) (var_ref i))\n"
   "		     (expression vec4 *\n"
   "		       (expression float +\n"
   "		         (expression float * (var_ref eta)\n"
   "			   (expression float dot (var_ref n) (var_ref i)))\n"
   "		         (expression float sqrt (var_ref k)))\n"
   "		       (var_ref n))))))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_round[] =
   "((function round\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float round_even (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 round_even (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 round_even (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 round_even (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_roundEven[] =
   "((function roundEven\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float round_even (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 round_even (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 round_even (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 round_even (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_shadow1D[] =
   "((function shadow1D\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz x (var_ref P)) 0 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz x (var_ref P)) 0 1 (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow1DArray[] =
   "((function shadow1DArray\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow1DArrayLod[] =
   "((function shadow1DArrayLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow1DGradARB[] =
   "((function shadow1DGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz x (var_ref P)) 0 1 (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow1DLod[] =
   "((function shadow1DLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz x (var_ref P)) 0 1 (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow1DProj[] =
   "((function shadow1DProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow1DProjGradARB[] =
   "((function shadow1DProjGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow1DProjLod[] =
   "((function shadow1DProjLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow2D[] =
   "((function shadow2D\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow2DArray[] =
   "((function shadow2DArray\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArrayShadow sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 1 (swiz w (var_ref P)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow2DGradARB[] =
   "((function shadow2DGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow2DLod[] =
   "((function shadow2DLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow2DProj[] =
   "((function shadow2DProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow2DProjGradARB[] =
   "((function shadow2DProjGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow2DProjLod[] =
   "((function shadow2DProjLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow2DRect[] =
   "((function shadow2DRect\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow2DRectGradARB[] =
   "((function shadow2DRectGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow2DRectProj[] =
   "((function shadow2DRectProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_shadow2DRectProjGradARB[] =
   "((function shadow2DRectProjGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_sign[] =
   "((function sign\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float sign (var_ref x)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 sign (var_ref x)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 sign (var_ref x)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 sign (var_ref x)))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) int x))\n"
   "     ((return (expression int sign (var_ref x)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 x))\n"
   "     ((return (expression ivec2 sign (var_ref x)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 x))\n"
   "     ((return (expression ivec3 sign (var_ref x)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 x))\n"
   "     ((return (expression ivec4 sign (var_ref x)))))\n"
   "))\n"
   "\n"
   ""
;
static const char builtin_sin[] =
   "((function sin\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float angle))\n"
   "     ((return (expression float sin (var_ref angle)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 angle))\n"
   "     ((return (expression vec2 sin (var_ref angle)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 angle))\n"
   "     ((return (expression vec3 sin (var_ref angle)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 angle))\n"
   "     ((return (expression vec4 sin (var_ref angle)))))\n"
   "))\n"
   ""
;
static const char builtin_sinh[] =
   "((function sinh\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float * (constant float (0.5))\n"
   "                (expression float -\n"
   "		  (expression float exp (var_ref x))\n"
   "		  (expression float exp (expression float neg (var_ref x))))))))\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 * (constant float (0.5))\n"
   "                (expression vec2 -\n"
   "		  (expression vec2 exp (var_ref x))\n"
   "		  (expression vec2 exp (expression vec2 neg (var_ref x))))))))\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 * (constant float (0.5))\n"
   "                (expression vec3 -\n"
   "		  (expression vec3 exp (var_ref x))\n"
   "		  (expression vec3 exp (expression vec3 neg (var_ref x))))))))\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 * (constant float (0.5))\n"
   "                (expression vec4 -\n"
   "		  (expression vec4 exp (var_ref x))\n"
   "		  (expression vec4 exp (expression vec4 neg (var_ref x))))))))\n"
   "))\n"
   ""
;
static const char builtin_smoothstep[] =
   "((function smoothstep\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float edge0)\n"
   "       (declare (in) float edge1)\n"
   "       (declare (in) float x))\n"
   "     ((declare () float t)\n"
   "      (assign (x) (var_ref t)\n"
   "              (expression float max\n"
   "	                  (expression float min\n"
   "	                              (expression float / (expression float - (var_ref x) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (return (expression float * (var_ref t) (expression float * (var_ref t) (expression float - (constant float (3.0)) (expression float * (constant float (2.0)) (var_ref t))))))))\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) float edge0)\n"
   "       (declare (in) float edge1)\n"
   "       (declare (in) vec2 x))\n"
   "     ((declare () vec2 t)\n"
   "      (assign (xy) (var_ref t)\n"
   "              (expression vec2 max\n"
   "	                  (expression vec2 min\n"
   "	                              (expression vec2 / (expression vec2 - (var_ref x) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (return (expression vec2 * (var_ref t) (expression vec2 * (var_ref t) (expression vec2 - (constant float (3.0)) (expression vec2 * (constant float (2.0)) (var_ref t))))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) float edge0)\n"
   "       (declare (in) float edge1)\n"
   "       (declare (in) vec3 x))\n"
   "     ((declare () vec3 t)\n"
   "      (assign (xyz) (var_ref t)\n"
   "              (expression vec3 max\n"
   "	                  (expression vec3 min\n"
   "	                              (expression vec3 / (expression vec3 - (var_ref x) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (return (expression vec3 * (var_ref t) (expression vec3 * (var_ref t) (expression vec3 - (constant float (3.0)) (expression vec3 * (constant float (2.0)) (var_ref t))))))))\n"
   "\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) float edge0)\n"
   "       (declare (in) float edge1)\n"
   "       (declare (in) vec4 x))\n"
   "     ((declare () vec4 t)\n"
   "      (assign (xyzw) (var_ref t)\n"
   "              (expression vec4 max\n"
   "	                  (expression vec4 min\n"
   "	                              (expression vec4 / (expression vec4 - (var_ref x) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (return (expression vec4 * (var_ref t) (expression vec4 * (var_ref t) (expression vec4 - (constant float (3.0)) (expression vec4 * (constant float (2.0)) (var_ref t))))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 edge0)\n"
   "       (declare (in) vec2 edge1)\n"
   "       (declare (in) vec2 x))\n"
   "     ((declare () vec2 t)\n"
   "      (assign (xy) (var_ref t)\n"
   "              (expression vec2 max\n"
   "                          (expression vec2 min\n"
   "                                      (expression vec2 / (expression vec2 - (var_ref x) (var_ref edge0)) (expression vec2 - (var_ref edge1) (var_ref edge0)))\n"
   "                                      (constant float (1.0)))\n"
   "                          (constant float (0.0))))\n"
   "      (return (expression vec2 * (var_ref t) (expression vec2 * (var_ref t) (expression vec2 - (constant float (3.0)) (expression vec2 * (constant float (2.0)) (var_ref t))))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 edge0)\n"
   "       (declare (in) vec3 edge1)\n"
   "       (declare (in) vec3 x))\n"
   "     ((declare () vec3 t)\n"
   "      (assign (xyz) (var_ref t)\n"
   "              (expression vec3 max\n"
   "                          (expression vec3 min\n"
   "                                      (expression vec3 / (expression vec3 - (var_ref x) (var_ref edge0)) (expression vec3 - (var_ref edge1) (var_ref edge0)))\n"
   "                                      (constant float (1.0)))\n"
   "                          (constant float (0.0))))\n"
   "      (return (expression vec3 * (var_ref t) (expression vec3 * (var_ref t) (expression vec3 - (constant float (3.0)) (expression vec3 * (constant float (2.0)) (var_ref t))))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 edge0)\n"
   "       (declare (in) vec4 edge1)\n"
   "       (declare (in) vec4 x))\n"
   "     ((declare () vec4 t)\n"
   "      (assign (xyzw) (var_ref t)\n"
   "              (expression vec4 max\n"
   "                          (expression vec4 min\n"
   "                                      (expression vec4 / (expression vec4 - (var_ref x) (var_ref edge0)) (expression vec4 - (var_ref edge1) (var_ref edge0)))\n"
   "                                      (constant float (1.0)))\n"
   "                          (constant float (0.0))))\n"
   "      (return (expression vec4 * (var_ref t) (expression vec4 * (var_ref t) (expression vec4 - (constant float (3.0)) (expression vec4 * (constant float (2.0)) (var_ref t))))))))\n"
   "))\n"
   "\n"
   ""
;
static const char builtin_sqrt[] =
   "((function sqrt\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float sqrt (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 sqrt (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 sqrt (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 sqrt (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_step[] =
   "((function step\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float edge)\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float b2f (expression bool >= (var_ref x) (var_ref edge))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) float edge)\n"
   "       (declare (in) vec2 x))\n"
   "     ((declare () vec2 t)\n"
   "      (assign (x) (var_ref t) (expression float b2f (expression bool >= (swiz x (var_ref x))(var_ref edge))))\n"
   "      (assign (y) (var_ref t) (expression float b2f (expression bool >= (swiz y (var_ref x))(var_ref edge))))\n"
   "      (return (var_ref t))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) float edge)\n"
   "       (declare (in) vec3 x))\n"
   "     ((declare () vec3 t)\n"
   "      (assign (x) (var_ref t) (expression float b2f (expression bool >= (swiz x (var_ref x))(var_ref edge))))\n"
   "      (assign (y) (var_ref t) (expression float b2f (expression bool >= (swiz y (var_ref x))(var_ref edge))))\n"
   "      (assign (z) (var_ref t) (expression float b2f (expression bool >= (swiz z (var_ref x))(var_ref edge))))\n"
   "      (return (var_ref t))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) float edge)\n"
   "       (declare (in) vec4 x))\n"
   "     ((declare () vec4 t)\n"
   "      (assign (x) (var_ref t) (expression float b2f (expression bool >= (swiz x (var_ref x))(var_ref edge))))\n"
   "      (assign (y) (var_ref t) (expression float b2f (expression bool >= (swiz y (var_ref x))(var_ref edge))))\n"
   "      (assign (z) (var_ref t) (expression float b2f (expression bool >= (swiz z (var_ref x))(var_ref edge))))\n"
   "      (assign (w) (var_ref t) (expression float b2f (expression bool >= (swiz w (var_ref x))(var_ref edge))))\n"
   "      (return (var_ref t))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 edge)\n"
   "       (declare (in) vec2 x))\n"
   "     ((declare () vec2 t)\n"
   "      (assign (x) (var_ref t) (expression float b2f (expression bool >= (swiz x (var_ref x))(swiz x (var_ref edge)))))\n"
   "      (assign (y) (var_ref t) (expression float b2f (expression bool >= (swiz y (var_ref x))(swiz y (var_ref edge)))))\n"
   "      (return (var_ref t))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 edge)\n"
   "       (declare (in) vec3 x))\n"
   "     ((declare () vec3 t)\n"
   "      (assign (x) (var_ref t) (expression float b2f (expression bool >= (swiz x (var_ref x))(swiz x (var_ref edge)))))\n"
   "      (assign (y) (var_ref t) (expression float b2f (expression bool >= (swiz y (var_ref x))(swiz y (var_ref edge)))))\n"
   "      (assign (z) (var_ref t) (expression float b2f (expression bool >= (swiz z (var_ref x))(swiz z (var_ref edge)))))\n"
   "      (return (var_ref t))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 edge)\n"
   "       (declare (in) vec4 x))\n"
   "     ((declare () vec4 t)\n"
   "      (assign (x) (var_ref t) (expression float b2f (expression bool >= (swiz x (var_ref x))(swiz x (var_ref edge)))))\n"
   "      (assign (y) (var_ref t) (expression float b2f (expression bool >= (swiz y (var_ref x))(swiz y (var_ref edge)))))\n"
   "      (assign (z) (var_ref t) (expression float b2f (expression bool >= (swiz z (var_ref x))(swiz z (var_ref edge)))))\n"
   "      (assign (w) (var_ref t) (expression float b2f (expression bool >= (swiz w (var_ref x))(swiz w (var_ref edge)))))\n"
   "      (return (var_ref t))))\n"
   "))\n"
   "\n"
   ""
;
static const char builtin_tan[] =
   "((function tan\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float angle))\n"
   "     ((return (expression float / (expression float sin (var_ref angle)) (expression float cos (var_ref angle))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 angle))\n"
   "     ((return (expression vec2 / (expression vec2 sin (var_ref angle)) (expression vec2 cos (var_ref angle))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 angle))\n"
   "     ((return (expression vec3 / (expression vec3 sin (var_ref angle)) (expression vec3 cos (var_ref angle))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 angle))\n"
   "     ((return (expression vec4 / (expression vec4 sin (var_ref angle)) (expression vec4 cos (var_ref angle))))))\n"
   "))\n"
   ""
;
static const char builtin_tanh[] =
   "((function tanh\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float /\n"
   "                (expression float -\n"
   "		  (expression float exp (var_ref x))\n"
   "		  (expression float exp (expression float neg (var_ref x))))\n"
   "                (expression float +\n"
   "		  (expression float exp (var_ref x))\n"
   "		  (expression float exp (expression float neg (var_ref x))))))))\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 /\n"
   "                (expression vec2 -\n"
   "		  (expression vec2 exp (var_ref x))\n"
   "		  (expression vec2 exp (expression vec2 neg (var_ref x))))\n"
   "                (expression vec2 +\n"
   "		  (expression vec2 exp (var_ref x))\n"
   "		  (expression vec2 exp (expression vec2 neg (var_ref x))))))))\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 /\n"
   "                (expression vec3 -\n"
   "		  (expression vec3 exp (var_ref x))\n"
   "		  (expression vec3 exp (expression vec3 neg (var_ref x))))\n"
   "                (expression vec3 +\n"
   "		  (expression vec3 exp (var_ref x))\n"
   "		  (expression vec3 exp (expression vec3 neg (var_ref x))))))))\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 /\n"
   "                (expression vec4 -\n"
   "		  (expression vec4 exp (var_ref x))\n"
   "		  (expression vec4 exp (expression vec4 neg (var_ref x))))\n"
   "                (expression vec4 +\n"
   "		  (expression vec4 exp (var_ref x))\n"
   "		  (expression vec4 exp (expression vec4 neg (var_ref x))))))))\n"
   "))\n"
   ""
;
static const char builtin_texelFetch[] =
   "((function texelFetch\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) int P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) int P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) int P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) ivec2 P) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) 0 (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) ivec2 P) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) 0 (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) ivec2 P) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) 0 (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler) \n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler) \n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) 0 (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerBuffer sampler) \n"
   "       (declare (in) int P) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) 0 (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isamplerBuffer sampler) \n"
   "       (declare (in) int P) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) 0 (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usamplerBuffer sampler) \n"
   "       (declare (in) int P) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) 0 (constant int (0))\n"
   "))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texelFetchOffset[] =
   "((function texelFetchOffset\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) int P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) int P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) int P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) (var_ref offset) (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) (var_ref offset) (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) (var_ref offset) (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler) \n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txf vec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler) \n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txf ivec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler) \n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txf uvec4 (var_ref sampler) (var_ref P) (var_ref offset) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture[] =
   "((function texture\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) float P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) float P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) float P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isamplerCube sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usamplerCube sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex float (var_ref sampler) (swiz x (var_ref P)) 0 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex float (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) samplerCubeShadow sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex float (var_ref sampler) (swiz xyz (var_ref P)) 0 1 (swiz w (var_ref P)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex float (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArrayShadow sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex float (var_ref sampler) (swiz xyz (var_ref P)) 0 1 (swiz w (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex float (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isamplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usamplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb float (var_ref sampler) (swiz x (var_ref P)) 0 1 (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb float (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) samplerCubeShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb float (var_ref sampler) (swiz xyz (var_ref P)) 0 1 (swiz w (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb float (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArrayShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb float (var_ref sampler) (swiz xyz (var_ref P)) 0 1 (swiz w (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture1D[] =
   "((function texture1D\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) float P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture1DArray[] =
   "((function texture1DArray\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture1DArrayLod[] =
   "((function texture1DArrayLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture1DGradARB[] =
   "((function texture1DGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture1DLod[] =
   "((function texture1DLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture1DProj[] =
   "((function texture1DProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture1DProjGradARB[] =
   "((function texture1DProjGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture1DProjLod[] =
   "((function texture1DProjLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture2D[] =
   "((function texture2D\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerExternalOES sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture2DArray[] =
   "((function texture2DArray\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture2DArrayLod[] =
   "((function texture2DArrayLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture2DGradARB[] =
   "((function texture2DGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture2DLod[] =
   "((function texture2DLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture2DProj[] =
   "((function texture2DProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerExternalOES sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerExternalOES sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture2DProjGradARB[] =
   "((function texture2DProjGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture2DProjLod[] =
   "((function texture2DProjLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture2DRect[] =
   "((function texture2DRect\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture2DRectGradARB[] =
   "((function texture2DRectGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture2DRectProj[] =
   "((function texture2DRectProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture2DRectProjGradARB[] =
   "((function texture2DRectProjGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture3D[] =
   "((function texture3D\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture3DGradARB[] =
   "((function texture3DGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture3DLod[] =
   "((function texture3DLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture3DProj[] =
   "((function texture3DProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture3DProjGradARB[] =
   "((function texture3DProjGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_texture3DProjLod[] =
   "((function texture3DProjLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureCube[] =
   "((function textureCube\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) 0 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureCubeGradARB[] =
   "((function textureCubeGradARB\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isamplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usamplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureCubeLod[] =
   "((function textureCubeLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureGrad[] =
   "((function textureGrad\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isamplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usamplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) 0 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd float (var_ref sampler) (swiz x (var_ref P)) 0 1 (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) samplerCubeShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xyz (var_ref P)) 0 1 (swiz w (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArrayShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xyz (var_ref P)) 0 1 (swiz w (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureGradOffset[] =
   "((function textureGradOffset\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd float (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArrayShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) 1 (swiz w (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureLod[] =
   "((function textureLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isamplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usamplerCube sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (var_ref P) 0 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl float (var_ref sampler) (swiz x (var_ref P)) 0 1 (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl float (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl float (var_ref sampler) (swiz xy (var_ref P)) 0 1 (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureLodOffset[] =
   "((function textureLodOffset\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl float (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureOffset[] =
   "((function textureOffset\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex float (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) float P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec3 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec3 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec3 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (var_ref P) (var_ref offset) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb float (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) 1 (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureProj[] =
   "((function textureProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex float (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex float (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) \n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex float (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb float (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb float (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureProjGrad[] =
   "((function textureProjGrad\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd float (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureProjGradOffset[] =
   "((function textureProjGradOffset\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz y (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz y (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz y (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd vec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd ivec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd uvec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txd float (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txd float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) (swiz z (var_ref P)) ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureProjLod[] =
   "((function textureProjLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz y (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz z (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (swiz xyz (var_ref P)) 0 (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl float (var_ref sampler) (swiz x (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl float (var_ref sampler) (swiz xy (var_ref P)) 0 (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureProjLodOffset[] =
   "((function textureProjLodOffset\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz y (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz y (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz y (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txl vec4 (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txl ivec4 (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (txl uvec4 (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (txl float (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (txl float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureProjOffset[] =
   "((function textureProjOffset\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz y (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz y (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz y (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec3 offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex vec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex ivec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex uvec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) int offset) )\n"
   "     ((return (tex float (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec2 offset) )\n"
   "     ((return (tex float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz y (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz y (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec2 P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz y (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec3 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz z (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec3 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb vec4 (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec3 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb ivec4 (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec3 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb uvec4 (var_ref sampler) (swiz xyz (var_ref P)) (var_ref offset) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) int offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb float (var_ref sampler) (swiz x (var_ref P)) (var_ref offset) (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) vec4 P) \n"
   "       (declare (const_in) ivec2 offset) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb float (var_ref sampler) (swiz xy (var_ref P)) (var_ref offset) (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_textureSize[] =
   "((function textureSize\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs int (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs int (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs int (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec3 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec3 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec3 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) isamplerCube sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) usamplerCube sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec3 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec3 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec3 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs int (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) samplerCubeShadow sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArrayShadow sampler) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txs ivec3 (var_ref sampler) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) isampler2DRect sampler) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) usampler2DRect sampler) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler) )\n"
   "     ((return (txs ivec2 (var_ref sampler) (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) samplerBuffer sampler) )\n"
   "     ((return (txs int (var_ref sampler) (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) isamplerBuffer sampler) )\n"
   "     ((return (txs int (var_ref sampler) (constant int (0))\n"
   "))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) usamplerBuffer sampler) )\n"
   "     ((return (txs int (var_ref sampler) (constant int (0))\n"
   "))))\n"
   "\n"
   "))\n"
   ""
;
static const char builtin_transpose[] =
   "((function transpose\n"
   "   (signature mat2\n"
   "     (parameters\n"
   "       (declare (in) mat2 m))\n"
   "     ((declare () mat2 t)\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat3x2\n"
   "     (parameters\n"
   "       (declare (in) mat2x3 m))\n"
   "     ((declare () mat3x2 t)\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (1)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat4x2\n"
   "     (parameters\n"
   "       (declare (in) mat2x4 m))\n"
   "     ((declare () mat4x2 t)\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (1)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat2x3\n"
   "     (parameters\n"
   "       (declare (in) mat3x2 m))\n"
   "     ((declare () mat2x3 t)\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (2)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat3\n"
   "     (parameters\n"
   "       (declare (in) mat3 m))\n"
   "     ((declare () mat3 t)\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (2)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat4x3\n"
   "     (parameters\n"
   "       (declare (in) mat3x4 m))\n"
   "     ((declare () mat4x3 t)\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (2)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat2x4\n"
   "     (parameters\n"
   "       (declare (in) mat4x2 m))\n"
   "     ((declare () mat2x4 t)\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (w) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (3)))))\n"
   "      (assign (w) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (3)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat3x4\n"
   "     (parameters\n"
   "       (declare (in) mat4x3 m))\n"
   "     ((declare () mat3x4 t)\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (w) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (3)))))\n"
   "      (assign (w) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (3)))))\n"
   "      (assign (w) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (3)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat4\n"
   "     (parameters\n"
   "       (declare (in) mat4 m))\n"
   "     ((declare () mat4 t)\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (x) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (y) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (z) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (w) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (3)))))\n"
   "      (assign (w) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (3)))))\n"
   "      (assign (w) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (3)))))\n"
   "      (assign (w) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (3)))))\n"
   "(return (var_ref t))))\n"
   ")\n"
   "\n"
   ")\n"
   "\n"
   ""
;
static const char builtin_trunc[] =
   "((function trunc\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float trunc (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 trunc (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 trunc (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 trunc (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char builtin_uintBitsToFloat[] =
   "((function uintBitsToFloat\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) uint arg))\n"
   "     ((return (expression float bitcast_u2f (var_ref arg)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg))\n"
   "     ((return (expression vec2 bitcast_u2f (var_ref arg)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg))\n"
   "     ((return (expression vec3 bitcast_u2f (var_ref arg)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg))\n"
   "     ((return (expression vec4 bitcast_u2f (var_ref arg)))))\n"
   "))\n"
   ""
;
static const char prototypes_for_100_frag[] =
   "(\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())))"
;
static const char *functions_for_100_frag [] = {
   builtin_texture2D,
   builtin_texture2DProj,
   builtin_textureCube,
};
static const char prototypes_for_100_glsl[] =
   "(\n"
   "(function radians\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float degrees))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 degrees))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 degrees))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 degrees))\n"
   "    ()))\n"
   "(function degrees\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float radians))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 radians))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 radians))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 radians))\n"
   "    ()))\n"
   "(function sin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function cos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function tan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function asin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function acos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function atan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y_over_x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y_over_x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y_over_x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y_over_x))\n"
   "    ()))\n"
   "(function pow\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function exp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function exp2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function inversesqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function abs\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sign\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function floor\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ceil\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function fract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function mod\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function min\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function max\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function clamp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 minVal)\n"
   "      (declare (in) vec2 maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 minVal)\n"
   "      (declare (in) vec3 maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 minVal)\n"
   "      (declare (in) vec4 maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ()))\n"
   "(function mix\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) float a))\n"
   "    ()))\n"
   "(function step\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function smoothstep\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge0)\n"
   "      (declare (in) vec2 edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge0)\n"
   "      (declare (in) vec3 edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge0)\n"
   "      (declare (in) vec4 edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function length\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function distance\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p0)\n"
   "      (declare (in) float p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 p0)\n"
   "      (declare (in) vec2 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 p0)\n"
   "      (declare (in) vec3 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 p0)\n"
   "      (declare (in) vec4 p1))\n"
   "    ()))\n"
   "(function dot\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function cross\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ()))\n"
   "(function normalize\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function faceforward\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float Nref))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 Nref))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 Nref))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 Nref))\n"
   "    ()))\n"
   "(function reflect\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N))\n"
   "    ()))\n"
   "(function refract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) float eta))\n"
   "    ()))\n"
   "(function matrixCompMult\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 x)\n"
   "      (declare (in) mat2 y))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 x)\n"
   "      (declare (in) mat3 y))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 x)\n"
   "      (declare (in) mat4 y))\n"
   "    ()))\n"
   "(function lessThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function lessThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function equal\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function notEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function any\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function all\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function not\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())))"
;
static const char *functions_for_100_glsl [] = {
   builtin_abs,
   builtin_acos,
   builtin_all,
   builtin_any,
   builtin_asin,
   builtin_atan,
   builtin_ceil,
   builtin_clamp,
   builtin_cos,
   builtin_cross,
   builtin_degrees,
   builtin_distance,
   builtin_dot,
   builtin_equal,
   builtin_exp,
   builtin_exp2,
   builtin_faceforward,
   builtin_floor,
   builtin_fract,
   builtin_greaterThan,
   builtin_greaterThanEqual,
   builtin_inversesqrt,
   builtin_length,
   builtin_lessThan,
   builtin_lessThanEqual,
   builtin_log,
   builtin_log2,
   builtin_matrixCompMult,
   builtin_max,
   builtin_min,
   builtin_mix,
   builtin_mod,
   builtin_normalize,
   builtin_not,
   builtin_notEqual,
   builtin_pow,
   builtin_radians,
   builtin_reflect,
   builtin_refract,
   builtin_sign,
   builtin_sin,
   builtin_smoothstep,
   builtin_sqrt,
   builtin_step,
   builtin_tan,
   builtin_texture2D,
   builtin_texture2DProj,
   builtin_textureCube,
};
static const char prototypes_for_100_vert[] =
   "(\n"
   "(function texture2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function textureCubeLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())))"
;
static const char *functions_for_100_vert [] = {
   builtin_texture2DLod,
   builtin_texture2DProjLod,
   builtin_textureCubeLod,
};
static const char prototypes_for_110_frag[] =
   "(\n"
   "(function texture1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function dFdx\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function dFdy\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function fwidth\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ())))"
;
static const char *functions_for_110_frag [] = {
   builtin_dFdx,
   builtin_dFdy,
   builtin_fwidth,
   builtin_shadow1D,
   builtin_shadow1DProj,
   builtin_shadow2D,
   builtin_shadow2DProj,
   builtin_texture1D,
   builtin_texture1DProj,
   builtin_texture2D,
   builtin_texture2DProj,
   builtin_texture3D,
   builtin_texture3DProj,
   builtin_textureCube,
};
static const char prototypes_for_110_glsl[] =
   "(\n"
   "(function radians\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float degrees))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 degrees))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 degrees))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 degrees))\n"
   "    ()))\n"
   "(function degrees\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float radians))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 radians))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 radians))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 radians))\n"
   "    ()))\n"
   "(function sin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function cos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function tan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function asin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function acos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function atan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y_over_x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y_over_x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y_over_x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y_over_x))\n"
   "    ()))\n"
   "(function pow\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function exp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function exp2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function inversesqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function abs\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sign\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function floor\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ceil\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function fract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function mod\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function min\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function max\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function clamp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 minVal)\n"
   "      (declare (in) vec2 maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 minVal)\n"
   "      (declare (in) vec3 maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 minVal)\n"
   "      (declare (in) vec4 maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ()))\n"
   "(function mix\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) float a))\n"
   "    ()))\n"
   "(function step\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function smoothstep\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge0)\n"
   "      (declare (in) vec2 edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge0)\n"
   "      (declare (in) vec3 edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge0)\n"
   "      (declare (in) vec4 edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function length\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function distance\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p0)\n"
   "      (declare (in) float p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 p0)\n"
   "      (declare (in) vec2 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 p0)\n"
   "      (declare (in) vec3 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 p0)\n"
   "      (declare (in) vec4 p1))\n"
   "    ()))\n"
   "(function dot\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function cross\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ()))\n"
   "(function normalize\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function faceforward\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float Nref))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 Nref))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 Nref))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 Nref))\n"
   "    ()))\n"
   "(function reflect\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N))\n"
   "    ()))\n"
   "(function refract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) float eta))\n"
   "    ()))\n"
   "(function matrixCompMult\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 x)\n"
   "      (declare (in) mat2 y))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 x)\n"
   "      (declare (in) mat3 y))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 x)\n"
   "      (declare (in) mat4 y))\n"
   "    ()))\n"
   "(function lessThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function lessThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function equal\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function notEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function any\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function all\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function not\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function texture1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord))\n"
   "    ()))\n"
   "(function texture1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function texture3D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function texture3DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function shadow2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function noise1\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise2\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise3\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise4\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ())))"
;
static const char *functions_for_110_glsl [] = {
   builtin_abs,
   builtin_acos,
   builtin_all,
   builtin_any,
   builtin_asin,
   builtin_atan,
   builtin_ceil,
   builtin_clamp,
   builtin_cos,
   builtin_cross,
   builtin_degrees,
   builtin_distance,
   builtin_dot,
   builtin_equal,
   builtin_exp,
   builtin_exp2,
   builtin_faceforward,
   builtin_floor,
   builtin_fract,
   builtin_greaterThan,
   builtin_greaterThanEqual,
   builtin_inversesqrt,
   builtin_length,
   builtin_lessThan,
   builtin_lessThanEqual,
   builtin_log,
   builtin_log2,
   builtin_matrixCompMult,
   builtin_max,
   builtin_min,
   builtin_mix,
   builtin_mod,
   builtin_noise1,
   builtin_noise2,
   builtin_noise3,
   builtin_noise4,
   builtin_normalize,
   builtin_not,
   builtin_notEqual,
   builtin_pow,
   builtin_radians,
   builtin_reflect,
   builtin_refract,
   builtin_shadow1D,
   builtin_shadow1DProj,
   builtin_shadow2D,
   builtin_shadow2DProj,
   builtin_sign,
   builtin_sin,
   builtin_smoothstep,
   builtin_sqrt,
   builtin_step,
   builtin_tan,
   builtin_texture1D,
   builtin_texture1DProj,
   builtin_texture2D,
   builtin_texture2DProj,
   builtin_texture3D,
   builtin_texture3DProj,
   builtin_textureCube,
};
static const char prototypes_for_110_vert[] =
   "(\n"
   "(function ftransform\n"
   "  (signature vec4\n"
   "    (parameters)\n"
   "    ()))\n"
   "(function texture1DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture1DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture3DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture3DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function textureCubeLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())))"
;
static const char *functions_for_110_vert [] = {
   builtin_ftransform,
   builtin_shadow1DLod,
   builtin_shadow1DProjLod,
   builtin_shadow2DLod,
   builtin_shadow2DProjLod,
   builtin_texture1DLod,
   builtin_texture1DProjLod,
   builtin_texture2DLod,
   builtin_texture2DProjLod,
   builtin_texture3DLod,
   builtin_texture3DProjLod,
   builtin_textureCubeLod,
};
static const char prototypes_for_120_frag[] =
   "(\n"
   "(function texture1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function dFdx\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function dFdy\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function fwidth\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ())))"
;
static const char *functions_for_120_frag [] = {
   builtin_dFdx,
   builtin_dFdy,
   builtin_fwidth,
   builtin_shadow1D,
   builtin_shadow1DProj,
   builtin_shadow2D,
   builtin_shadow2DProj,
   builtin_texture1D,
   builtin_texture1DProj,
   builtin_texture2D,
   builtin_texture2DProj,
   builtin_texture3D,
   builtin_texture3DProj,
   builtin_textureCube,
};
static const char prototypes_for_120_glsl[] =
   "(\n"
   "(function radians\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float degrees))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 degrees))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 degrees))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 degrees))\n"
   "    ()))\n"
   "(function degrees\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float radians))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 radians))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 radians))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 radians))\n"
   "    ()))\n"
   "(function sin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function cos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function tan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function asin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function acos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function atan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y_over_x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y_over_x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y_over_x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y_over_x))\n"
   "    ()))\n"
   "(function pow\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function exp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function exp2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function inversesqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function abs\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sign\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function floor\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ceil\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function fract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function mod\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function min\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function max\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function clamp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 minVal)\n"
   "      (declare (in) vec2 maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 minVal)\n"
   "      (declare (in) vec3 maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 minVal)\n"
   "      (declare (in) vec4 maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ()))\n"
   "(function mix\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) float a))\n"
   "    ()))\n"
   "(function step\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function smoothstep\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge0)\n"
   "      (declare (in) vec2 edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge0)\n"
   "      (declare (in) vec3 edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge0)\n"
   "      (declare (in) vec4 edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function length\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function distance\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p0)\n"
   "      (declare (in) float p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 p0)\n"
   "      (declare (in) vec2 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 p0)\n"
   "      (declare (in) vec3 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 p0)\n"
   "      (declare (in) vec4 p1))\n"
   "    ()))\n"
   "(function dot\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function cross\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ()))\n"
   "(function normalize\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function faceforward\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float Nref))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 Nref))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 Nref))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 Nref))\n"
   "    ()))\n"
   "(function reflect\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N))\n"
   "    ()))\n"
   "(function refract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) float eta))\n"
   "    ()))\n"
   "(function matrixCompMult\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 x)\n"
   "      (declare (in) mat2 y))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 x)\n"
   "      (declare (in) mat3 y))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 x)\n"
   "      (declare (in) mat4 y))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) mat2x3 x)\n"
   "      (declare (in) mat2x3 y))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) mat2x4 x)\n"
   "      (declare (in) mat2x4 y))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) mat3x2 x)\n"
   "      (declare (in) mat3x2 y))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) mat3x4 x)\n"
   "      (declare (in) mat3x4 y))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) mat4x2 x)\n"
   "      (declare (in) mat4x2 y))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) mat4x3 x)\n"
   "      (declare (in) mat4x3 y))\n"
   "    ()))\n"
   "(function outerProduct\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ()))\n"
   "(function transpose\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 m))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 m))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 m))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) mat3x2 m))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) mat2x3 m))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) mat4x2 m))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) mat2x4 m))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) mat4x3 m))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) mat3x4 m))\n"
   "    ()))\n"
   "(function lessThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function lessThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function equal\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function notEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function any\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function all\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function not\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function texture1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord))\n"
   "    ()))\n"
   "(function texture1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function texture3D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function texture3DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function shadow2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function noise1\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise2\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise3\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise4\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ())))"
;
static const char *functions_for_120_glsl [] = {
   builtin_abs,
   builtin_acos,
   builtin_all,
   builtin_any,
   builtin_asin,
   builtin_atan,
   builtin_ceil,
   builtin_clamp,
   builtin_cos,
   builtin_cross,
   builtin_degrees,
   builtin_distance,
   builtin_dot,
   builtin_equal,
   builtin_exp,
   builtin_exp2,
   builtin_faceforward,
   builtin_floor,
   builtin_fract,
   builtin_greaterThan,
   builtin_greaterThanEqual,
   builtin_inversesqrt,
   builtin_length,
   builtin_lessThan,
   builtin_lessThanEqual,
   builtin_log,
   builtin_log2,
   builtin_matrixCompMult,
   builtin_max,
   builtin_min,
   builtin_mix,
   builtin_mod,
   builtin_noise1,
   builtin_noise2,
   builtin_noise3,
   builtin_noise4,
   builtin_normalize,
   builtin_not,
   builtin_notEqual,
   builtin_outerProduct,
   builtin_pow,
   builtin_radians,
   builtin_reflect,
   builtin_refract,
   builtin_shadow1D,
   builtin_shadow1DProj,
   builtin_shadow2D,
   builtin_shadow2DProj,
   builtin_sign,
   builtin_sin,
   builtin_smoothstep,
   builtin_sqrt,
   builtin_step,
   builtin_tan,
   builtin_texture1D,
   builtin_texture1DProj,
   builtin_texture2D,
   builtin_texture2DProj,
   builtin_texture3D,
   builtin_texture3DProj,
   builtin_textureCube,
   builtin_transpose,
};
static const char prototypes_for_120_vert[] =
   "(\n"
   "(function ftransform\n"
   "  (signature vec4\n"
   "    (parameters)\n"
   "    ()))\n"
   "(function texture1DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture1DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture3DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture3DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function textureCubeLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())))"
;
static const char *functions_for_120_vert [] = {
   builtin_ftransform,
   builtin_shadow1DLod,
   builtin_shadow1DProjLod,
   builtin_shadow2DLod,
   builtin_shadow2DProjLod,
   builtin_texture1DLod,
   builtin_texture1DProjLod,
   builtin_texture2DLod,
   builtin_texture2DProjLod,
   builtin_texture3DLod,
   builtin_texture3DProjLod,
   builtin_textureCubeLod,
};
static const char prototypes_for_130_frag[] =
   "(\n"
   "(function texture\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) samplerCubeShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureOffset\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec3 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec3 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec3 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow samp)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureProjOffset\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec3 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec3 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec3 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow s)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow s)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function dFdx\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function dFdy\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function fwidth\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ())))"
;
static const char *functions_for_130_frag [] = {
   builtin_dFdx,
   builtin_dFdy,
   builtin_fwidth,
   builtin_shadow1D,
   builtin_shadow1DProj,
   builtin_shadow2D,
   builtin_shadow2DProj,
   builtin_texture,
   builtin_texture1D,
   builtin_texture1DProj,
   builtin_texture2D,
   builtin_texture2DProj,
   builtin_texture3D,
   builtin_texture3DProj,
   builtin_textureCube,
   builtin_textureOffset,
   builtin_textureProj,
   builtin_textureProjOffset,
};
static const char prototypes_for_130_glsl[] =
{'(',
'(','f','u','n','c','t','i','o','n',' ','r','a','d','i','a','n','s',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','e','g','r','e','e','s',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','e','g','r','e','e','s',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','e','g','r','e','e','s',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','d','e','g','r','e','e','s',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','d','e','g','r','e','e','s',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','r','a','d','i','a','n','s',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','r','a','d','i','a','n','s',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','r','a','d','i','a','n','s',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','r','a','d','i','a','n','s',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','i','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','a','n','g','l','e',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','c','o','s',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','a','n','g','l','e',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','a','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','a','n','g','l','e',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','s','i','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','a','n','g','l','e',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','c','o','s',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','a','n','g','l','e',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','t','a','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y','_','o','v','e','r','_','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y','_','o','v','e','r','_','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y','_','o','v','e','r','_','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y','_','o','v','e','r','_','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','i','n','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','c','o','s','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','a','n','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','s','i','n','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','c','o','s','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','t','a','n','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','p','o','w',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','e','x','p',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','l','o','g',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','e','x','p','2',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','l','o','g','2',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','q','r','t',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','i','n','v','e','r','s','e','s','q','r','t',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','b','s',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','i','g','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','f','l','o','o','r',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','r','u','n','c',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','r','o','u','n','d',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','r','o','u','n','d','E','v','e','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','c','e','i','l',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','f','r','a','c','t',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','m','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','m','o','d','f',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','o','u','t',')',' ','f','l','o','a','t',' ','i',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','o','u','t',')',' ','v','e','c','2',' ','i',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','o','u','t',')',' ','v','e','c','3',' ','i',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','o','u','t',')',' ','v','e','c','4',' ','i',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','m','i','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','m','a','x',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','c','l','a','m','p',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','m','i','x',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','o','o','l',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','a',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','t','e','p',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','m','o','o','t','h','s','t','e','p',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','i','s','n','a','n',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','i','s','i','n','f',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','l','e','n','g','t','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','d','i','s','t','a','n','c','e',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','p','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','p','1',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','p','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','p','1',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','p','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','p','1',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','p','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','p','1',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','d','o','t',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','c','r','o','s','s',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','n','o','r','m','a','l','i','z','e',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','f','a','c','e','f','o','r','w','a','r','d',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','N','r','e','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','N','r','e','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','N','r','e','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','N','r','e','f',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','r','e','f','l','e','c','t',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','N',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','N',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','N',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','N',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','r','e','f','r','a','c','t',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','t','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','t','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','t','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','t','a',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','m','a','t','r','i','x','C','o','m','p','M','u','l','t',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2','x','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2','x','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2','x','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2','x','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2','x','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2','x','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3','x','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3','x','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3','x','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3','x','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3','x','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3','x','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4','x','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4','x','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4','x','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4','x','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4','x','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4','x','3',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','o','u','t','e','r','P','r','o','d','u','c','t',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2','x','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3','x','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2','x','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4','x','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3','x','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4','x','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','r',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','r','a','n','s','p','o','s','e',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2','x','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3','x','2',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3','x','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2','x','3',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2','x','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4','x','2',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4','x','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2','x','4',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3','x','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4','x','3',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4','x','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3','x','4',' ','m',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','l','e','s','s','T','h','a','n',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','l','e','s','s','T','h','a','n','E','q','u','a','l',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','g','r','e','a','t','e','r','T','h','a','n',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','g','r','e','a','t','e','r','T','h','a','n','E','q','u','a','l',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','e','q','u','a','l',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','n','o','t','E','q','u','a','l',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','n','y',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','l','l',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','n','o','t',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','S','i','z','e',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','P','r','o','j',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','e','l','F','e','t','c','h',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','e','l','F','e','t','c','h','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','P','r','o','j','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','L','o','d','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','P','r','o','j','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','P','r','o','j','L','o','d','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','G','r','a','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','G','r','a','d','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y','S','h','a','d','o','w',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','P','r','o','j','G','r','a','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','P','r','o','j','G','r','a','d','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','1','D',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','c','o','o','r','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','1','D','P','r','o','j',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','c','o','o','r','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c','o','o','r','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','1','D','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','1','D','P','r','o','j','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','2','D',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','c','o','o','r','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','2','D','P','r','o','j',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c','o','o','r','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c','o','o','r','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','2','D','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','2','D','P','r','o','j','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','3','D',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c','o','o','r','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','3','D','P','r','o','j',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c','o','o','r','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','3','D','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','3','D','P','r','o','j','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','C','u','b','e',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c','o','o','r','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','C','u','b','e','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','h','a','d','o','w','1','D',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c','o','o','r','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','h','a','d','o','w','2','D',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c','o','o','r','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','h','a','d','o','w','1','D','P','r','o','j',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c','o','o','r','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','h','a','d','o','w','2','D','P','r','o','j',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c','o','o','r','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','h','a','d','o','w','1','D','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','h','a','d','o','w','2','D','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','h','a','d','o','w','1','D','P','r','o','j','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','h','a','d','o','w','2','D','P','r','o','j','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c','o','o','r','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','n','o','i','s','e','1',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','n','o','i','s','e','2',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','n','o','i','s','e','3',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','n','o','i','s','e','4',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',')'} ;
static const char *functions_for_130_glsl [] = {
   builtin_abs,
   builtin_acos,
   builtin_acosh,
   builtin_all,
   builtin_any,
   builtin_asin,
   builtin_asinh,
   builtin_atan,
   builtin_atanh,
   builtin_ceil,
   builtin_clamp,
   builtin_cos,
   builtin_cosh,
   builtin_cross,
   builtin_degrees,
   builtin_distance,
   builtin_dot,
   builtin_equal,
   builtin_exp,
   builtin_exp2,
   builtin_faceforward,
   builtin_floor,
   builtin_fract,
   builtin_greaterThan,
   builtin_greaterThanEqual,
   builtin_inversesqrt,
   builtin_isinf,
   builtin_isnan,
   builtin_length,
   builtin_lessThan,
   builtin_lessThanEqual,
   builtin_log,
   builtin_log2,
   builtin_matrixCompMult,
   builtin_max,
   builtin_min,
   builtin_mix,
   builtin_mod,
   builtin_modf,
   builtin_noise1,
   builtin_noise2,
   builtin_noise3,
   builtin_noise4,
   builtin_normalize,
   builtin_not,
   builtin_notEqual,
   builtin_outerProduct,
   builtin_pow,
   builtin_radians,
   builtin_reflect,
   builtin_refract,
   builtin_round,
   builtin_roundEven,
   builtin_shadow1D,
   builtin_shadow1DLod,
   builtin_shadow1DProj,
   builtin_shadow1DProjLod,
   builtin_shadow2D,
   builtin_shadow2DLod,
   builtin_shadow2DProj,
   builtin_shadow2DProjLod,
   builtin_sign,
   builtin_sin,
   builtin_sinh,
   builtin_smoothstep,
   builtin_sqrt,
   builtin_step,
   builtin_tan,
   builtin_tanh,
   builtin_texelFetch,
   builtin_texelFetchOffset,
   builtin_texture,
   builtin_texture1D,
   builtin_texture1DLod,
   builtin_texture1DProj,
   builtin_texture1DProjLod,
   builtin_texture2D,
   builtin_texture2DLod,
   builtin_texture2DProj,
   builtin_texture2DProjLod,
   builtin_texture3D,
   builtin_texture3DLod,
   builtin_texture3DProj,
   builtin_texture3DProjLod,
   builtin_textureCube,
   builtin_textureCubeLod,
   builtin_textureGrad,
   builtin_textureGradOffset,
   builtin_textureLod,
   builtin_textureLodOffset,
   builtin_textureOffset,
   builtin_textureProj,
   builtin_textureProjGrad,
   builtin_textureProjGradOffset,
   builtin_textureProjLod,
   builtin_textureProjLodOffset,
   builtin_textureProjOffset,
   builtin_textureSize,
   builtin_transpose,
   builtin_trunc,
};
static const char prototypes_for_130_vert[] =
   "(\n"
   "(function ftransform\n"
   "  (signature vec4\n"
   "    (parameters)\n"
   "    ())))"
;
static const char *functions_for_130_vert [] = {
   builtin_ftransform,
};
static const char prototypes_for_140_frag[] =
   "(\n"
   "(function texture\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) samplerCubeShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureOffset\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec3 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec3 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec3 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow samp)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureProjOffset\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec3 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec3 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec3 offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow s)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) int offset)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow s)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) ivec2 offset)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function dFdx\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function dFdy\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function fwidth\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ())))"
;
static const char *functions_for_140_frag [] = {
   builtin_dFdx,
   builtin_dFdy,
   builtin_fwidth,
   builtin_shadow1D,
   builtin_shadow1DProj,
   builtin_shadow2D,
   builtin_shadow2DProj,
   builtin_texture,
   builtin_texture1D,
   builtin_texture1DProj,
   builtin_texture2D,
   builtin_texture2DProj,
   builtin_texture3D,
   builtin_texture3DProj,
   builtin_textureCube,
   builtin_textureOffset,
   builtin_textureProj,
   builtin_textureProjOffset,
};
static const char prototypes_for_140_glsl[] =
{'(',
'(','f','u','n','c','t','i','o','n',' ','r','a','d','i','a','n','s',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','e','g','r','e','e','s',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','e','g','r','e','e','s',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','e','g','r','e','e','s',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','d','e','g','r','e','e','s',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','d','e','g','r','e','e','s',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','r','a','d','i','a','n','s',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','r','a','d','i','a','n','s',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','r','a','d','i','a','n','s',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','r','a','d','i','a','n','s',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','i','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','a','n','g','l','e',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','c','o','s',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','a','n','g','l','e',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','a','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','a','n','g','l','e',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','s','i','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','a','n','g','l','e',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','c','o','s',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','a','n','g','l','e',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','a','n','g','l','e',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','t','a','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y','_','o','v','e','r','_','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y','_','o','v','e','r','_','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y','_','o','v','e','r','_','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y','_','o','v','e','r','_','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','i','n','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','c','o','s','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','a','n','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','s','i','n','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','c','o','s','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','t','a','n','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','p','o','w',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','e','x','p',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','l','o','g',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','e','x','p','2',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','l','o','g','2',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','q','r','t',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','i','n','v','e','r','s','e','s','q','r','t',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','b','s',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','i','g','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','f','l','o','o','r',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','r','u','n','c',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','r','o','u','n','d',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','r','o','u','n','d','E','v','e','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','c','e','i','l',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','f','r','a','c','t',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','m','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','m','o','d','f',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','o','u','t',')',' ','f','l','o','a','t',' ','i',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','o','u','t',')',' ','v','e','c','2',' ','i',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','o','u','t',')',' ','v','e','c','3',' ','i',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','o','u','t',')',' ','v','e','c','4',' ','i',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','m','i','n',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','m','a','x',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','c','l','a','m','p',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','i','n','V','a','l',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','i','n','t',' ','m','a','x','V','a','l',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','m','i','x',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','o','o','l',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','a',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','t','e','p',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','s','m','o','o','t','h','s','t','e','p',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','d','g','e','1',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','i','s','n','a','n',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','i','s','i','n','f',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','l','e','n','g','t','h',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','d','i','s','t','a','n','c','e',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','p','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','p','1',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','p','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','p','1',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','p','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','p','1',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','p','0',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','p','1',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','d','o','t',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','c','r','o','s','s',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','n','o','r','m','a','l','i','z','e',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','f','a','c','e','f','o','r','w','a','r','d',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','N','r','e','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','N','r','e','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','N','r','e','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','N','r','e','f',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','r','e','f','l','e','c','t',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','N',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','N',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','N',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','N',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','r','e','f','r','a','c','t',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','t','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','t','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','t','a',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','I',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','N',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','e','t','a',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','m','a','t','r','i','x','C','o','m','p','M','u','l','t',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2','x','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2','x','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2','x','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2','x','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2','x','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2','x','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3','x','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3','x','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3','x','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3','x','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3','x','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3','x','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4','x','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4','x','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4','x','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4','x','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4','x','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4','x','3',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','o','u','t','e','r','P','r','o','d','u','c','t',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2','x','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3','x','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2','x','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4','x','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3','x','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4','x','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','c',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','r',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','r','a','n','s','p','o','s','e',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2','x','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3','x','2',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3','x','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2','x','3',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2','x','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4','x','2',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4','x','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2','x','4',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3','x','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4','x','3',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4','x','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3','x','4',' ','m',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','i','n','v','e','r','s','e',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','2',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','3',' ','m',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','m','a','t','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','m','a','t','4',' ','m',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','l','e','s','s','T','h','a','n',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','l','e','s','s','T','h','a','n','E','q','u','a','l',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','g','r','e','a','t','e','r','T','h','a','n',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','g','r','e','a','t','e','r','T','h','a','n','E','q','u','a','l',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','e','q','u','a','l',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','n','o','t','E','q','u','a','l',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','v','e','c','4',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','n','y',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','a','l','l',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','o','o','l',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','n','o','t',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','2',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','3',' ','x',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','b','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','b','v','e','c','4',' ','x',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','S','i','z','e',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','3',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','2',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','B','u','f','f','e','r',' ','s','a','m','p','l','e','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','B','u','f','f','e','r',' ','s','a','m','p','l','e','r',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','n','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','B','u','f','f','e','r',' ','s','a','m','p','l','e','r',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','P','r','o','j',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','e','l','F','e','t','c','h',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','B','u','f','f','e','r',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','B','u','f','f','e','r',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','B','u','f','f','e','r',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','e','l','F','e','t','c','h','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','P','r','o','j','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','L','o','d','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','P','r','o','j','L','o','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','P','r','o','j','L','o','d','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','3',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','l','o','d',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','v','e','c','2',' ','o','f','f','s','e','t',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','G','r','a','d',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','3','D',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','C','u','b','e',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','R','e','c','t',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','R','e','c','t','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','C','u','b','e','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','2','D','A','r','r','a','y',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','3',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','P','d','y',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','f','l','o','a','t',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','2','D','A','r','r','a','y','S','h','a','d','o','w',' ','s','a','m','p','l','e','r',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','4',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','v','e','c','2',' ','d','P','d','y',')',')',' ','(',')',')',')',
'(','f','u','n','c','t','i','o','n',' ','t','e','x','t','u','r','e','G','r','a','d','O','f','f','s','e','t',' ','(','s','i','g','n','a','t','u','r','e',' ','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','s','a','m','p','l','e','r','1','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','i','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','s','a','m','p','l','e','r','1','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','P',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','x',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t',' ','d','y',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','i','n','t',' ','o','f','f','s','e','t',')',')',' ','(',')',')',' ','(','s','i','g','n','a','t','u','r','e',' ','u','v','e','c','4',' ','(','p','a','r','a','m','e','t','e','r','s',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','u','s','a','m','p','l','e','r','1','D',' ','s',')',' ','(','d','e','c','l','a','r','e',' ','(','i','n',')',' ','f','l','o','a','t'