/*****************************************************************************
 *
 * Filename:
 * ---------
 *    pcbid.c
 *
 * Project:
 * --------
 *   Android_Software
 *
 * Description:
 * ------------
 *   
 *
 * Author:
 * -------
 * 
 *
 ****************************************************************************/
#include <linux/init.h>        /* For init/exit macros */
#include <linux/module.h>      /* For MODULE_ marcros  */
#include <linux/device.h>
#include <linux/platform_device.h>
#include <linux/device.h>
#include <linux/kdev_t.h>
#include <linux/delay.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/platform_device.h>
#include <linux/xlog.h>
#include <linux/seq_file.h>

#include <asm/uaccess.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <mach/hardware.h>
#include <mach/system.h>
#include <mach/mt_sleep.h>

#include <mach/mt_gpio.h>
#include <cust_gpio_usage.h>

#define PCB_APAC 1        //32G asia-paciffic ver
#define PCB_EMEA 2        //32G ema ver
#define PCB_OPEN_5_MODE_32G 3 //32G PRC open 5 mode  ver
#define PCB_OPEN_3_MODE 4//16G PRC open 3 mode  ver
#define PCB_CU  5         //32G CU ver
#define PCB_OPEN_5_MODE_16G 6 //16G PRC open 3 mode  ver

static void reset_pcbid_gpio()
{
    unsigned int ret = 0;

    ret = mt_set_gpio_mode(GPIO_PCB_ID0_PIN, GPIO_MODE_00);
    if(0 != ret)
    {
        printk("ID0 mt_set_gpio_mode fail\n");
    }
    ret = mt_set_gpio_dir(GPIO_PCB_ID0_PIN, GPIO_DIR_IN);
    if(0 != ret)
    {
        printk("ID0 mt_set_gpio_dir fail\n");
    }
    ret = mt_set_gpio_pull_enable(GPIO_PCB_ID0_PIN, GPIO_PULL_DISABLE);
    if(0 != ret)
    {
        printk("ID0 mt_set_gpio_pull_enable fail\n");
    }
   
    ret = mt_set_gpio_mode(GPIO_PCB_ID1_PIN, GPIO_MODE_00);
    if(0 != ret)
    {
        printk("ID1 mt_set_gpio_mode fail\n");
    }
    ret = mt_set_gpio_dir(GPIO_PCB_ID1_PIN, GPIO_DIR_IN);
    if(0 != ret)
    {
        printk("ID1 mt_set_gpio_dir fail\n");
    }
    ret = mt_set_gpio_pull_enable(GPIO_PCB_ID1_PIN, GPIO_PULL_DISABLE);
    if(0 != ret)
    {
        printk("ID1 mt_set_gpio_pull_enable fail\n");
    }

    ret = mt_set_gpio_mode(GPIO_PCB_ID2_PIN, GPIO_MODE_00);
    if(0 != ret)
    {
        printk("ID2 mt_set_gpio_mode fail\n");
    }
    ret = mt_set_gpio_dir(GPIO_PCB_ID2_PIN, GPIO_DIR_IN);
    if(0 != ret)
    {
        printk("ID2 mt_set_gpio_dir fail\n");
    }
    ret = mt_set_gpio_pull_enable(GPIO_PCB_ID2_PIN, GPIO_PULL_DISABLE);
    if(0 != ret)
    {
        printk("ID2 mt_set_gpio_pull_enable fail\n");
    }

	mdelay(1);
}

static unsigned int get_pcbid()
{
    unsigned int id0,id1,id2,id3;
    unsigned int id,pcb_id;

    reset_pcbid_gpio();

    id0 = mt_get_gpio_in(GPIO_PCB_ID0_PIN);
    id1 = mt_get_gpio_in(GPIO_PCB_ID1_PIN);
    id2 = mt_get_gpio_in(GPIO_PCB_ID2_PIN);

    id = id0 | (id1<<1) | (id2<<2)  | (id3<<3) ;
    
    switch (id)
    {  
       case 1:
           pcb_id = PCB_OPEN_5_MODE_32G;
	   break;
	   
       case 2:
           pcb_id = PCB_CU;
	   break;  
	   
       case 4:
           pcb_id = PCB_EMEA;
	   break;   
	   
       case 6:
           pcb_id = PCB_OPEN_3_MODE;
	   break;

	   case 7:
           pcb_id = PCB_APAC;
	   break;
	   
      default:	
	   pcb_id = PCB_APAC;
	   break;
    }

	printk("get pcb id: id=%d,pcb_id=%d\n",id,pcb_id);
	return pcb_id;

}

static ssize_t store_pcbid(struct device *dev,struct device_attribute *attr, const char *buf, size_t size)
{    
    return size;
}
static ssize_t show_pcbid(struct device *dev,struct device_attribute *attr, char *buf)
{   
    return sprintf(buf, "%u\n", get_pcbid());
}
static DEVICE_ATTR(pcbid, 0664, show_pcbid, store_pcbid);


static int pcbid_probe(struct platform_device *dev)    
{
    int ret_device_file = 0;

    printk("******** pcbid_probe!! ********\n" );

    ret_device_file = device_create_file(&(dev->dev), &dev_attr_pcbid);

    printk("******** pcbid preboe done!! ********\n" );    
		
    return 0;

}


struct platform_device pcbid_device = {
    .name   = "pcbid",
    .id        = -1,
};

static struct platform_driver pcbid_driver = {
    .probe        = pcbid_probe,
    .driver     = {
        .name = "pcbid",
    },
};

static int __init pcbid_init(void)
{
    int ret;
    
    ret = platform_device_register(&pcbid_device);
    if (ret) {
        printk("pcbid Unable to device register(%d)\n", ret);
        return ret;
    }    
    ret = platform_driver_register(&pcbid_driver);
    if (ret) {
        printk("pcbid Unable to register driver (%d)\n", ret);
        return ret;
    }

    printk("pcbid Initialization : DONE !!\n");
    return 0;
}

static void __exit pcbid_exit (void)
{
}

module_init(pcbid_init);
module_exit(pcbid_exit);

MODULE_AUTHOR("chailu1");
MODULE_DESCRIPTION("pcb id Device Driver");
MODULE_LICENSE("GPL");


