#include <linux/kernel.h>
#include <linux/xlog.h>
#include <linux/module.h>

#include <mach/upmu_sw.h>
#include <mach/upmu_hw.h>
#include <mach/upmu_common.h>

//MT6331
void mt6331_upmu_set_thr_det_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_THR_DET_DIS_MASK),
                             (kal_uint32)(MT6331_PMIC_THR_DET_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_thr_tmode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_THR_TMODE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_THR_TMODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_thr_temp_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_THR_TEMP_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_THR_TEMP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_strup_thr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_THR_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_THR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_thr_hwpdn_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_THR_HWPDN_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_THR_HWPDN_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_thrdet_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_THRDET_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_THRDET_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_strup_iref_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_IREF_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_IREF_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_usbdl_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_USBDL_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_USBDL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_fchr_keydet_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_FCHR_KEYDET_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_FCHR_KEYDET_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_fchr_pu_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_FCHR_PU_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_FCHR_PU_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_en_drvsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EN_DRVSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EN_DRVSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rstb_drv_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RSTB_DRV_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RSTB_DRV_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vref_bg(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VREF_BG_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VREF_BG_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pmu_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PMU_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PMU_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_thr_test(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_THR_TEST_MASK),
                             (kal_uint32)(MT6331_PMIC_THR_TEST_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_pmu_thr_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_STRUP_CON5),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_PMU_THR_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_PMU_THR_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_pmu_thr_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_STRUP_CON5),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_PMU_THR_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_PMU_THR_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_dduvlo_deb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DDUVLO_DEB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_DDUVLO_DEB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_pwrbb_deb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_PWRBB_DEB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_PWRBB_DEB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_osc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_OSC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_OSC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_osc_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_OSC_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_OSC_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_ft_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_FT_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_FT_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_pwron_force(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_PWRON_FORCE_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_PWRON_FORCE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_bias_gen_en_force(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_BIAS_GEN_EN_FORCE_MASK),
                             (kal_uint32)(MT6331_PMIC_BIAS_GEN_EN_FORCE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_pwron(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_PWRON_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_PWRON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_pwron_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_PWRON_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_PWRON_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_bias_gen_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_BIAS_GEN_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_BIAS_GEN_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_bias_gen_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_BIAS_GEN_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_BIAS_GEN_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rtc_xosc32_enb_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RTC_XOSC32_ENB_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_RTC_XOSC32_ENB_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rtc_xosc32_enb_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RTC_XOSC32_ENB_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RTC_XOSC32_ENB_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_dig_io_pg_force(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_DIG_IO_PG_FORCE_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_DIG_IO_PG_FORCE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vaud32_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VAUD32_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VAUD32_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vtcxo1_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VTCXO1_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VTCXO1_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vusb_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VUSB_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VUSB_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio28_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO28_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO28_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vaud32_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VAUD32_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VAUD32_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vtcxo1_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VTCXO1_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VTCXO1_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vusb_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VUSB_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VUSB_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio28_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO28_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO28_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_ext_pmic_status_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EXT_PMIC_STATUS_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EXT_PMIC_STATUS_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_ext_pmic_en_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EXT_PMIC_EN_PG_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EXT_PMIC_EN_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_clr_just_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_CLR_JUST_RST_MASK),
                             (kal_uint32)(MT6331_PMIC_CLR_JUST_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_uvlo_l2h_deb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_UVLO_L2H_DEB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_UVLO_L2H_DEB_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_just_pwrkey_rst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_STRUP_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_JUST_PWRKEY_RST_MASK),
                           (kal_uint32)(MT6331_PMIC_JUST_PWRKEY_RST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_osc_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_STRUP_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_OSC_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_OSC_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_strup_ext_pmic_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_EXT_PMIC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_EXT_PMIC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_ext_pmic_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_EXT_PMIC_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_EXT_PMIC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_con8_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_CON8_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_CON8_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_ext_pmic_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_STRUP_CON10),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_EXT_PMIC_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_EXT_PMIC_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_strup_auxadc_start_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_AUXADC_START_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_AUXADC_START_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_auxadc_rstb_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_AUXADC_RSTB_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_AUXADC_RSTB_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_auxadc_start_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_AUXADC_START_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_AUXADC_START_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_auxadc_rstb_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_AUXADC_RSTB_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_AUXADC_RSTB_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_pwroff_seq_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_PWROFF_SEQ_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_PWROFF_SEQ_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_pwroff_preoff_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_PWROFF_PREOFF_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_PWROFF_PREOFF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_pp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_PP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_PP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_pp_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_PP_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_PP_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_dig1_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_DIG1_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_DIG1_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_uvlo_vthl_vsys(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_UVLO_VTHL_VSYS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_UVLO_VTHL_VSYS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_uvlo_vthl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_UVLO_VTHL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_UVLO_VTHL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_bgr_test_rstb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_TEST_RSTB_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_TEST_RSTB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_bgr_test_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_TEST_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_TEST_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_bgr_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_bgr_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_TRIM_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_bgr_rsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_RSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_RSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_bgr_unchop_ph(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_UNCHOP_PH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_UNCHOP_PH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_bgr_unchop(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_UNCHOP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_UNCHOP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_strup_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_en_smt(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EN_SMT_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EN_SMT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_en_sr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EN_SR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EN_SR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_en_e8(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EN_E8_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EN_E8_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_en_e4(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EN_E4_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EN_E4_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_testmode_swen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_TESTMODE_SWEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_TESTMODE_SWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_strup_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rsv_swreg(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RSV_SWREG_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RSV_SWREG_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_strup_pg_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_STRUP_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_STRUP_PG_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_STRUP_PG_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_strup_pg_status_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_STRUP_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STRUP_PG_STATUS_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_STRUP_PG_STATUS_CLR_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_hwcid(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_HWCID),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_HWCID_MASK),
                           (kal_uint32)(MT6331_PMIC_HWCID_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_swcid(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SWCID),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_SWCID_MASK),
                           (kal_uint32)(MT6331_PMIC_SWCID_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_init_excep_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EXT_PMIC_STATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_INIT_EXCEP_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_INIT_EXCEP_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rtry_excep_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EXT_PMIC_STATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RTRY_EXCEP_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_RTRY_EXCEP_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_toff_excep_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EXT_PMIC_STATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_TOFF_EXCEP_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_TOFF_EXCEP_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ext_pmic_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EXT_PMIC_STATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EXT_PMIC_MON_MASK),
                           (kal_uint32)(MT6331_PMIC_EXT_PMIC_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_excep_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_EXT_PMIC_STATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_EXCEP_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_EXCEP_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_srclken_in1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SRCLKEN_IN1_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SRCLKEN_IN1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_srclken_in2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SRCLKEN_IN2_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SRCLKEN_IN2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_osc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OSC_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OSC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_srclken_in1_hw_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SRCLKEN_IN1_HW_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SRCLKEN_IN1_HW_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_srclken_in2_hw_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SRCLKEN_IN2_HW_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SRCLKEN_IN2_HW_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_osc_sel_hw_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OSC_SEL_HW_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OSC_SEL_HW_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_srclken_in_sync_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SRCLKEN_IN_SYNC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SRCLKEN_IN_SYNC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_osc_en_auto_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OSC_EN_AUTO_OFF_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OSC_EN_AUTO_OFF_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_test_out(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_TEST_OUT),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_TEST_OUT_MASK),
                           (kal_uint32)(MT6331_PMIC_TEST_OUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_mon_flag_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TEST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_MON_FLAG_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_MON_FLAG_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_mon_grp_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TEST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_MON_GRP_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_MON_GRP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_nandtree_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_NANDTREE_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_NANDTREE_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_test_auxadc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_TEST_AUXADC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_TEST_AUXADC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_efuse_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EFUSE_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EFUSE_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_test_strup(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_TEST_STRUP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_TEST_STRUP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_testmode_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TESTMODE_SW),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_TESTMODE_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_TESTMODE_SW_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_en_status_vdvfs11(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VDVFS11_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VDVFS11_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vdvfs12(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VDVFS12_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VDVFS12_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vdvfs13(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VDVFS13_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VDVFS13_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vdvfs14(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VDVFS14_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VDVFS14_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vgpu(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VGPU_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VGPU_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vcore1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VCORE1_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VCORE1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vcore2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VCORE2_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VCORE2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vio18(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VIO18_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VIO18_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vrtc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VRTC_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VRTC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vtcxo1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VTCXO1_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VTCXO1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vtcxo2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VTCXO2_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VTCXO2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vaud32(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VAUD32_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VAUD32_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vauxa32(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VAUXA32_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VAUXA32_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vcama(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VCAMA_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VCAMA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vio28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VIO28_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VIO28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vcam_af(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VCAM_AF_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VCAM_AF_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vmc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VMC_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VMC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vmch(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VMCH_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VMCH_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vemc33(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VEMC33_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VEMC33_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vgp1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VGP1_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VGP1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vgp4(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VGP4_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VGP4_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vsim1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VSIM1_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VSIM1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vsim2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VSIM2_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VSIM2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vfbb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VFBB_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VFBB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vmipi(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VMIPI_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VMIPI_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vibr(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VIBR_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VIBR_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vcamd(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VCAMD_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VCAMD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vusb10(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VUSB10_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VUSB10_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vcam_io(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VCAM_IO_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VCAM_IO_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vsram_dvfs1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VSRAM_DVFS1_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VSRAM_DVFS1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vgp2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VGP2_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VGP2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vgp3(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VGP3_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VGP3_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_en_status_vbiasn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_EN_STATUS2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VBIASN_MASK),
                           (kal_uint32)(MT6331_PMIC_EN_STATUS_VBIASN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vdvfs11(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VDVFS11_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VDVFS11_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vdvfs12(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VDVFS12_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VDVFS12_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vdvfs13(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VDVFS13_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VDVFS13_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vdvfs14(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VDVFS14_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VDVFS14_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vgpu(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VGPU_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VGPU_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vcore1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VCORE1_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VCORE1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vcore2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VCORE2_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VCORE2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vio18(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VIO18_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VIO18_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vtcxo1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VTCXO1_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VTCXO1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vtcxo2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VTCXO2_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VTCXO2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vaud32(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VAUD32_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VAUD32_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vauxa32(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VAUXA32_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VAUXA32_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vcama(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VCAMA_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VCAMA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vio28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VIO28_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VIO28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vcam_af(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VCAM_AF_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VCAM_AF_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vmc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VMC_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VMC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vmch(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VMCH_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VMCH_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vemc33(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VEMC33_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VEMC33_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vgp1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VGP1_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VGP1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vgp4(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VGP4_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VGP4_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vsim1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VSIM1_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VSIM1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vsim2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VSIM2_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VSIM2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vfbb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VFBB_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VFBB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vmipi(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VMIPI_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VMIPI_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vibr(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VIBR_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VIBR_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vcamd(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VCAMD_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VCAMD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vusb10(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VUSB10_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VUSB10_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vcam_io(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VCAM_IO_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VCAM_IO_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vsram_dvfs1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VSRAM_DVFS1_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VSRAM_DVFS1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vbiasn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VBIASN_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VBIASN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vgp2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VGP2_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VGP2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_oc_status_vgp3(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OCSTATUS2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VGP3_MASK),
                           (kal_uint32)(MT6331_PMIC_OC_STATUS_VGP3_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vtcxo1_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VTCXO1_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VTCXO1_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vaud32_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VAUD32_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VAUD32_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vsram_dvfs1_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vio28_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VIO28_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VIO28_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vusb10_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VUSB10_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VUSB10_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vio18_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VIO18_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VIO18_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vcore2_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VCORE2_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VCORE2_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vcore1_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VCORE1_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VCORE1_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vgpu_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VGPU_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VGPU_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vdvfs14_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VDVFS14_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VDVFS14_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vdvfs13_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VDVFS13_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VDVFS13_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vdvfs12_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VDVFS12_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VDVFS12_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vdvfs11_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VDVFS11_PG_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_VDVFS11_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_pmu_test_mode_scan(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_TOPSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_PMU_TEST_MODE_SCAN_MASK),
                           (kal_uint32)(MT6331_PMIC_PMU_TEST_MODE_SCAN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_pwrkey_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_TOPSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_PWRKEY_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_PWRKEY_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_homekey_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_TOPSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_HOMEKEY_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_HOMEKEY_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rtc_xtal_det_done(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_TOPSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RTC_XTAL_DET_DONE_MASK),
                           (kal_uint32)(MT6331_PMIC_RTC_XTAL_DET_DONE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_xosc32_enb_det(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_TOPSTATUS),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_XOSC32_ENB_DET_MASK),
                           (kal_uint32)(MT6331_PMIC_XOSC32_ENB_DET_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rtc_xtal_det_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOPSTATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RTC_XTAL_DET_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RTC_XTAL_DET_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pmu_tdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PMU_TDSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PMU_TDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_spi_tdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SPI_TDSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SPI_TDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aud_tdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_TDSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_TDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pmu_rdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PMU_RDSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PMU_RDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_spi_rdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SPI_RDSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SPI_RDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aud_rdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_RDSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_RDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_wdtrstb_in(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_WDTRSTB_IN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_WDTRSTB_IN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_homekey(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_HOMEKEY_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_HOMEKEY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_srclken_in1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_SRCLKEN_IN1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_SRCLKEN_IN1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_srclken_in2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_SRCLKEN_IN2_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_SRCLKEN_IN2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_rtc_32k1v8_1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_RTC_32K1V8_1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_RTC_32K1V8_1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_rtc_32k1v8_2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_RTC_32K1V8_2_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_RTC_32K1V8_2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_spi_clk(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_SPI_CLK_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_SPI_CLK_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_spi_csn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_SPI_CSN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_SPI_CSN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_spi_mosi(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_SPI_MOSI_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_SPI_MOSI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_spi_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_SPI_MISO_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_SPI_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_aud_clk(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_AUD_CLK_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_AUD_CLK_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_aud_dat1_mosi(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_AUD_DAT1_MOSI_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_AUD_DAT1_MOSI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_aud_dat1_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_AUD_DAT1_MISO_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_AUD_DAT1_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_aud_dat2_mosi(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_AUD_DAT2_MOSI_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_AUD_DAT2_MOSI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smt_aud_dat2_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SMT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_AUD_DAT2_MISO_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMT_AUD_DAT2_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_srclken_in1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_SRCLKEN_IN1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_SRCLKEN_IN1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_srclken_in2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_SRCLKEN_IN2_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_SRCLKEN_IN2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_rtc_32k1v8_1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_RTC_32K1V8_1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_RTC_32K1V8_1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_rtc_32k1v8_2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_RTC_32K1V8_2_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_RTC_32K1V8_2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_spi_clk(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_SPI_CLK_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_SPI_CLK_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_spi_csn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_SPI_CSN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_SPI_CSN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_spi_mosi(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_SPI_MOSI_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_SPI_MOSI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_spi_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_SPI_MISO_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_SPI_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_aud_dat1_mosi(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_AUD_DAT1_MOSI_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_AUD_DAT1_MOSI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_aud_dat1_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_AUD_DAT1_MISO_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_AUD_DAT1_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_aud_dat2_mosi(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_AUD_DAT2_MOSI_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_AUD_DAT2_MOSI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_aud_dat2_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_AUD_DAT2_MISO_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_AUD_DAT2_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_homekey(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_HOMEKEY_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_HOMEKEY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_octl_aud_clk(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DRV_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_AUD_CLK_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OCTL_AUD_CLK_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_top_status(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_STATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_TOP_STATUS_MASK),
                             (kal_uint32)(MT6331_PMIC_TOP_STATUS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_g_smps_pd_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_G_SMPS_PD_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_G_SMPS_PD_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_g_drv_2m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_G_DRV_2M_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_G_DRV_2M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_accdet_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ACCDET_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ACCDET_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_isink0_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK0_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK0_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_isink1_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK1_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK1_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_isink2_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK2_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK2_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_isink3_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK3_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK3_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auxadc_1m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_1M_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_1M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auxadc_12m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_12M_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_12M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auxadc_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auxadc_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audif_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIF_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIF_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aud_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_zcd13m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ZCD13M_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ZCD13M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_mad13m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_MAD13M_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_MAD13M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rtc_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RTC_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RTC_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rtc_mclk_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RTC_MCLK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RTC_MCLK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rtc_75k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RTC_75K_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RTC_75K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rtcdet_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RTCDET_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RTCDET_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rtc32k_1v8_1_o_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RTC32K_1V8_1_O_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RTC32K_1V8_1_O_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rtc32k_1v8_2_o_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RTC32K_1V8_2_O_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RTC32K_1V8_2_O_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rtc_2sec_off_det_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RTC_2SEC_OFF_DET_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RTC_2SEC_OFF_DET_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_fqmtr_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_FQMTR_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_FQMTR_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_ldostb_1m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LDOSTB_1M_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LDOSTB_1M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_fbb_12m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_FBB_12M_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_FBB_12M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_buck_ana_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BUCK_ANA_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BUCK_ANA_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_buck_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BUCK_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BUCK_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_buck_1m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BUCK_1M_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BUCK_1M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_buck_12m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BUCK_12M_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BUCK_12M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pwmoc_6m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PWMOC_6M_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PWMOC_6M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_intrp_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INTRP_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INTRP_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_strup_75k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_75K_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_75K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_strup_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_efuse_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EFUSE_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EFUSE_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_bgr_test_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_TEST_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_TEST_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smps_ck_div_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMPS_CK_DIV_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMPS_CK_DIV_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_spi_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SPI_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SPI_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_strup_auxadc_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_AUXADC_CK_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_AUXADC_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_top_ckpdn_con2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_TOP_CKPDN_CON2_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_TOP_CKPDN_CON2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audif_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIF_CK_CKSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIF_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aud_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_CK_CKSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_fqmtr_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_FQMTR_CK_CKSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_FQMTR_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_isink0_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK0_CK_CKSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK0_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_isink1_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK1_CK_CKSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK1_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_isink2_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK2_CK_CKSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK2_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_isink3_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK3_CK_CKSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK3_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_strup_75k_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_75K_CK_CKSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_75K_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_bgr_test_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_TEST_CK_CKSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BGR_TEST_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_75k_32k_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_75K_32K_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_75K_32K_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auxadc_ck_divsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_CK_DIVSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_CK_DIVSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_top_cksel_con_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_TOP_CKSEL_CON_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_TOP_CKSEL_CON_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_osc_sel_hw_src_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OSC_SEL_HW_SRC_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OSC_SEL_HW_SRC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_g_smps_pd_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_G_SMPS_PD_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_G_SMPS_PD_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_g_drv_2m_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_G_DRV_2M_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_G_DRV_2M_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auxadc_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_buck_1m_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BUCK_1M_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BUCK_1M_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_efuse_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EFUSE_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EFUSE_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_top_ckhwen_con_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_TOP_CKHWEN_CON_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_TOP_CKHWEN_CON_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pmu75k_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PMU75K_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PMU75K_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smps_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMPS_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMPS_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aud26m_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUD26M_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUD26M_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_mad13m_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_MAD13M_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_MAD13M_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rtc32k_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RTC32K_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RTC32K_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_top_cktst_con0_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_TOP_CKTST_CON0_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_TOP_CKTST_CON0_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_buck_ana_auto_off_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_isink0_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK0_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK0_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_isink1_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK1_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK1_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_isink2_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK2_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK2_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_drv_isink3_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK3_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRV_ISINK3_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_fqmtr_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_FQMTR_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_FQMTR_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rtcdet_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RTCDET_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RTCDET_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pmu75k_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PMU75K_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PMU75K_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_smps_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMPS_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMPS_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aud26m_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUD26M_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUD26M_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_mad13m_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_MAD13M_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_MAD13M_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audif_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIF_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIF_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aud_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_strup_75k_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_75K_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_STRUP_75K_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rtc32k_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RTC32K_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RTC32K_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_top_cktst_con1_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_TOP_CKTST_CON1_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_TOP_CKTST_CON1_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_clksq_en_aud(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CLKSQ),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_CLKSQ_EN_AUD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_CLKSQ_EN_AUD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_clksq_en_fqr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_CLKSQ),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_CLKSQ_EN_FQR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_CLKSQ_EN_FQR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_efuse_man_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EFUSE_MAN_RST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EFUSE_MAN_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auxadc_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_RST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audio_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIO_RST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIO_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_accdet_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ACCDET_RST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ACCDET_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_driver_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DRIVER_RST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DRIVER_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rtc_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RTC_RST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RTC_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_fqmtr_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_FQMTR_RST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_FQMTR_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_top_rst_con_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_TOP_RST_CON_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_TOP_RST_CON_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_wdtrstb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_WDTRSTB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_WDTRSTB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_wdtrstb_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_WDTRSTB_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_WDTRSTB_MODE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_wdtrstb_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_TOP_RST_MISC),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_WDTRSTB_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_WDTRSTB_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_wdtrstb_status_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_WDTRSTB_STATUS_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_WDTRSTB_STATUS_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_wdtrstb_fb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_WDTRSTB_FB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_WDTRSTB_FB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_homekey_rst_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HOMEKEY_RST_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HOMEKEY_RST_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pwrkey_rst_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PWRKEY_RST_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PWRKEY_RST_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pwrrst_tmr_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PWRRST_TMR_DIS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PWRRST_TMR_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pwrkey_rst_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PWRKEY_RST_TD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PWRKEY_RST_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_pwrkey(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_PWRKEY_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_PWRKEY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_homekey(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_HOMEKEY_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_HOMEKEY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_chrdet(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_CHRDET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_CHRDET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_thr_h(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_THR_H_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_THR_H_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_thr_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_THR_L_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_THR_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_bat_h(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_BAT_H_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_BAT_H_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_bat_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_BAT_L_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_BAT_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_rtc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_RTC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_RTC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_audio(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_AUDIO_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_AUDIO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_mad(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_MAD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_MAD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_accdet(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_ACCDET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_ACCDET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_accdet_eint(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_ACCDET_EINT_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_ACCDET_EINT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_accdet_negv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_ACCDET_NEGV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_ACCDET_NEGV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_vdvfs11_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VDVFS11_OC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VDVFS11_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_vdvfs12_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VDVFS12_OC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VDVFS12_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_vdvfs13_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VDVFS13_OC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VDVFS13_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_vdvfs14_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VDVFS14_OC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VDVFS14_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_vgpu_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VGPU_OC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VGPU_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_vcore1_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VCORE1_OC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VCORE1_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_vcore2_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VCORE2_OC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VCORE2_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_vio18_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VIO18_OC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_VIO18_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_en_ldo_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_LDO_OC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_EN_LDO_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_con1_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_CON1_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_CON1_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_con1_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_CON1_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_CON1_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_con1_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_CON1_RSV2_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_CON1_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_int_con1_rsv3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_INT_CON1_RSV3_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_INT_CON1_RSV3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_polarity(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_MISC_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_POLARITY_MASK),
                             (kal_uint32)(MT6331_PMIC_POLARITY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_homekey_int_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_MISC_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HOMEKEY_INT_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HOMEKEY_INT_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pwrkey_int_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_MISC_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PWRKEY_INT_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PWRKEY_INT_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_rg_int_status_pwrkey(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_PWRKEY_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_PWRKEY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_homekey(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_HOMEKEY_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_HOMEKEY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_chrdet(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_CHRDET_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_CHRDET_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_thr_h(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_THR_H_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_THR_H_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_thr_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_THR_L_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_THR_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_bat_h(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_BAT_H_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_BAT_H_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_bat_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_BAT_L_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_BAT_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_rtc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_RTC_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_RTC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_audio(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_AUDIO_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_AUDIO_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_mad(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_MAD_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_MAD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_accdet(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_ACCDET_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_ACCDET_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_accdet_eint(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_ACCDET_EINT_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_ACCDET_EINT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_accdet_negv(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_ACCDET_NEGV_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_ACCDET_NEGV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_vdvfs11_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VDVFS11_OC_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VDVFS11_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_vdvfs12_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VDVFS12_OC_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VDVFS12_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_vdvfs13_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VDVFS13_OC_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VDVFS13_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_vdvfs14_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VDVFS14_OC_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VDVFS14_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_vgpu_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VGPU_OC_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VGPU_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_vcore1_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VCORE1_OC_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VCORE1_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_vcore2_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VCORE2_OC_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VCORE2_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_vio18_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VIO18_OC_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_VIO18_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_int_status_ldo_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_LDO_OC_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_INT_STATUS_LDO_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_oc_gear_ldo(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OC_GEAR_0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_OC_GEAR_LDO_MASK),
                             (kal_uint32)(MT6331_PMIC_OC_GEAR_LDO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_fqmtr_tcksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_FQMTR_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_FQMTR_TCKSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_FQMTR_TCKSEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_fqmtr_busy(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_FQMTR_CON0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_FQMTR_BUSY_MASK),
                           (kal_uint32)(MT6331_PMIC_FQMTR_BUSY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_fqmtr_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_FQMTR_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_FQMTR_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_FQMTR_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_fqmtr_winset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_FQMTR_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_FQMTR_WINSET_MASK),
                             (kal_uint32)(MT6331_PMIC_FQMTR_WINSET_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_fqmtr_data(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_FQMTR_CON2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_FQMTR_DATA_MASK),
                           (kal_uint32)(MT6331_PMIC_FQMTR_DATA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_spi_con(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RG_SPI_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SPI_CON_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SPI_CON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_dew_dio_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DEW_DIO_EN),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DEW_DIO_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_DEW_DIO_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_dew_read_test(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DEW_READ_TEST),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_DEW_READ_TEST_MASK),
                           (kal_uint32)(MT6331_PMIC_DEW_READ_TEST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_dew_write_test(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DEW_WRITE_TEST),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DEW_WRITE_TEST_MASK),
                             (kal_uint32)(MT6331_PMIC_DEW_WRITE_TEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_dew_crc_swrst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DEW_CRC_SWRST),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DEW_CRC_SWRST_MASK),
                             (kal_uint32)(MT6331_PMIC_DEW_CRC_SWRST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_dew_crc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DEW_CRC_EN),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DEW_CRC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_DEW_CRC_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_dew_crc_val(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DEW_CRC_VAL),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_DEW_CRC_VAL_MASK),
                           (kal_uint32)(MT6331_PMIC_DEW_CRC_VAL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_dew_dbg_mon_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DEW_DBG_MON_SEL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DEW_DBG_MON_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_DEW_DBG_MON_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_dew_cipher_key_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DEW_CIPHER_KEY_SEL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DEW_CIPHER_KEY_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_DEW_CIPHER_KEY_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_dew_cipher_iv_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DEW_CIPHER_IV_SEL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DEW_CIPHER_IV_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_DEW_CIPHER_IV_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_dew_cipher_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DEW_CIPHER_EN),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DEW_CIPHER_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_DEW_CIPHER_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_dew_cipher_rdy(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DEW_CIPHER_RDY),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_DEW_CIPHER_RDY_MASK),
                           (kal_uint32)(MT6331_PMIC_DEW_CIPHER_RDY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_dew_cipher_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DEW_CIPHER_MODE),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DEW_CIPHER_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_DEW_CIPHER_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_dew_cipher_swrst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DEW_CIPHER_SWRST),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DEW_CIPHER_SWRST_MASK),
                             (kal_uint32)(MT6331_PMIC_DEW_CIPHER_SWRST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_dew_rddmy_no(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DEW_RDDMY_NO),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DEW_RDDMY_NO_MASK),
                             (kal_uint32)(MT6331_PMIC_DEW_RDDMY_NO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_int_type_con0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_TYPE_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_INT_TYPE_CON0_MASK),
                             (kal_uint32)(MT6331_PMIC_INT_TYPE_CON0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_int_type_con1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_INT_TYPE_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_INT_TYPE_CON1_MASK),
                             (kal_uint32)(MT6331_PMIC_INT_TYPE_CON1_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_cpu_int_sta(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STA),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_CPU_INT_STA_MASK),
                           (kal_uint32)(MT6331_PMIC_CPU_INT_STA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_md32_int_sta(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_INT_STA),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_MD32_INT_STA_MASK),
                           (kal_uint32)(MT6331_PMIC_MD32_INT_STA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_smps_testmode_b(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SMPS_TESTMODE_B_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SMPS_TESTMODE_B_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsleep_src0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSLEEP_SRC0_MASK),
                             (kal_uint32)(MT6331_PMIC_VSLEEP_SRC0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsleep_src1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSLEEP_SRC1_MASK),
                             (kal_uint32)(MT6331_PMIC_VSLEEP_SRC1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_r2r_src0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_R2R_SRC0_MASK),
                             (kal_uint32)(MT6331_PMIC_R2R_SRC0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_r2r_src1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_R2R_SRC1_MASK),
                             (kal_uint32)(MT6331_PMIC_R2R_SRC1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_buck_osc_sel_src0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_BUCK_OSC_SEL_SRC0_MASK),
                             (kal_uint32)(MT6331_PMIC_BUCK_OSC_SEL_SRC0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_srclken_dly_src1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_SRCLKEN_DLY_SRC1_MASK),
                             (kal_uint32)(MT6331_PMIC_SRCLKEN_DLY_SRC1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_buck_con5_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_BUCK_CON5_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_BUCK_CON5_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vgpu_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON5),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_DIG_MON_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vio18_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON5),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_DIG_MON_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vcore1_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON6),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_DIG_MON_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vcore2_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON6),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_DIG_MON_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs13_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON7),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS13_DIG_MON_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS13_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs14_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON7),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS14_DIG_MON_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS14_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs11_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON8),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS11_DIG_MON_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS11_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs12_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON8),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS12_DIG_MON_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS12_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs11_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_WND_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_THD_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_WND_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_THD_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_WND_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_THD_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_WND_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_THD_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_WND_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_THD_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_WND_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_THD_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_WND_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_THD_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_WND_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_THD_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_INT_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_INT_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_INT_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_INT_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_INT_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_INT_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_INT_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_INT_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_vdvfs11_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VDVFS11_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_VDVFS11_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vdvfs12_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VDVFS12_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_VDVFS12_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vdvfs13_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VDVFS13_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_VDVFS13_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vdvfs14_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VDVFS14_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_VDVFS14_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vgpu_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VGPU_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_VGPU_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vcore1_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VCORE1_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_VCORE1_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vcore2_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VCORE2_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_VCORE2_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_vio18_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_VIO18_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_VIO18_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vsram_dvfs1_track_sleep_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_TRACK_SLEEP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_TRACK_SLEEP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_track_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_TRACK_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_TRACK_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs1_track_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS1_TRACK_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS1_TRACK_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_vosel_delta(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_DELTA_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_DELTA_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_vosel_offset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_OFFSET_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_OFFSET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_vosel_on_lb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_ON_LB_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_ON_LB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_vosel_on_hb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_ON_HB_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_ON_HB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_vosel_sleep_lb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_SLEEP_LB_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_SLEEP_LB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_TRIMH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_ALL_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_TRIML_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_TRIMH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_TRIML_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_CSR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_CSL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_ZX_OS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_avp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_AVP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_AVP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_CSM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_MODESET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_SLP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_EN_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_dig1_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_DIG1_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_DIG1_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_dig0_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_DIG0_RSV2_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_DIG0_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_dig1_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_DIG1_RSV2_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_DIG1_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vdvfs11_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS11_STB_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS11_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs11_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS11_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS11_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs11_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS11_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS11_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs11_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_SFCHG_REN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VOSEL_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vdvfs11_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS11_VOSEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS11_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs11_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_TRANS_TD_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vdvfs11_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS11_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS11_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs11_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_R2R_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs11_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS11_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vdvfs11_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS11_R2R_PDN_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS11_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_vdvfs11_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS11_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS11_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vdvfs11_pkmode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_PKMODE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_PKMODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_cs_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_CS_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_CS_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_rc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_RC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_RC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_qi_vdvfs11_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_QI_VDVFS11_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_QI_VDVFS11_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_pfm_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_PFM_CSR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_PFM_CSR_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_rgs_vdvfs11_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RGS_VDVFS11_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_RGS_VDVFS11_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vdvfs11_trans_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_TRANS_BST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_TRANS_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vdvfs1_latch_modeconfig(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON21),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS1_LATCH_MODECONFIG_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS1_LATCH_MODECONFIG_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs1_en_modeconfig(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON21),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS1_EN_MODECONFIG_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS1_EN_MODECONFIG_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vdvfs11_dig0_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_DIG0_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_DIG0_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_qi_vsram_dvfs1_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_QI_VSRAM_DVFS1_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_QI_VSRAM_DVFS1_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs11_dig1_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_DIG1_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS11_DIG1_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vsram_dvfs1_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON25),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VSRAM_DVFS1_VOSEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VSRAM_DVFS1_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vsram_dvfs1_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_SFCHG_REN_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_TRANS_TD_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vsram_dvfs1_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON27),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VSRAM_DVFS1_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VSRAM_DVFS1_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vsram_dvfs1_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_R2R_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vsram_dvfs1_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS11_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VSRAM_DVFS1_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vsram_dvfs1_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON27),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VSRAM_DVFS1_R2R_PDN_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VSRAM_DVFS1_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_vsram_dvfs1_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS11_CON27),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VSRAM_DVFS1_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VSRAM_DVFS1_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vdvfs12_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_TRIMH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_TRIML_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_CSR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_CSL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_ZX_OS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_avp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_AVP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_AVP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_CSM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_MODESET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_SLP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_EN_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_dig1_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_DIG1_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_DIG1_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_dig0_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_DIG0_RSV2_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_DIG0_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_dig1_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_DIG1_RSV2_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_DIG1_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vdvfs12_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS12_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS12_STB_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS12_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs12_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS12_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS12_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS12_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs12_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS12_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS12_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS12_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs12_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_SFCHG_REN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VOSEL_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vdvfs12_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS12_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS12_VOSEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS12_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs12_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_TRANS_TD_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vdvfs12_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS12_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS12_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS12_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs12_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_R2R_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs12_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS12_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vdvfs12_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS12_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS12_R2R_PDN_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS12_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_vdvfs12_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS12_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS12_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS12_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vdvfs12_pkmode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_PKMODE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_PKMODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_cs_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_CS_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_CS_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_rc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_RC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_RC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_qi_vdvfs12_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_QI_VDVFS12_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_QI_VDVFS12_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs12_pfm_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_PFM_CSR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_PFM_CSR_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_rgs_vdvfs12_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS12_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RGS_VDVFS12_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_RGS_VDVFS12_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vdvfs12_trans_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS12_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_TRANS_BST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS12_TRANS_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_TRIMH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_TRIML_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_CSR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_CSL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_ZX_OS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_avp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_AVP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_AVP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_CSM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_MODESET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_SLP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_EN_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_dig1_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_DIG1_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_DIG1_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_dig0_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_DIG0_RSV2_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_DIG0_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_dig1_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_DIG1_RSV2_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_DIG1_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vdvfs13_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS13_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS13_STB_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS13_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs13_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS13_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS13_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS13_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs13_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS13_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS13_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS13_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs13_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_SFCHG_REN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VOSEL_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vdvfs13_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS13_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS13_VOSEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS13_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs13_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_TRANS_TD_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vdvfs13_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS13_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS13_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS13_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs13_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_R2R_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs13_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS13_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vdvfs13_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS13_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS13_R2R_PDN_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS13_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_vdvfs13_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS13_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS13_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS13_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vdvfs13_pkmode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_PKMODE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_PKMODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_cs_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_CS_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_CS_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_rc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_RC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_RC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_qi_vdvfs13_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_QI_VDVFS13_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_QI_VDVFS13_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs13_pfm_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_PFM_CSR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_PFM_CSR_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_rgs_vdvfs13_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS13_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RGS_VDVFS13_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_RGS_VDVFS13_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vdvfs13_trans_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS13_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_TRANS_BST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS13_TRANS_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_TRIMH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_TRIML_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_CSR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_CSL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_ZX_OS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_avp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_AVP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_AVP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_CSM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_MODESET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_SLP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_EN_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_dig1_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_DIG1_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_DIG1_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_dig0_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_DIG0_RSV2_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_DIG0_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_dig1_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_DIG1_RSV2_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_DIG1_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vdvfs14_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS14_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS14_STB_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS14_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs14_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS14_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS14_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS14_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vdvfs14_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS14_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS14_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VDVFS14_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs14_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_SFCHG_REN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VOSEL_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vdvfs14_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS14_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS14_VOSEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS14_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs14_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_TRANS_TD_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vdvfs14_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS14_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS14_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS14_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vdvfs14_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_R2R_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vdvfs14_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VDVFS14_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vdvfs14_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS14_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS14_R2R_PDN_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS14_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_vdvfs14_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS14_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS14_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VDVFS14_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vdvfs14_pkmode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_PKMODE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_PKMODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_cs_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_CS_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_CS_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_rc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_RC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_RC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_qi_vdvfs14_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_QI_VDVFS14_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_QI_VDVFS14_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdvfs14_pfm_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_PFM_CSR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_PFM_CSR_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_rgs_vdvfs14_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VDVFS14_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RGS_VDVFS14_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_RGS_VDVFS14_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vdvfs14_trans_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VDVFS14_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_TRANS_BST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDVFS14_TRANS_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_TRIMH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_TRIML_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_RZSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_cc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_CC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_CC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_CSR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_CSL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_ZX_OS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_CSM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_MODESET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_SLP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_EN_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_dlc_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_burst_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_BURST_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_BURST_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_dlc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_burst_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_BURST_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_BURST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vgpu_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VGPU_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_STB_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vgpu_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VGPU_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vgpu_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VGPU_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vgpu_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_SFCHG_REN_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_VOSEL_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vgpu_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VGPU_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VGPU_VOSEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VGPU_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vgpu_burst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_BURST_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_BURST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_burst_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_BURST_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_BURST_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_burst_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_BURST_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_BURST_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vgpu_burst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VGPU_CON15),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_BURST_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_BURST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vgpu_dlc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_dlc_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_dlc_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vgpu_dlc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VGPU_CON16),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_DLC_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_DLC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vgpu_dlc_n(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_N_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_N_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_dlc_n_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_N_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_N_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_dlc_n_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_N_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_DLC_N_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vgpu_dlc_n(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VGPU_CON17),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_DLC_N_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGPU_DLC_N_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vgpu_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_TRANS_TD_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vgpu_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VGPU_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VGPU_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VGPU_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vgpu_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_R2R_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vgpu_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VGPU_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VGPU_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vgpu_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VGPU_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VGPU_R2R_PDN_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VGPU_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_vgpu_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VGPU_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VGPU_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VGPU_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vgpu_dts_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_DTS_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_DTS_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_tran_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_TRAN_BST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_TRAN_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_qi_vgpu_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_QI_VGPU_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_QI_VGPU_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_qi_vgpu_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_QI_VGPU_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_QI_VGPU_MODE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_rgs_vgpu_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VGPU_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RGS_VGPU_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_RGS_VGPU_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vgpu_pfm_rip(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_PFM_RIP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_PFM_RIP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_rcl_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_RCL_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_RCL_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgpu_rcl_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VGPU_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_RCL_TRIM_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGPU_RCL_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_TRIMH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_TRIML_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_RZSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_cc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_CC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_CC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_CSR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_CSL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_ZX_OS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_avp_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_AVP_OS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_AVP_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_avp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_AVP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_AVP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_CSM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_MODESET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_SLP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_EN_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_dlc_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_burst_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_BURST_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_BURST_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_dlc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_burst_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_BURST_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_BURST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vcore1_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE1_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_STB_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vcore1_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE1_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vcore1_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE1_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vcore1_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_SFCHG_REN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VOSEL_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vcore1_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE1_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE1_VOSEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE1_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vcore1_burst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_BURST_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_BURST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_burst_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_BURST_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_BURST_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_burst_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_BURST_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_BURST_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vcore1_burst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE1_CON15),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_BURST_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_BURST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vcore1_dlc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_dlc_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_dlc_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vcore1_dlc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE1_CON16),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_DLC_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_DLC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vcore1_dlc_n(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_N_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_N_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_dlc_n_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_N_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_N_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_dlc_n_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_N_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_DLC_N_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vcore1_dlc_n(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE1_CON17),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_DLC_N_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE1_DLC_N_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vcore1_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_TRANS_TD_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vcore1_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE1_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE1_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE1_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vcore1_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_R2R_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore1_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE1_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vcore1_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE1_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE1_R2R_PDN_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE1_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_vcore1_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE1_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE1_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE1_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vcore1_dts_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_DTS_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_DTS_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_tran_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_TRAN_BST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_TRAN_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_qi_vcore1_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_QI_VCORE1_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_QI_VCORE1_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_qi_vcore1_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_QI_VCORE1_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_QI_VCORE1_MODE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_rgs_vcore1_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE1_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RGS_VCORE1_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_RGS_VCORE1_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vcore1_pfm_rip(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_PFM_RIP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_PFM_RIP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_rcl_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_RCL_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_RCL_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore1_rcl_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE1_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_RCL_TRIM_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE1_RCL_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_TRIMH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_TRIML_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_RZSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_cc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_CC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_CC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_CSR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_CSL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_ZX_OS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_CSM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_MODESET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_SLP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_EN_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_dlc_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_burst_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_BURST_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_BURST_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_dlc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_burst_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_BURST_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_BURST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vcore2_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE2_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_STB_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vcore2_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE2_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vcore2_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE2_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vcore2_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_SFCHG_REN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VOSEL_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vcore2_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE2_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE2_VOSEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE2_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vcore2_burst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_BURST_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_BURST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_burst_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_BURST_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_BURST_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_burst_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_BURST_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_BURST_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vcore2_burst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE2_CON15),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_BURST_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_BURST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vcore2_dlc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_dlc_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_dlc_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vcore2_dlc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE2_CON16),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_DLC_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_DLC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vcore2_dlc_n(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_N_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_N_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_dlc_n_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_N_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_N_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_dlc_n_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_N_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_DLC_N_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vcore2_dlc_n(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE2_CON17),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_DLC_N_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCORE2_DLC_N_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vcore2_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_TRANS_TD_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vcore2_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE2_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE2_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE2_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vcore2_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_R2R_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vcore2_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VCORE2_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vcore2_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE2_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE2_R2R_PDN_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE2_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_vcore2_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE2_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE2_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VCORE2_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vcore2_dts_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_DTS_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_DTS_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_tran_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_TRAN_BST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_TRAN_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_qi_vcore2_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_QI_VCORE2_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_QI_VCORE2_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_qi_vcore2_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_QI_VCORE2_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_QI_VCORE2_MODE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_rgs_vcore2_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VCORE2_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RGS_VCORE2_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_RGS_VCORE2_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vcore2_pfm_rip(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_PFM_RIP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_PFM_RIP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_rcl_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_RCL_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_RCL_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_rcl_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_RCL_TRIM_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_RCL_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcore2_fbdiv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VCORE2_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_FBDIV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCORE2_FBDIV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_TRIMH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_TRIML_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_RZSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_cc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_CC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_CC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_CSR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_CSL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_ZX_OS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_CSM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_MODESET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_SLP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_VSLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_EN_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_dlc_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_burst_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_BURST_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_BURST_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_dlc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_burst_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_BURST_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_BURST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vio18_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VIO18_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_STB_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vio18_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VIO18_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vio18_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VIO18_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_OC_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vio18_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_SFCHG_REN_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_VOSEL_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vio18_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VIO18_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VIO18_VOSEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VIO18_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vio18_burst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_BURST_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_BURST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_burst_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_BURST_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_BURST_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_burst_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_BURST_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_BURST_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vio18_burst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VIO18_CON15),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_BURST_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_BURST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vio18_dlc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_dlc_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_dlc_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vio18_dlc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VIO18_CON16),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_DLC_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_DLC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vio18_dlc_n(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_N_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_N_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_dlc_n_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_N_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_N_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_dlc_n_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_N_SLEEP_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_DLC_N_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vio18_dlc_n(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VIO18_CON17),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_DLC_N_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VIO18_DLC_N_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vio18_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_TRANS_TD_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vio18_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VIO18_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VIO18_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VIO18_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_vio18_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_R2R_PDN_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_vio18_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_VIO18_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_VIO18_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_vio18_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VIO18_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VIO18_R2R_PDN_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VIO18_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_vio18_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VIO18_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_VIO18_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_VIO18_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vio18_dts_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_DTS_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_DTS_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_tran_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_TRAN_BST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_TRAN_BST_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_rgs_vio18_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_VIO18_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RGS_VIO18_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_RGS_VIO18_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vio18_pfm_rip(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_PFM_RIP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_PFM_RIP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_rcl_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_RCL_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_RCL_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio18_rcl_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_VIO18_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_RCL_TRIM_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO18_RCL_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_k_rst_done(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_K_RST_DONE_MASK),
                             (kal_uint32)(MT6331_PMIC_K_RST_DONE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_k_map_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_K_MAP_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_K_MAP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_k_once_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_K_ONCE_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_K_ONCE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_k_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_K_ONCE_MASK),
                             (kal_uint32)(MT6331_PMIC_K_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_k_start_manual(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_K_START_MANUAL_MASK),
                             (kal_uint32)(MT6331_PMIC_K_START_MANUAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_k_src_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_K_SRC_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_K_SRC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_k_auto_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_K_AUTO_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_K_AUTO_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_k_inv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_K_INV_MASK),
                             (kal_uint32)(MT6331_PMIC_K_INV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_k_control_smps(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_K_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_K_CONTROL_SMPS_MASK),
                             (kal_uint32)(MT6331_PMIC_K_CONTROL_SMPS_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_k_result(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_K_CON2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_K_RESULT_MASK),
                           (kal_uint32)(MT6331_PMIC_K_RESULT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_k_done(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_K_CON2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_K_DONE_MASK),
                           (kal_uint32)(MT6331_PMIC_K_DONE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_k_control(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_K_CON2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_K_CONTROL_MASK),
                           (kal_uint32)(MT6331_PMIC_K_CONTROL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_smps_osc_cal(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_BUCK_K_CON2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_SMPS_OSC_CAL_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_SMPS_OSC_CAL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_k_buck_ck_cnt(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_BUCK_K_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_K_BUCK_CK_CNT_MASK),
                             (kal_uint32)(MT6331_PMIC_K_BUCK_CK_CNT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audzcdenable(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDZCDENABLE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDZCDENABLE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audzcdgainsteptime(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDZCDGAINSTEPTIME_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDZCDGAINSTEPTIME_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audzcdgainstepsize(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDZCDGAINSTEPSIZE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDZCDGAINSTEPSIZE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audzcdtimeoutmodesel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDZCDTIMEOUTMODESEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDZCDTIMEOUTMODESEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audzcdclksel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDZCDCLKSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDZCDCLKSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audzcdmuxsel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDZCDMUXSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDZCDMUXSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlolgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLGAIN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLGAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlorgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORGAIN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORGAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhplgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLGAIN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLGAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhprgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRGAIN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRGAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhsgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHSGAIN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHSGAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audivlgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIVLGAIN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIVLGAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audivrgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ZCD_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIVRGAIN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIVRGAIN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_rg_audintgain1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ZCD_CON5),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_AUDINTGAIN1_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_AUDINTGAIN1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_audintgain2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ZCD_CON5),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_AUDINTGAIN2_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_AUDINTGAIN2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_isink_ch0_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH0_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH0_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK0_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK0_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_dim0_fsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM0_FSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM0_FSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_sfstr0_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR0_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR0_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_sfstr0_tc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR0_TC_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR0_TC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_dim0_duty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM0_DUTY_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM0_DUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch0_step(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH0_STEP_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH0_STEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath0_tf2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH0_TF2_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH0_TF2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath0_tf1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH0_TF1_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH0_TF1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath0_tr2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH0_TR2_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH0_TR2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath0_tr1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH0_TR1_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH0_TR1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath0_toff_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH0_TOFF_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH0_TOFF_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath0_ton_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK0_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH0_TON_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH0_TON_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch1_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH1_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH1_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink1_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK1_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK1_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink1_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK1_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK1_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_dim1_fsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM1_FSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM1_FSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_sfstr1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR1_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_sfstr1_tc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR1_TC_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR1_TC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_dim1_duty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM1_DUTY_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM1_DUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch1_step(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH1_STEP_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH1_STEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath1_tf2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH1_TF2_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH1_TF2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath1_tf1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH1_TF1_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH1_TF1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath1_tr2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH1_TR2_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH1_TR2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath1_tr1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH1_TR1_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH1_TR1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath1_toff_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH1_TOFF_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH1_TOFF_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath1_ton_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK1_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH1_TON_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH1_TON_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch2_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH2_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH2_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink2_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK2_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK2_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink2_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK2_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK2_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_dim2_fsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM2_FSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM2_FSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_sfstr2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR2_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_sfstr2_tc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR2_TC_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR2_TC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_dim2_duty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM2_DUTY_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM2_DUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch2_step(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH2_STEP_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH2_STEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath2_tf2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH2_TF2_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH2_TF2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath2_tf1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH2_TF1_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH2_TF1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath2_tr2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH2_TR2_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH2_TR2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath2_tr1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH2_TR1_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH2_TR1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath2_toff_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH2_TOFF_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH2_TOFF_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath2_ton_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK2_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH2_TON_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH2_TON_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch3_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH3_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH3_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink3_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK3_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK3_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink3_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK3_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK3_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_dim3_fsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM3_FSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM3_FSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_sfstr3_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR3_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR3_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_sfstr3_tc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR3_TC_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_SFSTR3_TC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_dim3_duty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM3_DUTY_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_DIM3_DUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch3_step(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH3_STEP_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH3_STEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath3_tf2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH3_TF2_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH3_TF2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath3_tf1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH3_TF1_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH3_TF1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath3_tr2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH3_TR2_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH3_TR2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath3_tr1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH3_TR1_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH3_TR1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath3_toff_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH3_TOFF_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH3_TOFF_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_breath3_ton_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK3_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH3_TON_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_BREATH3_TON_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_isinks_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ISINKS_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ISINKS_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_isink3_double_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ISINK3_DOUBLE_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ISINK3_DOUBLE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_isink2_double_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ISINK2_DOUBLE_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ISINK2_DOUBLE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_isink1_double_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ISINK1_DOUBLE_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ISINK1_DOUBLE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_isink0_double_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ISINK0_DOUBLE_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ISINK0_DOUBLE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_trim_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_TRIM_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_TRIM_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_TRIM_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ni_isink3_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ISINK_ANA1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_ISINK3_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_ISINK3_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_isink2_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ISINK_ANA1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_ISINK2_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_ISINK2_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_isink1_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ISINK_ANA1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_ISINK1_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_ISINK1_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_isink0_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ISINK_ANA1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_ISINK0_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_ISINK0_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_isink_phase0_dly_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_PHASE0_DLY_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_PHASE0_DLY_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_phase1_dly_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_PHASE1_DLY_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_PHASE1_DLY_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_phase2_dly_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_PHASE2_DLY_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_PHASE2_DLY_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_phase3_dly_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_PHASE3_DLY_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_PHASE3_DLY_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_phase_dly_tc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_PHASE_DLY_TC_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_PHASE_DLY_TC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch0_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH0_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH0_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH1_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH2_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch3_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH3_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH3_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_chop0_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CHOP0_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CHOP0_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_chop1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CHOP1_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CHOP1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_chop2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CHOP2_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CHOP2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_chop3_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CHOP3_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CHOP3_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch0_bias_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH0_BIAS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH0_BIAS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch1_bias_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH1_BIAS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH1_BIAS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch2_bias_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH2_BIAS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH2_BIAS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_isink_ch3_bias_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH3_BIAS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ISINK_CH3_BIAS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aldo_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ALDO_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ALDO_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo1_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo1_lp_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_LP_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_LP_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo1_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vtcxo1_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VTCXO1_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VTCXO1_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vtcxo1_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo1_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo1_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vtcxo1_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VTCXO1_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VTCXO1_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vtcxo2_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo2_lp_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_LP_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_LP_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo2_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vtcxo2_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VTCXO2_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VTCXO2_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vtcxo2_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo2_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo2_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vtcxo2_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VTCXO2_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VTCXO2_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vaud32_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vaud32_lp_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_LP_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_LP_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vaud32_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vaud32_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON3),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VAUD32_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VAUD32_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vaud32_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vaud32_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vaud32_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vaud32_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vaud32_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON3),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VAUD32_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VAUD32_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vauxa32_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vauxa32_lp_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_LP_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_LP_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vauxa32_auxadc_pwdb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_AUXADC_PWDB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_AUXADC_PWDB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vauxa32_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vauxa32_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON4),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VAUXA32_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VAUXA32_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vauxa32_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vauxa32_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vauxa32_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vauxa32_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vauxa32_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON4),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VAUXA32_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VAUXA32_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vcama_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcama_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vauxa32_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vauxa32_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vauxa32_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo1_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo1_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo1_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo2_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo2_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo2_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcama_fbsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_FBSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_FBSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcama_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcama_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcama_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vaud32_fbsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_FBSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_FBSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vaud32_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vaud32_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vaud32_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcama_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMA_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vauxa32_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUXA32_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vaud32_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VAUD32_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo2_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO2_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtcxo1_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTCXO1_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_analdo_degtd_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ANALDO_DEGTD_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ANALDO_DEGTD_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vcama_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON12),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCAMA_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCAMA_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vauxa32_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON12),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VAUXA32_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VAUXA32_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vaud32_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON12),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VAUD32_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VAUD32_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vtcxo2_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON12),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VTCXO2_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VTCXO2_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vtcxo1_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ANALDO_CON12),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VTCXO1_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VTCXO1_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_analdo_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ANALDO_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ANALDO_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_analdo_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ANALDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ANALDO_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ANALDO_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_sysldo1_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SYSLDO1_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SYSLDO1_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_sysldo2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SYSLDO2_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SYSLDO2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_sysldo3_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SYSLDO3_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SYSLDO3_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcamd_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcamd_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcamd_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vcamd_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCAMD_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCAMD_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vcamd_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcamd_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vusb10_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vusb10_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vusb10_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vusb10_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VUSB10_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VUSB10_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vusb10_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vusb10_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vusb10_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VUSB10_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VUSB10_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vcam_io_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_io_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_io_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vcam_io_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON3),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCAM_IO_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCAM_IO_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vcam_io_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_io_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vsram_dvfs1_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON4),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VSRAM_DVFS1_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VSRAM_DVFS1_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vsram_dvfs1_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vsram_dvfs1_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON4),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VSRAM_DVFS1_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VSRAM_DVFS1_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vmipi_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmipi_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmipi_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vmipi_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON5),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VMIPI_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VMIPI_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vmipi_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmipi_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmipi_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmipi_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vmipi_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON5),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VMIPI_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VMIPI_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vgp2_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp2_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp2_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vgp2_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON6),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGP2_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGP2_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vgp2_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp3_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp3_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp3_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vgp3_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON7),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGP3_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGP3_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vgp3_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp3_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vbiasn_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vbiasn_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vbiasn_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vbiasn_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON8),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VBIASN_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VBIASN_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vbiasn_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vbiasn_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vbiasn_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON8),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VBIASN_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VBIASN_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vcamd_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcamd_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcamd_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vusb10_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vusb10_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vusb10_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_io_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_io_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_io_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_ndis_plcur(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_NDIS_PLCUR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_NDIS_PLCUR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_power_down_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_POWER_DOWN_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_POWER_DOWN_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_cmp_debug_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_CMP_DEBUG_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_CMP_DEBUG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmipi_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmipi_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmipi_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp2_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp2_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp2_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp3_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp3_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp3_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vbiasn_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vbiasn_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vbiasn_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_RSV2_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vbiasn_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vbiasn_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp3_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP3_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp2_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP2_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmipi_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMIPI_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsram_dvfs1_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSRAM_DVFS1_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_io_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_IO_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vusb10_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VUSB10_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcamd_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAMD_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_sysldo_degtd_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_SYSLDO_DEGTD_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_SYSLDO_DEGTD_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vbiasn_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VBIASN_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VBIASN_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vgp3_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGP3_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGP3_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vgp2_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGP2_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGP2_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vmipi_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VMIPI_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VMIPI_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vsram_dvfs1_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VSRAM_DVFS1_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VSRAM_DVFS1_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vcam_io_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCAM_IO_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCAM_IO_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vusb10_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VUSB10_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VUSB10_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vcamd_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_SYSLDO_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCAMD_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCAMD_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vbiasn_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBIASN_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_sysldo_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SYSLDO_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SYSLDO_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_sysldo_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_SYSLDO_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SYSLDO_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SYSLDO_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_dldo3_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DLDO3_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DLDO3_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_dldo2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DLDO2_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DLDO2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_dldo1_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DLDO1_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DLDO1_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio28_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio28_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio28_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vio28_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VIO28_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VIO28_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vio28_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio28_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vio28_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VIO28_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VIO28_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vcam_af_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_af_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_af_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vcam_af_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCAM_AF_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCAM_AF_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vcam_af_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_af_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmc_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmc_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmc_int_dis_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_INT_DIS_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_INT_DIS_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmc_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vmc_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON3),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VMC_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VMC_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vmc_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmc_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmc_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vmc_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON3),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VMC_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VMC_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vmch_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmch_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmch_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vmch_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON4),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VMCH_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VMCH_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vmch_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmch_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmch_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmch_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vmch_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON4),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VMCH_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VMCH_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vemc33_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vemc33_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vemc33_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vemc33_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON5),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VEMC33_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VEMC33_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vemc33_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vemc33_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vemc33_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vemc33_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vemc33_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON5),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VEMC33_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VEMC33_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vgp1_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp1_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp1_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vgp1_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON6),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGP1_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGP1_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vgp1_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp4_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp4_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp4_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vgp4_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON7),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGP4_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGP4_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vgp4_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp4_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim1_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim1_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim1_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vsim1_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON8),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VSIM1_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VSIM1_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vsim1_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim1_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim1_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vsim1_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON8),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VSIM1_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VSIM1_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vsim2_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim2_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim2_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vsim2_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VSIM2_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VSIM2_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vsim2_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim2_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_ON_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim2_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vsim2_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VSIM2_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VSIM2_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vfbb_rstb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_RSTB_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_RSTB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vfbb_rstb_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_RSTB_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_RSTB_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vfbb_rstb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON10),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VFBB_RSTB_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VFBB_RSTB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vfbb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vfbb_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_EN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vfbb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON10),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VFBB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VFBB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vrtc_force_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VRTC_FORCE_ON_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VRTC_FORCE_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vrtc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VRTC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VRTC_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vrtc_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON11),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VRTC_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VRTC_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vibr_lp_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_LP_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_LP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vibr_lp_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_LP_MODE_SET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_LP_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vibr_ther_shen_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_THER_SHEN_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_THER_SHEN_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vibr_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vibr_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON12),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VIBR_MODE_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VIBR_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vibr_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_STBTD_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vibr_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio28_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio28_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio28_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_af_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_af_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_af_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmc_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmc_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmc_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmch_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmch_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmch_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vemc33_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vemc33_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vemc33_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp4_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp4_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp4_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp1_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp1_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp1_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vibr_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vibr_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vibr_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim1_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim1_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim1_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim2_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_NDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim2_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim2_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_CAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vfbb_recovery(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_RECOVERY_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_RECOVERY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vfbb_slew_cntrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_SLEW_CNTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_SLEW_CNTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vfbb_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vfbb_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vibr_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIBR_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim2_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM2_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vsim1_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VSIM1_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp4_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP4_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vgp1_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VGP1_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vemc33_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VEMC33_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmch_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMCH_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vmc_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VMC_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcam_af_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCAM_AF_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vio28_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_OCFB_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VIO28_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_digldo_degtd_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_DIGLDO_DEGTD_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_DIGLDO_DEGTD_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_qi_vibr_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON25),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VIBR_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VIBR_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vsim2_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON25),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VSIM2_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VSIM2_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vsim1_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON25),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VSIM1_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VSIM1_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vgp4_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON25),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGP4_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGP4_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vgp1_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON25),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VGP1_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VGP1_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vemc33_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON25),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VEMC33_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VEMC33_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vmch_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON25),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VMCH_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VMCH_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vmc_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON25),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VMC_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VMC_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vcam_af_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON25),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VCAM_AF_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VCAM_AF_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_qi_vio28_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_DIGLDO_CON25),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_QI_VIO28_OCFB_EN_MASK),
                           (kal_uint32)(MT6331_PMIC_QI_VIO28_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vfbb_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VFBB_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_digldo_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DIGLDO_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DIGLDO_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_digldo_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DIGLDO_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DIGLDO_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdig18_srclken_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDIG18_SRCLKEN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDIG18_SRCLKEN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdig18_sleep_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDIG18_SLEEP_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDIG18_SLEEP_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdig18_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDIG18_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDIG18_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vdig18_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_DIGLDO_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VDIG18_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VDIG18_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_pa(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PA_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PA_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_pdin(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PDIN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PDIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_ptm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PTM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PTM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_pwe(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PWE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PWE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_pprog(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PPROG_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PPROG_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_pwe_src(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PWE_SRC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PWE_SRC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_prog_pkey(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PROG_PKEY_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_PROG_PKEY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_rd_pkey(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_RD_PKEY_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_RD_PKEY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_rd_trig(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_RD_TRIG_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_RD_TRIG_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rd_rdy_bypass(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RD_RDY_BYPASS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RD_RDY_BYPASS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_skip_otp_out(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SKIP_OTP_OUT_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SKIP_OTP_OUT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_rd_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_RD_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_RD_SW_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_sw(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_CON12),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_SW_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_SW_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_rd_busy(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_CON13),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_RD_BUSY_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_RD_BUSY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_rd_ack(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_CON13),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_RD_ACK_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_RD_ACK_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_pa_sw(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_PA_SW_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_PA_SW_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_0_15(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_0_15),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_0_15_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_0_15_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_16_31(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_16_31),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_16_31_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_16_31_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_32_47(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_32_47),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_32_47_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_32_47_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_48_63(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_48_63),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_48_63_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_48_63_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_64_79(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_64_79),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_64_79_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_64_79_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_80_95(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_80_95),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_80_95_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_80_95_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_96_111(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_96_111),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_96_111_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_96_111_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_112_127(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_112_127),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_112_127_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_112_127_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_128_143(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_128_143),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_128_143_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_128_143_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_144_159(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_144_159),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_144_159_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_144_159_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_160_175(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_160_175),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_160_175_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_160_175_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_176_191(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_176_191),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_176_191_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_176_191_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_192_207(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_192_207),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_192_207_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_192_207_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_208_223(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_208_223),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_208_223_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_208_223_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_224_239(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_224_239),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_224_239_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_224_239_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_rg_otp_dout_240_255(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_OTP_DOUT_240_255),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_240_255_MASK),
                           (kal_uint32)(MT6331_PMIC_RG_OTP_DOUT_240_255_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_otp_val_0_15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_0_15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_0_15_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_0_15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_16_31(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_16_31),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_16_31_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_16_31_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_32_47(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_32_47),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_32_47_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_32_47_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_48_63(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_48_63),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_48_63_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_48_63_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_64_79(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_64_79),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_64_79_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_64_79_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_80_95(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_80_95),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_80_95_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_80_95_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_96_111(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_96_111),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_96_111_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_96_111_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_112_127(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_112_127),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_112_127_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_112_127_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_128_143(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_128_143),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_128_143_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_128_143_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_144_159(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_144_159),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_144_159_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_144_159_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_160_175(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_160_175),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_160_175_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_160_175_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_176_191(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_176_191),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_176_191_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_176_191_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_192_207(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_192_207),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_192_207_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_192_207_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_208_223(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_208_223),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_208_223_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_208_223_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_224_239(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_224_239),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_224_239_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_224_239_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_otp_val_240_255(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_OTP_VAL_240_255),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_240_255_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_OTP_VAL_240_255_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_mix_eosc32_opt(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_EOSC32_OPT_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_EOSC32_OPT_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_mix_xosc32_stp_cpdtb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_RTC_MIX_CON0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_MIX_XOSC32_STP_CPDTB_MASK),
                           (kal_uint32)(MT6331_PMIC_MIX_XOSC32_STP_CPDTB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_mix_xosc32_stp_pwdb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_XOSC32_STP_PWDB_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_XOSC32_STP_PWDB_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_mix_xosc32_stp_lpdtb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_RTC_MIX_CON0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_MIX_XOSC32_STP_LPDTB_MASK),
                           (kal_uint32)(MT6331_PMIC_MIX_XOSC32_STP_LPDTB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_mix_xosc32_stp_lpden(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_XOSC32_STP_LPDEN_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_XOSC32_STP_LPDEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_mix_xosc32_stp_lpdrst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_XOSC32_STP_LPDRST_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_XOSC32_STP_LPDRST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_mix_xosc32_stp_cali(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_XOSC32_STP_CALI_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_XOSC32_STP_CALI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_stmp_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_STMP_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_STMP_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_mix_eosc32_stp_chop_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_EOSC32_STP_CHOP_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_EOSC32_STP_CHOP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_mix_dcxo_stp_lvsh_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_DCXO_STP_LVSH_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_DCXO_STP_LVSH_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_mix_pmu_stp_ddlo_vrtc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_PMU_STP_DDLO_VRTC_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_PMU_STP_DDLO_VRTC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_mix_pmu_stp_ddlo_vrtc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_PMU_STP_DDLO_VRTC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_PMU_STP_DDLO_VRTC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_mix_rtc_stp_xosc32_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_RTC_STP_XOSC32_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_RTC_STP_XOSC32_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_mix_dcxo_stp_test_deglitch_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_mix_eosc32_stp_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_EOSC32_STP_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_EOSC32_STP_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_mix_eosc32_vct_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_EOSC32_VCT_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_EOSC32_VCT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_mix_stp_bbwakeup(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_STP_BBWAKEUP_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_STP_BBWAKEUP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_mix_stp_rtc_ddlo(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_RTC_MIX_CON1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_MIX_STP_RTC_DDLO_MASK),
                           (kal_uint32)(MT6331_PMIC_MIX_STP_RTC_DDLO_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_mix_rtc_xosc32_enb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_RTC_MIX_CON1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_MIX_RTC_XOSC32_ENB_MASK),
                           (kal_uint32)(MT6331_PMIC_MIX_RTC_XOSC32_ENB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_mix_efuse_xosc32_enb_opt(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_MIX_EFUSE_XOSC32_ENB_OPT_MASK),
                             (kal_uint32)(MT6331_PMIC_MIX_EFUSE_XOSC32_ENB_OPT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auddaclpwrup_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDAC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDACLPWRUP_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDACLPWRUP_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auddacrpwrup_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDAC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDACRPWRUP_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDACRPWRUP_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aud_dac_pwr_up_va32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDAC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_DAC_PWR_UP_VA32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_DAC_PWR_UP_VA32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aud_dac_pwl_up_va32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDAC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_DAC_PWL_UP_VA32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_DAC_PWL_UP_VA32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhspwrup_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHSPWRUP_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHSPWRUP_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhplpwrup_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLPWRUP_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLPWRUP_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhprpwrup_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRPWRUP_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRPWRUP_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhsmuxinputsel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHSMUXINPUTSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHSMUXINPUTSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhplmuxinputsel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhprmuxinputsel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhsscdisable_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHSSCDISABLE_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHSSCDISABLE_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhplscdisable_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLSCDISABLE_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLSCDISABLE_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhprscdisable_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRSCDISABLE_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRSCDISABLE_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhplbsccurrent_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLBSCCURRENT_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLBSCCURRENT_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhprbsccurrent_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRBSCCURRENT_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRBSCCURRENT_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhsbsccurrent_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHSBSCCURRENT_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHSBSCCURRENT_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhpstartup_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPSTARTUP_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPSTARTUP_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhsstartup_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHSSTARTUP_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHSSTARTUP_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audbgbon_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDBGBON_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDBGBON_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_prechargebuf_en_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PRECHARGEBUF_EN_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PRECHARGEBUF_EN_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hpinputstbenh_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HPINPUTSTBENH_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HPINPUTSTBENH_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hpoutputstbenh_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HPOUTPUTSTBENH_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HPOUTPUTSTBENH_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hpinputreset0_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HPINPUTRESET0_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HPINPUTRESET0_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hpoutputreset0_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HPOUTPUTRESET0_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HPOUTPUTRESET0_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hpout_shortvcm_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HPOUT_SHORTVCM_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HPOUT_SHORTVCM_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_linenoiseenh_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LINENOISEENH_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LINENOISEENH_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hsinputstbenh_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HSINPUTSTBENH_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HSINPUTSTBENH_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hsoutputstbenh_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HSOUTPUTSTBENH_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HSOUTPUTSTBENH_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hsinputreset0_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HSINPUTRESET0_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HSINPUTRESET0_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hsoutputreset0_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HSOUTPUTRESET0_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HSOUTPUTRESET0_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hpoutstb_rsel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HPOUTSTB_RSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HPOUTSTB_RSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hsout_shortvcm_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HSOUT_SHORTVCM_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HSOUT_SHORTVCM_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhpltrim_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLTRIM_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLTRIM_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhprtrim_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRTRIM_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRTRIM_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhptrim_en_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPTRIM_EN_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPTRIM_EN_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhplfinetrim_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLFINETRIM_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPLFINETRIM_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhprfinetrim_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRFINETRIM_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPRFINETRIM_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_abidec_rsvd0_va32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ABIDEC_RSVD0_VA32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ABIDEC_RSVD0_VA32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_abidec_rsvd1_va32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ABIDEC_RSVD1_VA32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ABIDEC_RSVD1_VA32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_abidec_rsvd0_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ABIDEC_RSVD0_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ABIDEC_RSVD0_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_abidec_rsvd1_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ABIDEC_RSVD1_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ABIDEC_RSVD1_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlolpwrup_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLPWRUP_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLPWRUP_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlorpwrup_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORPWRUP_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORPWRUP_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlolmuxinputsel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLMUXINPUTSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLMUXINPUTSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlormuxinputsel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORMUXINPUTSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORMUXINPUTSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlolscdisable_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLSCDISABLE_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLSCDISABLE_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlorscdisable_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORSCDISABLE_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORSCDISABLE_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlolbsccurrent_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLBSCCURRENT_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLBSCCURRENT_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlorbsccurrent_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORBSCCURRENT_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORBSCCURRENT_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlostartup_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOSTARTUP_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOSTARTUP_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhpspkdet_inputmuxsel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhpspkdet_outputmuxsel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_loinputstbenh_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LOINPUTSTBENH_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LOINPUTSTBENH_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_looutputstbenh_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LOOUTPUTSTBENH_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LOOUTPUTSTBENH_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_loinputreset0_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LOINPUTRESET0_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LOINPUTRESET0_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_looutputreset0_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LOOUTPUTRESET0_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LOOUTPUTRESET0_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_loout_shortvcm_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LOOUT_SHORTVCM_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LOOUT_SHORTVCM_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_looutstb_rsel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LOOUTSTB_RSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LOOUTSTB_RSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audtrimbuf_gainsel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audtrimbuf_inputmuxsel_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audloltrim_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLTRIM_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLTRIM_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlortrim_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORTRIM_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORTRIM_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlotrim_en_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOTRIM_EN_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOTRIM_EN_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlolfinetrim_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLFINETRIM_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLOLFINETRIM_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audlorfinetrim_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORFINETRIM_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDLORFINETRIM_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audtrimbuf_en_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDTRIMBUF_EN_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDTRIMBUF_EN_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audhpspkdet_en_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDBUF_CFG8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPSPKDET_EN_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDHPSPKDET_EN_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audbiasadj_0_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_IBIASDIST_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDBIASADJ_0_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDBIASADJ_0_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audibiaspwrdn_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_IBIASDIST_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIBIASPWRDN_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDIBIASPWRDN_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rstb_decoder_va32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDCLKGEN_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RSTB_DECODER_VA32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RSTB_DECODER_VA32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rstb_encoder_va32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDCLKGEN_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RSTB_ENCODER_VA32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RSTB_ENCODER_VA32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_sel_decoder_96k_va32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDCLKGEN_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SEL_DECODER_96K_VA32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SEL_DECODER_96K_VA32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_sel_encoder_96k_va32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDCLKGEN_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SEL_ENCODER_96K_VA32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SEL_ENCODER_96K_VA32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_sel_delay_vcore(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDCLKGEN_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SEL_DELAY_VCORE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SEL_DELAY_VCORE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audbiasadj_1_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDCLKGEN_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDBIASADJ_1_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDBIASADJ_1_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hcldo_pddis_en_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HCLDO_PDDIS_EN_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HCLDO_PDDIS_EN_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hcldo_remote_sense_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HCLDO_REMOTE_SENSE_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HCLDO_REMOTE_SENSE_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo_pddis_en_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_PDDIS_EN_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_PDDIS_EN_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo_remote_sense_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_REMOTE_SENSE_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_REMOTE_SENSE_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo_enc_pddis_en_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_ENC_PDDIS_EN_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_ENC_PDDIS_EN_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo_enc_remote_sense_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_ENC_REMOTE_SENSE_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_ENC_REMOTE_SENSE_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpmu_reserved_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPMU_RESERVED_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPMU_RESERVED_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpmu_reserved_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPMU_RESERVED_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPMU_RESERVED_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_dcdc_remote_sense_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDCDC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DCDC_REMOTE_SENSE_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DCDC_REMOTE_SENSE_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_rsel_vn18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDCDC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_RSEL_VN18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_RSEL_VN18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vtfcv_disable_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDCDC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VTFCV_DISABLE_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VTFCV_DISABLE_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_chgboost_vbat(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDCDC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_CHGBOOST_VBAT_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_CHGBOOST_VBAT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_enb_vn_track_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDCDC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ENB_VN_TRACK_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ENB_VN_TRACK_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auddcdc_rsvd_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDCDC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDCDC_RSVD_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDCDC_RSVD_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auddcdc_rsvd_vbat(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDCDC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDCDC_RSVD_VBAT_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDCDC_RSVD_VBAT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audglb_pwrdn_va32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDNVREGGLB_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDGLB_PWRDN_VA32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDGLB_PWRDN_VA32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo_enc_en_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUD_NCP0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_ENC_EN_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_ENC_EN_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo_en_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUD_NCP0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_EN_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_EN_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_hcldo_en_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUD_NCP0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_HCLDO_EN_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_HCLDO_EN_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_ncp_remote_sense_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUD_NCP0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_NCP_REMOTE_SENSE_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_NCP_REMOTE_SENSE_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aud_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUD_ZCD_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aud_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUD_ZCD_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUD_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch0_1on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH0_1ON_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH0_1ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch0_1dccen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH0_1DCCEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH0_1DCCEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch0_1dcrpecharge(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH0_1DCRPECHARGE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH0_1DCRPECHARGE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch0_1pgatest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH0_1PGATEST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH0_1PGATEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch0_1inputsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH0_1INPUTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH0_1INPUTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_2on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_2ON_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_2ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_2dccen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_2DCCEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_2DCCEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_2dcrpecharge(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_2DCRPECHARGE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_2DCRPECHARGE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_2pgatest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_2PGATEST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_2PGATEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampchopen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCHOPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCHOPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampopenh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPOPENH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPOPENH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampaafen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPAAFEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPAAFEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampcapvalen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCAPVALEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCAPVALEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audsparepga(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDSPAREPGA_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDSPAREPGA_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcch0_1pwrup(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH0_1PWRUP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH0_1PWRUP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcch0_1inputsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH0_1INPUTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH0_1INPUTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcch0_1spare(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH0_1SPARE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH0_1SPARE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcch_2pwrup(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH_2PWRUP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH_2PWRUP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcch_2inputsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH_2INPUTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH_2INPUTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcch_3pwrup(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH_3PWRUP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH_3PWRUP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcch_3inputsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH_3INPUTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH_3INPUTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcch_4pwrup(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH_4PWRUP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH_4PWRUP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcch_4inputsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH_4INPUTSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCH_4INPUTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_3on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_3ON_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_3ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_3dccen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_3DCCEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_3DCCEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_3dcrpecharge(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_3DCRPECHARGE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_3DCRPECHARGE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_3pgatest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_3PGATEST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_3PGATEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_4on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_4ON_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_4ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_4dccen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_4DCCEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_4DCCEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_4dcrpecharge(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_4DCRPECHARGE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_4DCRPECHARGE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_4pgatest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_4PGATEST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_4PGATEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampiddtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPIDDTEST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPIDDTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreamplpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMP_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPLPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPLPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadc1ststageiddtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADC1STSTAGEIDDTEST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADC1STSTAGEIDDTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadc2ndstageiddtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADC2NDSTAGEIDDTEST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADC2NDSTAGEIDDTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcrefbufiddtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCREFBUFIDDTEST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCREFBUFIDDTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcflashiddtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCFLASHIDDTEST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCFLASHIDDTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadc1ststagelpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADC1STSTAGELPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADC1STSTAGELPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadc2ndstagelpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADC2NDSTAGELPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADC2NDSTAGELPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcclkrstb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCLKRSTB_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCLKRSTB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcflashlpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCFLASHLPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCFLASHLPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcclksource(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCLKSOURCE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCLKSOURCE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcclkgenmode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCLKGENMODE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCLKGENMODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcclksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCLKSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCCLKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcwidecm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCWIDECM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCWIDECM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadc2ndstagereset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADC2NDSTAGERESET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADC2NDSTAGERESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadc3rdstagereset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADC3RDSTAGERESET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADC3RDSTAGERESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcfsreset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCFSRESET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCFSRESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcnopatest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCNOPATEST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCNOPATEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcbypass(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCBYPASS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCBYPASS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcffbypass(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCFFBYPASS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCFFBYPASS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcdacfbcurrent(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCDACFBCURRENT_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCDACFBCURRENT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcdaciddtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCDACIDDTEST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCDACIDDTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcdacnrz(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCDACNRZ_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCDACNRZ_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcnodem(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCNODEM_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCNODEM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcdactest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCDACTEST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCDACTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadcdac0p25fs(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCDAC0P25FS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCDAC0P25FS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audulhalfbias(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDULHALFBIAS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDULHALFBIAS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audadctestdata(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCTESTDATA_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDADCTESTDATA_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audrctunech0_1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH0_1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH0_1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audrctunech0_1sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH0_1SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH0_1SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audrctunech_2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH_2_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH_2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audrctunech_2sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH_2SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH_2SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audrctunech_3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH_3_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH_3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audrctunech_3sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH_3SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH_3SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audrctunech_4(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH_4_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH_4_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audrctunech_4sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH_4SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDRCTUNECH_4SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audspareva28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDSPAREVA28_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDSPAREVA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audspareva18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDADC_CFG5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDSPAREVA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDSPAREVA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auddigmic0en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC0EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC0EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auddigmic0pduty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC0PDUTY_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC0PDUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auddigmic0nduty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC0NDUTY_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC0NDUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auddigmic0bias(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC0BIAS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC0BIAS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_dmic0monen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DMIC0MONEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DMIC0MONEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_dmic0hpclken(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DMIC0HPCLKEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DMIC0HPCLKEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auddigmic1en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC1EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC1EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auddigmic1pduty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC1PDUTY_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC1PDUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auddigmic1nduty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC1NDUTY_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC1NDUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auddigmic1bias(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC1BIAS_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDDIGMIC1BIAS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_dmic1monen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DMIC1MONEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DMIC1MONEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_dmic1monsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DMIC1MONSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DMIC1MONSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_dmic1hpclken(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_DMIC1HPCLKEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_DMIC1HPCLKEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audsparevmic(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDDIGMI_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDSPAREVMIC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDSPAREVMIC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpwdbmicbias0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPWDBMICBIAS0_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPWDBMICBIAS0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias0vref(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS0VREF_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS0VREF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias0dcswpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS0DCSWPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS0DCSWPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias0dcswnen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS0DCSWNEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS0DCSWNEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias0lowpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS0LOWPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS0LOWPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpwdbmicbias1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPWDBMICBIAS1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPWDBMICBIAS1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias1vref(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS1VREF_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS1VREF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias1dcswpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS1DCSWPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS1DCSWPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias1dcswnen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS1DCSWNEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS1DCSWNEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias1lowpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS1LOWPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS1LOWPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpwdbmicbias2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPWDBMICBIAS2_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPWDBMICBIAS2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias2vref(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS2VREF_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS2VREF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias2dcswpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS2DCSWPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS2DCSWPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias2dcswnen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS2DCSWNEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS2DCSWNEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias2lowpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS2LOWPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS2LOWPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpwdbmicbias3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPWDBMICBIAS3_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPWDBMICBIAS3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias3vref(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS3VREF_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS3VREF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias3dcswpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS3DCSWPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS3DCSWPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias3dcswnen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS3DCSWNEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS3DCSWNEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audmicbias3lowpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMICBIAS_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS3LOWPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDMICBIAS3LOWPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audencspareva28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDENCSPARE_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDENCSPAREVA28_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDENCSPAREVA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audencspareva18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDENCSPARE_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDENCSPAREVA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDENCSPAREVA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch0_1gain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMPGAIN_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH0_1GAIN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH0_1GAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_2gain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMPGAIN_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_2GAIN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_2GAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_3gain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMPGAIN_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_3GAIN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_3GAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpreampch_4gain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDPREAMPGAIN_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_4GAIN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPREAMPCH_4GAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pllbs_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLLBS_RST_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLLBS_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_div1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_DIV1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_DIV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_pdiv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_PDIV1_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_PDIV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_pdiv1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_PDIV1_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_PDIV1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_bc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_BC_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_BC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_bp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_BP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_BP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_br(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_BR_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_BR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_cko_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_CKO_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_CKO_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_ibsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_IBSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_IBSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_ckt_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_CKT_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_CKT_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_vct_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_VCT_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_VCT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_ckt_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_CKT_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_CKT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_hpm_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_HPM_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_HPM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_cdiv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_CDIV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_CDIV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_rlatch_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_RLATCH_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_RLATCH_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vcoband(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VCOBAND_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VCOBAND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_ckdrv_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_CKDRV_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_CKDRV_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_pll_rsva(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDMADPLL_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_RSVA_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_PLL_RSVA_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo_dec_en_va32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_DEC_EN_VA32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_DEC_EN_VA32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo_dec_pddis_en_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_DEC_PDDIS_EN_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_DEC_PDDIS_EN_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo_dec_remote_sense_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_DEC_REMOTE_SENSE_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_DEC_REMOTE_SENSE_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_nvreg_en_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_NVREG_EN_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_NVREG_EN_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_nvreg_pull0v_vaudp32(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_NVREG_PULL0V_VAUDP32_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_NVREG_PULL0V_VAUDP32_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audpmu_rsvd_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPMU_RSVD_VA18_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDPMU_RSVD_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo18_enc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO18_ENC_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO18_ENC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo18_enc_pddis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO18_ENC_PDDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO18_ENC_PDDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo18_enc_remote_sense(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO18_ENC_REMOTE_SENSE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO18_ENC_REMOTE_SENSE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo18_enc_lpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO18_ENC_LPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO18_ENC_LPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo18_enc_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO18_ENC_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO18_ENC_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adc_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADC_VOSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADC_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo_enc_rsva(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_ENC_RSVA_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO_ENC_RSVA_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch0_1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH0_1_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH0_1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch0_1_pddis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH0_1_PDDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH0_1_PDDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch0_1_remote_sense(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH0_1_REMOTE_SENSE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH0_1_REMOTE_SENSE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch0_1_lpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH0_1_LPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH0_1_LPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch_2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_2_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch_2_pddis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_2_PDDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_2_PDDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch_2_remote_sense(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_2_REMOTE_SENSE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_2_REMOTE_SENSE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch_2_lpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_2_LPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_2_LPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch_3_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_3_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_3_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch_3_pddis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_3_PDDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_3_PDDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch_3_remote_sense(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_3_REMOTE_SENSE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_3_REMOTE_SENSE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch_3_lpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_3_LPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_3_LPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch_4_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_4_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_4_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch_4_pddis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_4_PDDIS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_4_PDDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch_4_remote_sense(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_4_REMOTE_SENSE_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_4_REMOTE_SENSE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_lcldo19_adcch_4_lpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUDLDO_NVREG_CFG2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_4_LPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_LCLDO19_ADCCH_4_LPEN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch0(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH0_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH0_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch0(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH0_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH0_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH1_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH1_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH2_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC2),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH2_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch3(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC3),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH3_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH3_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch3(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC3),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH3_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH3_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch4(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC4),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH4_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH4_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch4(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC4),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH4_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH4_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch5(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC5),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH5_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH5_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch5(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC5),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH5_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH5_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch6(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC6),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH6_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH6_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch6(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC6),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH6_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH6_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch7(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC7),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH7_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH7_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch7(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC7),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH7_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH7_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch8(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC8),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH8_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH8_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch8(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC8),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH8_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH8_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch9(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH9_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH9_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch9(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC9),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH9_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH9_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch10(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC10),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH10_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH10_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch10(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC10),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH10_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH10_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch11_15(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC11),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH11_15_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH11_15_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch11_15(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC11),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH11_15_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH11_15_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_wakeup(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC12),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_WAKEUP_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_WAKEUP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_wakeup(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC12),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_WAKEUP_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_WAKEUP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_lbat(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC13),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_LBAT_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_LBAT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_lbat(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC13),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_LBAT_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_LBAT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch7_by_gps(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch7_by_gps(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch7_by_md(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC15),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH7_BY_MD_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH7_BY_MD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch7_by_md(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC15),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH7_BY_MD_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH7_BY_MD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch7_by_ap(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC16),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH7_BY_AP_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH7_BY_AP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch7_by_ap(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC16),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH7_BY_AP_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH7_BY_AP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_ch4_by_md(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC17),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH4_BY_MD_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_CH4_BY_MD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_ch4_by_md(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC17),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH4_BY_MD_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_CH4_BY_MD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_thr_hw(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_THR_HW_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_THR_HW_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_rdy_thr_hw(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_THR_HW_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_THR_HW_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_out_raw(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_ADC19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_RAW_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_OUT_RAW_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_busy_in(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_STA0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_busy_in_lbat(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_STA0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_LBAT_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_LBAT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_busy_in_wakeup(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_STA0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_busy_in_spk_i(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_STA0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_SPK_I_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_SPK_I_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_busy_in_spk_v(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_STA0),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_SPK_V_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_SPK_V_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_busy_in_gps_ap(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_STA1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_busy_in_gps_md(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_STA1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_busy_in_gps(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_STA1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_GPS_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_GPS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_busy_in_thr_hw(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_STA1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_THR_HW_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_THR_HW_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_adc_busy_in_thr_md(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_STA1),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_THR_MD_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_ADC_BUSY_IN_THR_MD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_auxadc_rqst_ch0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH0_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH1_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH2_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH3_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch4(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH4_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH4_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch5(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH5_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH5_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch6(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH6_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH6_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch7(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH7_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH7_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch8(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH8_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH8_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch9(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH9_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH9_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch10(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH10_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH10_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch11(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH11_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH11_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch12(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH12_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH12_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch13(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH13_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH13_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch14(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH14_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH14_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH15_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch4_by_md(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH4_BY_MD_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH4_BY_MD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch7_by_md(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH7_BY_MD_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH7_BY_MD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_ch7_by_gps(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH7_BY_GPS_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_CH7_BY_GPS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rqst_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_RQST1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RQST_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_ck_on_extd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_CK_ON_EXTD_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_CK_ON_EXTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_strup_ck_on_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_STRUP_CK_ON_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_STRUP_CK_ON_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_adc_rdy_wakeup_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_srclken_ck_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SRCLKEN_CK_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SRCLKEN_CK_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_ck_aon_gps(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_CK_AON_GPS_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_CK_AON_GPS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_ck_aon_md(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_CK_AON_MD_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_CK_AON_MD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_ck_aon(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_CK_AON_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_CK_AON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_avg_num_small(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_SMALL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_SMALL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_avg_num_large(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_LARGE_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_LARGE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_spl_num(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPL_NUM_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPL_NUM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_avg_num_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_avg_num_sel_lbat(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_SEL_LBAT_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_SEL_LBAT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_avg_num_sel_wakeup(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_avg_num_sel_spk_i(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_SEL_SPK_I_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_SEL_SPK_I_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_avg_num_sel_spk_v(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_SEL_SPK_V_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AVG_NUM_SEL_SPK_V_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_trim_ch0_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH0_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH0_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_trim_ch1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH1_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_trim_ch2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH2_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_trim_ch3_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH3_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH3_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_trim_ch4_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH4_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH4_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_trim_ch5_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH5_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH5_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_trim_ch6_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH6_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH6_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_trim_ch7_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH7_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH7_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_trim_ch8_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH8_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH8_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_trim_ch9_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH9_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH9_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_trim_ch10_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH10_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH10_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_trim_ch11_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH11_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TRIM_CH11_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_adc_2s_comp_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ADC_2S_COMP_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ADC_2S_COMP_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_adc_trim_comp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ADC_TRIM_COMP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ADC_TRIM_COMP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_sw_gain_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SW_GAIN_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SW_GAIN_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_sw_offset_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SW_OFFSET_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SW_OFFSET_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_rng_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RNG_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_RNG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_data_reuse_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DATA_REUSE_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DATA_REUSE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_test_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TEST_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_TEST_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_bit_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_BIT_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_BIT_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_start_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_START_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_START_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_start_swctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_START_SWCTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_START_SWCTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_adc_pwdb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADC_PWDB_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADC_PWDB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_adc_pwdb_swctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADC_PWDB_SWCTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADC_PWDB_SWCTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_out_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_OUT_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_OUT_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_da_dac(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DA_DAC_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DA_DAC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_da_dac_swctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DA_DAC_SWCTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DA_DAC_SWCTRL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_ad_auxadc_comp(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_CON8),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AD_AUXADC_COMP_MASK),
                           (kal_uint32)(MT6331_PMIC_AD_AUXADC_COMP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_rg_vbuf_exten(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBUF_EXTEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBUF_EXTEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vbuf_calen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBUF_CALEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBUF_CALEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vbuf_byp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBUF_BYP_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBUF_BYP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_vbuf_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_VBUF_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_VBUF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_aux_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUX_RSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUX_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_auxadc_cali(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_CALI_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUXADC_CALI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_adcin_chrin_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADCIN_CHRIN_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADCIN_CHRIN_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_adcin_batsns_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADCIN_BATSNS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADCIN_BATSNS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_adcin_cs_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADCIN_CS_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADCIN_CS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_adcin_baton_ted_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADCIN_BATON_TED_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ADCIN_BATON_TED_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_chsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_CHSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_CHSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_swctrl_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SWCTRL_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SWCTRL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_dig0_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DIG0_RSV2_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DIG0_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_dig1_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DIG1_RSV2_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DIG1_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_accdet_auto_spl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ACCDET_AUTO_SPL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ACCDET_AUTO_SPL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_accdet_auto_rqst_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_dac_extd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DAC_EXTD_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DAC_EXTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_dac_extd_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DAC_EXTD_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DAC_EXTD_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_spk_buffer_length(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPK_BUFFER_LENGTH_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPK_BUFFER_LENGTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_dig1_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DIG1_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DIG1_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_spk_sw_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPK_SW_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPK_SW_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_spk_hw_sel_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPK_HW_SEL_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPK_HW_SEL_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_spk_i_ptr_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPK_I_PTR_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPK_I_PTR_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_spk_v_ptr_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPK_V_PTR_ENB_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPK_V_PTR_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_spk_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPK_MODE_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_SPK_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_autorpt_prd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AUTORPT_PRD_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AUTORPT_PRD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_autorpt_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AUTORPT_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_AUTORPT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_pmu_thr_pdn_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_PMU_THR_PDN_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_PMU_THR_PDN_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_pmu_thr_pdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_PMU_THR_PDN_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_PMU_THR_PDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_auxadc_pmu_thr_pdn_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_CON13),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_PMU_THR_PDN_STATUS_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_PMU_THR_PDN_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_auxadc_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_lbat_debt_max(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_DEBT_MAX_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_DEBT_MAX_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_lbat_debt_min(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_DEBT_MIN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_DEBT_MIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_lbat_det_prd_15_0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_DET_PRD_15_0_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_DET_PRD_15_0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_lbat_det_prd_19_16(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_DET_PRD_19_16_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_DET_PRD_19_16_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_lbat_volt_max(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_VOLT_MAX_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_VOLT_MAX_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_lbat_irq_en_max(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_IRQ_EN_MAX_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_IRQ_EN_MAX_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_lbat_en_max(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_EN_MAX_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_EN_MAX_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_auxadc_lbat_max_irq_b(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_CON17),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_MAX_IRQ_B_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_MAX_IRQ_B_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_auxadc_lbat_volt_min(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_VOLT_MIN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_VOLT_MIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_lbat_irq_en_min(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_IRQ_EN_MIN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_IRQ_EN_MIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_lbat_en_min(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_EN_MIN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_EN_MIN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_auxadc_lbat_min_irq_b(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_CON18),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_MIN_IRQ_B_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_MIN_IRQ_B_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_lbat_debounce_count_max(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_lbat_debounce_count_min(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_auxadc_accdet_dig1_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ACCDET_DIG1_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ACCDET_DIG1_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_accdet_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ACCDET_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_ACCDET_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_thr_debt_max(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_DEBT_MAX_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_DEBT_MAX_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_thr_debt_min(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_DEBT_MIN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_DEBT_MIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_thr_det_prd_15_0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_DET_PRD_15_0_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_DET_PRD_15_0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_thr_det_prd_19_16(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_DET_PRD_19_16_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_DET_PRD_19_16_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_thr_volt_max(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_VOLT_MAX_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_VOLT_MAX_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_thr_irq_en_max(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_IRQ_EN_MAX_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_IRQ_EN_MAX_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_thr_en_max(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_EN_MAX_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_EN_MAX_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_auxadc_thr_max_irq_b(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_CON25),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_THR_MAX_IRQ_B_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_THR_MAX_IRQ_B_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_auxadc_thr_volt_min(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_VOLT_MIN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_VOLT_MIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_thr_irq_en_min(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_IRQ_EN_MIN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_IRQ_EN_MIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_auxadc_thr_en_min(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_EN_MIN_MASK),
                             (kal_uint32)(MT6331_PMIC_AUXADC_THR_EN_MIN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_auxadc_thr_min_irq_b(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_CON26),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_THR_MIN_IRQ_B_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_THR_MIN_IRQ_B_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_thr_debounce_count_max(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_CON27),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_auxadc_thr_debounce_count_min(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_AUXADC_CON28),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_MASK),
                           (kal_uint32)(MT6331_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_efuse_gain_ch4_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON29),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_EFUSE_GAIN_CH4_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_EFUSE_GAIN_CH4_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_efuse_offset_ch4_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_EFUSE_OFFSET_CH4_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_EFUSE_OFFSET_CH4_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_efuse_gain_ch7_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON31),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_EFUSE_GAIN_CH7_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_EFUSE_GAIN_CH7_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_efuse_offset_ch7_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_AUXADC_CON32),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_EFUSE_OFFSET_CH7_TRIM_MASK),
                             (kal_uint32)(MT6331_PMIC_EFUSE_OFFSET_CH7_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audaccdetvthcal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETVTHCAL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETVTHCAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audaccdetanaswctrlenb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETANASWCTRLENB_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETANASWCTRLENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_accdetsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_ACCDETSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_ACCDETSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audaccdetswctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETSWCTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETSWCTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audaccdetmicbias1pulllow(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETMICBIAS1PULLLOW_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETMICBIAS1PULLLOW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audaccdettvdet(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETTVDET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETTVDET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audaccdetvin1pulllow(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETVIN1PULLLOW_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETVIN1PULLLOW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_audaccdetauxadcswctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUDACCDETAUXADCSWCTRL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUDACCDETAUXADCSWCTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_audaccdetauxadcswctrl_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_AUDACCDETAUXADCSWCTRL_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_AUDACCDETAUXADCSWCTRL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_audaccdetrsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETRSV_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_AUDACCDETRSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_seq_init(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_SEQ_INIT_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_SEQ_INIT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_negvdet_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_NEGVDET_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_NEGVDET_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eintdet_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINTDET_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINTDET_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_seq_init(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_SEQ_INIT_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_SEQ_INIT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_cmp_pwm_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_CMP_PWM_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_CMP_PWM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_vth_pwm_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_VTH_PWM_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_VTH_PWM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_mbias_pwm_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_MBIAS_PWM_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_MBIAS_PWM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_pwm_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_PWM_EN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_PWM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_cmp_pwm_idle(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_CMP_PWM_IDLE_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_CMP_PWM_IDLE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_vth_pwm_idle(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_VTH_PWM_IDLE_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_VTH_PWM_IDLE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_mbias_pwm_idle(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_MBIAS_PWM_IDLE_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_MBIAS_PWM_IDLE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_pwm_idle(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_PWM_IDLE_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_PWM_IDLE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_pwm_width(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_PWM_WIDTH_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_PWM_WIDTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_pwm_thresh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_PWM_THRESH_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_PWM_THRESH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_rise_delay(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_RISE_DELAY_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_RISE_DELAY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_fall_delay(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_FALL_DELAY_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_FALL_DELAY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_debounce0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_DEBOUNCE0_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_DEBOUNCE0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_debounce1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_DEBOUNCE1_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_DEBOUNCE1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_debounce2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_DEBOUNCE2_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_DEBOUNCE2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_debounce3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_DEBOUNCE3_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_DEBOUNCE3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_debounce4(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_DEBOUNCE4_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_DEBOUNCE4_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_ival_cur_in(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_IVAL_CUR_IN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_IVAL_CUR_IN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_ival_cur_in(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IVAL_CUR_IN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IVAL_CUR_IN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_ival_sam_in(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_IVAL_SAM_IN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_IVAL_SAM_IN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_ival_sam_in(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IVAL_SAM_IN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IVAL_SAM_IN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_ival_mem_in(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_IVAL_MEM_IN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_IVAL_MEM_IN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_ival_mem_in(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IVAL_MEM_IN_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IVAL_MEM_IN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_ival_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IVAL_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IVAL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_ival_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_IVAL_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_IVAL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_accdet_irq(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON12),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_IRQ_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_IRQ_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_negv_irq(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON12),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_IRQ_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_IRQ_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_eint_irq(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON12),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IRQ_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IRQ_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_accdet_irq_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_IRQ_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_IRQ_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_negv_irq_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_IRQ_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_IRQ_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_irq_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IRQ_CLR_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IRQ_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_irq_polarity(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IRQ_POLARITY_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_IRQ_POLARITY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE0_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE1_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE2_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE3_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode4(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE4_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE4_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode5(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE5_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE5_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_pwm_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_PWM_SEL_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_PWM_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_in_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_IN_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_IN_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_cmp_en_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_CMP_EN_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_CMP_EN_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_vth_en_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_VTH_EN_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_VTH_EN_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_mbias_en_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_MBIAS_EN_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_MBIAS_EN_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_pwm_en_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_PWM_EN_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_PWM_EN_SW_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_accdet_in(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_IN_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_IN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_cur_in(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_CUR_IN_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_CUR_IN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_sam_in(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_SAM_IN_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_SAM_IN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_mem_in(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_MEM_IN_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_MEM_IN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_state(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_STATE_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_STATE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_mbias_clk(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_MBIAS_CLK_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_MBIAS_CLK_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_vth_clk(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_VTH_CLK_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_VTH_CLK_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_cmp_clk(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_CMP_CLK_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_CMP_CLK_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_da_audaccdetauxadcswctrl(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON14),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_DA_AUDACCDETAUXADCSWCTRL_MASK),
                           (kal_uint32)(MT6331_PMIC_DA_AUDACCDETAUXADCSWCTRL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_accdet_eint_debounce(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_DEBOUNCE_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_DEBOUNCE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_pwm_thresh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_PWM_THRESH_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_PWM_THRESH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_pwm_width(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_PWM_WIDTH_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_PWM_WIDTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_negv_thresh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_THRESH_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_THRESH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_pwm_fall_delay(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_PWM_FALL_DELAY_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_PWM_FALL_DELAY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eint_pwm_rise_delay(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_PWM_RISE_DELAY_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINT_PWM_RISE_DELAY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode13(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE13_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE13_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode12(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE12_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE12_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_nvdetectout_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_NVDETECTOUT_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_NVDETECTOUT_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode11(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE11_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE11_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode10(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE10_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE10_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eintcmpout_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINTCMPOUT_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINTCMPOUT_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode9(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE9_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE9_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode8(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE8_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE8_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_auxadc_ctrl_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_AUXADC_CTRL_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_AUXADC_CTRL_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode7(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE7_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE7_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_test_mode6(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE6_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_TEST_MODE6_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_eintcmp_en_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINTCMP_EN_SW_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_EINTCMP_EN_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_swbufswen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SWBUFSWEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SWBUFSWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_swbufmodsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_SWBUFMODSEL_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_SWBUFMODSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_nvdetvth(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_NVDETVTH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_NVDETVTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_nvdetcmpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_NVDETCMPEN_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_NVDETCMPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_eintconfigaccdet(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EINTCONFIGACCDET_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EINTCONFIGACCDET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_rg_eintcompvth(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_RG_EINTCOMPVTH_MASK),
                             (kal_uint32)(MT6331_PMIC_RG_EINTCOMPVTH_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6331_upmu_get_accdet_eint_state(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_EINT_STATE_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_EINT_STATE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_eint_cur_in(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_EINT_CUR_IN_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_EINT_CUR_IN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_eint_sam_in(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_EINT_SAM_IN_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_EINT_SAM_IN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_eint_mem_in(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_EINT_MEM_IN_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_EINT_MEM_IN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_nvdetectout(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NVDETECTOUT_MASK),
                           (kal_uint32)(MT6331_PMIC_NVDETECTOUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_eintcmpout(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_EINTCMPOUT_MASK),
                           (kal_uint32)(MT6331_PMIC_EINTCMPOUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_ni_eintcmpen(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON19),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_NI_EINTCMPEN_MASK),
                           (kal_uint32)(MT6331_PMIC_NI_EINTCMPEN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_negv_count_in(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_COUNT_IN_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_COUNT_IN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_negv_count_end(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_COUNT_END_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_COUNT_END_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_negv_minu(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_MINU_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_MINU_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_negv_add(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_ADD_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_ADD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_negv_cmp(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON20),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_CMP_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_NEGV_CMP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_cur_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON21),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_CUR_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_CUR_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6331_upmu_get_accdet_eint_cur_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6331_ACCDET_CON22),
                           (&val),
                           (kal_uint32)(MT6331_PMIC_ACCDET_EINT_CUR_DEB_MASK),
                           (kal_uint32)(MT6331_PMIC_ACCDET_EINT_CUR_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6331_upmu_set_accdet_rsv_con0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_RSV_CON0_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_RSV_CON0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6331_upmu_set_accdet_rsv_con1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6331_ACCDET_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6331_PMIC_ACCDET_RSV_CON1_MASK),
                             (kal_uint32)(MT6331_PMIC_ACCDET_RSV_CON1_SHIFT)
	                         );
  pmic_unlock();
}


//MT6332
kal_uint32 mt6332_upmu_get_hwcid(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_HWCID),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_HWCID_MASK),
                           (kal_uint32)(MT6332_PMIC_HWCID_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_swcid(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_SWCID),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_SWCID_MASK),
                           (kal_uint32)(MT6332_PMIC_SWCID_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6332_upmu_set_rg_srclken_in1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SRCLKEN_IN1_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SRCLKEN_IN1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_srclken_in2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SRCLKEN_IN2_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SRCLKEN_IN2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_osc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OSC_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OSC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_lpddr3_lp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_LPDDR3_LP_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_LPDDR3_LP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_srclken_in1_hw_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SRCLKEN_IN1_HW_MODE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SRCLKEN_IN1_HW_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_srclken_in2_hw_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SRCLKEN_IN2_HW_MODE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SRCLKEN_IN2_HW_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_osc_sel_hw_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OSC_SEL_HW_MODE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OSC_SEL_HW_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_lpddr3_lp_hw_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_LPDDR3_LP_HW_MODE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_LPDDR3_LP_HW_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_srclken_in_sync_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SRCLKEN_IN_SYNC_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SRCLKEN_IN_SYNC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_osc_en_auto_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OSC_EN_AUTO_OFF_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OSC_EN_AUTO_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_en_ref_ap(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DDR_VREF_AP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_EN_REF_AP_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_EN_REF_AP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ds_ap(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DDR_VREF_AP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_DS_AP_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_DS_AP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_reftune_ap(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DDR_VREF_AP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_REFTUNE_AP_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_REFTUNE_AP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_en_ref_dq(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DDR_VREF_DQ_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_EN_REF_DQ_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_EN_REF_DQ_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ds_dq(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DDR_VREF_DQ_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_DS_DQ_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_DS_DQ_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_reftune_dq(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DDR_VREF_DQ_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_REFTUNE_DQ_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_REFTUNE_DQ_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_en_ref_ca(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DDR_VREF_CA_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_EN_REF_CA_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_EN_REF_CA_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ds_ca(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DDR_VREF_CA_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_DS_CA_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_DS_CA_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_reftune_ca(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DDR_VREF_CA_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_REFTUNE_CA_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_REFTUNE_CA_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6332_upmu_get_test_out(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_TEST_OUT),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_TEST_OUT_MASK),
                           (kal_uint32)(MT6332_PMIC_TEST_OUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6332_upmu_set_rg_mon_flag_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TEST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_MON_FLAG_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_MON_FLAG_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_mon_grp_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TEST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_MON_GRP_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_MON_GRP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_test_spk_pwm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TEST_SPK_PWM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TEST_SPK_PWM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_test_spk(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TEST_SPK_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TEST_SPK_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_test_strup(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TEST_STRUP_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TEST_STRUP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_efuse_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_EFUSE_MODE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_EFUSE_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_nandtree_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_NANDTREE_MODE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_NANDTREE_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_test_auxadc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TEST_AUXADC_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TEST_AUXADC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_test_classd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TEST_CLASSD_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TEST_CLASSD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_test_driver(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TEST_DRIVER_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TEST_DRIVER_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_testmode_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TESTMODE_SW),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_TESTMODE_SW_MASK),
                             (kal_uint32)(MT6332_PMIC_TESTMODE_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ana_testmode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TESTMODE_ANA),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_ANA_TESTMODE_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_ANA_TESTMODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ana_testmode_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TESTMODE_ANA),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_ANA_TESTMODE_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_ANA_TESTMODE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_pmu_tdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_PMU_TDSEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_PMU_TDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_spi_tdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SPI_TDSEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SPI_TDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_pmu_rdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_RDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_PMU_RDSEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_PMU_RDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_spi_rdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_RDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SPI_RDSEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SPI_RDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_smt_wdtrstb_in(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_WDTRSTB_IN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_WDTRSTB_IN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_smt_srclken_in1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_SRCLKEN_IN1_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_SRCLKEN_IN1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_smt_srclken_in2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_SRCLKEN_IN2_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_SRCLKEN_IN2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_smt_drv_vbus(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_DRV_VBUS_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_DRV_VBUS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_smt_rtc_32k1v8(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_RTC_32K1V8_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_RTC_32K1V8_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_smt_pwm_in(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_PWM_IN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_PWM_IN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_smt_spi_clk(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_SMT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_SPI_CLK_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_SPI_CLK_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_smt_spi_csn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_SMT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_SPI_CSN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_SPI_CSN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_smt_spi_mosi(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_SMT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_SPI_MOSI_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_SPI_MOSI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_smt_spi_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_SMT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_SPI_MISO_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SMT_SPI_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_octl_srclken_in1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DRV_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_SRCLKEN_IN1_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_SRCLKEN_IN1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_octl_srclken_in2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DRV_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_SRCLKEN_IN2_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_SRCLKEN_IN2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_octl_drv_vbus(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DRV_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_DRV_VBUS_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_DRV_VBUS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_octl_rtc_32k1v8(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DRV_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_RTC_32K1V8_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_RTC_32K1V8_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_octl_pwm_in(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DRV_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_PWM_IN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_PWM_IN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_octl_spi_clk(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DRV_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_SPI_CLK_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_SPI_CLK_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_octl_spi_csn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DRV_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_SPI_CSN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_SPI_CSN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_octl_spi_mosi(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DRV_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_SPI_MOSI_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_SPI_MOSI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_octl_spi_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_DRV_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_SPI_MISO_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OCTL_SPI_MISO_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6332_upmu_get_en_status_vauxb32(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VAUXB32_MASK),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VAUXB32_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_en_status_vbif28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VBIF28_MASK),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VBIF28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_en_status_vusb33(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VUSB33_MASK),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VUSB33_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_en_status_vsram_dvfs2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VSRAM_DVFS2_MASK),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VSRAM_DVFS2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_en_status_vdram(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VDRAM_MASK),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VDRAM_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_en_status_vdvfs2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VDVFS2_MASK),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VDVFS2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_en_status_vrf1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VRF1_MASK),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VRF1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_en_status_vrf2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VRF2_MASK),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VRF2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_en_status_vpa(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VPA_MASK),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VPA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_en_status_vsbst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VSBST_MASK),
                           (kal_uint32)(MT6332_PMIC_EN_STATUS_VSBST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_oc_status_vauxb32(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VAUXB32_MASK),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VAUXB32_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_oc_status_vbif28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VBIF28_MASK),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VBIF28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_oc_status_vusb33(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VUSB33_MASK),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VUSB33_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_oc_status_vsram_dvfs2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VSRAM_DVFS2_MASK),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VSRAM_DVFS2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_ni_spk_oc_det_d_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_NI_SPK_OC_DET_D_L_MASK),
                           (kal_uint32)(MT6332_PMIC_NI_SPK_OC_DET_D_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_ni_spk_oc_det_ab_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_NI_SPK_OC_DET_AB_L_MASK),
                           (kal_uint32)(MT6332_PMIC_NI_SPK_OC_DET_AB_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_oc_status_vdram(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VDRAM_MASK),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VDRAM_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_oc_status_vdvfs2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VDVFS2_MASK),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VDVFS2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_oc_status_vrf1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VRF1_MASK),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VRF1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_oc_status_vrf2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VRF2_MASK),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VRF2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_oc_status_vpa(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VPA_MASK),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VPA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_oc_status_vsbst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VSBST_MASK),
                           (kal_uint32)(MT6332_PMIC_OC_STATUS_VSBST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6332_upmu_set_top_status(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_STATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_TOP_STATUS_MASK),
                             (kal_uint32)(MT6332_PMIC_TOP_STATUS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch1_drv_en_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_FLASH_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_DRV_EN_RSV_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_DRV_EN_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch2_drv_en_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_FLASH_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_DRV_EN_RSV_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_DRV_EN_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch1_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_FLASH_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_TRIM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch2_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_FLASH_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_TRIM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch_vclamp_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_FLASH_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH_VCLAMP_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH_VCLAMP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash1_drv_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_FLASH_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_DRV_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_DRV_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash2_drv_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_FLASH_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_DRV_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_DRV_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash1_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_FLASH_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_TRIM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash2_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_FLASH_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_TRIM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash_vclamp_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_FLASH_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH_VCLAMP_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH_VCLAMP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash1_open_vth(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_FLASH_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_OPEN_VTH_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_OPEN_VTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash2_open_vth(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_FLASH_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_OPEN_VTH_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_OPEN_VTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_bc12_vsrc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_VSRC_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_VSRC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_bc12_vref_vth(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_VREF_VTH_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_VREF_VTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_bc12_ipu_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_IPU_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_IPU_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_bc12_ipd_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_IPD_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_IPD_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_bc12_cmp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_CMP_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_CMP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_bc12_bias_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_BIAS_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_BIAS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_bc12_bb_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_BB_CTRL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BC12_BB_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_asw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_ASW_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_ASW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_burshth(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BURSHTH_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BURSHTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_burshtl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BURSHTL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BURSHTL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_cc_compcc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CC_COMPCC_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CC_COMPCC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_cc_comprc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CC_COMPRC_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CC_COMPRC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_chgpreg_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CHGPREG_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CHGPREG_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_chr_force_pwm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CHR_FORCE_PWM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CHR_FORCE_PWM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_cs_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CS_FEN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CS_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_cs_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CS_TRIM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_cs_vreftrim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CS_VREFTRIM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CS_VREFTRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_cv_compcc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CV_COMPCC_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CV_COMPCC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_cv_comprc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CV_COMPRC_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CV_COMPRC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash_drv_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH_DRV_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH_DRV_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_force_non_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FORCE_NON_OC_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FORCE_NON_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_force_non_ov(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FORCE_NON_OV_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FORCE_NON_OV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_force_non_sst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FORCE_NON_SST_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FORCE_NON_SST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_freq_half(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FREQ_HALF_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FREQ_HALF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_gdri_minoff_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_GDRI_MINOFF_DIS_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_GDRI_MINOFF_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_hfdet_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_HFDET_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_HFDET_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ics_loop(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_ICS_LOOP_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_ICS_LOOP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_inout_csreg_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_INOUT_CSREG_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_INOUT_CSREG_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_iterm_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_ITERM_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_ITERM_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_cp_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_CP_CKSEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_CP_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_cp_vg(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_CP_VG_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_CP_VG_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_fctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_FCTRL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_FCTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_FEN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_ref_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_REF_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_REF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_ref_oe(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_REF_OE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_REF_OE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_osc_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OSC_TRIM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OSC_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_clk_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_CLK_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_CLK_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_csa_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_CSA_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_CSA_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_cs_slp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_CS_SLP_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_CS_SLP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_fpwm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_FPWM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_FPWM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_lvl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_LVL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_LVL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_maxduty_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_MAXDUTY_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_MAXDUTY_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_ocplvl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_OCPLVL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_OCPLVL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_ocp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_OCP_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_OCP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_slp_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_SLP_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_SLP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ramp_half(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_RAMP_HALF_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_RAMP_HALF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_sst_current(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SST_CURRENT_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SST_CURRENT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_atest_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_ATEST_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_ATEST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_bount(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_BOUNT_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_BOUNT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_chrinslp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_CHRINSLP_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_CHRINSLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_dtest_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_DTEST_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_DTEST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_test_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_TEST_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_TEST_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_vrampcc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_VRAMPCC_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_VRAMPCC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_vrampslp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_VRAMPSLP_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_VRAMPSLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_sys_vreftrim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SYS_VREFTRIM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SYS_VREFTRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_trim_iprecc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TRIM_IPRECC_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TRIM_IPRECC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_zxgm_tune(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_ZXGM_TUNE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_ZXGM_TUNE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_zx_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_ZX_TRIM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_ZX_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_zx_trim_boost(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_ZX_TRIM_BOOST_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_ZX_TRIM_BOOST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_buck_novlp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_NOVLP_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_NOVLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_buck_novlp_pd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_NOVLP_PD_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_NOVLP_PD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_fastran(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_FASTRAN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_FASTRAN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_rev(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_REV_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_REV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_cs_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_CS_TRIM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_CS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_cs_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_CS_MODE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_CS_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_m3_rev(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_M3_REV_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_M3_REV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_trev(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_TREV_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_TREV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_pptrim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_PPTRIM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_PPTRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_chr_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CHR_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CHR_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_ana_test_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_ANA_TEST_MODE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_ANA_TEST_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_bat_ov_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BAT_OV_TRIM_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BAT_OV_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_fastran_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_FASTRAN_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_FASTRAN_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_compres(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_COMPRES_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_COMPRES_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_hfdet_lvl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_HFDET_LVL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_HFDET_LVL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ramp_consbias_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_RAMP_CONSBIAS_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_RAMP_CONSBIAS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_adtest_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_ADTEST_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_ADTEST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_force_non_oc2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FORCE_NON_OC2_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FORCE_NON_OC2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_rccomp_tune(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_RCCOMP_TUNE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_RCCOMP_TUNE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_current_tune(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_CURRENT_TUNE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_CURRENT_TUNE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_buck_vbtcheck_pd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_VBTCHECK_PD_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_VBTCHECK_PD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_cbias_extr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CBIAS_EXTR_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CBIAS_EXTR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_rcomp_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_RCOMP_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_RCOMP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_faston_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CORE_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_FASTON_FEN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_FASTON_FEN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6332_upmu_get_rgs_bc12_cmp_out(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BC12_CMP_OUT_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BC12_CMP_OUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_ich_low_flag_chr_core(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_ICH_LOW_FLAG_CHR_CORE_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_ICH_LOW_FLAG_CHR_CORE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_ich_och_flag_chr_core(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_ICH_OCH_FLAG_CHR_CORE_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_ICH_OCH_FLAG_CHR_CORE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_m3_cp_rdy(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_M3_CP_RDY_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_M3_CP_RDY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_sys_cv_flag_chr_core(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_SYS_CV_FLAG_CHR_CORE_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_SYS_CV_FLAG_CHR_CORE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_chrin_gt_v6p0(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CHRIN_GT_V6P0_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CHRIN_GT_V6P0_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_vsys_lt_vbat_v0p1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_VSYS_LT_VBAT_V0P1_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_VSYS_LT_VBAT_V0P1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_bat_gt_22(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_GT_22_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_GT_22_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_bat_gt_24(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_GT_24_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_GT_24_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_bat_gt_27(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_GT_27_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_GT_27_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_bat_gt_30(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_GT_30_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_GT_30_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_bat_gt_34(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_GT_34_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_GT_34_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_bat_gt_cv(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_GT_CV_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_GT_CV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_cs_gt_34(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CS_GT_34_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CS_GT_34_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_cs_gt_22(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CS_GT_22_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CS_GT_22_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_vdrv_rdy(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON0),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_VDRV_RDY_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_VDRV_RDY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_temp_gt_150(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_TEMP_GT_150_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_TEMP_GT_150_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_temp_gt_120(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_TEMP_GT_120_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_TEMP_GT_120_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_chr_gt_dpm(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_GT_DPM_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_GT_DPM_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_otg_chr_gt_lv(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_OTG_CHR_GT_LV_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_OTG_CHR_GT_LV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_otg_chr_gt_hv(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_OTG_CHR_GT_HV_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_OTG_CHR_GT_HV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_flash1_vled_gt_hv(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_FLASH1_VLED_GT_HV_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_FLASH1_VLED_GT_HV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_flash1_vled_gt_lv(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_FLASH1_VLED_GT_LV_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_FLASH1_VLED_GT_LV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_flash2_vled_gt_hv(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_FLASH2_VLED_GT_HV_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_FLASH2_VLED_GT_HV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_flash2_vled_gt_lv(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_FLASH2_VLED_GT_LV_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_FLASH2_VLED_GT_LV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_bat_ov(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_OV_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BAT_OV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_baton_ht(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BATON_HT_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BATON_HT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_swchr_bc12_cmp_out(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_SWCHR_BC12_CMP_OUT_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_SWCHR_BC12_CMP_OUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_chr_sta_rsv_0(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON1),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_STA_RSV_0_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_STA_RSV_0_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_dcin_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON2),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_DCIN_OC_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_DCIN_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_ovp_dcin(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON2),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_OVP_DCIN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_OVP_DCIN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_ovp_usb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON2),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_OVP_USB_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_OVP_USB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_usb_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON2),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_USB_OC_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_USB_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_uvp_dcin(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON2),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_UVP_DCIN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_UVP_DCIN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_uvp_usb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON2),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_UVP_USB_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_UVP_USB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_chr_sta_rsv_1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON2),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_STA_RSV_1_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_STA_RSV_1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_cs_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON3),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CS_SEL_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CS_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_iprecc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON3),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_IPRECC_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_IPRECC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_ics_setting(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON3),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_ICS_SETTING_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_ICS_SETTING_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_syscv_coarse_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON4),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_SYSCV_COARSE_SEL_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_SYSCV_COARSE_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_syscv_fine_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON4),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_SYSCV_FINE_SEL_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_SYSCV_FINE_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_m3_rtune(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON4),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_M3_RTUNE_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_M3_RTUNE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_cv_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CV_MODE_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CV_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_chr_plug_in(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_PLUG_IN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_PLUG_IN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_m3_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_M3_EN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_M3_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_boost_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BOOST_EN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BOOST_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_boost_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BOOST_MODE_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BOOST_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_precc_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_PRECC_EN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_PRECC_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_pwm_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_PWM_EN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_PWM_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_swchr_ref_osc_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_SWCHR_REF_OSC_EN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_SWCHR_REF_OSC_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_csbat_vsns(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CSBAT_VSNS_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CSBAT_VSNS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_chrinbat_isns(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CHRINBAT_ISNS_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CHRINBAT_ISNS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_charge_complete_det(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CHARGE_COMPLETE_DET_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CHARGE_COMPLETE_DET_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_auto_recharge(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_AUTO_RECHARGE_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_AUTO_RECHARGE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_usb_sw_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_USB_SW_EN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_USB_SW_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_dcin_sw_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON5),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_DCIN_SW_EN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_DCIN_SW_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_vin_dpm_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_VIN_DPM_MODE_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_VIN_DPM_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_adaptive_cv_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_ADAPTIVE_CV_MODE_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_ADAPTIVE_CV_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_thermal_reg_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_THERMAL_REG_MODE_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_THERMAL_REG_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_flash1_en_timeout(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_FLASH1_EN_TIMEOUT_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_FLASH1_EN_TIMEOUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_flash2_en_timeout(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_FLASH2_EN_TIMEOUT_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_FLASH2_EN_TIMEOUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_vled1_short(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_VLED1_SHORT_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_VLED1_SHORT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_vled2_short(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_VLED2_SHORT_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_VLED2_SHORT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_vled1_open(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_VLED1_OPEN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_VLED1_OPEN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_vled2_open(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_VLED2_OPEN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_VLED2_OPEN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_chrin_short(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CHRIN_SHORT_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CHRIN_SHORT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_boost_m3_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BOOST_M3_OC_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BOOST_M3_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_chr_m3_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_M3_OC_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_M3_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_boost_thermal(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BOOST_THERMAL_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BOOST_THERMAL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_drvcdt_short(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_DRVCDT_SHORT_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_DRVCDT_SHORT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_boost_pwron_rdy(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BOOST_PWRON_RDY_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BOOST_PWRON_RDY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_chr_hv_det(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON6),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_HV_DET_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_HV_DET_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_chrwdt_flag(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CHRWDT_FLAG_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CHRWDT_FLAG_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_m3_rtune_eq(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_M3_RTUNE_EQ_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_M3_RTUNE_EQ_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_temp_gt_120_db(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_TEMP_GT_120_DB_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_TEMP_GT_120_DB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_temp_gt_150_db(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_TEMP_GT_150_DB_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_TEMP_GT_150_DB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_baton_ht_db(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BATON_HT_DB_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BATON_HT_DB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_usbldo_force_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_USBLDO_FORCE_EN_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_USBLDO_FORCE_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_usbldo_force_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_USBLDO_FORCE_STB_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_USBLDO_FORCE_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_m3_en_swchr(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_M3_EN_SWCHR_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_M3_EN_SWCHR_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_usb_in_uv_db(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_USB_IN_UV_DB_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_USB_IN_UV_DB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_usb_in_ov_db(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_USB_IN_OV_DB_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_USB_IN_OV_DB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_dc_in_uv_db(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_DC_IN_UV_DB_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_DC_IN_UV_DB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_dc_in_ov_db(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_DC_IN_OV_DB_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_DC_IN_OV_DB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_usb_oc_db(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_USB_OC_DB_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_USB_OC_DB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_dcin_oc_db(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_DCIN_OC_DB_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_DCIN_OC_DB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_bc12_timeout(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_BC12_TIMEOUT_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_BC12_TIMEOUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6332_upmu_get_rgs_chr_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6332_STA_CON7),
                           (&val),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_MODE_MASK),
                           (kal_uint32)(MT6332_PMIC_RGS_CHR_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6332_upmu_set_rg_force_chr_plug_out(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FORCE_CHR_PLUG_OUT_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FORCE_CHR_PLUG_OUT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_pwm_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_PWM_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_PWM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_usbdl_mode_b(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_USBDL_MODE_B_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_USBDL_MODE_B_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ch_complete_auto_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CH_COMPLETE_AUTO_OFF_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CH_COMPLETE_AUTO_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ch_complete_det_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CH_COMPLETE_DET_OFF_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CH_COMPLETE_DET_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ch_complete_pwm_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CH_COMPLETE_PWM_OFF_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CH_COMPLETE_PWM_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ch_complete_m3_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CH_COMPLETE_M3_OFF_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CH_COMPLETE_M3_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_chr_oc_auto_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CHR_OC_AUTO_OFF_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CHR_OC_AUTO_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_chr_ovpfet_oc_auto_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CHR_OVPFET_OC_AUTO_OFF_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CHR_OVPFET_OC_AUTO_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_term_timer(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TERM_TIMER_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TERM_TIMER_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_thermal_checker_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_THERMAL_CHECKER_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_THERMAL_CHECKER_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_RSV_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_rtune_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_RTUNE_CKSEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_RTUNE_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_rtune_fload(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_RTUNE_FLOAD_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_RTUNE_FLOAD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_faston_swen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_FASTON_SWEN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_FASTON_SWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_faston(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_FASTON_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_FASTON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_oc2_lvl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_OC2_LVL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_OC2_LVL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_oc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_OC_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_OC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_cs1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_CS1_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_CS1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_cs2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_CS2_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_CS2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_m3_rtune(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_M3_RTUNE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_M3_RTUNE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_swchr_dig_rsv_2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_DIG_RSV_2_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SWCHR_DIG_RSV_2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_scc_en_swen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SCC_EN_SWEN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SCC_EN_SWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_scc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SCC_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SCC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_precc_en_swen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_PRECC_EN_SWEN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_PRECC_EN_SWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_precc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_PRECC_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_PRECC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_csbat_vsns_swen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CSBAT_VSNS_SWEN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CSBAT_VSNS_SWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_csbat_vsns(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CSBAT_VSNS_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CSBAT_VSNS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_chrinbat_isns_swen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CHRINBAT_ISNS_SWEN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CHRINBAT_ISNS_SWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_chrinbat_isns(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CHRINBAT_ISNS_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CHRINBAT_ISNS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_iprecc_swen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_IPRECC_SWEN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_IPRECC_SWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ich_sel_swen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_ICH_SEL_SWEN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_ICH_SEL_SWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_syscv_fine_sel_swen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SYSCV_FINE_SEL_SWEN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SYSCV_FINE_SEL_SWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_fload_ich_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLOAD_ICH_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLOAD_ICH_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_fload_cv_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLOAD_CV_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLOAD_CV_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_iprecc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_IPRECC_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_IPRECC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ich_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_ICH_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_ICH_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_cv_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CV_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CV_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_syscv_fine_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SYSCV_FINE_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SYSCV_FINE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_cv_pp_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CV_PP_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CV_PP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ich_sfstr_step(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_ICH_SFSTR_STEP_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_ICH_SFSTR_STEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_cvvth_sfstr_step(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CVVTH_SFSTR_STEP_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CVVTH_SFSTR_STEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_thermal_rg_vth(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_THERMAL_RG_VTH_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_THERMAL_RG_VTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_thermal_temp_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_THERMAL_TEMP_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_THERMAL_TEMP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_oc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OC_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_pwm_oc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_PWM_OC_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_PWM_OC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_pwm_bat_config(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_PWM_BAT_CONFIG_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_PWM_BAT_CONFIG_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_vsys_lt_vbat_v0p1_off_toggle(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_VSYS_LT_VBAT_V0P1_OFF_TOGGLE_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_VSYS_LT_VBAT_V0P1_OFF_TOGGLE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_vsys_lt_vbat_v0p1_off_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_VSYS_LT_VBAT_V0P1_OFF_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_VSYS_LT_VBAT_V0P1_OFF_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_vsys_lt_vbat_v0p1_db_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_CHR_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_VSYS_LT_VBAT_V0P1_DB_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_VSYS_LT_VBAT_V0P1_DB_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_otg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OTG_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OTG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_fled_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLED_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLED_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch_ck_en_hw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH_CK_EN_HW_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH_CK_EN_HW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_otg_m3_oc_auto_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OTG_M3_OC_AUTO_OFF_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OTG_M3_OC_AUTO_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_otg_ovpfet_dcin(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OTG_OVPFET_DCIN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OTG_OVPFET_DCIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_otg_ovpfet_oc_auto_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_OTG_OVPFET_OC_AUTO_OFF_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_OTG_OVPFET_OC_AUTO_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_dig_rsv_0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_DIG_RSV_0_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_DIG_RSV_0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch1_iset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_ISET_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_ISET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch2_iset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_ISET_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_ISET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_dig_rsv_1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_DIG_RSV_1_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_DIG_RSV_1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash1_iset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_ISET_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_ISET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash1_iset_fload(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_ISET_FLOAD_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_ISET_FLOAD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash2_iset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_ISET_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_ISET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash2_iset_fload(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_ISET_FLOAD_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_ISET_FLOAD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash1_iset_step(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_ISET_STEP_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_ISET_STEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash2_iset_step(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_ISET_STEP_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_ISET_STEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash1_en_timeout_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_EN_TIMEOUT_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH1_EN_TIMEOUT_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_flash2_en_timeout_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_EN_TIMEOUT_SEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FLASH2_EN_TIMEOUT_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch1_pwm_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_PWM_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_PWM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch1_dim_duty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_DIM_DUTY_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_DIM_DUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch1_dim_fsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_DIM_FSEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH1_DIM_FSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch2_pwm_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_PWM_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_PWM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch2_dim_duty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_DIM_DUTY_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_DIM_DUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch2_dim_fsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_DIM_FSEL_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH2_DIM_FSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_boost_dig_rsv_2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_BOOST_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_DIG_RSV_2_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BOOST_DIG_RSV_2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_g_smps_pd_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_G_SMPS_PD_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_G_SMPS_PD_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_spk_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SPK_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SPK_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_spk_pwm_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SPK_PWM_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SPK_PWM_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_spk_pwmin_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_SPK_PWMIN_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_SPK_PWMIN_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_fgadc_ana_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FGADC_ANA_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FGADC_ANA_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_fgadc_dig_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FGADC_DIG_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FGADC_DIG_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_bif_x4_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BIF_X4_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BIF_X4_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_bif_x1_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BIF_X1_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BIF_X1_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_auxadc_1m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_AUXADC_1M_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_AUXADC_1M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_auxadc_12m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_AUXADC_12M_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_AUXADC_12M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_auxadc_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_AUXADC_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_AUXADC_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_auxadc_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_AUXADC_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_AUXADC_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_vwled_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_VWLED_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_VWLED_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_vwled_6m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_VWLED_6M_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_VWLED_6M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_cbus_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CBUS_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CBUS_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_bif_x48_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BIF_X48_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BIF_X48_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_vwled_1m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_VWLED_1M_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_VWLED_1M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_vsbst_3m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_VSBST_3M_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_VSBST_3M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_fqmtr_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FQMTR_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FQMTR_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ldostb_1m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_LDOSTB_1M_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_LDOSTB_1M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_buck_ana_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_ANA_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_ANA_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_buck_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_buck_1m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_1M_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_1M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_buck_12m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_12M_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BUCK_12M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_pwmoc_6m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_PWMOC_6M_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_PWMOC_6M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_intrp_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_INTRP_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_INTRP_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_chr_0p25m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_CHR_0P25M_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_CHR_0P25M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_torch_0p25m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH_0P25M_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_TORCH_0P25M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_ana_torch_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_ANA_TORCH_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_ANA_TORCH_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_swchr_ref_osc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_SWCHR_REF_OSC_EN_MASK),
                             (kal_uint32)(MT6332_PMIC_SWCHR_REF_OSC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_strup_75k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_STRUP_75K_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_STRUP_75K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_fgadc_ft_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_FGADC_FT_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_FGADC_FT_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_efuse_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_EFUSE_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_EFUSE_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332_upmu_set_rg_bgr_test_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6332_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6332_PMIC_RG_BGR_TEST_CK_PDN_MASK),
                             (kal_uint32)(MT6332_PMIC_RG_BGR_TEST_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6332