#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/spinlock.h>
#include <linux/delay.h>  

#include <mach/irqs.h>
#include <mach/mt_cirq.h>
#include <mach/mt_spm_idle.h>
#include <mach/mt_cpuidle.h>
#include <mach/mt_gpt.h>
#include <mach/mt_cpufreq.h>
#include <mach/mt_dramc.h>
#include <mach/mt_boot.h>

//FIXME: for FPGA early porting
//#include <asm/hardware/gic.h>

#include "mt_spm_internal.h"


/**************************************
 * only for internal debug
 **************************************/
//FIXME: for FPGA early porting
#define  CONFIG_MTK_LDVT

#ifdef CONFIG_MTK_LDVT
#define SPM_BYPASS_SYSPWREQ     1
#else
#define SPM_BYPASS_SYSPWREQ     0
#endif

#define WAKE_SRC_FOR_SODI \
    (WAKE_SRC_KP | WAKE_SRC_GPT | WAKE_SRC_EINT | WAKE_SRC_CCIF_MD |        \
     WAKE_SRC_MD32 | WAKE_SRC_USB_CD | WAKE_SRC_USB_PDN | WAKE_SRC_PMIC_EINT_0 |  \
     WAKE_SRC_PMIC_EINT_1 | WAKE_SRC_AFE | WAKE_SRC_CIRQ | WAKE_SRC_SYSPWREQ |         \
     WAKE_SRC_MD_WDT | WAKE_SRC_CLDMA_MD | WAKE_SRC_SEJ | WAKE_SRC_CPU_IRQ)

#define WAKE_SRC_FOR_MD32  0                                          \
    //(WAKE_SRC_AUD_MD32)


#define CA7_BUS_CONFIG          (CA7MCUCFG_BASE + 0x1C) //0x1020011c

// ==========================================
// PCM code for SODI (Screen On Deep Idle)
//
// core 0 : GPT 4
// ==========================================
#if SPM_CTRL_BIG_CPU
static const u32 sodi_binary[] = {
	0x81411801, 0xd8000165, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xe0e00016,
	0xe0e0001e, 0xe0e0000e, 0xe0e0000f, 0xc2801360, 0x17c07c1f, 0x80368400,
	0x1b80001f, 0x20000208, 0x80370400, 0x1b80001f, 0x20000208, 0x80360400,
	0x803e0400, 0x1b80001f, 0x20000208, 0x80380400, 0x1b80001f, 0x20000208,
	0x803b0400, 0x1b80001f, 0x20000208, 0x803d0400, 0xa01d8400, 0x1b80001f,
	0x20000034, 0x803d8400, 0x1b80001f, 0x2000001a, 0x18c0001f, 0x1000f5c8,
	0x1910001f, 0x1000f5c8, 0xa1000404, 0xe0c00004, 0x18c0001f, 0x100125c8,
	0x1910001f, 0x100125c8, 0xa1000404, 0xe0c00004, 0x1910001f, 0x100125c8,
	0x80340400, 0x17c07c1f, 0x17c07c1f, 0x80310400, 0x1b80001f, 0x2000000a,
	0x18c0001f, 0x10006240, 0xe0e0000d, 0xd8000765, 0x17c07c1f, 0x1b80001f,
	0x20000100, 0x81fa0407, 0x81f08407, 0x81f18407, 0xe8208000, 0x10006354,
	0xfffe7b01, 0xa1d80407, 0xa1dc0407, 0x8880000c, 0x2f7be35f, 0xd82009a2,
	0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0xd00009e0, 0x17c07c1f, 0x1b00001f,
	0xbfffe7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f, 0x20000fdf, 0x1890001f,
	0x10006608, 0x80c98801, 0x810a8801, 0x10918c1f, 0xa0939002, 0xa0950402,
	0x8080080d, 0xd8200ce2, 0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0x1b80001f,
	0x20000004, 0xd800132c, 0x17c07c1f, 0x1b00001f, 0xbfffe7ff, 0xd0001320,
	0x17c07c1f, 0x81f80407, 0x81fc0407, 0xe8208000, 0x10006354, 0xffffffff,
	0x1b80001f, 0x20000020, 0x02000408, 0x1880001f, 0x10006320, 0xc0c02240,
	0xe080000f, 0xd8000c63, 0x17c07c1f, 0xe080001f, 0xa1da0407, 0xa0110400,
	0xa0140400, 0x18c0001f, 0x1000f5c8, 0x1910001f, 0x1000f5c8, 0x81200404,
	0xe0c00004, 0x18c0001f, 0x100125c8, 0x1910001f, 0x100125c8, 0x81200404,
	0xe0c00004, 0x1910001f, 0x100125c8, 0xa01d0400, 0xa01b0400, 0xa0180400,
	0xa01e0400, 0xa0160400, 0xa0170400, 0xa0168400, 0x1b80001f, 0x20000104,
	0x81411801, 0xd80012e5, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xc0c02180,
	0x17c07c1f, 0x1b00001f, 0x7fffe7ff, 0xf0000000, 0x17c07c1f, 0x18c0001f,
	0x100110e4, 0x1910001f, 0x100110e4, 0xa1158404, 0xe0c00004, 0x81358404,
	0xe0c00004, 0x18c0001f, 0x100040e4, 0x1910001f, 0x100040e4, 0xa1158404,
	0xe0c00004, 0x81358404, 0xe0c00004, 0xf0000000, 0x17c07c1f, 0x803d8400,
	0x1b80001f, 0x2000001a, 0x80340400, 0x17c07c1f, 0x17c07c1f, 0x80310400,
	0x89c00007, 0xffeffff5, 0xa9c00007, 0x01010000, 0xe8208000, 0x10006354,
	0xfffe7b01, 0x1b80001f, 0x200000d0, 0x1b00001f, 0xbfffe7ff, 0x1b00001f,
	0xffffffff, 0x1b80001f, 0x20000004, 0x8a80000c, 0x2f7be35f, 0xd820192a,
	0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0xf0000000, 0x17c07c1f, 0x1a90001f,
	0x10212018, 0x828fa801, 0xa281b40a, 0xa285340a, 0x82802801, 0xd80017aa,
	0x17c07c1f, 0x1b00001f, 0xffffffff, 0x1b80001f, 0x20000004, 0x8a80000c,
	0x2f7be35f, 0xd80018ea, 0x17c07c1f, 0xe8208000, 0x10006354, 0xffffffff,
	0x1b80001f, 0x20000020, 0x02000408, 0x89c00007, 0xfefeffff, 0xa9c00007,
	0x0010000a, 0x1b80001f, 0x20000020, 0x810ab401, 0x80cbb401, 0x80c00c04,
	0xd80020a3, 0x17c07c1f, 0x89c00007, 0xfffffff5, 0xa9c00007, 0x0000000a,
	0x1b80001f, 0x20000020, 0x810ab401, 0x80cbb401, 0x80c00c04, 0xd80020a3,
	0x17c07c1f, 0x89c00007, 0xffeffff5, 0xa9c00007, 0x01010000, 0x1880001f,
	0x10006814, 0xe0800001, 0x1880001f, 0x10006320, 0xe080000f, 0x1b00001f,
	0x2f7be35f, 0xd0002140, 0x17c07c1f, 0xa0110400, 0xa0140400, 0xa01d8400,
	0x1b00001f, 0x7fffe7ff, 0xf0000000, 0x17c07c1f, 0xe0f07f0d, 0xe0f07f0f,
	0xe0f07f1e, 0xe0f07f12, 0xf0000000, 0x17c07c1f, 0x11407c1f, 0x81f08407,
	0x81f18407, 0x1b80001f, 0x20000001, 0xa1d08407, 0xa1d18407, 0x1b80001f,
	0x20000020, 0x812ab401, 0x80ebb401, 0xa0c00c04, 0xd8202463, 0x17c07c1f,
	0x80c01403, 0xd8202263, 0x01400405, 0x1900001f, 0x10006814, 0xf0000000,
	0xe1000003, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000, 0x17c07c1f,
	0xd800260a, 0x17c07c1f, 0xe2e0006d, 0xe2e0002d, 0xd82026aa, 0x17c07c1f,
	0xe2e0002f, 0xe2e0003e, 0xe2e00032, 0xf0000000, 0x17c07c1f, 0xd80027ea,
	0x17c07c1f, 0xe2e00036, 0x1380201f, 0xe2e0003e, 0x1380201f, 0xe2e0002e,
	0x1380201f, 0xd82028ea, 0x17c07c1f, 0xe2e0006e, 0xe2e0004e, 0xe2e0004c,
	0x1b80001f, 0x20000020, 0xe2e0004d, 0xf0000000, 0x17c07c1f, 0x18c0001f,
	0x10006b6c, 0x1910001f, 0x10006b6c, 0xa1002804, 0xe0c00004, 0xf0000000,
	0x17c07c1f, 0xd8202b29, 0x17c07c1f, 0xe2e0000d, 0xe2e0000c, 0xe2e0001c,
	0xe2e0001e, 0xe2e00016, 0xe2e00012, 0xf0000000, 0x17c07c1f, 0xd8202ca9,
	0x17c07c1f, 0xe2e00016, 0x1380201f, 0xe2e0001e, 0x1380201f, 0xe2e0001c,
	0x1380201f, 0xe2e0000c, 0xe2e0000d, 0xf0000000, 0x17c07c1f, 0x18d0001f,
	0x10006604, 0x10cf8c1f, 0xd8202ce3, 0x17c07c1f, 0xf0000000, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0x1a50001f, 0x10006610, 0x8246a401, 0xe8208000, 0x10006310,
	0x0b160008, 0xe8208000, 0x10006b6c, 0x00000000, 0x1b00001f, 0x2f7be35f,
	0x1b80001f, 0xd00f0000, 0x8880000c, 0x2f7be35f, 0xd80060c2, 0x17c07c1f,
	0xe8208000, 0x10006354, 0xfffe7b01, 0xc0c024e0, 0x17c07c1f, 0x81401801,
	0xd8004bc5, 0x17c07c1f, 0x81f60407, 0x18c0001f, 0x100062a0, 0xc0c02580,
	0x12807c1f, 0x18c0001f, 0x100062b4, 0x1910001f, 0x100062b4, 0xa9000004,
	0x00000001, 0xe0c00004, 0xa9000004, 0x00000011, 0xe0c00004, 0x18c0001f,
	0x100062a0, 0xc0c02580, 0x1280041f, 0x18c0001f, 0x100062b0, 0xc0c02580,
	0x12807c1f, 0xe8208000, 0x100062b8, 0x00000000, 0x1b80001f, 0x20000080,
	0xe8208000, 0x100062b8, 0x00000040, 0xc0c02580, 0x1280041f, 0x18c0001f,
	0x10006290, 0xc0c02580, 0x1280041f, 0xe8208000, 0x10006404, 0x00003101,
	0x81449801, 0xd8004bc5, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200005,
	0xc0c02ce0, 0x17c07c1f, 0xe2200001, 0x81459801, 0xd8004b05, 0x17c07c1f,
	0x18c0001f, 0x10005468, 0x1111041f, 0xe0c00004, 0xd0004b80, 0x17c07c1f,
	0x18c0001f, 0x10005468, 0x1113841f, 0xe0c00004, 0xc0c02ce0, 0x17c07c1f,
	0x81401801, 0xd8004e85, 0x17c07c1f, 0xa1d38407, 0xa0108400, 0xa0148400,
	0xa01b8400, 0xa0188400, 0x18c0001f, 0x10209200, 0x1910001f, 0x10209200,
	0x81200404, 0xe0c00004, 0x18c0001f, 0x1020920c, 0x1910001f, 0x1020920c,
	0xa1108404, 0xe0c00004, 0x81200404, 0xe0c00004, 0xe8208000, 0x10006310,
	0x0b160008, 0x81431801, 0xd8005085, 0x17c07c1f, 0xe8208000, 0x10006310,
	0x0b1600c8, 0x81439801, 0xd8205085, 0x17c07c1f, 0xe8208000, 0x10006310,
	0x0b160038, 0x12007c1f, 0x1b00001f, 0xbfffe7ff, 0x1b80001f, 0x90100000,
	0x1ac0001f, 0x10006b6c, 0xe2c00008, 0xe8208000, 0x10006310, 0x0b160008,
	0x82809c01, 0x1990001f, 0x10006b08, 0x81439801, 0xd8205305, 0x17c07c1f,
	0xca8015aa, 0x17c07c1f, 0xd0005340, 0x17c07c1f, 0xca80000a, 0x17c07c1f,
	0x1990001f, 0x10006b08, 0x81401801, 0xd8005a45, 0x17c07c1f, 0x81449801,
	0xd8005725, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200000, 0xc0c02ce0,
	0x17c07c1f, 0xe2200004, 0x81459801, 0xd8005625, 0x17c07c1f, 0x18c0001f,
	0x10005464, 0x1111041f, 0xe0c00004, 0xd00056a0, 0x17c07c1f, 0x18c0001f,
	0x10005464, 0x1113841f, 0xe0c00004, 0xc0c02ce0, 0x17c07c1f, 0x1b80001f,
	0x200016a8, 0x80388400, 0x18c0001f, 0x1020920c, 0x1910001f, 0x1020920c,
	0xa1000404, 0xe0c00004, 0x1b80001f, 0x20000300, 0x803b8400, 0x81308404,
	0xe0c00004, 0x18c0001f, 0x10209200, 0x1910001f, 0x10209200, 0xa1000404,
	0xe0c00004, 0x1b80001f, 0x20000300, 0x80348400, 0x1b80001f, 0x20000104,
	0x80308400, 0x81f38407, 0x81401801, 0xd80060c5, 0x17c07c1f, 0xe8208000,
	0x10006404, 0x00001101, 0x18c0001f, 0x10006290, 0x1212841f, 0xc0c026e0,
	0x12807c1f, 0xc0c026e0, 0x1280041f, 0x18c0001f, 0x100062b0, 0x1212841f,
	0xc0c026e0, 0x12807c1f, 0xe8208000, 0x100062b8, 0x00000000, 0xe8208000,
	0x100062b8, 0x00000010, 0x1b80001f, 0x20000080, 0xc0c026e0, 0x1280041f,
	0xe8208000, 0x10200268, 0x000ffffe, 0x18c0001f, 0x100062a0, 0x1212841f,
	0xc0c026e0, 0x12807c1f, 0x18c0001f, 0x100062b4, 0x1910001f, 0x100062b4,
	0x89000004, 0xffffffef, 0xe0c00004, 0x89000004, 0xffffffee, 0xe0c00004,
	0x1b80001f, 0x20000a50, 0x18c0001f, 0x100062a0, 0xc0c026e0, 0x1280041f,
	0x19c0001f, 0x01411820, 0x10007c1f, 0xe8208000, 0x10006b40, 0x00000000,
	0xe8208000, 0x100063e0, 0x00000001, 0xf0000000, 0x17c07c1f
};
static struct pcm_desc sodi_pcm = {
	.version	= "pcm_sodi_e2_v0.17_20140617_srf_mrf_txrf",
	.base		= sodi_binary,
	.size		= 785,
	.sess		= 2,
	.replace	= 0,
	.vec2		= EVENT_VEC(30, 1, 0, 0),	/* FUNC_SUSPEND_APSRC_WAKEUP */
	.vec3		= EVENT_VEC(31, 1, 0, 81),	/* FUNC_SUSPEND_APSRC_SLEEP */
	.vec0		= EVENT_VEC(30, 1, 0, 173),	/* FUNC_APSRC_WAKEUP */
	.vec1		= EVENT_VEC(31, 1, 0, 203),	/* FUNC_APSRC_SLEEP */
};
#else	/* !SPM_CTRL_BIG_CPU */
static const u32 sodi_binary[] = {
	0x81411801, 0xd8000165, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xe0e00016,
	0xe0e0001e, 0xe0e0000e, 0xe0e0000f, 0xc2801360, 0x17c07c1f, 0x80368400,
	0x1b80001f, 0x20000208, 0x80370400, 0x1b80001f, 0x20000208, 0x80360400,
	0x803e0400, 0x1b80001f, 0x20000208, 0x80380400, 0x1b80001f, 0x20000208,
	0x803b0400, 0x1b80001f, 0x20000208, 0x803d0400, 0xa01d8400, 0x1b80001f,
	0x20000034, 0x803d8400, 0x1b80001f, 0x2000001a, 0x18c0001f, 0x1000f5c8,
	0x1910001f, 0x1000f5c8, 0xa1000404, 0xe0c00004, 0x18c0001f, 0x100125c8,
	0x1910001f, 0x100125c8, 0xa1000404, 0xe0c00004, 0x1910001f, 0x100125c8,
	0x80340400, 0x17c07c1f, 0x17c07c1f, 0x80310400, 0x1b80001f, 0x2000000a,
	0x18c0001f, 0x10006240, 0xe0e0000d, 0xd8000765, 0x17c07c1f, 0x1b80001f,
	0x20000100, 0x81fa0407, 0x81f08407, 0x81f18407, 0xe8208000, 0x10006354,
	0xfffe7b01, 0xa1d80407, 0xa1dc0407, 0x8880000c, 0x2f7be35f, 0xd82009a2,
	0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0xd00009e0, 0x17c07c1f, 0x1b00001f,
	0xbfffe7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f, 0x20000fdf, 0x1890001f,
	0x10006608, 0x80c98801, 0x810a8801, 0x10918c1f, 0xa0939002, 0xa0950402,
	0x8080080d, 0xd8200ce2, 0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0x1b80001f,
	0x20000004, 0xd800132c, 0x17c07c1f, 0x1b00001f, 0xbfffe7ff, 0xd0001320,
	0x17c07c1f, 0x81f80407, 0x81fc0407, 0xe8208000, 0x10006354, 0xffffffff,
	0x1b80001f, 0x20000020, 0x02000408, 0x1880001f, 0x10006320, 0xc0c02240,
	0xe080000f, 0xd8000c63, 0x17c07c1f, 0xe080001f, 0xa1da0407, 0xa0110400,
	0xa0140400, 0x18c0001f, 0x1000f5c8, 0x1910001f, 0x1000f5c8, 0x81200404,
	0xe0c00004, 0x18c0001f, 0x100125c8, 0x1910001f, 0x100125c8, 0x81200404,
	0xe0c00004, 0x1910001f, 0x100125c8, 0xa01d0400, 0xa01b0400, 0xa0180400,
	0xa01e0400, 0xa0160400, 0xa0170400, 0xa0168400, 0x1b80001f, 0x20000104,
	0x81411801, 0xd80012e5, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xc0c02180,
	0x17c07c1f, 0x1b00001f, 0x7fffe7ff, 0xf0000000, 0x17c07c1f, 0x18c0001f,
	0x100110e4, 0x1910001f, 0x100110e4, 0xa1158404, 0xe0c00004, 0x81358404,
	0xe0c00004, 0x18c0001f, 0x100040e4, 0x1910001f, 0x100040e4, 0xa1158404,
	0xe0c00004, 0x81358404, 0xe0c00004, 0xf0000000, 0x17c07c1f, 0x803d8400,
	0x1b80001f, 0x2000001a, 0x80340400, 0x17c07c1f, 0x17c07c1f, 0x80310400,
	0x89c00007, 0xffeffff5, 0xa9c00007, 0x01010000, 0xe8208000, 0x10006354,
	0xfffe7b01, 0x1b80001f, 0x200000d0, 0x1b00001f, 0xbfffe7ff, 0x1b00001f,
	0xffffffff, 0x1b80001f, 0x20000004, 0x8a80000c, 0x2f7be35f, 0xd820192a,
	0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0xf0000000, 0x17c07c1f, 0x1a90001f,
	0x10212018, 0x828fa801, 0xa281b40a, 0xa285340a, 0x82802801, 0xd80017aa,
	0x17c07c1f, 0x1b00001f, 0xffffffff, 0x1b80001f, 0x20000004, 0x8a80000c,
	0x2f7be35f, 0xd80018ea, 0x17c07c1f, 0xe8208000, 0x10006354, 0xffffffff,
	0x1b80001f, 0x20000020, 0x02000408, 0x89c00007, 0xfefeffff, 0xa9c00007,
	0x0010000a, 0x1b80001f, 0x20000020, 0x810ab401, 0x80cbb401, 0x80c00c04,
	0xd80020a3, 0x17c07c1f, 0x89c00007, 0xfffffff5, 0xa9c00007, 0x0000000a,
	0x1b80001f, 0x20000020, 0x810ab401, 0x80cbb401, 0x80c00c04, 0xd80020a3,
	0x17c07c1f, 0x89c00007, 0xffeffff5, 0xa9c00007, 0x01010000, 0x1880001f,
	0x10006814, 0xe0800001, 0x1880001f, 0x10006320, 0xe080000f, 0x1b00001f,
	0x2f7be35f, 0xd0002140, 0x17c07c1f, 0xa0110400, 0xa0140400, 0xa01d8400,
	0x1b00001f, 0x7fffe7ff, 0xf0000000, 0x17c07c1f, 0xe0f07f0d, 0xe0f07f0f,
	0xe0f07f1e, 0xe0f07f12, 0xf0000000, 0x17c07c1f, 0x11407c1f, 0x81f08407,
	0x81f18407, 0x1b80001f, 0x20000001, 0xa1d08407, 0xa1d18407, 0x1b80001f,
	0x20000020, 0x812ab401, 0x80ebb401, 0xa0c00c04, 0xd8202463, 0x17c07c1f,
	0x80c01403, 0xd8202263, 0x01400405, 0x1900001f, 0x10006814, 0xf0000000,
	0xe1000003, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000, 0x17c07c1f,
	0xd800260a, 0x17c07c1f, 0xe2e0006d, 0xe2e0002d, 0xd82026aa, 0x17c07c1f,
	0xe2e0002f, 0xe2e0003e, 0xe2e00032, 0xf0000000, 0x17c07c1f, 0xd80027ea,
	0x17c07c1f, 0xe2e00036, 0x1380201f, 0xe2e0003e, 0x1380201f, 0xe2e0002e,
	0x1380201f, 0xd82028ea, 0x17c07c1f, 0xe2e0006e, 0xe2e0004e, 0xe2e0004c,
	0x1b80001f, 0x20000020, 0xe2e0004d, 0xf0000000, 0x17c07c1f, 0x18c0001f,
	0x10006b6c, 0x1910001f, 0x10006b6c, 0xa1002804, 0xe0c00004, 0xf0000000,
	0x17c07c1f, 0xd8202b29, 0x17c07c1f, 0xe2e0000d, 0xe2e0000c, 0xe2e0001c,
	0xe2e0001e, 0xe2e00016, 0xe2e00012, 0xf0000000, 0x17c07c1f, 0xd8202ca9,
	0x17c07c1f, 0xe2e00016, 0x1380201f, 0xe2e0001e, 0x1380201f, 0xe2e0001c,
	0x1380201f, 0xe2e0000c, 0xe2e0000d, 0xf0000000, 0x17c07c1f, 0x18d0001f,
	0x10006604, 0x10cf8c1f, 0xd8202ce3, 0x17c07c1f, 0xf0000000, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0x1a50001f, 0x10006610, 0x8246a401, 0xe8208000, 0x10006310,
	0x0b160008, 0xe8208000, 0x10006b6c, 0x00000000, 0x1b00001f, 0x2f7be35f,
	0x1b80001f, 0xd00f0000, 0x8880000c, 0x2f7be35f, 0xd8005802, 0x17c07c1f,
	0xe8208000, 0x10006354, 0xfffe7b01, 0xc0c024e0, 0x17c07c1f, 0x81401801,
	0xd8004965, 0x17c07c1f, 0x81f60407, 0x18c0001f, 0x10006200, 0xc0c02580,
	0x12807c1f, 0xe8208000, 0x1000625c, 0x00000001, 0x1b80001f, 0x20000080,
	0xc0c02580, 0x1280041f, 0x18c0001f, 0x10006204, 0xc0c02a20, 0x1280041f,
	0x18c0001f, 0x10006208, 0xc0c02580, 0x12807c1f, 0xe8208000, 0x10006248,
	0x00000000, 0x1b80001f, 0x20000080, 0xc0c02580, 0x1280041f, 0x18c0001f,
	0x10006290, 0xc0c02580, 0x1280041f, 0xe8208000, 0x10006404, 0x00003101,
	0x81449801, 0xd8004965, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200007,
	0xc0c02ce0, 0x17c07c1f, 0xe2200003, 0xc0c02ce0, 0x17c07c1f, 0x81401801,
	0xd8004a65, 0x17c07c1f, 0xa1d38407, 0xa0108400, 0xa0148400, 0xa01b8400,
	0xa0188400, 0xe8208000, 0x10006310, 0x0b160008, 0x81431801, 0xd8004c65,
	0x17c07c1f, 0xe8208000, 0x10006310, 0x0b1600c8, 0x81439801, 0xd8204c65,
	0x17c07c1f, 0xe8208000, 0x10006310, 0x0b160038, 0x12007c1f, 0x1b00001f,
	0xbfffe7ff, 0x1b80001f, 0x90100000, 0x1ac0001f, 0x10006b6c, 0xe2c00008,
	0xe8208000, 0x10006310, 0x0b160008, 0x82809c01, 0x1990001f, 0x10006b08,
	0x81439801, 0xd8204ee5, 0x17c07c1f, 0xca8015aa, 0x17c07c1f, 0xd0004f20,
	0x17c07c1f, 0xca80000a, 0x17c07c1f, 0x1990001f, 0x10006b08, 0x81401801,
	0xd80052c5, 0x17c07c1f, 0x81449801, 0xd8005165, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0xe2200002, 0xc0c02ce0, 0x17c07c1f, 0xe2200006, 0xc0c02ce0,
	0x17c07c1f, 0x1b80001f, 0x200016a8, 0x80388400, 0x1b80001f, 0x20000300,
	0x803b8400, 0x1b80001f, 0x20000300, 0x80348400, 0x1b80001f, 0x20000104,
	0x80308400, 0x81f38407, 0x81401801, 0xd8005805, 0x17c07c1f, 0xe8208000,
	0x10006404, 0x00002101, 0x18c0001f, 0x10006290, 0x1212841f, 0xc0c026e0,
	0x12807c1f, 0xc0c026e0, 0x1280041f, 0x18c0001f, 0x10006208, 0x1212841f,
	0xc0c026e0, 0x12807c1f, 0xe8208000, 0x10006248, 0x00000001, 0x1b80001f,
	0x20000080, 0xc0c026e0, 0x1280041f, 0x18c0001f, 0x10006204, 0x1212841f,
	0xc0c02b60, 0x1280041f, 0x18c0001f, 0x10006200, 0x1212841f, 0xc0c026e0,
	0x12807c1f, 0xe8208000, 0x1000625c, 0x00000000, 0x1b80001f, 0x20000080,
	0xc0c026e0, 0x1280041f, 0x19c0001f, 0x01411820, 0x10007c1f, 0xe8208000,
	0x10006b30, 0x00000000, 0xe8208000, 0x100063e0, 0x00000001, 0xf0000000,
	0x17c07c1f
};
static struct pcm_desc sodi_pcm = {
	.version	= "pcm_sodi_e2_v0.17_20140617_srf_mrf_txrf",
	.base		= sodi_binary,
	.size		= 715,
	.sess		= 2,
	.replace	= 0,
	.vec2		= EVENT_VEC(30, 1, 0, 0),	/* FUNC_SUSPEND_APSRC_WAKEUP */
	.vec3		= EVENT_VEC(31, 1, 0, 81),	/* FUNC_SUSPEND_APSRC_SLEEP */
	.vec0		= EVENT_VEC(30, 1, 0, 173),	/* FUNC_APSRC_WAKEUP */
	.vec1		= EVENT_VEC(31, 1, 0, 203),	/* FUNC_APSRC_SLEEP */
};
#endif

static const u32 sodi_binary_e2[] = {
	0x81411801, 0xd8000165, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xe0e00016,
	0xe0e0001e, 0xe0e0000e, 0xe0e0000f, 0xc2801320, 0x17c07c1f, 0x80368400,
	0x1b80001f, 0x20000208, 0x80370400, 0x1b80001f, 0x20000208, 0x80360400,
	0x803e0400, 0x1b80001f, 0x20000208, 0x80380400, 0x803b0400, 0xa01d8400,
	0x1b80001f, 0x20000034, 0x803d8400, 0x1b80001f, 0x20000152, 0x803d0400,
	0x1b80001f, 0x20000208, 0x18c0001f, 0x1000f5c8, 0x1910001f, 0x1000f5c8,
	0xa1000404, 0xe0c00004, 0x18c0001f, 0x100125c8, 0x1910001f, 0x100125c8,
	0xa1000404, 0xe0c00004, 0x1910001f, 0x100125c8, 0x80340400, 0x17c07c1f,
	0x17c07c1f, 0x80310400, 0x1b80001f, 0x2000000a, 0x18c0001f, 0x10006240,
	0xe0e0000d, 0xd8000725, 0x17c07c1f, 0x1b80001f, 0x20000100, 0x81fa0407,
	0x81f08407, 0x81f18407, 0xe8208000, 0x10006354, 0xfffe7b01, 0xa1d80407,
	0xa1dc0407, 0x8880000c, 0x2f7be35f, 0xd8200962, 0x17c07c1f, 0x1b00001f,
	0x3fffe7ff, 0xd00009a0, 0x17c07c1f, 0x1b00001f, 0xbfffe7ff, 0xf0000000,
	0x17c07c1f, 0x1b80001f, 0x20000fdf, 0x1890001f, 0x10006608, 0x80c98801,
	0x810a8801, 0x10918c1f, 0xa0939002, 0xa0950402, 0x8080080d, 0xd8200ca2,
	0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0x1b80001f, 0x20000004, 0xd80012ec,
	0x17c07c1f, 0x1b00001f, 0xbfffe7ff, 0xd00012e0, 0x17c07c1f, 0x81f80407,
	0x81fc0407, 0xe8208000, 0x10006354, 0xffffffff, 0x1b80001f, 0x20000020,
	0x02000408, 0x1880001f, 0x10006320, 0xc0c02260, 0xe080000f, 0xd8000c23,
	0x17c07c1f, 0xe080001f, 0xa1da0407, 0xa0110400, 0xa0140400, 0x18c0001f,
	0x1000f5c8, 0x1910001f, 0x1000f5c8, 0x81200404, 0xe0c00004, 0x18c0001f,
	0x100125c8, 0x1910001f, 0x100125c8, 0x81200404, 0xe0c00004, 0x1910001f,
	0x100125c8, 0xa01d0400, 0xa01b0400, 0xa0180400, 0xa01e0400, 0xa0160400,
	0xa0170400, 0xa0168400, 0x1b80001f, 0x20000104, 0x81411801, 0xd80012a5,
	0x17c07c1f, 0x18c0001f, 0x10006240, 0xc0c021a0, 0x17c07c1f, 0x1b00001f,
	0x7fffe7ff, 0xf0000000, 0x17c07c1f, 0x18c0001f, 0x100110e4, 0x1910001f,
	0x100110e4, 0xa1158404, 0xe0c00004, 0x81358404, 0xe0c00004, 0x18c0001f,
	0x100040e4, 0x1910001f, 0x100040e4, 0xa1158404, 0xe0c00004, 0x81358404,
	0xe0c00004, 0xf0000000, 0x17c07c1f, 0x803d8400, 0x1b80001f, 0x2000001a,
	0x80340400, 0x17c07c1f, 0x17c07c1f, 0x80310400, 0x89c00007, 0xffeffff5,
	0xa9c00007, 0x01010000, 0xe8208000, 0x10006354, 0xfffe7b01, 0x1b80001f,
	0x200000d0, 0x1b00001f, 0xbfffe7ff, 0x1b00001f, 0xffffffff, 0x1b80001f,
	0x20000004, 0x8a80000c, 0x2f7be35f, 0xd82018ea, 0x17c07c1f, 0x1b00001f,
	0x3fffe7ff, 0xf0000000, 0x17c07c1f, 0x1a90001f, 0x10212018, 0x828fa801,
	0xa281b40a, 0xa285340a, 0x82802801, 0xd800176a, 0x17c07c1f, 0x1b00001f,
	0xffffffff, 0x1b80001f, 0x20000004, 0x8a80000c, 0x2f7be35f, 0xd80018aa,
	0x17c07c1f, 0xe8208000, 0x10006354, 0xffffffff, 0x1b80001f, 0x20000020,
	0x02000408, 0x89c00007, 0xfefeffff, 0xa9c00007, 0x0010000a, 0x1b80001f,
	0x20000020, 0x810ab401, 0x80cbb401, 0x80c00c04, 0xd8002063, 0x17c07c1f,
	0x89c00007, 0xfffffff5, 0xa9c00007, 0x0000000a, 0x1b80001f, 0x20000020,
	0x810ab401, 0x80cbb401, 0x80c00c04, 0xd8002063, 0x17c07c1f, 0x89c00007,
	0xffeffff5, 0xa9c00007, 0x01010000, 0x1880001f, 0x10006814, 0xe0800001,
	0x1880001f, 0x10006320, 0xe080000f, 0x1b00001f, 0x2f7be35f, 0xd0002160,
	0x17c07c1f, 0xa0110400, 0xa0140400, 0x814f9801, 0xd8002125, 0x17c07c1f,
	0xa01d8400, 0x1b00001f, 0x7fffe7ff, 0xf0000000, 0x17c07c1f, 0xe0f07f0d,
	0xe0f07f0f, 0xe0f07f1e, 0xe0f07f12, 0xf0000000, 0x17c07c1f, 0x11407c1f,
	0x81f08407, 0x81f18407, 0x1b80001f, 0x20000001, 0xa1d08407, 0xa1d18407,
	0x1b80001f, 0x20000020, 0x812ab401, 0x80ebb401, 0xa0c00c04, 0xd8202483,
	0x17c07c1f, 0x80c01403, 0xd8202283, 0x01400405, 0x1900001f, 0x10006814,
	0xf0000000, 0xe1000003, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000,
	0x17c07c1f, 0xd800262a, 0x17c07c1f, 0xe2e0006d, 0xe2e0002d, 0xd82026ca,
	0x17c07c1f, 0xe2e0002f, 0xe2e0003e, 0xe2e00032, 0xf0000000, 0x17c07c1f,
	0xd800282a, 0x17c07c1f, 0xe2e00036, 0x1380201f, 0xe2e0003e, 0x1380201f,
	0xe2e0002e, 0x1380201f, 0xe2e0002c, 0xd820290a, 0x17c07c1f, 0xe2e0006c,
	0xe2e0004c, 0x1b80001f, 0x20000020, 0xe2e0004d, 0xf0000000, 0x17c07c1f,
	0x18c0001f, 0x10006b6c, 0x1910001f, 0x10006b6c, 0xa1002804, 0xe0c00004,
	0xf0000000, 0x17c07c1f, 0xd8202b49, 0x17c07c1f, 0xe2e0000d, 0xe2e0000c,
	0xe2e0001c, 0xe2e0001e, 0xe2e00016, 0xe2e00012, 0xf0000000, 0x17c07c1f,
	0xd8202cc9, 0x17c07c1f, 0xe2e00016, 0x1380201f, 0xe2e0001e, 0x1380201f,
	0xe2e0001c, 0x1380201f, 0xe2e0000c, 0xe2e0000d, 0xf0000000, 0x17c07c1f,
	0x18d0001f, 0x10006604, 0x10cf8c1f, 0xd8202d03, 0x17c07c1f, 0xf0000000,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0x1a50001f, 0x10006610, 0x8246a401, 0xe8208000, 0x10006310,
	0x0b160008, 0xe8208000, 0x10006b6c, 0x00000000, 0x1b00001f, 0x2f7be35f,
	0x1b80001f, 0xd00f0000, 0x8880000c, 0x2f7be35f, 0xd8005802, 0x17c07c1f,
	0xe8208000, 0x10006354, 0xfffe7b01, 0xc0c02500, 0x17c07c1f, 0x81401801,
	0xd8004965, 0x17c07c1f, 0x81f60407, 0x18c0001f, 0x10006200, 0xc0c025a0,
	0x12807c1f, 0xe8208000, 0x1000625c, 0x00000001, 0x1b80001f, 0x20000080,
	0xc0c025a0, 0x1280041f, 0x18c0001f, 0x10006204, 0xc0c02a40, 0x1280041f,
	0x18c0001f, 0x10006208, 0xc0c025a0, 0x12807c1f, 0xe8208000, 0x10006248,
	0x00000000, 0x1b80001f, 0x20000080, 0xc0c025a0, 0x1280041f, 0x18c0001f,
	0x10006290, 0xc0c025a0, 0x1280041f, 0xe8208000, 0x10006404, 0x00003101,
	0x81449801, 0xd8004965, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200007,
	0xc0c02d00, 0x17c07c1f, 0xe2200003, 0xc0c02d00, 0x17c07c1f, 0x81401801,
	0xd8004a65, 0x17c07c1f, 0xa1d38407, 0xa0108400, 0xa0148400, 0xa01b8400,
	0xa0188400, 0xe8208000, 0x10006310, 0x0b160008, 0x81431801, 0xd8004c65,
	0x17c07c1f, 0xe8208000, 0x10006310, 0x0b1600c8, 0x81439801, 0xd8204c65,
	0x17c07c1f, 0xe8208000, 0x10006310, 0x0b160038, 0x12007c1f, 0x1b00001f,
	0xbfffe7ff, 0x1b80001f, 0x90100000, 0x1ac0001f, 0x10006b6c, 0xe2c00008,
	0xe8208000, 0x10006310, 0x0b160008, 0x82809c01, 0x1990001f, 0x10006b08,
	0x81439801, 0xd8204ee5, 0x17c07c1f, 0xca80156a, 0x17c07c1f, 0xd0004f20,
	0x17c07c1f, 0xca80000a, 0x17c07c1f, 0x1990001f, 0x10006b08, 0x81401801,
	0xd80052c5, 0x17c07c1f, 0x81449801, 0xd8005165, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0xe2200002, 0xc0c02d00, 0x17c07c1f, 0xe2200006, 0xc0c02d00,
	0x17c07c1f, 0x1b80001f, 0x200016a8, 0x80388400, 0x1b80001f, 0x20000300,
	0x803b8400, 0x1b80001f, 0x20000300, 0x80348400, 0x1b80001f, 0x20000104,
	0x80308400, 0x81f38407, 0x81401801, 0xd8005805, 0x17c07c1f, 0xe8208000,
	0x10006404, 0x00002101, 0x18c0001f, 0x10006290, 0x1212841f, 0xc0c02700,
	0x12807c1f, 0xc0c02700, 0x1280041f, 0x18c0001f, 0x10006208, 0x1212841f,
	0xc0c02700, 0x12807c1f, 0xe8208000, 0x10006248, 0x00000001, 0x1b80001f,
	0x20000080, 0xc0c02700, 0x1280041f, 0x18c0001f, 0x10006204, 0x1212841f,
	0xc0c02b80, 0x1280041f, 0x18c0001f, 0x10006200, 0x1212841f, 0xc0c02700,
	0x12807c1f, 0xe8208000, 0x1000625c, 0x00000000, 0x1b80001f, 0x20000080,
	0xc0c02700, 0x1280041f, 0x19c0001f, 0x01411820, 0x10007c1f, 0xe8208000,
	0x10006b30, 0x00000000, 0xe8208000, 0x100063e0, 0x00000001, 0xf0000000,
	0x17c07c1f
};
static struct pcm_desc sodi_pcm_e2 = {
	.version	= "pcm_sodi_e2_v0.20_20140727_mtcmos",
	.base		= sodi_binary_e2,
	.size		= 715,
	.sess		= 2,
	.replace	= 0,
	.vec2		= EVENT_VEC(30, 1, 0, 0),	/* FUNC_SUSPEND_APSRC_WAKEUP */
	.vec3		= EVENT_VEC(31, 1, 0, 79),	/* FUNC_SUSPEND_APSRC_SLEEP */
	.vec0		= EVENT_VEC(30, 1, 0, 171),	/* FUNC_APSRC_WAKEUP */
	.vec1		= EVENT_VEC(31, 1, 0, 201),	/* FUNC_APSRC_SLEEP */
};

static struct pwr_ctrl sodi_ctrl = {
	.wake_src		= WAKE_SRC_FOR_SODI,
	.wake_src_md32		= WAKE_SRC_FOR_MD32,
	.r0_ctrl_en		= 1,
	.r7_ctrl_en		= 1,
	.wfi_op			= WFI_OP_AND,
#if 1
	.ca15_wfi0_en		= 1,
	.ca15_wfi1_en		= 1,
	.ca15_wfi2_en		= 1,
	.ca15_wfi3_en		= 1,
	.ca7_wfi0_en		= 1,
	.ca7_wfi1_en		= 1,
	.ca7_wfi2_en		= 1,
	.ca7_wfi3_en		= 1,
	.md2_req_mask		= 1,
	.mfg_req_mask		= 1,
#if SPM_BYPASS_SYSPWREQ
	.syspwreq_mask		= 1,
#endif
#else
	.ca15_wfi0_en		= 1,
	.ca15_wfi1_en		= 1,
	.ca15_wfi2_en		= 1,
	.ca15_wfi3_en		= 1,
	.ca7_wfi0_en		= 1,
	.ca7_wfi1_en		= 1,
	.ca7_wfi2_en		= 1,
	.ca7_wfi3_en		= 1,
	.md2_req_mask		= 1,
	.md1_req_mask		= 0,
	.disp_req_mask		= 0,
	.mfg_req_mask		= 1,
	.md32_req_mask		= 0,
#if SPM_BYPASS_SYSPWREQ
	.syspwreq_mask		= 1,
#endif

#endif
};

struct spm_lp_scen __spm_sodi = {
	.pcmdesc	= &sodi_pcm,
	.pwrctrl	= &sodi_ctrl,
};

static bool gSpm_SODI_mempll_pwr_mode = 1;
static bool gSpm_sodi_en=0;

extern int mt_irq_mask_all(struct mtk_irq_mask *mask);
extern int mt_irq_mask_restore(struct mtk_irq_mask *mask);
extern void mt_irq_unmask_for_sleep(unsigned int irq);

extern void soidle_before_wfi(int cpu);
extern void soidle_after_wfi(int cpu);


void __attribute__((weak)) soidle_before_wfi(int cpu)
{
}

void __attribute__((weak)) soidle_after_wfi(int cpu)
{
}
static void spm_trigger_wfi_for_sodi(struct pwr_ctrl *pwrctrl)
{
    //sync_hw_gating_value();     /* for Vcore DVFS */

    if (is_cpu_pdn(pwrctrl->pcm_flags)) {
        mt_cpu_dormant(CPU_SODI_MODE);
    } else {
        
        spm_write(CA7_BUS_CONFIG, spm_read(CA7_BUS_CONFIG) | 0x10);
        wfi_with_sync();
        spm_write(CA7_BUS_CONFIG, spm_read(CA7_BUS_CONFIG) & ~0x10);

    }
}

void spm_go_to_sodi(u32 spm_flags, u32 spm_data)
{
    struct wake_status wakesta;
    unsigned long flags;
    struct mtk_irq_mask mask;
    wake_reason_t wr = WR_NONE;
    struct pcm_desc *pcmdesc = __spm_sodi.pcmdesc;
    struct pwr_ctrl *pwrctrl = __spm_sodi.pwrctrl;

    set_pwrctrl_pcm_flags(pwrctrl, spm_flags);

    /* set PMIC WRAP table for deepidle power control */
    mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_SODI);	

    spin_lock_irqsave(&__spm_lock, flags);

    mt_irq_mask_all(&mask);
    mt_irq_unmask_for_sleep(MT_SPM_IRQ_ID);
    mt_cirq_clone_gic();
    mt_cirq_enable();

    __spm_reset_and_init_pcm(pcmdesc);
#if 0//workaroud for ca17 disp mempll power down switch crash
    if(gSpm_SODI_mempll_pwr_mode == 1)
    {
        //MEMPLL reset mode
        pwrctrl->pcm_flags |= SPM_MEMPLL_RESET;
    }
    else
        pwrctrl->pcm_flags &= ~SPM_MEMPLL_RESET;
#else
    pwrctrl->pcm_flags |= SPM_MEMPLL_RESET;
#endif

    __spm_kick_im_to_fetch(pcmdesc);

    __spm_init_pcm_register();

    __spm_init_event_vector(pcmdesc);

    __spm_set_power_control(pwrctrl);

    __spm_set_wakeup_event(pwrctrl);

    __spm_kick_pcm_to_run(pwrctrl);
    
    soidle_before_wfi(0);

    spm_trigger_wfi_for_sodi(pwrctrl);

    soidle_after_wfi(0);

    __spm_get_wakeup_status(&wakesta);

    __spm_clean_after_wakeup();	

    wr = __spm_output_wake_reason(&wakesta, pcmdesc, false);

    mt_cirq_flush();
    mt_cirq_disable();
    mt_irq_mask_restore(&mask);

    spin_unlock_irqrestore(&__spm_lock, flags);
	
     /* set PMIC WRAP table for normal power control */
    mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_NORMAL);  
    //return wr;

}
void spm_sodi_mempll_pwr_mode(bool pwr_mode)
{
    gSpm_SODI_mempll_pwr_mode = pwr_mode;
}

void spm_enable_sodi(bool en)
{
    gSpm_sodi_en=en;
}

bool spm_get_sodi_en(void)
{
    return gSpm_sodi_en;
}

static void spm_set_sodi_pcm_ver(void)
{
    CHIP_SW_VER ver=mt_get_chip_sw_ver();

    if(CHIP_SW_VER_02<=ver)
    {
    	/*E2 SODI FW*/
        __spm_sodi.pcmdesc = &sodi_pcm_e2;
    }	
}

void spm_sodi_init(void)
{
    spm_set_sodi_pcm_ver();
}


#if 0
void spm_sodi_lcm_video_mode(bool IsLcmVideoMode)
{
    gSpm_IsLcmVideoMode = IsLcmVideoMode;

    spm_idle_ver("spm_sodi_lcm_video_mode() : gSpm_IsLcmVideoMode = %x\n", gSpm_IsLcmVideoMode);    
    
}
#endif
MODULE_DESCRIPTION("SPM-SODI Driver v0.1");
