/*****************************************************************************
 *
 * Filename:
 * ---------
 *   OV5693mipi_Sensor.c
 *
 * Project:
 * --------
 *   ALPS
 *
 * Description:
 * ------------
 *   Source code of Sensor driver
 *
 *
 *------------------------------------------------------------------------------
 * Upper this line, this part is controlled by CC/CQ. DO NOT MODIFY!!
 *============================================================================
 ****************************************************************************/

#include <linux/videodev2.h>
#include <linux/i2c.h>
#include <linux/platform_device.h>
#include <linux/delay.h>
#include <linux/cdev.h>
#include <linux/uaccess.h>
#include <linux/fs.h>
#include <asm/atomic.h>
#include <asm/system.h>

#include <linux/proc_fs.h> 

#include <linux/dma-mapping.h>
#include <linux/slab.h> 
//slab.h add for kmalloc & kfree build error

#include "kd_camera_hw.h"
#include "kd_imgsensor.h"
#include "kd_imgsensor_define.h"
#include "kd_imgsensor_errcode.h"

#include "ov5693mipiraw_Sensor.h"
#include "ov5693mipiraw_Camera_Sensor_para.h"
#include "ov5693mipiraw_CameraCustomized.h"

//#define OV5693MIPI_DRIVER_TRACE
//#define OV5693MIPI_DEBUG
#ifdef OV5693MIPI_DEBUG
#define SENSORDB(fmt, arg...) printk("%s: " fmt "\n", __FUNCTION__ ,##arg)
#else
#define SENSORDB(x,...)
#endif
#define OV5693_OTP
typedef enum
{
    OV5693MIPI_SENSOR_MODE_INIT,
    OV5693MIPI_SENSOR_MODE_PREVIEW,  
    OV5693MIPI_SENSOR_MODE_CAPTURE,
    OV5693MIPI_SENSOR_MODE_VIDEO,
} OV5693MIPI_SENSOR_MODE;

/* SENSOR PRIVATE STRUCT */
typedef struct OV5693MIPI_sensor_STRUCT
{
    MSDK_SENSOR_CONFIG_STRUCT cfg_data;
    sensor_data_struct eng; /* engineer mode */
    MSDK_SENSOR_ENG_INFO_STRUCT eng_info;
    kal_uint8 mirror;

    OV5693MIPI_SENSOR_MODE sensor_mode;
    
    kal_bool video_mode;
    kal_bool NightMode;
    kal_uint16 normal_fps; /* video normal mode max fps */
    kal_uint16 night_fps; /* video night mode max fps */
    kal_uint16 FixedFps;
    kal_uint16 shutter;
    kal_uint16 gain;
    kal_uint32 pclk;
    kal_uint16 frame_length;
    kal_uint16 line_length;

    kal_uint16 dummy_pixel;
    kal_uint16 dummy_line;
} OV5693MIPI_sensor_struct;

static kal_bool ov5693_otp_shading_read = KAL_TRUE;
static int otp_lenc[62];
  

static MSDK_SCENARIO_ID_ENUM mCurrentScenarioId = MSDK_SCENARIO_ID_CAMERA_PREVIEW;
static kal_bool OV5693MIPIAutoFlickerMode = KAL_FALSE;

extern int iReadRegI2C(u8 *a_pSendData , u16 a_sizeSendData, u8 * a_pRecvData, u16 a_sizeRecvData, u16 i2cId);
extern int iWriteRegI2C(u8 *a_pSendData , u16 a_sizeSendData, u16 i2cId);
extern int iMultiWriteReg(u8 *pData, u16 lens, u16 i2cId);
UINT32 OV5693MIPISetMaxFrameRate(UINT16 u2FrameRate);

static DEFINE_SPINLOCK(ov5693mipi_drv_lock);
#define OV5693_multi_write_cmos_sensor(pData, lens) iMultiWriteReg((u8*) pData, (u16) lens, OV5693MIPI_WRITE_ID)


static OV5693MIPI_sensor_struct OV5693MIPI_sensor =
{
    .eng =
    {
        .reg = CAMERA_SENSOR_REG_DEFAULT_VALUE,
        .cct = CAMERA_SENSOR_CCT_DEFAULT_VALUE,
    },
    .eng_info =
    {
        .SensorId = 128,
        .SensorType = CMOS_SENSOR,
        .SensorOutputDataFormat = OV5693MIPI_COLOR_FORMAT,
    },
    .sensor_mode = OV5693MIPI_SENSOR_MODE_INIT,
    .shutter = 0x3D0,  
    .gain = 0x100,
    .pclk = OV5693MIPI_PREVIEW_CLK,
    .frame_length = OV5693MIPI_PV_PERIOD_LINE_NUMS,
    .line_length = OV5693MIPI_PV_PERIOD_PIXEL_NUMS,
    .dummy_pixel = 0,
    .dummy_line = 0,
};


kal_uint16 OV5693MIPI_read_cmos_sensor(kal_uint32 addr)
{
    kal_uint16 get_byte=0;

    char puSendCmd[2] = {(char)(addr >> 8), (char)(addr & 0xFF) };
    iReadRegI2C(puSendCmd, 2, (u8*)&get_byte, 1, OV5693MIPI_WRITE_ID);

    return get_byte;
}

kal_uint16 OV5693MIPI_write_cmos_sensor(kal_uint32 addr, kal_uint32 para)
{
    char puSendCmd[3] = {(char)(addr >> 8), (char)(addr & 0xFF), (char)(para & 0xFF)};
    iWriteRegI2C(puSendCmd, 3, OV5693MIPI_WRITE_ID);
}
#if defined(OV5693_OTP)
#define BG_Ratio_Typical 0x147
#define RG_Ratio_Typical 0x16C

struct otp_struct {
          int module_integrator_id;
          int lens_id;
          int production_year;
          int production_month;
          int production_day;
          int rg_ratio;
          int bg_ratio;
          int light_rg;
          int light_bg;
          int user_data[5];
          int lenc[62];
          int VCM_start;
          int VCM_end;
};

int check_otp_wb(int index)
{
	int flag, i;
	int bank, address;
	// select bank index
	bank = 0xc0 | index;
	OV5693MIPI_write_cmos_sensor(0x3d84, bank);
	// read otp into buffer
	OV5693MIPI_write_cmos_sensor(0x3d81, 0x01);
	mdelay(5);
	
	// read flag
	address = 0x3d00;
	flag = OV5693MIPI_read_cmos_sensor(address);
	flag = flag & 0xc0;
	
	// clear otp buffer
	for (i=0;i<16;i++) {
		OV5693MIPI_write_cmos_sensor(0x3d00 + i, 0x00);
	}
	
	if (flag == 0x00) 
	{
	           return 0;
	}
	else if (flag & 0x80) 
	{
		return 1;
	}
	else {
		return 2;
	}
}



// index: index of otp group. (1, 2, 3)
// return:              0, group index is empty
//                      1, group index has invalid data
//                      2, group index has valid data
int check_otp_lenc(int index)
{
	int flag, i, bank;
	int address;
	// select bank: 4, 8, 12
	bank = 0xc0 | (index * 4);
	OV5693MIPI_write_cmos_sensor(0x3d84, bank);
	// read otp into buffer
	OV5693MIPI_write_cmos_sensor(0x3d81, 0x01);
	mdelay(5);
	// read flag
	address = 0x3d00;
	flag = OV5693MIPI_read_cmos_sensor(address);
	flag = flag & 0xc0;
	// clear otp buffer
	for (i=0;i<16;i++) {
		OV5693MIPI_write_cmos_sensor(0x3d00 + i, 0x00);
	}
	if (flag == 0x00) {
        return 0;
	}
	else if (flag & 0x80) {
        return 1;
	}
	else {
        return 2;
	}
}
// index: index of otp group. (1, 2, 3)
// otp_ptr: pointer of otp_struct
// return:             0,
int read_otp_wb(int index, struct otp_struct *otp_ptr)
{
	int i, bank;
	int address;
	int temp;
	// select bank index
	bank = 0xc0 | index;
	OV5693MIPI_write_cmos_sensor(0x3d84, bank);
	// read otp into buffer
	OV5693MIPI_write_cmos_sensor(0x3d81, 0x01);
	mdelay(5);
	address = 0x3d00;
	(*otp_ptr).module_integrator_id = OV5693MIPI_read_cmos_sensor(address + 1);
	(*otp_ptr).lens_id = OV5693MIPI_read_cmos_sensor(address + 2);
	(*otp_ptr).production_year = OV5693MIPI_read_cmos_sensor(address + 3);
	(*otp_ptr).production_month = OV5693MIPI_read_cmos_sensor(address + 4);
	(*otp_ptr).production_day = OV5693MIPI_read_cmos_sensor(address + 5);
	temp = OV5693MIPI_read_cmos_sensor(address + 10);
	(*otp_ptr).rg_ratio = (OV5693MIPI_read_cmos_sensor(address + 6)<<2) + ((temp>>6) & 0x03);
	(*otp_ptr).bg_ratio = (OV5693MIPI_read_cmos_sensor(address + 7)<<2) + ((temp>>4) & 0x03);
	(*otp_ptr).light_rg = (OV5693MIPI_read_cmos_sensor(address + 8) <<2) + ((temp>>2) & 0x03);
	(*otp_ptr).light_bg = (OV5693MIPI_read_cmos_sensor(address + 9)<<2) + (temp & 0x03);
	(*otp_ptr).user_data[0] = OV5693MIPI_read_cmos_sensor(address + 11);
	(*otp_ptr).user_data[1] = OV5693MIPI_read_cmos_sensor(address + 12);
	(*otp_ptr).user_data[2] = OV5693MIPI_read_cmos_sensor(address + 13);
	(*otp_ptr).user_data[3] = OV5693MIPI_read_cmos_sensor(address + 14);
	(*otp_ptr).user_data[4] = OV5693MIPI_read_cmos_sensor(address + 15);
	SENSORDB("(*otp_ptr).rg_ratio =0x%x, (*otp_ptr).bg_ratio=0x%x\n",(*otp_ptr).rg_ratio, (*otp_ptr).bg_ratio);
	// clear otp buffer
	for (i=0;i<16;i++) {
		OV5693MIPI_write_cmos_sensor(0x3d00 + i, 0x00);
	}
	return 0;
}
// index: index of otp group. (1, 2, 3)
// otp_ptr: pointer of otp_struct
// return:            0,
int read_otp_lenc(int index)
{
	int bank, i;
	int address;
	// select bank: 4, 8, 12
	bank = 0xc0 | (index * 4);
	OV5693MIPI_write_cmos_sensor(0x3d84, bank);
	
	// read otp into buffer
	OV5693MIPI_write_cmos_sensor(0x3d81, 0x01);
	mdelay(5);
	address = 0x3d01;
	
	for(i=0;i<15;i++) 
	{
		otp_lenc[i]=OV5693MIPI_read_cmos_sensor(address);
		SENSORDB("read ADRESS:=0x%x, PARA:=0x%x\n ",address,otp_lenc[i]);
		address++;
	}
	
	// clear otp buffer
	for (i=0;i<16;i++) {
		OV5693MIPI_write_cmos_sensor(0x3d00 + i, 0x00);
	}
	
	// select 2nd bank
	bank++;
	OV5693MIPI_write_cmos_sensor(0x3d84, bank);
	
	// read otp
	OV5693MIPI_write_cmos_sensor(0x3d81, 0x01);
	mdelay(5);
	address = 0x3d00;
	for(i=15;i<31;i++) 
	{
		otp_lenc[i]=OV5693MIPI_read_cmos_sensor(address);
		SENSORDB("read ADRESS:=0x%x, PARA:=0x%x\n ",address,otp_lenc[i]);
		address++;
	}
	
	// clear otp buffer
	for (i=0;i<16;i++) {
		OV5693MIPI_write_cmos_sensor(0x3d00 + i, 0x00);
	}
	
	// select 3rd bank
	bank++;
	OV5693MIPI_write_cmos_sensor(0x3d84, bank);
	
	// read otp
	OV5693MIPI_write_cmos_sensor(0x3d81, 0x01);
	mdelay(5);
	address = 0x3d00;
	for(i=31;i<47;i++) 
	{
		otp_lenc[i]=OV5693MIPI_read_cmos_sensor(address);
		SENSORDB("read ADRESS:=0x%x, PARA:=0x%x\n ",address,otp_lenc[i]);
		address++;
	}
	
	// clear otp buffer
	for (i=0;i<16;i++) {
	OV5693MIPI_write_cmos_sensor(0x3d00 + i, 0x00);
	}
	
	// select 4th bank
	bank++;
	OV5693MIPI_write_cmos_sensor(0x3d84, bank);
	
	// read otp
	OV5693MIPI_write_cmos_sensor(0x3d81, 0x01);
	mdelay(5);
	address = 0x3d00;
	for(i=47;i<62;i++) {
		otp_lenc[i]=OV5693MIPI_read_cmos_sensor(address);
		SENSORDB("read ADRESS:=0x%x, PARA:=0x%x\n ",address,otp_lenc[i]);
		address++;
	}
	
	// clear otp buffer
	for (i=0;i<16;i++) {
		OV5693MIPI_write_cmos_sensor(0x3d00 + i, 0x00);
	}
	return 0;
}
// R_gain, sensor red gain of AWB, 0x400 =1
// G_gain, sensor green gain of AWB, 0x400 =1
// B_gain, sensor blue gain of AWB, 0x400 =1
// return 0;
int update_awb_gain(int R_gain, int G_gain, int B_gain)
{
	SENSORDB("OV5693DB_update_awb_gain ENTER :\n ");

	SENSORDB("OV5693DB_update_awb_gain R_gain =0x%x, G_gain=0x%x, B_gain=0x%x\n",R_gain, G_gain, B_gain);

	if (R_gain>0x400) 
	{
		OV5693MIPI_write_cmos_sensor(0x3400, R_gain>>8);
		OV5693MIPI_write_cmos_sensor(0x3401, R_gain & 0x00ff);
	}
	if (G_gain>0x400) 
	{
		OV5693MIPI_write_cmos_sensor(0x3402, G_gain>>8);
		OV5693MIPI_write_cmos_sensor(0x3403, G_gain & 0x00ff);
	}
	if (B_gain>0x400) 
	{
		OV5693MIPI_write_cmos_sensor(0x3404, B_gain>>8);
		OV5693MIPI_write_cmos_sensor(0x3405, B_gain & 0x00ff);
	}
	return 0;
}
// otp_ptr: pointer of otp_struct
int update_lenc(void)
{
	int i, temp;
	temp = OV5693MIPI_read_cmos_sensor(0x5000);
	temp = 0x80 | temp;
	OV5693MIPI_write_cmos_sensor(0x5000, temp);
	for(i=0;i<62;i++) 
	{
		OV5693MIPI_write_cmos_sensor(0x5800 + i, otp_lenc[i]);
		SENSORDB("OV5693OTP ADRESS:=0x%x, PARA:=0x%x\n ",0x5800 + i,otp_lenc[i]);

	}
	return 0;
}
// call this function after OV5690/OV5693 initialization
// return value: 0 update success
//                     1, no OTP
int update_otp_wb()
{
	struct otp_struct current_otp;
	int i;
	int otp_index;
	int temp;
	int R_gain, G_gain, B_gain, G_gain_R, G_gain_B;
	int rg,bg;
	// R/G and B/G of current camera module is read out from sensor OTP
	// check first OTP with valid data
	for(i=1;i<=3;i++)
	{
		temp = check_otp_wb(i);
		if (temp == 2) 
		{
			otp_index = i;
			break;
		}
	}
	
	if (i>3) {
		// no valid wb OTP data
		SENSORDB("[OV5693OTP]No WB OTP Data\n");
		return 1;
	}
	read_otp_wb(otp_index, &current_otp);
	if(current_otp.light_rg==0) 
	{
		// no light source information in OTP, light factor = 1
		rg = current_otp.rg_ratio;
	}
	else 
	{
		rg = current_otp.rg_ratio * ((current_otp.light_rg +512) / 1024);
	}
	if(current_otp.light_bg==0) {
		// not light source information in OTP, light factor = 1
		bg = current_otp.bg_ratio;
	}
	else {
		bg = current_otp.bg_ratio * ((current_otp.light_bg +512) / 1024);
	}
//calculate G gain
//0x400 = 1x gain
	if(bg < BG_Ratio_Typical) 
	{
		if (rg< RG_Ratio_Typical) 
		{
	         // current_otp.bg_ratio < BG_Ratio_typical &&
	         // current_otp.rg_ratio < RG_Ratio_typical
	         G_gain = 0x400;
	         B_gain = 0x400 * BG_Ratio_Typical / bg;
	         R_gain = 0x400 * RG_Ratio_Typical / rg;
		}
		else {
	         // current_otp.bg_ratio < BG_Ratio_typical &&
	         // current_otp.rg_ratio >= RG_Ratio_typical
	         R_gain = 0x400;
	         G_gain = 0x400 * rg / RG_Ratio_Typical;
	         B_gain = G_gain * BG_Ratio_Typical /bg;
		}
	}
	else 
	{
		if (rg < RG_Ratio_Typical) 
		{
	         // current_otp.bg_ratio >= BG_Ratio_typical &&
	         // current_otp.rg_ratio < RG_Ratio_typical
	         B_gain = 0x400;
	         G_gain = 0x400 * bg / BG_Ratio_Typical;
	         R_gain = G_gain * RG_Ratio_Typical / rg;
		}
		else 
		{
			// current_otp.bg_ratio >= BG_Ratio_typical &&
			// current_otp.rg_ratio >= RG_Ratio_typical
			G_gain_B = 0x400 * bg / BG_Ratio_Typical;
			G_gain_R = 0x400 * rg / RG_Ratio_Typical;
			if(G_gain_B > G_gain_R ) 
			{
				B_gain = 0x400;
				G_gain = G_gain_B;
				R_gain = G_gain * RG_Ratio_Typical /rg;
			}
			else 
			{
				R_gain = 0x400;
				       G_gain = G_gain_R;
				B_gain = G_gain * BG_Ratio_Typical / bg;
			}
		}
	}
	update_awb_gain(R_gain, G_gain, B_gain);
	return 0;
}
// call this function after OV5690/OV5693 initialization
// return value: 0 update success
//                     1, no OTP
int update_otp_lenc()
{
	struct otp_struct current_otp;
	int i;
	int otp_index;
	int temp;
	// check first lens correction OTP with valid data
	for(i=1;i<=3;i++) 
	{
		temp = check_otp_lenc(i);
		if (temp == 2) 
		{
			otp_index = i;
			break;
		}
	}
	if (i>3)
	{
		// no valid WB OTP data
		return 1;
	}
	SENSORDB("ov5693_otp_shading_read =  %d", ov5693_otp_shading_read);
	if(ov5693_otp_shading_read == KAL_TRUE)
	{
		read_otp_lenc(otp_index);
		ov5693_otp_shading_read = KAL_FALSE;
	}
	update_lenc();
	// success
	return 0;
}
#endif

static void OV5693MIPI_Write_Shutter(kal_uint16 iShutter)
{
    kal_uint16 extra_line = 0, frame_length;

    #ifdef OV5693MIPI_DRIVER_TRACE
        SENSORDB("iShutter =  %d", iShutter);
    #endif
    
    /* 0x3500, 0x3501, 0x3502 will increase VBLANK to get exposure larger than frame exposure */
    /* AE doesn't update sensor gain at capture mode, thus extra exposure lines must be updated here. */
    if (!iShutter) iShutter = 1;

    if(OV5693MIPIAutoFlickerMode){
        if(OV5693MIPI_sensor.video_mode == KAL_FALSE){
            if(mCurrentScenarioId == MSDK_SCENARIO_ID_CAMERA_ZSD)
            {
                //Change frame 14.7fps ~ 14.9fps to do auto flick
                OV5693MIPISetMaxFrameRate(296);
            }
            else
            {
                //Change frame 29.5fps ~ 29.8fps to do auto flick
                OV5693MIPISetMaxFrameRate(296);
            }
        }
    }

    // OV Recommend Solution
    // if shutter bigger than frame_length, should extend frame length first

#if 1  

    if(iShutter > OV5693MIPI_sensor.frame_length - 4)
        frame_length = iShutter + 4;
    else
        frame_length = OV5693MIPI_sensor.frame_length;

    // Extend frame length
    OV5693MIPI_write_cmos_sensor(0x380f, frame_length & 0xFF);
    OV5693MIPI_write_cmos_sensor(0x380e, frame_length >> 8);
    
#endif

    // Update Shutter
    OV5693MIPI_write_cmos_sensor(0x3502, (iShutter << 4) & 0xFF);
    OV5693MIPI_write_cmos_sensor(0x3501, (iShutter >> 4) & 0xFF);     
    OV5693MIPI_write_cmos_sensor(0x3500, (iShutter >> 12) & 0x0F);  
}   /*  OV5693MIPI_Write_Shutter  */

static void OV5693MIPI_Set_Dummy(const kal_uint16 iDummyPixels, const kal_uint16 iDummyLines)
{
    kal_uint16 hactive, vactive, line_length, frame_length;

    #ifdef OV5693MIPI_DRIVER_TRACE
        SENSORDB("iDummyPixels = %d, iDummyLines = %d ", iDummyPixels, iDummyLines);
    #endif

    if (OV5693MIPI_SENSOR_MODE_PREVIEW == OV5693MIPI_sensor.sensor_mode)
    {
        line_length = OV5693MIPI_PV_PERIOD_PIXEL_NUMS + iDummyPixels;
        frame_length = OV5693MIPI_PV_PERIOD_LINE_NUMS + iDummyLines;
    }
    else if(OV5693MIPI_SENSOR_MODE_VIDEO == OV5693MIPI_sensor.sensor_mode)
    {
        line_length = OV5693MIPI_VIDEO_PERIOD_PIXEL_NUMS + iDummyPixels;
        frame_length = OV5693MIPI_VIDEO_PERIOD_LINE_NUMS + iDummyLines;
    }    
    else
    {
        line_length = OV5693MIPI_FULL_PERIOD_PIXEL_NUMS + iDummyPixels;
        frame_length = OV5693MIPI_FULL_PERIOD_LINE_NUMS + iDummyLines;
    }

    OV5693MIPI_sensor.dummy_pixel = iDummyPixels;
    OV5693MIPI_sensor.dummy_line = iDummyLines;
    OV5693MIPI_sensor.line_length = line_length;
    OV5693MIPI_sensor.frame_length = frame_length;
    
    OV5693MIPI_write_cmos_sensor(0x380c, line_length >> 8);
    OV5693MIPI_write_cmos_sensor(0x380d, line_length & 0xFF);
    OV5693MIPI_write_cmos_sensor(0x380e, frame_length >> 8);
    OV5693MIPI_write_cmos_sensor(0x380f, frame_length & 0xFF);   
}   /*  OV5693MIPI_Set_Dummy  */


UINT32 OV5693MIPISetMaxFrameRate(UINT16 u2FrameRate)
{
    kal_int16 dummy_line;
    kal_uint16 frame_length = OV5693MIPI_sensor.frame_length;
    unsigned long flags;

    #ifdef OV5693MIPI_DRIVER_TRACE
        SENSORDB("u2FrameRate = %d ", u2FrameRate);
    #endif

    frame_length= (10 * OV5693MIPI_sensor.pclk) / u2FrameRate / OV5693MIPI_sensor.line_length;

    spin_lock_irqsave(&ov5693mipi_drv_lock, flags);
    OV5693MIPI_sensor.frame_length = frame_length;
    spin_unlock_irqrestore(&ov5693mipi_drv_lock, flags);

    if (OV5693MIPI_SENSOR_MODE_PREVIEW == OV5693MIPI_sensor.sensor_mode)
    {
        dummy_line = frame_length - OV5693MIPI_PV_PERIOD_LINE_NUMS;
    }
    else if(OV5693MIPI_SENSOR_MODE_VIDEO == OV5693MIPI_sensor.sensor_mode)
    {
        dummy_line = frame_length - OV5693MIPI_VIDEO_PERIOD_LINE_NUMS;
    }    
    else
    {
        dummy_line = frame_length - OV5693MIPI_FULL_PERIOD_LINE_NUMS;
    }

#if 0
    if(mCurrentScenarioId == MSDK_SCENARIO_ID_CAMERA_ZSD)
        dummy_line = frame_length - OV5693MIPI_FULL_PERIOD_LINE_NUMS;
    else
        dummy_line = frame_length - OV5693MIPI_PV_PERIOD_LINE_NUMS;
#endif

    if (dummy_line < 0) dummy_line = 0;

    OV5693MIPI_Set_Dummy(OV5693MIPI_sensor.dummy_pixel, dummy_line); /* modify dummy_pixel must gen AE table again */   
}   /*  OV5693MIPISetMaxFrameRate  */


/*************************************************************************
* FUNCTION
*   OV5693MIPI_SetShutter
*
* DESCRIPTION
*   This function set e-shutter of OV5693MIPI to change exposure time.
*
* PARAMETERS
*   iShutter : exposured lines
*
* RETURNS
*   None
*
* GLOBALS AFFECTED
*
*************************************************************************/
void set_OV5693MIPI_shutter(kal_uint16 iShutter)
{
    unsigned long flags;
    
    spin_lock_irqsave(&ov5693mipi_drv_lock, flags);
    OV5693MIPI_sensor.shutter = iShutter;
    spin_unlock_irqrestore(&ov5693mipi_drv_lock, flags);
    
    OV5693MIPI_Write_Shutter(iShutter);
}   /*  Set_OV5693MIPI_Shutter */


static kal_uint16 OV5693MIPI_Reg2Gain(const kal_uint8 iReg)
{
    kal_uint16 iGain ;
    /* Range: 1x to 32x */
    iGain = (iReg >> 4) * BASEGAIN + (iReg & 0xF) * BASEGAIN / 16; 
    return iGain ;
}


 kal_uint8 OV5693MIPI_Gain2Reg(const kal_uint16 iGain)
{
    kal_uint16 iReg = 0x0000;
    
    iReg = ((iGain / BASEGAIN) << 4) + ((iGain % BASEGAIN) * 16 / BASEGAIN);
    iReg = iReg & 0xFF;
    return (kal_uint8)iReg;
}


/*************************************************************************
* FUNCTION
*   OV5693MIPI_SetGain
*
* DESCRIPTION
*   This function is to set global gain to sensor.
*
* PARAMETERS
*   iGain : sensor global gain(base: 0x40)
*
* RETURNS
*   the actually gain set to sensor.
*
* GLOBALS AFFECTED
*
*************************************************************************/
kal_uint16 OV5693MIPI_SetGain(kal_uint16 iGain)
{
    kal_uint8 iRegGain;

    OV5693MIPI_sensor.gain = iGain;

    /* 0x350A[0:1], 0x350B[0:7] AGC real gain */
    /* [0:3] = N meams N /16 X  */
    /* [4:9] = M meams M X       */
    /* Total gain = M + N /16 X   */

    //
    if(iGain >= BASEGAIN && iGain <= 32 * BASEGAIN){
    
        iRegGain = OV5693MIPI_Gain2Reg(iGain);

        #ifdef OV5693MIPI_DRIVER_TRACE
            SENSORDB("iGain = %d , iRegGain = 0x%x ", iGain, iRegGain);
        #endif

        if (iRegGain < 0x10) iRegGain = 0x10;
        OV5693MIPI_write_cmos_sensor(0x350b, iRegGain);
    } else {
        SENSORDB("Error gain setting");
    }
  
    return iGain;
}   /*  OV5693MIPI_SetGain  */


void OV5693MIPI_Set_Mirror_Flip(kal_uint8 image_mirror)
{
    SENSORDB("image_mirror = %d", image_mirror);

    /********************************************************
       *
       *   0x3820[2] ISP Vertical flip
       *   0x3820[1] Sensor Vertical flip
       *
       *   0x3821[2] ISP Horizontal mirror
       *   0x3821[1] Sensor Horizontal mirror
       *
       *   ISP and Sensor flip or mirror register bit should be the same!!
       *
       ********************************************************/
    
	switch (image_mirror)
	{
		case IMAGE_NORMAL:
		    OV5693MIPI_write_cmos_sensor(0x3820,((OV5693MIPI_read_cmos_sensor(0x3820) & 0xF9) | 0x00));
		    OV5693MIPI_write_cmos_sensor(0x3821,((OV5693MIPI_read_cmos_sensor(0x3821) & 0xF9) | 0x06));
		    break;
		case IMAGE_H_MIRROR:
		    OV5693MIPI_write_cmos_sensor(0x3820,((OV5693MIPI_read_cmos_sensor(0x3820) & 0xF9) | 0x00));
		    OV5693MIPI_write_cmos_sensor(0x3821,((OV5693MIPI_read_cmos_sensor(0x3821) & 0xF9) | 0x00));
		    break;
		case IMAGE_V_MIRROR:
		    OV5693MIPI_write_cmos_sensor(0x3820,((OV5693MIPI_read_cmos_sensor(0x3820) & 0xF9) | 0x06));
		    OV5693MIPI_write_cmos_sensor(0x3821,((OV5693MIPI_read_cmos_sensor(0x3821) & 0xF9) | 0x06));		
		    break;
		case IMAGE_HV_MIRROR:
		    OV5693MIPI_write_cmos_sensor(0x3820,((OV5693MIPI_read_cmos_sensor(0x3820) & 0xF9) | 0x06));
		    OV5693MIPI_write_cmos_sensor(0x3821,((OV5693MIPI_read_cmos_sensor(0x3821) & 0xF9) | 0x00));
		    break;
		default:
		    SENSORDB("Error image_mirror setting");
	}

}


/*************************************************************************
* FUNCTION
*   OV5693MIPI_NightMode
*
* DESCRIPTION
*   This function night mode of OV5693MIPI.
*
* PARAMETERS
*   bEnable: KAL_TRUE -> enable night mode, otherwise, disable night mode
*
* RETURNS
*   None
*
* GLOBALS AFFECTED
*
*************************************************************************/
void OV5693MIPI_night_mode(kal_bool enable)
{
/*No Need to implement this function*/ 
}   /*  OV5693MIPI_night_mode  */


/* write camera_para to sensor register */
static void OV5693MIPI_camera_para_to_sensor(void)
{
    kal_uint32 i;

    SENSORDB("OV5693MIPI_camera_para_to_sensor\n");

    for (i = 0; 0xFFFFFFFF != OV5693MIPI_sensor.eng.reg[i].Addr; i++)
    {
        OV5693MIPI_write_cmos_sensor(OV5693MIPI_sensor.eng.reg[i].Addr, OV5693MIPI_sensor.eng.reg[i].Para);
    }
    for (i = OV5693MIPI_FACTORY_START_ADDR; 0xFFFFFFFF != OV5693MIPI_sensor.eng.reg[i].Addr; i++)
    {
        OV5693MIPI_write_cmos_sensor(OV5693MIPI_sensor.eng.reg[i].Addr, OV5693MIPI_sensor.eng.reg[i].Para);
    }
    OV5693MIPI_SetGain(OV5693MIPI_sensor.gain); /* update gain */
}

/* update camera_para from sensor register */
static void OV5693MIPI_sensor_to_camera_para(void)
{
    kal_uint32 i,temp_data;

    SENSORDB("OV5693MIPI_sensor_to_camera_para\n");

    for (i = 0; 0xFFFFFFFF != OV5693MIPI_sensor.eng.reg[i].Addr; i++)
    {
        temp_data =OV5693MIPI_read_cmos_sensor(OV5693MIPI_sensor.eng.reg[i].Addr);
     
        spin_lock(&ov5693mipi_drv_lock);
        OV5693MIPI_sensor.eng.reg[i].Para = temp_data;
        spin_unlock(&ov5693mipi_drv_lock);
    }
    for (i = OV5693MIPI_FACTORY_START_ADDR; 0xFFFFFFFF != OV5693MIPI_sensor.eng.reg[i].Addr; i++)
    {
        temp_data =OV5693MIPI_read_cmos_sensor(OV5693MIPI_sensor.eng.reg[i].Addr);
    
        spin_lock(&ov5693mipi_drv_lock);
        OV5693MIPI_sensor.eng.reg[i].Para = temp_data;
        spin_unlock(&ov5693mipi_drv_lock);
    }
}

/* ------------------------ Engineer mode ------------------------ */
inline static void OV5693MIPI_get_sensor_group_count(kal_int32 *sensor_count_ptr)
{

    SENSORDB("OV5693MIPI_get_sensor_group_count\n");

    *sensor_count_ptr = OV5693MIPI_GROUP_TOTAL_NUMS;
}

inline static void OV5693MIPI_get_sensor_group_info(MSDK_SENSOR_GROUP_INFO_STRUCT *para)
{

    SENSORDB("OV5693MIPI_get_sensor_group_info\n");

    switch (para->GroupIdx)
    {
    case OV5693MIPI_PRE_GAIN:
        sprintf(para->GroupNamePtr, "CCT");
        para->ItemCount = 5;
        break;
    case OV5693MIPI_CMMCLK_CURRENT:
        sprintf(para->GroupNamePtr, "CMMCLK Current");
        para->ItemCount = 1;
        break;
    case OV5693MIPI_FRAME_RATE_LIMITATION:
        sprintf(para->GroupNamePtr, "Frame Rate Limitation");
        para->ItemCount = 2;
        break;
    case OV5693MIPI_REGISTER_EDITOR:
        sprintf(para->GroupNamePtr, "Register Editor");
        para->ItemCount = 2;
        break;
    default:
        ASSERT(0);
  }
}

inline static void OV5693MIPI_get_sensor_item_info(MSDK_SENSOR_ITEM_INFO_STRUCT *para)
{

    const static kal_char *cct_item_name[] = {"SENSOR_BASEGAIN", "Pregain-R", "Pregain-Gr", "Pregain-Gb", "Pregain-B"};
    const static kal_char *editer_item_name[] = {"REG addr", "REG value"};
  
    SENSORDB("OV5693MIPI_get_sensor_item_info");

    switch (para->GroupIdx)
    {
    case OV5693MIPI_PRE_GAIN:
        switch (para->ItemIdx)
        {
        case OV5693MIPI_SENSOR_BASEGAIN:
        case OV5693MIPI_PRE_GAIN_R_INDEX:
        case OV5693MIPI_PRE_GAIN_Gr_INDEX:
        case OV5693MIPI_PRE_GAIN_Gb_INDEX:
        case OV5693MIPI_PRE_GAIN_B_INDEX:
            break;
        default:
            ASSERT(0);
        }
        sprintf(para->ItemNamePtr, cct_item_name[para->ItemIdx - OV5693MIPI_SENSOR_BASEGAIN]);
        para->ItemValue = OV5693MIPI_sensor.eng.cct[para->ItemIdx].Para * 1000 / BASEGAIN;
        para->IsTrueFalse = para->IsReadOnly = para->IsNeedRestart = KAL_FALSE;
        para->Min = OV5693MIPI_MIN_ANALOG_GAIN * 1000;
        para->Max = OV5693MIPI_MAX_ANALOG_GAIN * 1000;
        break;
    case OV5693MIPI_CMMCLK_CURRENT:
        switch (para->ItemIdx)
        {
        case 0:
            sprintf(para->ItemNamePtr, "Drv Cur[2,4,6,8]mA");
            switch (OV5693MIPI_sensor.eng.reg[OV5693MIPI_CMMCLK_CURRENT_INDEX].Para)
            {
            case ISP_DRIVING_2MA:
                para->ItemValue = 2;
                break;
            case ISP_DRIVING_4MA:
                para->ItemValue = 4;
                break;
            case ISP_DRIVING_6MA:
                para->ItemValue = 6;
                break;
            case ISP_DRIVING_8MA:
                para->ItemValue = 8;
                break;
            default:
                ASSERT(0);
            }
            para->IsTrueFalse = para->IsReadOnly = KAL_FALSE;
            para->IsNeedRestart = KAL_TRUE;
            para->Min = 2;
            para->Max = 8;
            break;
        default:
            ASSERT(0);
        }
        break;
    case OV5693MIPI_FRAME_RATE_LIMITATION:
        switch (para->ItemIdx)
        {
        case 0:
            sprintf(para->ItemNamePtr, "Max Exposure Lines");
            para->ItemValue = 5998;
            break;
        case 1:
            sprintf(para->ItemNamePtr, "Min Frame Rate");
            para->ItemValue = 5;
            break;
        default:
            ASSERT(0);
        }
        para->IsTrueFalse = para->IsNeedRestart = KAL_FALSE;
        para->IsReadOnly = KAL_TRUE;
        para->Min = para->Max = 0;
        break;
    case OV5693MIPI_REGISTER_EDITOR:
        switch (para->ItemIdx)
        {
        case 0:
        case 1:
            sprintf(para->ItemNamePtr, editer_item_name[para->ItemIdx]);
            para->ItemValue = 0;
            para->IsTrueFalse = para->IsReadOnly = para->IsNeedRestart = KAL_FALSE;
            para->Min = 0;
            para->Max = (para->ItemIdx == 0 ? 0xFFFF : 0xFF);
            break;
        default:
            ASSERT(0);
        }
        break;
    default:
        ASSERT(0);
  }
}

inline static kal_bool OV5693MIPI_set_sensor_item_info(MSDK_SENSOR_ITEM_INFO_STRUCT *para)
{
    kal_uint16 temp_para;

    SENSORDB("OV5693MIPI_set_sensor_item_info\n");

    switch (para->GroupIdx)
    {
    case OV5693MIPI_PRE_GAIN:
        switch (para->ItemIdx)
        {
        case OV5693MIPI_SENSOR_BASEGAIN:
        case OV5693MIPI_PRE_GAIN_R_INDEX:
        case OV5693MIPI_PRE_GAIN_Gr_INDEX:
        case OV5693MIPI_PRE_GAIN_Gb_INDEX:
        case OV5693MIPI_PRE_GAIN_B_INDEX:
            spin_lock(&ov5693mipi_drv_lock);
            OV5693MIPI_sensor.eng.cct[para->ItemIdx].Para = para->ItemValue * BASEGAIN / 1000;
            spin_unlock(&ov5693mipi_drv_lock);
            OV5693MIPI_SetGain(OV5693MIPI_sensor.gain); /* update gain */
            break;
        default:
            ASSERT(0);
        }
        break;
    case OV5693MIPI_CMMCLK_CURRENT:
        switch (para->ItemIdx)
        {
        case 0:
            switch (para->ItemValue)
            {
            case 2:
                temp_para = ISP_DRIVING_2MA;
                break;
            case 3:
            case 4:
                temp_para = ISP_DRIVING_4MA;
                break;
            case 5:
            case 6:
                temp_para = ISP_DRIVING_6MA;
                break;
            default:
                temp_para = ISP_DRIVING_8MA;
                break;
            }
            spin_lock(&ov5693mipi_drv_lock);
            //OV5693MIPI_set_isp_driving_current(temp_para);
            OV5693MIPI_sensor.eng.reg[OV5693MIPI_CMMCLK_CURRENT_INDEX].Para = temp_para;
            spin_unlock(&ov5693mipi_drv_lock);
            break;
        default:
            ASSERT(0);
        }
        break;
    case OV5693MIPI_FRAME_RATE_LIMITATION:
        ASSERT(0);
        break;
    case OV5693MIPI_REGISTER_EDITOR:
        switch (para->ItemIdx)
        {
        static kal_uint32 fac_sensor_reg;
        case 0:
            if (para->ItemValue < 0 || para->ItemValue > 0xFFFF) return KAL_FALSE;
            fac_sensor_reg = para->ItemValue;
            break;
        case 1:
            if (para->ItemValue < 0 || para->ItemValue > 0xFF) return KAL_FALSE;
            OV5693MIPI_write_cmos_sensor(fac_sensor_reg, para->ItemValue);
            break;
        default:
            ASSERT(0);
        }
        break;
    default:
        ASSERT(0);
    }

    return KAL_TRUE;
}
static kal_uint8 ov5693_init[] = {
    0x01,0x03,0x01,  // Software Reset

    0x30,0x01,0x0a,  // FSIN output, FREX input
    0x30,0x02,0x80,  // Vsync output, Href, Frex, strobe, fsin, ilpwm input
    0x30,0x06,0x00,  // output value of GPIO

    0x30,0x11,0x21,  //MIPI 2 lane enable
    0x30,0x12,0x09,  //MIPI 10-bit
    0x30,0x13,0x10,  //Drive 1x
    0x30,0x14,0x00,
    0x30,0x15,0x08,  //MIPI on
    0x30,0x16,0xf0,
    0x30,0x17,0xf0,
    0x30,0x18,0xf0,
    0x30,0x1b,0xb4,
    0x30,0x1d,0x02,
		0x30,0x21,0x20,
    0x30,0x22,0x01,
    0x30,0x28,0x44,
    0x30,0x98,0x03,  //PLL
    0x30,0x99,0x1e,  //PLL
    0x30,0x9a,0x02,  //PLL
    0x30,0x9b,0x01,  //PLL
    0x30,0x9c,0x00,  //PLL
    0x30,0xa0,0xd2,
    0x30,0xa2,0x01,
    0x30,0xb2,0x00,
    0x30,0xb3,0x6a,  //PLL 50 64 6c
    0x30,0xb4,0x03,  //PLL
    0x30,0xb5,0x04,  //PLL
    0x30,0xb6,0x01,  //PLL
    0x31,0x04,0x21,  //sclk from dac_pll
    0x31,0x06,0x00,  //sclk_sel from pll_clk
    0x34,0x00,0x04,  //MWB R H
    0x34,0x01,0x00,  //MWB R L
    0x34,0x02,0x04,  //MWB G H
    0x34,0x03,0x00,  //MWB G L
    0x34,0x04,0x04,  //MWB B H
    0x34,0x05,0x00,  //MWB B L
    0x34,0x06,0x01,  //MWB gain enable
    0x35,0x00,0x00,  //exposure HH
    0x35,0x01,0x3d,  //exposure H   3d
    0x35,0x02,0x00,  //exposure L
    0x35,0x03,0x07,  //gain 1 frame latch, VTS manual, AGC manual, AEC manual
    0x35,0x04,0x00,  //manual gain H
    0x35,0x05,0x00,  //manual gain L
    0x35,0x06,0x00,  //short exposure HH
    0x35,0x07,0x02,  //short exposure H
    0x35,0x08,0x00,  //short exposure L
    0x35,0x09,0x10,  //use real ggain
    0x35,0x0a,0x00,  //gain H 
    0x35,0x0b,0x40,  //gain L
    0x36,0x01,0x0a,  //analog
    0x36,0x02,0x38,
    0x36,0x12,0x80,
    0x36,0x20,0x44,//54 2013.09.02
    0x36,0x21,0xb5,//c7 2013.09.02
    0x36,0x22,0x0c,//0f 2013.09.02
		0x36,0x00,0xbc,//9c 2013.09.02
    0x36,0x25,0x10,
    0x36,0x30,0x55,
    0x36,0x31,0xf4,
    0x36,0x32,0x00,
    0x36,0x33,0x34,
    0x36,0x34,0x02,
    0x36,0x4d,0x0d,
    0x36,0x4f,0xdd,
    0x36,0x60,0x04,
    0x36,0x62,0x10,
    0x36,0x63,0xf1,
    0x36,0x65,0x00,
    0x36,0x66,0x20,
    0x36,0x67,0x00,
    0x36,0x6a,0x80,
    0x36,0x80,0xe0,
    0x36,0x81,0x00,  //analog
    0x37,0x00,0x42,  //sensor control
    0x37,0x01,0x14,
    0x37,0x02,0xa0,
    0x37,0x03,0xd8,
    0x37,0x04,0x78,
    0x37,0x05,0x02,
    0x37,0x08,0xe6,  //e6 //e2
    0x37,0x09,0xc7,  //c7 //c3
    0x37,0x0a,0x00,
    0x37,0x0b,0x20,
    0x37,0x0c,0x0c,
    0x37,0x0d,0x11,
    0x37,0x0e,0x00,
    0x37,0x0f,0x40,
    0x37,0x10,0x00,
    0x37,0x1a,0x1c,
    0x37,0x1b,0x05,
    0x37,0x1c,0x01,
    0x37,0x1e,0xa1,
    0x37,0x1f,0x0c,
    0x37,0x21,0x00,
    0x37,0x24,0x10,
    0x37,0x26,0x00,
    0x37,0x2a,0x01,
    0x37,0x30,0x10,
    0x37,0x38,0x22,
    0x37,0x39,0xe5,
    0x37,0x3a,0x50,
    0x37,0x3b,0x02,
    0x37,0x3c,0x41,
    0x37,0x3f,0x02,
    0x37,0x40,0x42,
    0x37,0x41,0x02,
    0x37,0x42,0x18,
    0x37,0x43,0x01,
    0x37,0x44,0x02,
    0x37,0x47,0x10,
    0x37,0x4c,0x04,
    0x37,0x51,0xf0,
    0x37,0x52,0x00,
    0x37,0x53,0x00,
    0x37,0x54,0xc0,
    0x37,0x55,0x00,
    0x37,0x56,0x1a,
    0x37,0x58,0x00,
    0x37,0x59,0x0f,
    0x37,0x6b,0x44,
    0x37,0x5c,0x04,
    0x37,0x74,0x10,
    0x37,0x76,0x00,
    0x37,0x7f,0x08,  //sensor control
    0x37,0x80,0x22,  //PSRAM control
    0x37,0x81,0x0c,
    0x37,0x84,0x2c,
    0x37,0x85,0x1e,
    0x37,0x8f,0xf5,
    0x37,0x91,0xb0,
    0x37,0x95,0x00,
    0x37,0x96,0x64,
    0x37,0x97,0x11,
    0x37,0x98,0x30,
    0x37,0x99,0x41,
    0x37,0x9a,0x07,
    0x37,0x9b,0xb0,
    0x37,0x9c,0x0c,  //PSRAM control                       
    0x37,0xc5,0x00,  //sensor FREX exp HH                  
    0x37,0xc6,0x00,  //sensor FREX exp H                   
    0x37,0xc7,0x00,  //sensor FREX exp L                   
    0x37,0xc9,0x00,  //strobe Width HH                     
    0x37,0xca,0x00,  //strobe Width H                      
    0x37,0xcb,0x00,  //strobe Width L                      
    0x37,0xde,0x00,  //sensor FREX PCHG Width H            
    0x37,0xdf,0x00,  //sensor FREX PCHG Width L

    0x38,0x00,0x00,  //X start H                           
    0x38,0x01,0x00,  //X start L                           
    0x38,0x02,0x00,  //Y start H                           
    0x38,0x03,0x00,  //Y start L                           
    0x38,0x04,0x0a,  //X end H                             
    0x38,0x05,0x3f,  //X end L                             
    0x38,0x06,0x07,  //Y end H                             
    0x38,0x07,0xa3,  //Y end L                             
    0x38,0x08,0x05,  //X output size H  2592             //05  0a
    0x38,0x09,0x10,  //X output size L                       //10  20
    0x38,0x0a,0x03,  //Y output size H  1944             //03  07
    0x38,0x0b,0xcc,  //Y output size L                       //cc   98
    0x38,0x0c,0x0a,  //HTS H  2688                             
    0x38,0x0d,0x80,  //HTS H                               
    0x38,0x0e,0x07,  //HTS L  1984                           //05
    0x38,0x0f,0xc0,  //HTS L                                     //d0

    0x38,0x10,0x00,  //timing ISP x win H                  
    0x38,0x11,0x08,  //timing ISP x win L     //02             
    0x38,0x12,0x00,  //timing ISP y win H                  
    0x38,0x13,0x02,  //timing ISP y win L                  
    0x38,0x14,0x31,  //timing x inc                                        //31  11
    0x38,0x15,0x31,  //timing y ing                                        //31  11
    0x38,0x20,0x04,  //v fast bin on, v flip off, v bin off           //04  00
    0x38,0x21,0x1f,  //hsync on, mirror on, hbin on              //1f   1e
    0x38,0x23,0x00,
    0x38,0x24,0x00,
    0x38,0x25,0x00,
    0x38,0x26,0x00,
    0x38,0x27,0x00,
    0x38,0x2a,0x04,
    0x3a,0x04,0x06,
    0x3a,0x05,0x14,
    0x3a,0x06,0x00,
    0x3a,0x07,0xfe,
    0x3b,0x00,0x00,  //strobe off          
    0x3b,0x02,0x00,  //strobe dummy line H     
    0x3b,0x03,0x00,  //strobe dummy line L     
    0x3b,0x04,0x00,  //strobe at next frame    
    0x3b,0x05,0x00,  //strobe pulse width      
    0x3e,0x07,0x20,
    0x40,0x00,0x08,
    0x40,0x01,0x04,  //BLC start line                                                                         
    0x40,0x02,0x45,  //BLC auto enable, do 5 frames                                                           
    0x40,0x04,0x08,  //8 black lines                                                                          
    0x40,0x05,0x18,  //don't output black line, apply one channel offset to all, BLC triggered by gain change,
    0x40,0x06,0x20,  //ZLINE COEF                                                                             
    0x40,0x08,0x24,                                                                                       
    0x40,0x09,0x40,  //black level target                                                                     
    0x40,0x0c,0x00,  //BLC man level0 H                                                                       
    0x40,0x0d,0x00,  //BLC man level0 L                                                                       
    0x40,0x58,0x00,                                                                                         
    0x40,0x4e,0x37,  //BLC maximum black level                                                                
    0x40,0x4f,0x8f,  //BLC stable range                                                                       
    0x40,0x58,0x00,                                                                                     
    0x41,0x01,0xb2,                                                                                   
    0x43,0x03,0x00,  //test pattern off                                                                       
    0x43,0x04,0x08,  //test pattern option                                                                    
    0x43,0x07,0x30,                                                                                       
    0x43,0x11,0x04,  //Vsync width H                                                                          
    0x43,0x15,0x01,  //Vsync width L                                                                          
    0x45,0x11,0x05,                                                                                      
    0x45,0x12,0x00, //01 2013.09.02

    0x48,0x00,0x14,  // MIPI line sync enable

    0x48,0x06,0x00,                                                                                      
    0x48,0x16,0x52,  //embedded line data type                                                                
    0x48,0x1f,0x30,  //max clk_prepare                                                                        
    0x48,0x26,0x2c,  //hs prepare min                                                                         
    0x48,0x31,0x64,  //UI hs prepare     
    0x4d,0x00,0x04,  //temprature sensor 
    0x4d,0x01,0x71,                 
    0x4d,0x02,0xfd,                  
    0x4d,0x03,0xf5,                  
    0x4d,0x04,0x0c,                  
    0x4d,0x05,0xcc,  //temperature sensor
    0x48,0x37,0x09,  //MIPI global timing  //0d 0a
    0x50,0x00,0x06,  //BPC on, WPC on    
    0x50,0x01,0x01,  //MWB on            
    0x50,0x02,0x00,  //scal off          
    0x50,0x03,0x20,
    0x50,0x46,0x0a,  //SOF auto mode 
    0x50,0x13,0x00,            
    0x50,0x46,0x0a,  //SOF auto mode 
    0x57,0x80,0xfc,  //1c DPC           
    0x57,0x86,0x20, //20
    0x57,0x87,0x40,//10
    0x57,0x88,0x08,//18
    0x57,0x8a,0x02,//04
    0x57,0x8b,0x01,//02
    0x57,0x8c,0x01,//02
    0x57,0x8e,0x02,//04
    0x57,0x8f,0x01,//02
    0x57,0x90,0x01,//02
    0x57,0x91,0xff,  //DPC             
    0x58,0x42,0x01,  //LENC BR Hscale H
    0x58,0x43,0x2b,  //LENC BR Hscale L
    0x58,0x44,0x01,  //LENC BR Vscale H
    0x58,0x45,0x92,  //LENC BR Vscale L
    0x58,0x46,0x01,  //LENC G Hscale H 
    0x58,0x47,0x8f,  //LENC G Hscale L 
    0x58,0x48,0x01,  //LENC G Vscale H 
    0x58,0x49,0x0c,  //LENC G Vscale L 
    0x5e,0x00,0x00,  //test pattern off
    0x5e,0x10,0x0c,
    0x01,0x00,0x01,  //wake up

};

static void OV5693MIPI_Sensor_Init(void)
{
    SENSORDB("Enter!");

   /*****************************************************************************
    0x3098[0:1] pll3_prediv
    pll3_prediv_map[] = {2, 3, 4, 6} 
    
    0x3099[0:4] pll3_multiplier
    pll3_multiplier
    
    0x309C[0] pll3_rdiv
    pll3_rdiv + 1
    
    0x309A[0:3] pll3_sys_div
    pll3_sys_div + 1
    
    0x309B[0:1] pll3_div
    pll3_div[] = {2, 2, 4, 5}
    
    VCO = XVCLK * 2 / pll3_prediv * pll3_multiplier * pll3_rdiv
    sysclk = VCO * 2 * 2 / pll3_sys_div / pll3_div

    XVCLK = 24 MHZ
    0x3098, 0x03
    0x3099, 0x1e
    0x309a, 0x02
    0x309b, 0x01
    0x309c, 0x00


    VCO = 24 * 2 / 6 * 31 * 1
    sysclk = VCO * 2  * 2 / 3 / 2
    sysclk = 160 MHZ
    */
    #if 0
    OV5693MIPI_write_cmos_sensor(0x0103,0x01);  // Software Reset

    OV5693MIPI_write_cmos_sensor(0x3001,0x0a);  // FSIN output, FREX input
    OV5693MIPI_write_cmos_sensor(0x3002,0x80);  // Vsync output, Href, Frex, strobe, fsin, ilpwm input
    OV5693MIPI_write_cmos_sensor(0x3006,0x00);  // output value of GPIO
    
    OV5693MIPI_write_cmos_sensor(0x3011,0x21);  //MIPI 2 lane enable
    OV5693MIPI_write_cmos_sensor(0x3012,0x09);  //MIPI 10-bit
    OV5693MIPI_write_cmos_sensor(0x3013,0x10);  //Drive 1x
    OV5693MIPI_write_cmos_sensor(0x3014,0x00);
    OV5693MIPI_write_cmos_sensor(0x3015,0x08);  //MIPI on
    OV5693MIPI_write_cmos_sensor(0x3016,0xf0);
    OV5693MIPI_write_cmos_sensor(0x3017,0xf0);
    OV5693MIPI_write_cmos_sensor(0x3018,0xf0);
    OV5693MIPI_write_cmos_sensor(0x301b,0xb4);
    OV5693MIPI_write_cmos_sensor(0x301d,0x02);
OV5693MIPI_write_cmos_sensor(0x3021,0x20);
    OV5693MIPI_write_cmos_sensor(0x3022,0x01);
    OV5693MIPI_write_cmos_sensor(0x3028,0x44);
    OV5693MIPI_write_cmos_sensor(0x3098,0x03);  //PLL
    OV5693MIPI_write_cmos_sensor(0x3099,0x1e);  //PLL
    OV5693MIPI_write_cmos_sensor(0x309a,0x02);  //PLL
    OV5693MIPI_write_cmos_sensor(0x309b,0x01);  //PLL
    OV5693MIPI_write_cmos_sensor(0x309c,0x00);  //PLL
    OV5693MIPI_write_cmos_sensor(0x30a0,0xd2);
    OV5693MIPI_write_cmos_sensor(0x30a2,0x01);
    OV5693MIPI_write_cmos_sensor(0x30b2,0x00);
    OV5693MIPI_write_cmos_sensor(0x30b3,0x6a);  //PLL 50 64 6c
    OV5693MIPI_write_cmos_sensor(0x30b4,0x03);  //PLL
    OV5693MIPI_write_cmos_sensor(0x30b5,0x04);  //PLL
    OV5693MIPI_write_cmos_sensor(0x30b6,0x01);  //PLL
    OV5693MIPI_write_cmos_sensor(0x3104,0x21);  //sclk from dac_pll
    OV5693MIPI_write_cmos_sensor(0x3106,0x00);  //sclk_sel from pll_clk
    OV5693MIPI_write_cmos_sensor(0x3400,0x04);  //MWB R H
    OV5693MIPI_write_cmos_sensor(0x3401,0x00);  //MWB R L
    OV5693MIPI_write_cmos_sensor(0x3402,0x04);  //MWB G H
    OV5693MIPI_write_cmos_sensor(0x3403,0x00);  //MWB G L
    OV5693MIPI_write_cmos_sensor(0x3404,0x04);  //MWB B H
    OV5693MIPI_write_cmos_sensor(0x3405,0x00);  //MWB B L
    OV5693MIPI_write_cmos_sensor(0x3406,0x01);  //MWB gain enable
    OV5693MIPI_write_cmos_sensor(0x3500,0x00);  //exposure HH
    OV5693MIPI_write_cmos_sensor(0x3501,0x3d);  //exposure H   3d
    OV5693MIPI_write_cmos_sensor(0x3502,0x00);  //exposure L
    OV5693MIPI_write_cmos_sensor(0x3503,0x07);  //gain 1 frame latch, VTS manual, AGC manual, AEC manual
    OV5693MIPI_write_cmos_sensor(0x3504,0x00);  //manual gain H
    OV5693MIPI_write_cmos_sensor(0x3505,0x00);  //manual gain L
    OV5693MIPI_write_cmos_sensor(0x3506,0x00);  //short exposure HH
    OV5693MIPI_write_cmos_sensor(0x3507,0x02);  //short exposure H
    OV5693MIPI_write_cmos_sensor(0x3508,0x00);  //short exposure L
    OV5693MIPI_write_cmos_sensor(0x3509,0x10);  //use real ggain
    OV5693MIPI_write_cmos_sensor(0x350a,0x00);  //gain H 
    OV5693MIPI_write_cmos_sensor(0x350b,0x40);  //gain L
    OV5693MIPI_write_cmos_sensor(0x3601,0x0a);  //analog
    OV5693MIPI_write_cmos_sensor(0x3602,0x38);
    OV5693MIPI_write_cmos_sensor(0x3612,0x80);
    OV5693MIPI_write_cmos_sensor(0x3620,0x44);//54 2013.09.02
    OV5693MIPI_write_cmos_sensor(0x3621,0xb5);//c7 2013.09.02
    OV5693MIPI_write_cmos_sensor(0x3622,0x0c);//0f 2013.09.02
	OV5693MIPI_write_cmos_sensor(0x3600,0xbc);//9c 2013.09.02
    OV5693MIPI_write_cmos_sensor(0x3625,0x10);
    OV5693MIPI_write_cmos_sensor(0x3630,0x55);
    OV5693MIPI_write_cmos_sensor(0x3631,0xf4);
    OV5693MIPI_write_cmos_sensor(0x3632,0x00);
    OV5693MIPI_write_cmos_sensor(0x3633,0x34);
    OV5693MIPI_write_cmos_sensor(0x3634,0x02);
    OV5693MIPI_write_cmos_sensor(0x364d,0x0d);
    OV5693MIPI_write_cmos_sensor(0x364f,0xdd);
    OV5693MIPI_write_cmos_sensor(0x3660,0x04);
    OV5693MIPI_write_cmos_sensor(0x3662,0x10);
    OV5693MIPI_write_cmos_sensor(0x3663,0xf1);
    OV5693MIPI_write_cmos_sensor(0x3665,0x00);
    OV5693MIPI_write_cmos_sensor(0x3666,0x20);
    OV5693MIPI_write_cmos_sensor(0x3667,0x00);
    OV5693MIPI_write_cmos_sensor(0x366a,0x80);
    OV5693MIPI_write_cmos_sensor(0x3680,0xe0);
    OV5693MIPI_write_cmos_sensor(0x3681,0x00);  //analog
    OV5693MIPI_write_cmos_sensor(0x3700,0x42);  //sensor control
    OV5693MIPI_write_cmos_sensor(0x3701,0x14);
    OV5693MIPI_write_cmos_sensor(0x3702,0xa0);
    OV5693MIPI_write_cmos_sensor(0x3703,0xd8);
    OV5693MIPI_write_cmos_sensor(0x3704,0x78);
    OV5693MIPI_write_cmos_sensor(0x3705,0x02);
    OV5693MIPI_write_cmos_sensor(0x3708,0xe6);  //e6 //e2
    OV5693MIPI_write_cmos_sensor(0x3709,0xc7);  //c7 //c3
    OV5693MIPI_write_cmos_sensor(0x370a,0x00);
    OV5693MIPI_write_cmos_sensor(0x370b,0x20);
    OV5693MIPI_write_cmos_sensor(0x370c,0x0c);
    OV5693MIPI_write_cmos_sensor(0x370d,0x11);
    OV5693MIPI_write_cmos_sensor(0x370e,0x00);
    OV5693MIPI_write_cmos_sensor(0x370f,0x40);
    OV5693MIPI_write_cmos_sensor(0x3710,0x00);
    OV5693MIPI_write_cmos_sensor(0x371a,0x1c);
    OV5693MIPI_write_cmos_sensor(0x371b,0x05);
    OV5693MIPI_write_cmos_sensor(0x371c,0x01);
    OV5693MIPI_write_cmos_sensor(0x371e,0xa1);
    OV5693MIPI_write_cmos_sensor(0x371f,0x0c);
    OV5693MIPI_write_cmos_sensor(0x3721,0x00);
    OV5693MIPI_write_cmos_sensor(0x3724,0x10);
    OV5693MIPI_write_cmos_sensor(0x3726,0x00);
    OV5693MIPI_write_cmos_sensor(0x372a,0x01);
    OV5693MIPI_write_cmos_sensor(0x3730,0x10);
    OV5693MIPI_write_cmos_sensor(0x3738,0x22);
    OV5693MIPI_write_cmos_sensor(0x3739,0xe5);
    OV5693MIPI_write_cmos_sensor(0x373a,0x50);
    OV5693MIPI_write_cmos_sensor(0x373b,0x02);
    OV5693MIPI_write_cmos_sensor(0x373c,0x41);
    OV5693MIPI_write_cmos_sensor(0x373f,0x02);
    OV5693MIPI_write_cmos_sensor(0x3740,0x42);
    OV5693MIPI_write_cmos_sensor(0x3741,0x02);
    OV5693MIPI_write_cmos_sensor(0x3742,0x18);
    OV5693MIPI_write_cmos_sensor(0x3743,0x01);
    OV5693MIPI_write_cmos_sensor(0x3744,0x02);
    OV5693MIPI_write_cmos_sensor(0x3747,0x10);
    OV5693MIPI_write_cmos_sensor(0x374c,0x04);
    OV5693MIPI_write_cmos_sensor(0x3751,0xf0);
    OV5693MIPI_write_cmos_sensor(0x3752,0x00);
    OV5693MIPI_write_cmos_sensor(0x3753,0x00);
    OV5693MIPI_write_cmos_sensor(0x3754,0xc0);
    OV5693MIPI_write_cmos_sensor(0x3755,0x00);
    OV5693MIPI_write_cmos_sensor(0x3756,0x1a);
    OV5693MIPI_write_cmos_sensor(0x3758,0x00);
    OV5693MIPI_write_cmos_sensor(0x3759,0x0f);
    OV5693MIPI_write_cmos_sensor(0x376b,0x44);
    OV5693MIPI_write_cmos_sensor(0x375c,0x04);
    OV5693MIPI_write_cmos_sensor(0x3774,0x10);
    OV5693MIPI_write_cmos_sensor(0x3776,0x00);
    OV5693MIPI_write_cmos_sensor(0x377f,0x08);  //sensor control
    OV5693MIPI_write_cmos_sensor(0x3780,0x22);  //PSRAM control
    OV5693MIPI_write_cmos_sensor(0x3781,0x0c);
    OV5693MIPI_write_cmos_sensor(0x3784,0x2c);
    OV5693MIPI_write_cmos_sensor(0x3785,0x1e);
    OV5693MIPI_write_cmos_sensor(0x378f,0xf5);
    OV5693MIPI_write_cmos_sensor(0x3791,0xb0);
    OV5693MIPI_write_cmos_sensor(0x3795,0x00);
    OV5693MIPI_write_cmos_sensor(0x3796,0x64);
    OV5693MIPI_write_cmos_sensor(0x3797,0x11);
    OV5693MIPI_write_cmos_sensor(0x3798,0x30);
    OV5693MIPI_write_cmos_sensor(0x3799,0x41);
    OV5693MIPI_write_cmos_sensor(0x379a,0x07);
    OV5693MIPI_write_cmos_sensor(0x379b,0xb0);
    OV5693MIPI_write_cmos_sensor(0x379c,0x0c);  //PSRAM control                       
    OV5693MIPI_write_cmos_sensor(0x37c5,0x00);  //sensor FREX exp HH                  
    OV5693MIPI_write_cmos_sensor(0x37c6,0x00);  //sensor FREX exp H                   
    OV5693MIPI_write_cmos_sensor(0x37c7,0x00);  //sensor FREX exp L                   
    OV5693MIPI_write_cmos_sensor(0x37c9,0x00);  //strobe Width HH                     
    OV5693MIPI_write_cmos_sensor(0x37ca,0x00);  //strobe Width H                      
    OV5693MIPI_write_cmos_sensor(0x37cb,0x00);  //strobe Width L                      
    OV5693MIPI_write_cmos_sensor(0x37de,0x00);  //sensor FREX PCHG Width H            
    OV5693MIPI_write_cmos_sensor(0x37df,0x00);  //sensor FREX PCHG Width L
    
    OV5693MIPI_write_cmos_sensor(0x3800,0x00);  //X start H                           
    OV5693MIPI_write_cmos_sensor(0x3801,0x00);  //X start L                           
    OV5693MIPI_write_cmos_sensor(0x3802,0x00);  //Y start H                           
    OV5693MIPI_write_cmos_sensor(0x3803,0x00);  //Y start L                           
    OV5693MIPI_write_cmos_sensor(0x3804,0x0a);  //X end H                             
    OV5693MIPI_write_cmos_sensor(0x3805,0x3f);  //X end L                             
    OV5693MIPI_write_cmos_sensor(0x3806,0x07);  //Y end H                             
    OV5693MIPI_write_cmos_sensor(0x3807,0xa3);  //Y end L                             
    OV5693MIPI_write_cmos_sensor(0x3808,0x05);  //X output size H  2592             //05  0a
    OV5693MIPI_write_cmos_sensor(0x3809,0x10);  //X output size L                       //10  20
    OV5693MIPI_write_cmos_sensor(0x380a,0x03);  //Y output size H  1944             //03  07
    OV5693MIPI_write_cmos_sensor(0x380b,0xcc);  //Y output size L                       //cc   98
    OV5693MIPI_write_cmos_sensor(0x380c,0x0a);  //HTS H  2688                             
    OV5693MIPI_write_cmos_sensor(0x380d,0x80);  //HTS H                               
    OV5693MIPI_write_cmos_sensor(0x380e,0x07);  //HTS L  1984                           //05
    OV5693MIPI_write_cmos_sensor(0x380f,0xc0);  //HTS L                                     //d0
    
    OV5693MIPI_write_cmos_sensor(0x3810,0x00);  //timing ISP x win H                  
    OV5693MIPI_write_cmos_sensor(0x3811,0x08);  //timing ISP x win L     //02             
    OV5693MIPI_write_cmos_sensor(0x3812,0x00);  //timing ISP y win H                  
    OV5693MIPI_write_cmos_sensor(0x3813,0x02);  //timing ISP y win L                  
    OV5693MIPI_write_cmos_sensor(0x3814,0x31);  //timing x inc                                        //31  11
    OV5693MIPI_write_cmos_sensor(0x3815,0x31);  //timing y ing                                        //31  11
    OV5693MIPI_write_cmos_sensor(0x3820,0x04);  //v fast bin on, v flip off, v bin off           //04  00
    OV5693MIPI_write_cmos_sensor(0x3821,0x1f);  //hsync on, mirror on, hbin on              //1f   1e
    OV5693MIPI_write_cmos_sensor(0x3823,0x00);
    OV5693MIPI_write_cmos_sensor(0x3824,0x00);
    OV5693MIPI_write_cmos_sensor(0x3825,0x00);
    OV5693MIPI_write_cmos_sensor(0x3826,0x00);
    OV5693MIPI_write_cmos_sensor(0x3827,0x00);
    OV5693MIPI_write_cmos_sensor(0x382a,0x04);
    OV5693MIPI_write_cmos_sensor(0x3a04,0x06);
    OV5693MIPI_write_cmos_sensor(0x3a05,0x14);
    OV5693MIPI_write_cmos_sensor(0x3a06,0x00);
    OV5693MIPI_write_cmos_sensor(0x3a07,0xfe);
    OV5693MIPI_write_cmos_sensor(0x3b00,0x00);  //strobe off          
    OV5693MIPI_write_cmos_sensor(0x3b02,0x00);  //strobe dummy line H     
    OV5693MIPI_write_cmos_sensor(0x3b03,0x00);  //strobe dummy line L     
    OV5693MIPI_write_cmos_sensor(0x3b04,0x00);  //strobe at next frame    
    OV5693MIPI_write_cmos_sensor(0x3b05,0x00);  //strobe pulse width      
    OV5693MIPI_write_cmos_sensor(0x3e07,0x20);
    OV5693MIPI_write_cmos_sensor(0x4000,0x08);
    OV5693MIPI_write_cmos_sensor(0x4001,0x04);  //BLC start line                                                                         
    OV5693MIPI_write_cmos_sensor(0x4002,0x45);  //BLC auto enable, do 5 frames                                                           
    OV5693MIPI_write_cmos_sensor(0x4004,0x08);  //8 black lines                                                                          
    OV5693MIPI_write_cmos_sensor(0x4005,0x18);  //don't output black line, apply one channel offset to all, BLC triggered by gain change,
    OV5693MIPI_write_cmos_sensor(0x4006,0x20);  //ZLINE COEF                                                                             
    OV5693MIPI_write_cmos_sensor(0x4008,0x24);                                                                                       
    OV5693MIPI_write_cmos_sensor(0x4009,0x40);  //black level target                                                                     
    OV5693MIPI_write_cmos_sensor(0x400c,0x00);  //BLC man level0 H                                                                       
    OV5693MIPI_write_cmos_sensor(0x400d,0x00);  //BLC man level0 L                                                                       
    OV5693MIPI_write_cmos_sensor(0x4058,0x00);                                                                                         
    OV5693MIPI_write_cmos_sensor(0x404e,0x37);  //BLC maximum black level                                                                
    OV5693MIPI_write_cmos_sensor(0x404f,0x8f);  //BLC stable range                                                                       
    OV5693MIPI_write_cmos_sensor(0x4058,0x00);                                                                                     
    OV5693MIPI_write_cmos_sensor(0x4101,0xb2);                                                                                   
    OV5693MIPI_write_cmos_sensor(0x4303,0x00);  //test pattern off                                                                       
    OV5693MIPI_write_cmos_sensor(0x4304,0x08);  //test pattern option                                                                    
    OV5693MIPI_write_cmos_sensor(0x4307,0x30);                                                                                       
    OV5693MIPI_write_cmos_sensor(0x4311,0x04);  //Vsync width H                                                                          
    OV5693MIPI_write_cmos_sensor(0x4315,0x01);  //Vsync width L                                                                          
    OV5693MIPI_write_cmos_sensor(0x4511,0x05);                                                                                      
    OV5693MIPI_write_cmos_sensor(0x4512,0x00); //01 2013.09.02

    OV5693MIPI_write_cmos_sensor(0x4800,0x14);  // MIPI line sync enable
    
    OV5693MIPI_write_cmos_sensor(0x4806,0x00);                                                                                      
    OV5693MIPI_write_cmos_sensor(0x4816,0x52);  //embedded line data type                                                                
    OV5693MIPI_write_cmos_sensor(0x481f,0x30);  //max clk_prepare                                                                        
    OV5693MIPI_write_cmos_sensor(0x4826,0x2c);  //hs prepare min                                                                         
    OV5693MIPI_write_cmos_sensor(0x4831,0x64);  //UI hs prepare     
    OV5693MIPI_write_cmos_sensor(0x4d00,0x04);  //temprature sensor 
    OV5693MIPI_write_cmos_sensor(0x4d01,0x71);                 
    OV5693MIPI_write_cmos_sensor(0x4d02,0xfd);                  
    OV5693MIPI_write_cmos_sensor(0x4d03,0xf5);                  
    OV5693MIPI_write_cmos_sensor(0x4d04,0x0c);                  
    OV5693MIPI_write_cmos_sensor(0x4d05,0xcc);  //temperature sensor
    OV5693MIPI_write_cmos_sensor(0x4837,0x09);  //MIPI global timing  //0d 0a
    OV5693MIPI_write_cmos_sensor(0x5000,0x06);  //BPC on, WPC on    
    OV5693MIPI_write_cmos_sensor(0x5001,0x01);  //MWB on            
    OV5693MIPI_write_cmos_sensor(0x5002,0x00);  //scal off          
    OV5693MIPI_write_cmos_sensor(0x5003,0x20);
    OV5693MIPI_write_cmos_sensor(0x5046,0x0a);  //SOF auto mode 
    OV5693MIPI_write_cmos_sensor(0x5013,0x00);            
    OV5693MIPI_write_cmos_sensor(0x5046,0x0a);  //SOF auto mode 
    OV5693MIPI_write_cmos_sensor(0x5780,0xfc);  //1c DPC           
    OV5693MIPI_write_cmos_sensor(0x5786,0x20); //20
    OV5693MIPI_write_cmos_sensor(0x5787,0x40);//10
    OV5693MIPI_write_cmos_sensor(0x5788,0x08);//18
    OV5693MIPI_write_cmos_sensor(0x578a,0x02);//04
    OV5693MIPI_write_cmos_sensor(0x578b,0x01);//02
    OV5693MIPI_write_cmos_sensor(0x578c,0x01);//02
    OV5693MIPI_write_cmos_sensor(0x578e,0x02);//04
    OV5693MIPI_write_cmos_sensor(0x578f,0x01);//02
    OV5693MIPI_write_cmos_sensor(0x5790,0x01);//02
    OV5693MIPI_write_cmos_sensor(0x5791,0xff);  //DPC             
    OV5693MIPI_write_cmos_sensor(0x5842,0x01);  //LENC BR Hscale H
    OV5693MIPI_write_cmos_sensor(0x5843,0x2b);  //LENC BR Hscale L
    OV5693MIPI_write_cmos_sensor(0x5844,0x01);  //LENC BR Vscale H
    OV5693MIPI_write_cmos_sensor(0x5845,0x92);  //LENC BR Vscale L
    OV5693MIPI_write_cmos_sensor(0x5846,0x01);  //LENC G Hscale H 
    OV5693MIPI_write_cmos_sensor(0x5847,0x8f);  //LENC G Hscale L 
    OV5693MIPI_write_cmos_sensor(0x5848,0x01);  //LENC G Vscale H 
    OV5693MIPI_write_cmos_sensor(0x5849,0x0c);  //LENC G Vscale L 
    OV5693MIPI_write_cmos_sensor(0x5e00,0x00);  //test pattern off
    OV5693MIPI_write_cmos_sensor(0x5e10,0x0c);
    OV5693MIPI_write_cmos_sensor(0x0100,0x01);  //wake up
	#else
    int totalCnt = 0, len = 0;
	int transfer_len, transac_len=3;
	kal_uint8* pBuf=NULL;
	dma_addr_t dmaHandle;
	pBuf = (kal_uint8*)kmalloc(1024, GFP_KERNEL);
	

    totalCnt = ARRAY_SIZE(ov5693_init);
	transfer_len = totalCnt / transac_len;
	len = (transfer_len<<8)|transac_len;    
	SENSORDB("Total Count = %d, Len = 0x%x\n", totalCnt,len);    
	memcpy(pBuf, &ov5693_init, totalCnt );   
	dmaHandle = dma_map_single(NULL, pBuf, 1024, DMA_TO_DEVICE);	
	OV5693_multi_write_cmos_sensor(dmaHandle, len); 

	dma_unmap_single(NULL, dmaHandle, 1024, DMA_TO_DEVICE);
	kfree(pBuf);
	#endif
	#if defined(OV5693_OTP)
	update_otp_wb();
	update_otp_lenc();
	#endif
}   /*  OV5693MIPI_Sensor_Init  */


static void OV5693MIPI_Preview_Setting(void)
{
    //5.1.2 FQPreview 1296x972 30fps 24M MCLK 2lane 864Mbps/lane
    OV5693MIPI_write_cmos_sensor(0x0100,0x00);  //software sleep

    OV5693MIPI_write_cmos_sensor(0x3708,0xe6);  //sensor control
    OV5693MIPI_write_cmos_sensor(0x3709,0xc7);  //sensor control
    OV5693MIPI_write_cmos_sensor(0x3803,0x00);  //timing Y start L
    OV5693MIPI_write_cmos_sensor(0x3806,0x07);  //timing Y end H
    OV5693MIPI_write_cmos_sensor(0x3807,0xa3);  //timing Y end L
    
    OV5693MIPI_write_cmos_sensor(0x3808,0x05);  //X output size H  1296
    OV5693MIPI_write_cmos_sensor(0x3809,0x10);  //X output size L
    OV5693MIPI_write_cmos_sensor(0x380a,0x03);  //Y output size H  972
    OV5693MIPI_write_cmos_sensor(0x380b,0xcc);  //Y output size L
    
    OV5693MIPI_write_cmos_sensor(0x380c,0x0a);  //HTS H  2688
    OV5693MIPI_write_cmos_sensor(0x380d,0x80);  //HTS L
    OV5693MIPI_write_cmos_sensor(0x380e,0x07);  //VTS H  1984
    OV5693MIPI_write_cmos_sensor(0x380f,0xc0);  //VTS L
    
    OV5693MIPI_write_cmos_sensor(0x3810,0x00);  //timing ISP x win H
    OV5693MIPI_write_cmos_sensor(0x3811,0x08);  //timing ISP x win L
    OV5693MIPI_write_cmos_sensor(0x3812,0x00);  //timing ISP y win H
    OV5693MIPI_write_cmos_sensor(0x3813,0x02);  //timing ISP y win L
    OV5693MIPI_write_cmos_sensor(0x3814,0x31);  //timing X inc
    OV5693MIPI_write_cmos_sensor(0x3815,0x31);  //timing Y inc
    
    OV5693MIPI_write_cmos_sensor(0x3820,0x04);  //v fast bin on, v flip off, v bin off
    OV5693MIPI_write_cmos_sensor(0x3821,0x1f);  //hsync on, mirror on, hbin on
    
    OV5693MIPI_write_cmos_sensor(0x3a04,0x06);
    OV5693MIPI_write_cmos_sensor(0x3a05,0x14);
    OV5693MIPI_write_cmos_sensor(0x5002,0x00);  //scale off

    OV5693MIPI_write_cmos_sensor(0x0100,0x01);  //wake up   
}   /*  OV5693MIPI_Capture_Setting  */

static void OV5693MIPI_Capture_Setting(void)
{
    //5.1.3 Capture 2592x1944 30fps 24M MCLK 2lane 864Mbps/lane
    OV5693MIPI_write_cmos_sensor(0x0100,0x00);  //software sleep
    
    OV5693MIPI_write_cmos_sensor(0x3708,0xe2);  //sensor control
    OV5693MIPI_write_cmos_sensor(0x3709,0xc3);  //sensor control
    OV5693MIPI_write_cmos_sensor(0x3803,0x00);  //timing Y start L
    OV5693MIPI_write_cmos_sensor(0x3806,0x07);  //timing Y end H
    OV5693MIPI_write_cmos_sensor(0x3807,0xa3);  //timing Y end L
    
    OV5693MIPI_write_cmos_sensor(0x3808,0x0a);  //X output size H  2592
    OV5693MIPI_write_cmos_sensor(0x3809,0x20);  //X output size L
    OV5693MIPI_write_cmos_sensor(0x380a,0x07);  //Y output size H  1944
    OV5693MIPI_write_cmos_sensor(0x380b,0x98);  //Y output size L
    
    OV5693MIPI_write_cmos_sensor(0x380c,0x0a);  //HTS H 2688
    OV5693MIPI_write_cmos_sensor(0x380d,0x80);  //HTS L
    OV5693MIPI_write_cmos_sensor(0x380e,0x07);  //VTS H 1984
    OV5693MIPI_write_cmos_sensor(0x380f,0xc0);  //VTS L
    
    OV5693MIPI_write_cmos_sensor(0x3810,0x00);  //timing ISP x win H
    OV5693MIPI_write_cmos_sensor(0x3811,0x10);  //timing ISP x win L
    OV5693MIPI_write_cmos_sensor(0x3812,0x00);  //timing ISP y win H
    OV5693MIPI_write_cmos_sensor(0x3813,0x06);  //timing ISP y win L
    OV5693MIPI_write_cmos_sensor(0x3814,0x11);  //timing X inc
    OV5693MIPI_write_cmos_sensor(0x3815,0x11);  //timing Y inc
    OV5693MIPI_write_cmos_sensor(0x3820,0x00);  //v fast vbin on, flip off, v bin on
    OV5693MIPI_write_cmos_sensor(0x3821,0x1e);  //hsync on, h mirror on, h bin on
    OV5693MIPI_write_cmos_sensor(0x3a04,0x06);
    OV5693MIPI_write_cmos_sensor(0x3a05,0x14);
    OV5693MIPI_write_cmos_sensor(0x5002,0x00);  //scale off
    
    OV5693MIPI_write_cmos_sensor(0x0100,0x01);  //wake up
}


static void OV5693MIPI_Video_Setting(void)
{
    SENSORDB("Enter!");
    
    //5.1.3 Video 2592x1944 30fps 24M MCLK 2lane 864Mbps/lane
    OV5693MIPI_write_cmos_sensor(0x0100,0x00);  //software sleep

    OV5693MIPI_write_cmos_sensor(0x3708,0xe2);  //sensor control
    OV5693MIPI_write_cmos_sensor(0x3709,0xc3);  //sensor control
    OV5693MIPI_write_cmos_sensor(0x3803,0x00);  //timing Y start L
    OV5693MIPI_write_cmos_sensor(0x3806,0x07);  //timing Y end H
    OV5693MIPI_write_cmos_sensor(0x3807,0xa3);  //timing Y end L

    OV5693MIPI_write_cmos_sensor(0x3808,0x0a);  //X output size H  2592
    OV5693MIPI_write_cmos_sensor(0x3809,0x20);  //X output size L
    OV5693MIPI_write_cmos_sensor(0x380a,0x07);  //Y output size H  1944
    OV5693MIPI_write_cmos_sensor(0x380b,0x98);  //Y output size L

    OV5693MIPI_write_cmos_sensor(0x380c,0x0a);  //HTS H 2688
    OV5693MIPI_write_cmos_sensor(0x380d,0x80);  //HTS L
    OV5693MIPI_write_cmos_sensor(0x380e,0x07);  //VTS H 1984
    OV5693MIPI_write_cmos_sensor(0x380f,0xc0);  //VTS L

    OV5693MIPI_write_cmos_sensor(0x3810,0x00);  //timing ISP x win H
    OV5693MIPI_write_cmos_sensor(0x3811,0x10);  //timing ISP x win L
    OV5693MIPI_write_cmos_sensor(0x3812,0x00);  //timing ISP y win H
    OV5693MIPI_write_cmos_sensor(0x3813,0x06);  //timing ISP y win L
    OV5693MIPI_write_cmos_sensor(0x3814,0x11);  //timing X inc
    OV5693MIPI_write_cmos_sensor(0x3815,0x11);  //timing Y inc
    OV5693MIPI_write_cmos_sensor(0x3820,0x00);  //v fast vbin on, flip off, v bin on
    OV5693MIPI_write_cmos_sensor(0x3821,0x1e);  //hsync on, h mirror on, h bin on
    OV5693MIPI_write_cmos_sensor(0x3a04,0x06);
    OV5693MIPI_write_cmos_sensor(0x3a05,0x14);
    OV5693MIPI_write_cmos_sensor(0x5002,0x00);  //scale off

    OV5693MIPI_write_cmos_sensor(0x0100,0x01);  //wake up

    SENSORDB("Exit!");
}


static void OV5693MIPI_Video_720P_Setting(void)
{
    SENSORDB("Enter!");

    //5.1.4 Video BQ720p Full FOV 30fps 24M MCLK 2lane 864Mbps/lane
    OV5693MIPI_write_cmos_sensor(0x0100,0x00);  //software sleep
    
    OV5693MIPI_write_cmos_sensor(0x3708,0xe6);  //sensor control
    OV5693MIPI_write_cmos_sensor(0x3709,0xc3);  //sensor control
    OV5693MIPI_write_cmos_sensor(0x3803,0xf4);  //timing Y start L
    OV5693MIPI_write_cmos_sensor(0x3806,0x06);  //timing Y end H
    OV5693MIPI_write_cmos_sensor(0x3807,0xab);  //timing Y end L
    
    OV5693MIPI_write_cmos_sensor(0x3808,0x05);  //X output size H  1280
    OV5693MIPI_write_cmos_sensor(0x3809,0x00);  //X output size L
    OV5693MIPI_write_cmos_sensor(0x380a,0x02);  //Y output size H  720
    OV5693MIPI_write_cmos_sensor(0x380b,0xd0);  //Y output size L
    
    OV5693MIPI_write_cmos_sensor(0x380c,0x0d);  //HTS H  2688
    OV5693MIPI_write_cmos_sensor(0x380d,0xb0);  //HTS L
    OV5693MIPI_write_cmos_sensor(0x380e,0x05);  //VTS H  1984
    OV5693MIPI_write_cmos_sensor(0x380f,0xf0);  //VTS L
    
    OV5693MIPI_write_cmos_sensor(0x3810,0x00);  //timing ISP x win H
    OV5693MIPI_write_cmos_sensor(0x3811,0x08);  //timing ISP x win L
    OV5693MIPI_write_cmos_sensor(0x3812,0x00);  //timing ISP y win H
    OV5693MIPI_write_cmos_sensor(0x3813,0x02);  //timing ISP y win L
    OV5693MIPI_write_cmos_sensor(0x3814,0x31);  //timing X inc
    OV5693MIPI_write_cmos_sensor(0x3815,0x31);  //timing Y inc
    
    OV5693MIPI_write_cmos_sensor(0x3820,0x01);  //v fast vbin of, flip off, v bin on
    OV5693MIPI_write_cmos_sensor(0x3821,0x1f);  //hsync on, h mirror on, h bin on
    
    OV5693MIPI_write_cmos_sensor(0x3a04,0x06);
    OV5693MIPI_write_cmos_sensor(0x3a05,0x14);
    OV5693MIPI_write_cmos_sensor(0x5002,0x00);  //scale off
    
    OV5693MIPI_write_cmos_sensor(0x0100,0x01);  //wake up

    SENSORDB("Exit!");
}

static void OV5693MIPI_Video_1080P_Setting(void)
{
    SENSORDB("Enter!");
    
    //5.1.5 Video 1080p 30fps 24M MCLK 2lane 864Mbps/lane
    OV5693MIPI_write_cmos_sensor(0x0100,0x00);  //software sleep

    OV5693MIPI_write_cmos_sensor(0x3708,0xe2);  //sensor control
    OV5693MIPI_write_cmos_sensor(0x3709,0xc3);  //sensor control
    OV5693MIPI_write_cmos_sensor(0x3803,0xf8);  //timing Y start L
    OV5693MIPI_write_cmos_sensor(0x3806,0x06);  //timing Y end H
    OV5693MIPI_write_cmos_sensor(0x3807,0xab);  //timing Y end L

    OV5693MIPI_write_cmos_sensor(0x3808,0x07);  //X output size H  1920
    OV5693MIPI_write_cmos_sensor(0x3809,0x80);  //X output size L
    OV5693MIPI_write_cmos_sensor(0x380a,0x04);  //Y output size H  1080
    OV5693MIPI_write_cmos_sensor(0x380b,0x38);  //Y output size L

    OV5693MIPI_write_cmos_sensor(0x380c,0x0a);  //HTS H  2688
    OV5693MIPI_write_cmos_sensor(0x380d,0x80);  //HTS L
    OV5693MIPI_write_cmos_sensor(0x380e,0x07);  //VTS H  1984
    OV5693MIPI_write_cmos_sensor(0x380f,0xc0);  //VYS L

    OV5693MIPI_write_cmos_sensor(0x3810,0x00);  //timing ISP x win H
    OV5693MIPI_write_cmos_sensor(0x3811,0x02);  //timing ISP x win L
    OV5693MIPI_write_cmos_sensor(0x3812,0x00);  //timing ISP y win H
    OV5693MIPI_write_cmos_sensor(0x3813,0x02);  //timing ISP y win L
    OV5693MIPI_write_cmos_sensor(0x3814,0x11);  //timing X inc
    OV5693MIPI_write_cmos_sensor(0x3815,0x11);  //timing Y inc
    
    OV5693MIPI_write_cmos_sensor(0x3820,0x00);  //v bin off
    OV5693MIPI_write_cmos_sensor(0x3821,0x1e);  //hsync on, h mirror on, h bin off
    
    OV5693MIPI_write_cmos_sensor(0x3a04,0x06);
    OV5693MIPI_write_cmos_sensor(0x3a05,0x14);
    OV5693MIPI_write_cmos_sensor(0x5002,0x80);  //scale on

    OV5693MIPI_write_cmos_sensor(0x0100,0x01);  //wake up

    SENSORDB("Exit!");
}


/*************************************************************************
* FUNCTION
*   OV5693MIPIOpen
*
* DESCRIPTION
*   This function initialize the registers of CMOS sensor
*
* PARAMETERS
*   None
*
* RETURNS
*   None
*
* GLOBALS AFFECTED
*
*************************************************************************/
UINT32 OV5693MIPIOpen(void)
{
    kal_uint16 sensor_id = 0; 

    // check if sensor ID correct
    sensor_id=((OV5693MIPI_read_cmos_sensor(0x300A) << 8) | OV5693MIPI_read_cmos_sensor(0x300B));   
    SENSORDB("sensor_id = 0x%x ", sensor_id);
    
    if (sensor_id != OV5693_SENSOR_ID){
        return ERROR_SENSOR_CONNECT_FAIL;
    }
    
    /* initail sequence write in  */
    OV5693MIPI_Sensor_Init();

    spin_lock(&ov5693mipi_drv_lock);
    OV5693MIPIAutoFlickerMode = KAL_FALSE;
    OV5693MIPI_sensor.sensor_mode = OV5693MIPI_SENSOR_MODE_INIT;
    OV5693MIPI_sensor.shutter = 0x3D0;
    OV5693MIPI_sensor.gain = 0x100;
    OV5693MIPI_sensor.pclk = OV5693MIPI_PREVIEW_CLK;
    OV5693MIPI_sensor.frame_length = OV5693MIPI_PV_PERIOD_LINE_NUMS;
    OV5693MIPI_sensor.line_length = OV5693MIPI_PV_PERIOD_PIXEL_NUMS;
    OV5693MIPI_sensor.dummy_pixel = 0;
    OV5693MIPI_sensor.dummy_line = 0;
    spin_unlock(&ov5693mipi_drv_lock);

    return ERROR_NONE;
}   /*  OV5693MIPIOpen  */


/*************************************************************************
* FUNCTION
*   OV5693GetSensorID
*
* DESCRIPTION
*   This function get the sensor ID 
*
* PARAMETERS
*   *sensorID : return the sensor ID 
*
* RETURNS
*   None
*
* GLOBALS AFFECTED
*
*************************************************************************/
UINT32 OV5693GetSensorID(UINT32 *sensorID) 
{
    // check if sensor ID correct
    *sensorID=((OV5693MIPI_read_cmos_sensor(0x300A) << 8) | OV5693MIPI_read_cmos_sensor(0x300B));   

    SENSORDB("Sensor ID: 0x%x ", *sensorID);
        
    if (*sensorID != OV5693_SENSOR_ID) {
        // if Sensor ID is not correct, Must set *sensorID to 0xFFFFFFFF 
        *sensorID = 0xFFFFFFFF;
        return ERROR_SENSOR_CONNECT_FAIL;
    }
 
    return ERROR_NONE;
}

/*************************************************************************
* FUNCTION
*   OV5693MIPIClose
*
* DESCRIPTION
*   
*
* PARAMETERS
*   None
*
* RETURNS
*   None
*
* GLOBALS AFFECTED
*
*************************************************************************/
UINT32 OV5693MIPIClose(void)
{

    /*No Need to implement this function*/ 
    
    return ERROR_NONE;
}   /*  OV5693MIPIClose  */


/*************************************************************************
* FUNCTION
* OV5693MIPIPreview
*
* DESCRIPTION
*   This function start the sensor preview.
*
* PARAMETERS
*   *image_window : address pointer of pixel numbers in one period of HSYNC
*  *sensor_config_data : address pointer of line numbers in one period of VSYNC
*
* RETURNS
*   None
*
* GLOBALS AFFECTED
*
*************************************************************************/
UINT32 OV5693MIPIPreview(MSDK_SENSOR_EXPOSURE_WINDOW_STRUCT *image_window,
                      MSDK_SENSOR_CONFIG_STRUCT *sensor_config_data)
{
    kal_uint16 dummy_pixel, dummy_line;

    SENSORDB("Enter!");

	if(OV5693MIPI_SENSOR_MODE_PREVIEW == OV5693MIPI_sensor.sensor_mode)
	{
		// do nothing
		// FOR CCT PREVIEW
	}
	else
	{
		OV5693MIPI_Capture_Setting();
	}

    spin_lock(&ov5693mipi_drv_lock);
    OV5693MIPI_sensor.sensor_mode = OV5693MIPI_SENSOR_MODE_PREVIEW;
    OV5693MIPI_sensor.pclk = OV5693MIPI_PREVIEW_CLK;
    OV5693MIPI_sensor.video_mode = KAL_FALSE;
    spin_unlock(&ov5693mipi_drv_lock);

    // rotate it 180 degree
    //sensor_config_data->SensorImageMirror = IMAGE_HV_MIRROR;
    //OV5693MIPI_Set_Mirror_Flip(sensor_config_data->SensorImageMirror);

    dummy_pixel = 0;
    dummy_line = 0;
    OV5693MIPI_Set_Dummy(dummy_pixel, dummy_line); /* modify dummy_pixel must gen AE table again */

    SENSORDB("Exit!");
    
    return ERROR_NONE;
}   /*  OV5693MIPIPreview   */

UINT32 OV5693MIPIZSDPreview(MSDK_SENSOR_EXPOSURE_WINDOW_STRUCT *image_window,
                      MSDK_SENSOR_CONFIG_STRUCT *sensor_config_data)
{
    kal_uint16 dummy_pixel, dummy_line;

    SENSORDB("OV5693MIPIZSDPreview Enter!");



    OV5693MIPI_Capture_Setting();

    spin_lock(&ov5693mipi_drv_lock);
    OV5693MIPI_sensor.sensor_mode = OV5693MIPI_SENSOR_MODE_CAPTURE;
    OV5693MIPI_sensor.pclk = OV5693MIPI_CAPTURE_CLK;
    OV5693MIPI_sensor.video_mode = KAL_FALSE;
    spin_unlock(&ov5693mipi_drv_lock);

    // rotate it 180 degree
    //sensor_config_data->SensorImageMirror = IMAGE_HV_MIRROR;
    //OV5693MIPI_Set_Mirror_Flip(sensor_config_data->SensorImageMirror);

    dummy_pixel = 0;
    dummy_line = 0;   
    OV5693MIPI_Set_Dummy(dummy_pixel, dummy_line); /* modify dummy_pixel must gen AE table again */

    SENSORDB("Exit!");

    return ERROR_NONE;
   
}   /*  OV5693MIPIZSDPreview   */

/*************************************************************************
* FUNCTION
*   OV5693MIPICapture
*
* DESCRIPTION
*   This function setup the CMOS sensor in capture MY_OUTPUT mode
*
* PARAMETERS
*
* RETURNS
*   None
*
* GLOBALS AFFECTED
*
*************************************************************************/
UINT32 OV5693MIPICapture(MSDK_SENSOR_EXPOSURE_WINDOW_STRUCT *image_window,
                          MSDK_SENSOR_CONFIG_STRUCT *sensor_config_data)
{
    kal_uint16 dummy_pixel, dummy_line, cap_shutter, cap_gain;
    kal_uint16 pre_shutter = OV5693MIPI_sensor.shutter;
    kal_uint16 pre_gain = OV5693MIPI_sensor.gain;

    SENSORDB("Enter!");

    if(OV5693MIPI_SENSOR_MODE_CAPTURE != OV5693MIPI_sensor.sensor_mode)
    {
		OV5693MIPI_Capture_Setting();
    }
        
    spin_lock(&ov5693mipi_drv_lock);
    OV5693MIPI_sensor.sensor_mode = OV5693MIPI_SENSOR_MODE_CAPTURE;
    OV5693MIPI_sensor.pclk = OV5693MIPI_CAPTURE_CLK;
    OV5693MIPI_sensor.video_mode = KAL_FALSE;
    OV5693MIPIAutoFlickerMode = KAL_FALSE;    
    spin_unlock(&ov5693mipi_drv_lock);

    // rotate it 180 degree
    //sensor_config_data->SensorImageMirror = IMAGE_HV_MIRROR;
    //OV5693MIPI_Set_Mirror_Flip(sensor_config_data->SensorImageMirror);

    dummy_pixel = 0;
    dummy_line = 0;               
    OV5693MIPI_Set_Dummy(dummy_pixel, dummy_line);

    SENSORDB("Exit!");
    
    return ERROR_NONE;
}   /* OV5693MIPI_Capture() */


UINT32 OV5693MIPIVideo(MSDK_SENSOR_EXPOSURE_WINDOW_STRUCT *image_window,
                      MSDK_SENSOR_CONFIG_STRUCT *sensor_config_data)
{
    kal_uint16 dummy_pixel, dummy_line;

    SENSORDB("Enter!");

    #ifdef VIDEO_720P
        OV5693MIPI_Video_720P_Setting();
    #elif defined VIDEO_1080P
        OV5693MIPI_Video_1080P_Setting();
    #else
        OV5693MIPI_Video_Setting();
    #endif

    spin_lock(&ov5693mipi_drv_lock);
    OV5693MIPI_sensor.sensor_mode = OV5693MIPI_SENSOR_MODE_VIDEO;
    OV5693MIPI_sensor.pclk = OV5693MIPI_VIDEO_CLK;
    OV5693MIPI_sensor.video_mode = KAL_TRUE;
    spin_unlock(&ov5693mipi_drv_lock);

    // rotate it 180 degree
    //sensor_config_data->SensorImageMirror = IMAGE_HV_MIRROR;
    //OV5693MIPI_Set_Mirror_Flip(sensor_config_data->SensorImageMirror);

    dummy_pixel = 0;
    dummy_line = 0;
    OV5693MIPI_Set_Dummy(dummy_pixel, dummy_line); /* modify dummy_pixel must gen AE table again */

    SENSORDB("Exit!");
    
    return ERROR_NONE;
}   /*  OV5693MIPIPreview   */



UINT32 OV5693MIPIGetResolution(MSDK_SENSOR_RESOLUTION_INFO_STRUCT *pSensorResolution)
{
#ifdef OV5693MIPI_DRIVER_TRACE
        SENSORDB("Enter");
#endif

    pSensorResolution->SensorFullWidth = OV5693MIPI_IMAGE_SENSOR_FULL_WIDTH;
    pSensorResolution->SensorFullHeight = OV5693MIPI_IMAGE_SENSOR_FULL_HEIGHT;
    
    pSensorResolution->SensorPreviewWidth = OV5693MIPI_IMAGE_SENSOR_PV_WIDTH;
    pSensorResolution->SensorPreviewHeight = OV5693MIPI_IMAGE_SENSOR_PV_HEIGHT;

    pSensorResolution->SensorVideoWidth = OV5693MIPI_IMAGE_SENSOR_VIDEO_WIDTH;
    pSensorResolution->SensorVideoHeight = OV5693MIPI_IMAGE_SENSOR_VIDEO_HEIGHT;		
    
    return ERROR_NONE;
}   /*  OV5693MIPIGetResolution  */

UINT32 OV5693MIPIGetInfo(MSDK_SCENARIO_ID_ENUM ScenarioId,
                      MSDK_SENSOR_INFO_STRUCT *pSensorInfo,
                      MSDK_SENSOR_CONFIG_STRUCT *pSensorConfigData)
{
#ifdef OV5693MIPI_DRIVER_TRACE
    SENSORDB("ScenarioId = %d", ScenarioId);
#endif

    switch(ScenarioId)
    {
        case MSDK_SCENARIO_ID_CAMERA_ZSD:
            pSensorInfo->SensorPreviewResolutionX = OV5693MIPI_IMAGE_SENSOR_FULL_WIDTH; /* not use */
            pSensorInfo->SensorPreviewResolutionY = OV5693MIPI_IMAGE_SENSOR_FULL_HEIGHT; /* not use */
            pSensorInfo->SensorCameraPreviewFrameRate = 15; /* not use */
            break;

        default:
            pSensorInfo->SensorPreviewResolutionX = OV5693MIPI_IMAGE_SENSOR_PV_WIDTH; /* not use */
            pSensorInfo->SensorPreviewResolutionY = OV5693MIPI_IMAGE_SENSOR_PV_HEIGHT; /* not use */
            pSensorInfo->SensorCameraPreviewFrameRate = 30; /* not use */
            break;
    }

    pSensorInfo->SensorFullResolutionX = OV5693MIPI_IMAGE_SENSOR_FULL_WIDTH; /* not use */
    pSensorInfo->SensorFullResolutionY = OV5693MIPI_IMAGE_SENSOR_FULL_HEIGHT; /* not use */

    pSensorInfo->SensorVideoFrameRate = 30; /* not use */
	pSensorInfo->SensorStillCaptureFrameRate= 30; /* not use */
	pSensorInfo->SensorWebCamCaptureFrameRate= 30; /* not use */

    pSensorInfo->SensorClockPolarity = SENSOR_CLOCK_POLARITY_LOW;
    pSensorInfo->SensorClockFallingPolarity = SENSOR_CLOCK_POLARITY_LOW; /* not use */
    pSensorInfo->SensorHsyncPolarity = SENSOR_CLOCK_POLARITY_LOW; // inverse with datasheet
    pSensorInfo->SensorVsyncPolarity = SENSOR_CLOCK_POLARITY_LOW;
    pSensorInfo->SensorInterruptDelayLines = 4; /* not use */
    pSensorInfo->SensorResetActiveHigh = FALSE; /* not use */
    pSensorInfo->SensorResetDelayCount = 5; /* not use */

    pSensorInfo->SensroInterfaceType = SENSOR_INTERFACE_TYPE_MIPI;

    pSensorInfo->SensorOutputDataFormat = OV5693MIPI_COLOR_FORMAT;

    pSensorInfo->CaptureDelayFrame = 2; 
    pSensorInfo->PreviewDelayFrame = 2; 
    pSensorInfo->VideoDelayFrame = 2; 

    pSensorInfo->SensorMasterClockSwitch = 0; /* not use */
    pSensorInfo->SensorDrivingCurrent = ISP_DRIVING_6MA;
    
    pSensorInfo->AEShutDelayFrame = 0;          /* The frame of setting shutter default 0 for TG int */
    pSensorInfo->AESensorGainDelayFrame = 0;    /* The frame of setting sensor gain */
    pSensorInfo->AEISPGainDelayFrame = 2;   

    switch (ScenarioId)
    {
	    case MSDK_SCENARIO_ID_CAMERA_CAPTURE_JPEG:
	    case MSDK_SCENARIO_ID_CAMERA_ZSD:
			pSensorInfo->SensorClockFreq = 24;
			pSensorInfo->SensorClockDividCount = 3; /* not use */
			pSensorInfo->SensorClockRisingCount = 0;
			pSensorInfo->SensorClockFallingCount = 2; /* not use */
			pSensorInfo->SensorPixelClockCount = 3; /* not use */
			pSensorInfo->SensorDataLatchCount = 2; /* not use */
	        pSensorInfo->SensorGrabStartX = OV5693MIPI_FULL_START_X; 
	        pSensorInfo->SensorGrabStartY = OV5693MIPI_FULL_START_Y;

            pSensorInfo->SensorMIPILaneNumber = SENSOR_MIPI_2_LANE;         
            pSensorInfo->MIPIDataLowPwr2HighSpeedTermDelayCount = 0; 
            pSensorInfo->MIPIDataLowPwr2HighSpeedSettleDelayCount = 14; 
            pSensorInfo->MIPICLKLowPwr2HighSpeedTermDelayCount = 0;
            pSensorInfo->SensorWidthSampling = 0;  // 0 is default 1x
            pSensorInfo->SensorHightSampling = 0;   // 0 is default 1x 
            pSensorInfo->SensorPacketECCOrder = 1;

	        break;
	    case MSDK_SCENARIO_ID_VIDEO_PREVIEW:
			pSensorInfo->SensorClockFreq = 24;
			pSensorInfo->SensorClockDividCount = 3; /* not use */
			pSensorInfo->SensorClockRisingCount = 0;
			pSensorInfo->SensorClockFallingCount = 2; /* not use */
			pSensorInfo->SensorPixelClockCount = 3; /* not use */
			pSensorInfo->SensorDataLatchCount = 2; /* not use */
	        pSensorInfo->SensorGrabStartX = OV5693MIPI_VIDEO_START_X; 
	        pSensorInfo->SensorGrabStartY = OV5693MIPI_VIDEO_START_Y;

            pSensorInfo->SensorMIPILaneNumber = SENSOR_MIPI_2_LANE;         
            pSensorInfo->MIPIDataLowPwr2HighSpeedTermDelayCount = 0; 
            pSensorInfo->MIPIDataLowPwr2HighSpeedSettleDelayCount = 14; 
            pSensorInfo->MIPICLKLowPwr2HighSpeedTermDelayCount = 0;
            pSensorInfo->SensorWidthSampling = 0;  // 0 is default 1x
            pSensorInfo->SensorHightSampling = 0;   // 0 is default 1x 
            pSensorInfo->SensorPacketECCOrder = 1;

	        break;            
	    default:
	        pSensorInfo->SensorClockFreq = 24;
			pSensorInfo->SensorClockDividCount = 3; /* not use */
			pSensorInfo->SensorClockRisingCount = 0;
			pSensorInfo->SensorClockFallingCount = 2; /* not use */
			pSensorInfo->SensorPixelClockCount = 3; /* not use */
			pSensorInfo->SensorDataLatchCount = 2; /* not use */
	        pSensorInfo->SensorGrabStartX = OV5693MIPI_PV_START_X; 
	        pSensorInfo->SensorGrabStartY = OV5693MIPI_PV_START_Y;

            pSensorInfo->SensorMIPILaneNumber = SENSOR_MIPI_2_LANE;         
            pSensorInfo->MIPIDataLowPwr2HighSpeedTermDelayCount = 0; 
            pSensorInfo->MIPIDataLowPwr2HighSpeedSettleDelayCount = 14; 
            pSensorInfo->MIPICLKLowPwr2HighSpeedTermDelayCount = 0;
            pSensorInfo->SensorWidthSampling = 0;  // 0 is default 1x
            pSensorInfo->SensorHightSampling = 0;   // 0 is default 1x 
            pSensorInfo->SensorPacketECCOrder = 1;

	        break;
    }
	
	return ERROR_NONE;
}   /*  OV5693MIPIGetInfo  */


UINT32 OV5693MIPIControl(MSDK_SCENARIO_ID_ENUM ScenarioId, MSDK_SENSOR_EXPOSURE_WINDOW_STRUCT *pImageWindow,
                      MSDK_SENSOR_CONFIG_STRUCT *pSensorConfigData)
{
    SENSORDB("ScenarioId = %d", ScenarioId);

    mCurrentScenarioId =ScenarioId;
    
    switch (ScenarioId)
    {
        case MSDK_SCENARIO_ID_CAMERA_PREVIEW:
            OV5693MIPIPreview(pImageWindow, pSensorConfigData);
            break;
        case MSDK_SCENARIO_ID_VIDEO_PREVIEW:
            OV5693MIPIVideo(pImageWindow, pSensorConfigData);
            break;
        case MSDK_SCENARIO_ID_CAMERA_CAPTURE_JPEG:
            OV5693MIPICapture(pImageWindow, pSensorConfigData);
            break;
        case MSDK_SCENARIO_ID_CAMERA_ZSD:
            OV5693MIPIZSDPreview(pImageWindow, pSensorConfigData);
            break;      
        default:
            SENSORDB("Error ScenarioId setting");
            return ERROR_INVALID_SCENARIO_ID;
    }

    return ERROR_NONE;
}   /* OV5693MIPIControl() */



UINT32 OV5693MIPISetVideoMode(UINT16 u2FrameRate)
{
    SENSORDB("u2FrameRate = %d ", u2FrameRate);

    // SetVideoMode Function should fix framerate
    if(u2FrameRate < 5){
        // Dynamic frame rate
        return ERROR_NONE;
    }

    spin_lock(&ov5693mipi_drv_lock);
    OV5693MIPI_sensor.video_mode = KAL_TRUE;
    spin_unlock(&ov5693mipi_drv_lock);

    if(u2FrameRate == 30){
        spin_lock(&ov5693mipi_drv_lock);
        OV5693MIPI_sensor.NightMode = KAL_FALSE;
        spin_unlock(&ov5693mipi_drv_lock);
    }else if(u2FrameRate == 15){
        spin_lock(&ov5693mipi_drv_lock);
        OV5693MIPI_sensor.NightMode = KAL_TRUE;
        spin_unlock(&ov5693mipi_drv_lock);
    }else{
        // fixed other frame rate
    }

    spin_lock(&ov5693mipi_drv_lock);
    OV5693MIPI_sensor.FixedFps = u2FrameRate;
    spin_unlock(&ov5693mipi_drv_lock);

    if((u2FrameRate == 30)&&(OV5693MIPIAutoFlickerMode == KAL_TRUE))
        u2FrameRate = 296;
    else if ((u2FrameRate == 15)&&(OV5693MIPIAutoFlickerMode == KAL_TRUE))
        u2FrameRate = 146;
    else
        u2FrameRate = 10 * u2FrameRate;
    
    OV5693MIPISetMaxFrameRate(u2FrameRate);
    OV5693MIPI_Write_Shutter(OV5693MIPI_sensor.shutter);//From Meimei Video issue

    return ERROR_NONE;
}

UINT32 OV5693MIPISetAutoFlickerMode(kal_bool bEnable, UINT16 u2FrameRate)
{
    SENSORDB("bEnable = %d, u2FrameRate = %d ", bEnable, u2FrameRate);

    if(bEnable){
        spin_lock(&ov5693mipi_drv_lock);
        OV5693MIPIAutoFlickerMode = KAL_TRUE;
        spin_unlock(&ov5693mipi_drv_lock);

        /*Change frame rate 29.5fps to 29.8fps to do Auto flick*/
        if((OV5693MIPI_sensor.FixedFps == 30)&&(OV5693MIPI_sensor.video_mode==KAL_TRUE))
            OV5693MIPISetMaxFrameRate(296);
        else if((OV5693MIPI_sensor.FixedFps == 15)&&(OV5693MIPI_sensor.video_mode==KAL_TRUE))
            OV5693MIPISetMaxFrameRate(148);
        
    }else{ //Cancel Auto flick
        spin_lock(&ov5693mipi_drv_lock);
        OV5693MIPIAutoFlickerMode = KAL_FALSE;
        spin_unlock(&ov5693mipi_drv_lock);
        
        if((OV5693MIPI_sensor.FixedFps == 30)&&(OV5693MIPI_sensor.video_mode==KAL_TRUE))
            OV5693MIPISetMaxFrameRate(300);
        else if((OV5693MIPI_sensor.FixedFps == 15)&&(OV5693MIPI_sensor.video_mode==KAL_TRUE))
            OV5693MIPISetMaxFrameRate(150);            
    }

    return ERROR_NONE;
}


UINT32 OV5693MIPISetMaxFramerateByScenario(MSDK_SCENARIO_ID_ENUM scenarioId, MUINT32 frameRate) 
{
    kal_uint32 pclk;
	kal_int16 dummyLine;
	kal_uint16 lineLength,frameHeight;
  
	SENSORDB("scenarioId = %d, frame rate = %d", scenarioId, frameRate);

    switch (scenarioId) {
		case MSDK_SCENARIO_ID_CAMERA_PREVIEW:
			pclk = OV5693MIPI_PREVIEW_CLK;
			lineLength = OV5693MIPI_PV_PERIOD_PIXEL_NUMS;
			frameHeight = (10 * pclk)/frameRate/lineLength;
			dummyLine = frameHeight - OV5693MIPI_PV_PERIOD_LINE_NUMS;
            if (dummyLine < 0) dummyLine = 0;
			OV5693MIPI_Set_Dummy(0, dummyLine);			
			break;			
		case MSDK_SCENARIO_ID_VIDEO_PREVIEW:
			pclk = OV5693MIPI_VIDEO_CLK;
			lineLength = OV5693MIPI_VIDEO_PERIOD_PIXEL_NUMS;
			frameHeight = (10 * pclk)/frameRate/lineLength;
			dummyLine = frameHeight - OV5693MIPI_VIDEO_PERIOD_LINE_NUMS;
            if (dummyLine < 0) dummyLine = 0;
			OV5693MIPI_Set_Dummy(0, dummyLine);			
			break;
		case MSDK_SCENARIO_ID_CAMERA_CAPTURE_JPEG:
		case MSDK_SCENARIO_ID_CAMERA_ZSD:			
			pclk = OV5693MIPI_CAPTURE_CLK;
			lineLength = OV5693MIPI_FULL_PERIOD_PIXEL_NUMS;
			frameHeight = (10 * pclk)/frameRate/lineLength;
			dummyLine = frameHeight - OV5693MIPI_FULL_PERIOD_LINE_NUMS;
            if (dummyLine < 0) dummyLine = 0;
			OV5693MIPI_Set_Dummy(0, dummyLine);			
			break;		
/*        case MSDK_SCENARIO_ID_CAMERA_3D_PREVIEW: //added
            break;
        case MSDK_SCENARIO_ID_CAMERA_3D_VIDEO:
			break;
        case MSDK_SCENARIO_ID_CAMERA_3D_CAPTURE: //added   
			break;		*/
		default:
			break;
	}	
	return ERROR_NONE;
}


UINT32 OV5693MIPIGetDefaultFramerateByScenario(MSDK_SCENARIO_ID_ENUM scenarioId, MUINT32 *pframeRate) 
{
	SENSORDB("scenarioId = %d \n", scenarioId);

	switch (scenarioId) {
        case MSDK_SCENARIO_ID_CAMERA_PREVIEW:
		case MSDK_SCENARIO_ID_VIDEO_PREVIEW:
            *pframeRate = 300;
            break;
		case MSDK_SCENARIO_ID_CAMERA_CAPTURE_JPEG:
		case MSDK_SCENARIO_ID_CAMERA_ZSD:
            *pframeRate = 300;
            break;		
/*        case MSDK_SCENARIO_ID_CAMERA_3D_PREVIEW: //added
        case MSDK_SCENARIO_ID_CAMERA_3D_VIDEO:
        case MSDK_SCENARIO_ID_CAMERA_3D_CAPTURE: //added   
            *pframeRate = 300;
			break;		*/
		default:
			break;
	}

	return ERROR_NONE;
}


UINT32 OV5693MIPIFeatureControl(MSDK_SENSOR_FEATURE_ENUM FeatureId,
                             UINT8 *pFeaturePara,UINT32 *pFeatureParaLen)
{
    UINT16 *pFeatureReturnPara16=(UINT16 *) pFeaturePara;
    UINT16 *pFeatureData16=(UINT16 *) pFeaturePara;
    UINT32 *pFeatureReturnPara32=(UINT32 *) pFeaturePara;
    UINT32 *pFeatureData32=(UINT32 *) pFeaturePara;
    UINT32 OV5693MIPISensorRegNumber;
    UINT32 i;
    PNVRAM_SENSOR_DATA_STRUCT pSensorDefaultData=(PNVRAM_SENSOR_DATA_STRUCT) pFeaturePara;
    MSDK_SENSOR_CONFIG_STRUCT *pSensorConfigData=(MSDK_SENSOR_CONFIG_STRUCT *) pFeaturePara;
    MSDK_SENSOR_REG_INFO_STRUCT *pSensorRegData=(MSDK_SENSOR_REG_INFO_STRUCT *) pFeaturePara;
    MSDK_SENSOR_GROUP_INFO_STRUCT *pSensorGroupInfo=(MSDK_SENSOR_GROUP_INFO_STRUCT *) pFeaturePara;
    MSDK_SENSOR_ITEM_INFO_STRUCT *pSensorItemInfo=(MSDK_SENSOR_ITEM_INFO_STRUCT *) pFeaturePara;
    MSDK_SENSOR_ENG_INFO_STRUCT *pSensorEngInfo=(MSDK_SENSOR_ENG_INFO_STRUCT *) pFeaturePara;

    #ifdef OV5693MIPI_DRIVER_TRACE
        //SENSORDB("FeatureId = %d", FeatureId);
    #endif

    switch (FeatureId)
    {
        case SENSOR_FEATURE_GET_RESOLUTION:
            *pFeatureReturnPara16++=OV5693MIPI_IMAGE_SENSOR_FULL_WIDTH;
            *pFeatureReturnPara16=OV5693MIPI_IMAGE_SENSOR_FULL_HEIGHT;
            *pFeatureParaLen=4;
            break;
        case SENSOR_FEATURE_GET_PERIOD:
            switch(mCurrentScenarioId)
            {
                case MSDK_SCENARIO_ID_CAMERA_CAPTURE_JPEG:
                case MSDK_SCENARIO_ID_CAMERA_ZSD:
                    *pFeatureReturnPara16++ = OV5693MIPI_FULL_PERIOD_PIXEL_NUMS;
                    *pFeatureReturnPara16 = OV5693MIPI_sensor.frame_length;
                    *pFeatureParaLen=4;
                    break;
                case MSDK_SCENARIO_ID_VIDEO_PREVIEW:
                    *pFeatureReturnPara16++ = OV5693MIPI_VIDEO_PERIOD_PIXEL_NUMS;
                    *pFeatureReturnPara16 = OV5693MIPI_sensor.frame_length;
                    *pFeatureParaLen=4;
                    break;
                default:
                    *pFeatureReturnPara16++ = OV5693MIPI_PV_PERIOD_PIXEL_NUMS;
                    *pFeatureReturnPara16 = OV5693MIPI_sensor.frame_length;
                    *pFeatureParaLen=4;
                    break;
            }
            break;
        case SENSOR_FEATURE_GET_PIXEL_CLOCK_FREQ:
            switch(mCurrentScenarioId)
            {
                case MSDK_SCENARIO_ID_CAMERA_CAPTURE_JPEG:
                case MSDK_SCENARIO_ID_CAMERA_ZSD: 
                    *pFeatureReturnPara32 = OV5693MIPI_CAPTURE_CLK;
                    *pFeatureParaLen=4;
                    break;
                case MSDK_SCENARIO_ID_VIDEO_PREVIEW:
                    *pFeatureReturnPara32 = OV5693MIPI_VIDEO_CLK;
                    *pFeatureParaLen=4;
                    break;                  
                default:
                    *pFeatureReturnPara32 = OV5693MIPI_PREVIEW_CLK;
                    *pFeatureParaLen=4;
                    break;
            }
            break;
        case SENSOR_FEATURE_SET_ESHUTTER:
            set_OV5693MIPI_shutter(*pFeatureData16);
            break;
        case SENSOR_FEATURE_SET_NIGHTMODE:
            OV5693MIPI_night_mode((BOOL) *pFeatureData16);
            break;
        case SENSOR_FEATURE_SET_GAIN:       
            OV5693MIPI_SetGain((UINT16) *pFeatureData16);
            break;
        case SENSOR_FEATURE_SET_FLASHLIGHT:
            break;
        case SENSOR_FEATURE_SET_ISP_MASTER_CLOCK_FREQ:
            break;
        case SENSOR_FEATURE_SET_REGISTER:
            OV5693MIPI_write_cmos_sensor(pSensorRegData->RegAddr, pSensorRegData->RegData);
            break;
        case SENSOR_FEATURE_GET_REGISTER:
            pSensorRegData->RegData = OV5693MIPI_read_cmos_sensor(pSensorRegData->RegAddr);
            break;
        case SENSOR_FEATURE_SET_CCT_REGISTER:
            memcpy(&OV5693MIPI_sensor.eng.cct, pFeaturePara, sizeof(OV5693MIPI_sensor.eng.cct));
            break;
            break;
        case SENSOR_FEATURE_GET_CCT_REGISTER:
            if (*pFeatureParaLen >= sizeof(OV5693MIPI_sensor.eng.cct) + sizeof(kal_uint32))
            {
              *((kal_uint32 *)pFeaturePara++) = sizeof(OV5693MIPI_sensor.eng.cct);
              memcpy(pFeaturePara, &OV5693MIPI_sensor.eng.cct, sizeof(OV5693MIPI_sensor.eng.cct));
            }
            break;
        case SENSOR_FEATURE_SET_ENG_REGISTER:
            memcpy(&OV5693MIPI_sensor.eng.reg, pFeaturePara, sizeof(OV5693MIPI_sensor.eng.reg));
            break;
        case SENSOR_FEATURE_GET_ENG_REGISTER:
            if (*pFeatureParaLen >= sizeof(OV5693MIPI_sensor.eng.reg) + sizeof(kal_uint32))
            {
              *((kal_uint32 *)pFeaturePara++) = sizeof(OV5693MIPI_sensor.eng.reg);
              memcpy(pFeaturePara, &OV5693MIPI_sensor.eng.reg, sizeof(OV5693MIPI_sensor.eng.reg));
            }
        case SENSOR_FEATURE_GET_REGISTER_DEFAULT:
            ((PNVRAM_SENSOR_DATA_STRUCT)pFeaturePara)->Version = NVRAM_CAMERA_SENSOR_FILE_VERSION;
            ((PNVRAM_SENSOR_DATA_STRUCT)pFeaturePara)->SensorId = OV5693_SENSOR_ID;
            memcpy(((PNVRAM_SENSOR_DATA_STRUCT)pFeaturePara)->SensorEngReg, &OV5693MIPI_sensor.eng.reg, sizeof(OV5693MIPI_sensor.eng.reg));
            memcpy(((PNVRAM_SENSOR_DATA_STRUCT)pFeaturePara)->SensorCCTReg, &OV5693MIPI_sensor.eng.cct, sizeof(OV5693MIPI_sensor.eng.cct));
            *pFeatureParaLen = sizeof(NVRAM_SENSOR_DATA_STRUCT);
            break;
        case SENSOR_FEATURE_GET_CONFIG_PARA:
            memcpy(pFeaturePara, &OV5693MIPI_sensor.cfg_data, sizeof(OV5693MIPI_sensor.cfg_data));
            *pFeatureParaLen = sizeof(OV5693MIPI_sensor.cfg_data);
            break;
        case SENSOR_FEATURE_CAMERA_PARA_TO_SENSOR:
             OV5693MIPI_camera_para_to_sensor();
            break;
        case SENSOR_FEATURE_SENSOR_TO_CAMERA_PARA:
            OV5693MIPI_sensor_to_camera_para();
            break;                          
        case SENSOR_FEATURE_GET_GROUP_COUNT:
            OV5693MIPI_get_sensor_group_count((kal_uint32 *)pFeaturePara);
            *pFeatureParaLen = 4;
            break;    
        case SENSOR_FEATURE_GET_GROUP_INFO:
            OV5693MIPI_get_sensor_group_info((MSDK_SENSOR_GROUP_INFO_STRUCT *)pFeaturePara);
            *pFeatureParaLen = sizeof(MSDK_SENSOR_GROUP_INFO_STRUCT);
            break;
        case SENSOR_FEATURE_GET_ITEM_INFO:
            OV5693MIPI_get_sensor_item_info((MSDK_SENSOR_ITEM_INFO_STRUCT *)pFeaturePara);
            *pFeatureParaLen = sizeof(MSDK_SENSOR_ITEM_INFO_STRUCT);
            break;
        case SENSOR_FEATURE_SET_ITEM_INFO:
            OV5693MIPI_set_sensor_item_info((MSDK_SENSOR_ITEM_INFO_STRUCT *)pFeaturePara);
            *pFeatureParaLen = sizeof(MSDK_SENSOR_ITEM_INFO_STRUCT);
            break;
        case SENSOR_FEATURE_GET_ENG_INFO:
            memcpy(pFeaturePara, &OV5693MIPI_sensor.eng_info, sizeof(OV5693MIPI_sensor.eng_info));
            *pFeatureParaLen = sizeof(OV5693MIPI_sensor.eng_info);
            break;
        case SENSOR_FEATURE_GET_LENS_DRIVER_ID:
            // get the lens driver ID from EEPROM or just return LENS_DRIVER_ID_DO_NOT_CARE
            // if EEPROM does not exist in camera module.
            *pFeatureReturnPara32=LENS_DRIVER_ID_DO_NOT_CARE;
            *pFeatureParaLen=4;
            break;
        case SENSOR_FEATURE_SET_VIDEO_MODE:
            OV5693MIPISetVideoMode(*pFeatureData16);
            break; 
        case SENSOR_FEATURE_CHECK_SENSOR_ID:
            OV5693GetSensorID(pFeatureReturnPara32); 
            break; 
        case SENSOR_FEATURE_SET_AUTO_FLICKER_MODE:
            OV5693MIPISetAutoFlickerMode((BOOL)*pFeatureData16,*(pFeatureData16+1));
            break;
		case SENSOR_FEATURE_SET_MAX_FRAME_RATE_BY_SCENARIO:
			OV5693MIPISetMaxFramerateByScenario((MSDK_SCENARIO_ID_ENUM)*pFeatureData32, *(pFeatureData32+1));
			break;
		case SENSOR_FEATURE_GET_DEFAULT_FRAME_RATE_BY_SCENARIO:
			OV5693MIPIGetDefaultFramerateByScenario((MSDK_SCENARIO_ID_ENUM)*pFeatureData32, (MUINT32 *)(*(pFeatureData32+1)));
			break;
        default:
            break;
    }
  
    return ERROR_NONE;
}   /*  OV5693MIPIFeatureControl()  */
SENSOR_FUNCTION_STRUCT  SensorFuncOV5693MIPI=
{
    OV5693MIPIOpen,
    OV5693MIPIGetInfo,
    OV5693MIPIGetResolution,
    OV5693MIPIFeatureControl,
    OV5693MIPIControl,
    OV5693MIPIClose
};

UINT32 OV5693_MIPI_RAW_SensorInit(PSENSOR_FUNCTION_STRUCT *pfFunc)
{
    /* To Do : Check Sensor status here */
    if (pfFunc!=NULL)
        *pfFunc=&SensorFuncOV5693MIPI;

    return ERROR_NONE;
}   /*  OV5693MIPISensorInit  */
