#ifndef BUILD_LK
#include <linux/string.h>
#endif
#include "lcm_drv.h"

#ifdef BUILD_LK
    #include <string.h>
    #include <platform/mt_pmic.h>
	#include <platform/mt_gpio.h>
    #include <platform/upmu_common.h>
#elif defined(BUILD_UBOOT)
	#include <asm/arch/mt_gpio.h>
    #include <platform/upmu_common.h>
#else
	#include <mach/mt_gpio.h>
	#include <mach/upmu_common.h>
    #include <mach/mt_pm_ldo.h>
#endif

#ifdef BUILD_LK
#define LCM_PRINT printf
#else
#if defined(BUILD_UBOOT)
#define LCM_PRINT printf
#else
#define LCM_PRINT printk
#endif
#endif

#define LCM_DBG(fmt, arg...) \
	LCM_PRINT ("[LCM-NT35517-QHD-DSI-VDO] %s (line:%d) :" fmt "\r\n", __func__, __LINE__, ## arg)

// ---------------------------------------------------------------------------
//  Local Constants
// ---------------------------------------------------------------------------

#define FRAME_WIDTH  										(540)
#define FRAME_HEIGHT 										(960)
#define  LCM_ID_NT35517 0x5517

#define GPIO_LCM_RST      GPIO83


#define REGFLAG_DELAY             							0XFE
#define REGFLAG_END_OF_TABLE      							0xFF   // END OF REGISTERS MARKER

#define LCM_DSI_CMD_MODE									0

//static unsigned int lcm_esd_test = FALSE;      ///only for ESD test

// ---------------------------------------------------------------------------
//  Local Variables
// ---------------------------------------------------------------------------

static LCM_UTIL_FUNCS lcm_util = {0};

#define SET_RESET_PIN(v)    (lcm_util.set_reset_pin((v)))

#define UDELAY(n) (lcm_util.udelay(n))
#define MDELAY(n) (lcm_util.mdelay(n))


// ---------------------------------------------------------------------------
//  Local Functions
// ---------------------------------------------------------------------------

#define dsi_set_cmdq_V3(para_tbl,size,force_update)        lcm_util.dsi_set_cmdq_V3(para_tbl,size,force_update)
#define dsi_set_cmdq_V2(cmd, count, ppara, force_update)	        lcm_util.dsi_set_cmdq_V2(cmd, count, ppara, force_update)
#define dsi_set_cmdq(pdata, queue_size, force_update)		lcm_util.dsi_set_cmdq(pdata, queue_size, force_update)
#define wrtie_cmd(cmd)										lcm_util.dsi_write_cmd(cmd)
#define write_regs(addr, pdata, byte_nums)					lcm_util.dsi_write_regs(addr, pdata, byte_nums)
#define read_reg(cmd)											lcm_util.dsi_dcs_read_lcm_reg(cmd)
#define read_reg_v2(cmd, buffer, buffer_size)   				lcm_util.dsi_dcs_read_lcm_reg_v2(cmd, buffer, buffer_size)

#ifndef BUILD_LK
static bool fgisFirst = TRUE;
#endif


static LCM_setting_table_V3 lcm_initialization_setting[] = {
	
	/*
	Note :

	Data ID will depends on the following rule.
	
		count of parameters > 1	=> Data ID = 0x39
		count of parameters = 1	=> Data ID = 0x15
		count of parameters = 0	=> Data ID = 0x05

	Structure Format :

	{DCS command, count of parameters, {parameter list}}
	{REGFLAG_DELAY, milliseconds of time, {}},

	...

	Setting ending by predefined flag
	
	{REGFLAG_END_OF_TABLE, 0x00, {}}
	*/
/*
#if 1
	{0x39, 0xFF, 4, {0xAA, 0x55, 0x25,0x01}},
	
	{0x39, 0xF2, 35, {0x00, 0x00, 0x4A, 0x0A, 0xA8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x01, 0x51, 0x00, 0x01, 0x00, 0x01}},
	
	{0x39, 0xF3, 7, {0x02, 0x03, 0x07, 0x45, 0x88, 0xD1, 0x0D}},
	
	//########################################
	//#page 0
	{0x39, 0xF0, 5, {0x55, 0xAA, 0x52, 0x08, 0x00}},
	
	{0x15, 0xB6, 1, {0x05}},
	
	{0x39, 0xB7, 2, {0x72, 0x72}},
	
	{0x39, 0xB8, 4, {0x01, 0x06, 0x05, 0x04}},
	
	{0x15, 0xBB, 1, {0x33}},
	
	{0x15, 0xBC, 1, {0x02}},
	
	{0x39, 0xBD, 5, {0x01, 0x4E, 0x10, 0x20, 0x01}},
	
	{0x39, 0xC9, 6, {0x61, 0x06, 0x0D, 0x17, 0x17, 0x00}},

	{0x15, 0xB1, 1, {0xCC}},
	
	{0x15, 0x3A, 1, {0x77}},
	
	{0x15, 0x36, 1, {0x00}},
	
	//General Purpose Output Pins Control
	//{0x15, 0x35, 1, {0x00}},
	//#####################################333
	//#page1
	{0x39, 0xF0, 5, {0x55, 0xAA, 0x52, 0x08, 0x01}},
	
	//AVDD:5.5V
	{0x39, 0xB0, 3, {0x0C,0x0C,0x0C}},
	
	//AVDD:3.0x
	{0x39, 0xB6, 3, {0x44,0x44,0x44}},
	
	//AVEE:-5.5V
	{0x39, 0xB1, 3, {0x0C,0x0C,0x0C}},
	
	//AVEE:-2.0x
	{0x39, 0xB7, 3, {0x34,0x34,0x34}},
	
	//VCL:-4.0V
	{0x39, 0xB2, 3, {0x02,0x02,0x02}},
	
	//VCL:-2.0x
	{0x39, 0xB8, 3, {0x34,0x34,0x34}},
	
	//VGH:14V
	//{0x39, 0xB3, 3, {0x10,0x10,0x10}},
	
	//VGH:AVDD - AVEE + VDDB
	{0x39, 0xB9, 3, {0x34,0x34,0x34}},
	
	//VGLX:-12.0V
	{0x39, 0xB4, 3, {0x0A,0x0A,0x0A}},
	
	//VGLX:AVEE+VCL-AVDD0
	{0x39, 0xBA, 3, {0x24,0x24,0x24}},
	
	//VGMP 5.0V, VGSP: 0.3V 0x98
	{0x39, 0xBC, 3, {0x00,0x98,0x00}},
	
	//VGMN:-5.0V, VGSN:-0.3V
	{0x39, 0xBD, 3, {0x00,0x98,0x00}},
	
	{0x15, 0xBE, 1, {0x5A}},
	
	{0x15, 0xC2, 1, {0x00}},
	
	{0x39, 0xD0, 4, {0x0F,0x0F,0x10, 0x10}},
	
	//#Gamma Setting
	//R+
	{0x39, 0xD1, 16, {0x00,0x23,0x00,0x24,0x00,0x31,0x00,0x52,0x00,0x72,0x00,0xAE,0x00,0xDE,0x01,0x22}},
	{0x39, 0xD2, 16, {0x01,0x52,0x01,0x92,0x01,0xBE,0x01,0xFD,0x02,0x2A,0x02,0x2B,0x02,0x53,0x02,0x7A}},
	{0x39, 0xD3, 16, {0x02,0x90,0x02,0xA8,0x02,0xB8,0x02,0xCB,0x02,0xD7,0x02,0xE6,0x02,0xF2,0x03,0x00}},
	{0x39, 0xD4, 4,  {0x03,0x1C,0x03,0x52}},
	//G+
	{0x39, 0xD5, 16, {0x00,0x23,0x00,0x24,0x00,0x31,0x00,0x52,0x00,0x72,0x00,0xAE,0x00,0xDE,0x01,0x22}},
	{0x39, 0xD6, 16, {0x01,0x52,0x01,0x92,0x01,0xBE,0x01,0xFD,0x02,0x2A,0x02,0x2B,0x02,0x53,0x02,0x7A}},
	{0x39, 0xD7, 16, {0x02,0x90,0x02,0xA8,0x02,0xB8,0x02,0xCB,0x02,0xD7,0x02,0xE6,0x02,0xF2,0x03,0x00}},
	{0x39, 0xD8, 4,  {0x03,0x1C,0x03,0x52}},
	//B+
	{0x39, 0xD9, 16, {0x00,0x23,0x00,0x24,0x00,0x31,0x00,0x52,0x00,0x72,0x00,0xAE,0x00,0xDE,0x01,0x22}},
	{0x39, 0xDD, 16, {0x01,0x52,0x01,0x92,0x01,0xBE,0x01,0xFD,0x02,0x2A,0x02,0x2B,0x02,0x53,0x02,0x7A}},
	{0x39, 0xDE, 16, {0x02,0x90,0x02,0xA8,0x02,0xB8,0x02,0xCB,0x02,0xD7,0x02,0xE6,0x02,0xF2,0x03,0x00}},
	{0x39, 0xDF, 4,  {0x03,0x1C,0x03,0x52}},
	//R- 
	{0x39, 0xE0, 16, {0x00,0x23,0x00,0x24,0x00,0x31,0x00,0x52,0x00,0x72,0x00,0xAE,0x00,0xDE,0x01,0x22}},
	{0x39, 0xE1, 16, {0x01,0x52,0x01,0x92,0x01,0xBE,0x01,0xFD,0x02,0x2A,0x02,0x2B,0x02,0x53,0x02,0x7A}},
	{0x39, 0xE2, 16, {0x02,0x90,0x02,0xA8,0x02,0xB8,0x02,0xCB,0x02,0xD7,0x02,0xE6,0x02,0xF2,0x03,0x00}},
	{0x39, 0xE3, 4,  {0x03,0x1C,0x03,0x52}},
	//G-
	{0x39, 0xE4, 16, {0x00,0x23,0x00,0x24,0x00,0x31,0x00,0x52,0x00,0x72,0x00,0xAE,0x00,0xDE,0x01,0x22}},
	{0x39, 0xE5, 16, {0x01,0x52,0x01,0x92,0x01,0xBE,0x01,0xFD,0x02,0x2A,0x02,0x2B,0x02,0x53,0x02,0x7A}},
	{0x39, 0xE6, 16, {0x02,0x90,0x02,0xA8,0x02,0xB8,0x02,0xCB,0x02,0xD7,0x02,0xE6,0x02,0xF2,0x03,0x00}},
	{0x39, 0xE7, 4,  {0x03,0x1C,0x03,0x52}},
	//B-
	{0x39, 0xE8, 16, {0x00,0x23,0x00,0x24,0x00,0x31,0x00,0x52,0x00,0x72,0x00,0xAE,0x00,0xDE,0x01,0x22}},
	{0x39, 0xE9, 16, {0x01,0x52,0x01,0x92,0x01,0xBE,0x01,0xFD,0x02,0x2A,0x02,0x2B,0x02,0x53,0x02,0x7A}},
	{0x39, 0xEA, 16, {0x02,0x90,0x02,0xA8,0x02,0xB8,0x02,0xCB,0x02,0xD7,0x02,0xE6,0x02,0xF2,0x03,0x00}},
	{0x39, 0xEB, 4,  {0x03,0x1C,0x03,0x52}},
	
	//{0x39, 0xF0, 5,  {0x55,0xAA,0x52,0x08,0x00}},
	//{0x15, 0xB3, 1,  {0x00}},
	//{0x39, 0xB1, 3,  {0xFC,0x00,0x01}},
	//{0x39, 0xB8, 4,  {0x01,0x02,0x02,0x02}},
	//{0x39, 0xBC, 3,  {0x00,0x00,0x005}},
	//{0x39, 0xC9, 6,  {0x63,0x06,0x0D,0x17,0x17,0x00}},
	//{0x15, 0x3A, 1,  {0x77}},
	           
	//{0x15, 0x36, 1,  {0x00}},
	//{0x15, 0x35, 1,  {0x00}},
	
	{0x05,0x11,0,{}},		
	{REGFLAG_ESCAPE_ID,REGFLAG_DELAY_MS_V3, 120, {}},
	{0x05,0x29,0,{}},
	{REGFLAG_ESCAPE_ID,REGFLAG_DELAY_MS_V3, 10, {}},
#else
	{0x39, 0xF0, 5, {0x55, 0xAA, 0x52,0x08,0x01}},
	
	//AVDD
	{0x39, 0xB0, 3, {0x0A, 0x0A, 0x0A}},
	
	//#AVEE 
	{0x39, 0xB1, 3, {0x0A, 0x0A, 0x0A}},
	
	//#VCL 
	{0x39, 0xB2, 3, {0x02, 0x02, 0x02}},
	
	//#VGH
	{0x39, 0xB3, 3, {0x0E, 0x0E, 0x0E}},
	
	//#VGL
	{0x39, 0xB4, 3, {0x08, 0x08, 0x08}},
	
	//Pump Power Control for AVDD/AVEE/VCL/VGH/VGL
	{0x39, 0xB6, 3, {0x44, 0x44, 0x44}},
	{0x39, 0xB7, 3, {0x34, 0x34, 0x34}},
	{0x39, 0xB8, 3, {0x33, 0x33, 0x33}},
	{0x39, 0xB9, 3, {0x34, 0x34, 0x34}},
	{0x39, 0xBA, 3, {0x14, 0x14, 0x14}},
	
	//Setting VGMP and VGSP Voltage
	
	{0x39, 0xBC, 3, {0x00, 0x88, 0x00}},
	
	//Setting VGMN and VGSN Voltage
	{0x39, 0xBD, 3, {0x00, 0x88, 0x00}},
	
	//Setting VCOM Offset Voltage
	{0x15, 0xBE, 1, {0x63}},
	
	//General Purpose Output Pins Control
	{0x39, 0xC0, 2, {0x04, 0x00}},
	{0x15, 0xCA, 1, {0x00}},
	{0x39, 0xD0, 4, {0x0a,0x10,0x0d,0x0f}},
	
	//#Gamma Setting
	//R+
	{0x39, 0xD1, 16, {0x00,0x00,0x00,0x42,0x00,0x69,0x00,0x84,0x00,0x8F,0x00,0xBB,0x00,0xD7,0x01,0x03}},
	{0x39, 0xD2, 16, {0x01,0x27,0x01,0x5E,0x01,0x87,0x01,0xCC,0x02,0x04,0x02,0x06,0x02,0x37,0x02,0x74}},
	{0x39, 0xD3, 16, {0x02,0x97,0x02,0xC5,0x02,0xE4,0x03,0x0D,0x03,0x25,0x03,0x40,0x03,0x4B,0x03,0x55}},
	{0x39, 0xD4, 4,  {0x03,0x5B,0x03,0x5D}},
	//G+
	{0x39, 0xD5, 16, {0x00,0x00,0x00,0x42,0x00,0x69,0x00,0x84,0x00,0x8F,0x00,0xBB,0x00,0xD7,0x01,0x03}},
	{0x39, 0xD6, 16, {0x01,0x27,0x01,0x5E,0x01,0x87,0x01,0xCC,0x02,0x04,0x02,0x06,0x02,0x37,0x02,0x74}},
	{0x39, 0xD7, 16, {0x02,0x97,0x02,0xC5,0x02,0xE4,0x03,0x0D,0x03,0x25,0x03,0x40,0x03,0x4B,0x03,0x55}},
	{0x39, 0xD8, 4,  {0x03,0x5B,0x03,0x5D}},
	//B+
	{0x39, 0xD9, 16, {0x00,0x00,0x00,0x42,0x00,0x69,0x00,0x84,0x00,0x8F,0x00,0xBB,0x00,0xD7,0x01,0x03}},
	{0x39, 0xDD, 16, {0x01,0x27,0x01,0x5E,0x01,0x87,0x01,0xCC,0x02,0x04,0x02,0x06,0x02,0x37,0x02,0x74}},
	{0x39, 0xDE, 16, {0x02,0x97,0x02,0xC5,0x02,0xE4,0x03,0x0D,0x03,0x25,0x03,0x40,0x03,0x4B,0x03,0x55}},
	{0x39, 0xDF, 4,  {0x03,0x5B,0x03,0x5D}},
	//R- 
	{0x39, 0xE0, 16, {0x00,0x00,0x00,0x42,0x00,0x69,0x00,0x84,0x00,0x8F,0x00,0xBB,0x00,0xD7,0x01,0x03}},
	{0x39, 0xE1, 16, {0x01,0x27,0x01,0x5E,0x01,0x87,0x01,0xCC,0x02,0x04,0x02,0x06,0x02,0x37,0x02,0x74}},
	{0x39, 0xE2, 16, {0x02,0x97,0x02,0xC5,0x02,0xE4,0x03,0x0D,0x03,0x25,0x03,0x40,0x03,0x4B,0x03,0x55}},
	{0x39, 0xE3, 4,  {0x03,0x5B,0x03,0x5D}},
	//G-
	{0x39, 0xE4, 16, {0x00,0x00,0x00,0x42,0x00,0x69,0x00,0x84,0x00,0x8F,0x00,0xBB,0x00,0xD7,0x01,0x03}},
	{0x39, 0xE5, 16, {0x01,0x27,0x01,0x5E,0x01,0x87,0x01,0xCC,0x02,0x04,0x02,0x06,0x02,0x37,0x02,0x74}},
	{0x39, 0xE6, 16, {0x02,0x97,0x02,0xC5,0x02,0xE4,0x03,0x0D,0x03,0x25,0x03,0x40,0x03,0x4B,0x03,0x55}},
	{0x39, 0xE7, 4,  {0x03,0x5B,0x03,0x5D}},
	//B-
	{0x39, 0xE8, 16, {0x00,0x00,0x00,0x42,0x00,0x69,0x00,0x84,0x00,0x8F,0x00,0xBB,0x00,0xD7,0x01,0x03}},
	{0x39, 0xE9, 16, {0x01,0x27,0x01,0x5E,0x01,0x87,0x01,0xCC,0x02,0x04,0x02,0x06,0x02,0x37,0x02,0x74}},
	{0x39, 0xEA, 16, {0x02,0x97,0x02,0xC5,0x02,0xE4,0x03,0x0D,0x03,0x25,0x03,0x40,0x03,0x4B,0x03,0x55}},
	{0x39, 0xEB, 4,  {0x03,0x5B,0x03,0x5D}},
	
	{0x39, 0xF0, 5,  {0x55,0xAA,0x52,0x08,0x00}},
	{0x15, 0xB3, 1,  {0x00}},
	{0x39, 0xB1, 3,  {0xFC,0x00,0x01}},
	{0x39, 0xB8, 4,  {0x01,0x02,0x02,0x02}},
	{0x39, 0xBC, 3,  {0x00,0x00,0x005}},
	{0x39, 0xC9, 6,  {0x63,0x06,0x0D,0x17,0x17,0x00}},
	{0x15, 0x3A, 1,  {0x77}},
	           
	{0x15, 0x36, 1,  {0x00}},
	{0x15, 0x35, 1,  {0x00}},
	
	{0x05,0x11,0,{}},		
	{REGFLAG_ESCAPE_ID,REGFLAG_DELAY_MS_V3, 120, {}},
	{0x05,0x29,0,{}},
	{REGFLAG_ESCAPE_ID,REGFLAG_DELAY_MS_V3, 10, {}},
#endif

*/

       {0x39, 0xF0, 5, {0x55, 0xAA, 0x52,0x08,0x00}},

	{0x15, 0xB3, 1, {0x80}},

	{0x39, 0xB1, 3, {0xFC, 0x00, 0x00}},

	{0x15, 0xB6, 1, {0x05}},

	{0x39, 0xB7, 2, {0x74, 0x74}},

	{0x39, 0xB8, 4, {0x01, 0x06, 0x06,0x06}},

	{0x15, 0xBA, 1, {0x06}},

	{0x15, 0xBB, 1, {0x33}},

	{0x15, 0xBC, 1, {0x00}},
	
	{0x39, 0xC9, 6, {0x61,0x06,0x0D,0x17,0x17,0x00}},

	{0x39, 0xF0, 5, {0x55,0xAA,0x52,0x08,0x01}},

	{0x15, 0xB0, 1, {0x0A}},

	{0x15, 0xB6, 1, {0x34}},

	{0x15, 0xB1, 1, {0x0A}},

	{0x15, 0xB7, 1, {0x24}},
	
	{0x15, 0xB2, 1, {0x02}},

	{0x15, 0xB8, 1, {0x36}},

	{0x15, 0xB3, 1, {0x10}},

	{0x15, 0xB9, 1, {0x34}},

	{0x15, 0xB4, 1, {0x06}},

	{0x15, 0xBA, 1, {0x24}},

	{0x39, 0xBC, 3, {0x00,0x60,0x00}},

	{0x39, 0xBD, 3, {0x00,0x60,0x00}},

	//{0x15, 0xC1, 1, {0x01}},

	{0x15, 0xBE, 1, {0x2D}},

	//{0x15, 0xBF, 1, {0x3B}},

	{0x39, 0xD1, 16, {0x00,0x00,0x00,0x01,0x00,0x03,0x00,0x09,0x00,0x12,0x00,0x2F,0x00,0x59,0x00,0x9F}},

	{0x39, 0xD2, 16, {0x00,0xD6,0x01,0x25,0x01,0x5D,0x01,0xAB,0x01,0xE1,0x01,0xE2,0x02,0x15,0x02,0x46}},

	{0x39, 0xD3, 16, {0x02,0x61,0x02,0x7D,0x02,0x92,0x02,0xAB,0x02,0xB9,0x02,0xD3,0x02,0xE4,0x02,0xFF}},

	{0x39, 0xD4, 4, {0x03,0x44,0x03,0xFF}},

	{0x39, 0xD5, 16, {0x00,0x00,0x00,0x01,0x00,0x03,0x00,0x09,0x00,0x12,0x00,0x2F,0x00,0x59,0x00,0x9F}},

	{0x39, 0xD6, 16, {0x00,0xD6,0x01,0x25,0x01,0x5D,0x01,0xAB,0x01,0xE1,0x01,0xE2,0x02,0x15,0x02,0x46}},

	{0x39, 0xD7, 16, {0x02,0x61,0x02,0x7D,0x02,0x92,0x02,0xAB,0x02,0xB9,0x02,0xD3,0x02,0xE4,0x02,0xFF}},

	{0x39, 0xD8, 4, {0x03,0x44,0x03,0xFF}},

	{0x39, 0xD9, 16, {0x00,0x00,0x00,0x01,0x00,0x03,0x00,0x09,0x00,0x12,0x00,0x2F,0x00,0x59,0x00,0x9F}},

	{0x39, 0xDD, 16, {0x00,0xD6,0x01,0x25,0x01,0x5D,0x01,0xAB,0x01,0xE1,0x01,0xE2,0x02,0x15,0x02,0x46}},

	{0x39, 0xDE, 16, {0x02,0x61,0x02,0x7D,0x02,0x92,0x02,0xAB,0x02,0xB9,0x02,0xD3,0x02,0xE4,0x02,0xFF}},

	{0x39, 0xDF, 4, {0x03,0x44,0x03,0xFF}},	

	{0x39, 0xE0, 16, {0x00,0x00,0x00,0x01,0x00,0x03,0x00,0x09,0x00,0x12,0x00,0x2F,0x00,0x59,0x00,0x9F}},

	{0x39, 0xE1, 16, {0x00,0xD6,0x01,0x25,0x01,0x5D,0x01,0xAB,0x01,0xE1,0x01,0xE2,0x02,0x15,0x02,0x46}},

	{0x39, 0xE2, 16, {0x02,0x61,0x02,0x7D,0x02,0x92,0x02,0xAB,0x02,0xB9,0x02,0xD3,0x02,0xE4,0x02,0xFF}},

	{0x39, 0xE3, 4, {0x03,0x44,0x03,0xFF}},

	{0x39, 0xE4, 16, {0x00,0x00,0x00,0x01,0x00,0x03,0x00,0x09,0x00,0x12,0x00,0x2F,0x00,0x59,0x00,0x9F}},

	{0x39, 0xE5, 16, {0x00,0xD6,0x01,0x25,0x01,0x5D,0x01,0xAB,0x01,0xE1,0x01,0xE2,0x02,0x15,0x02,0x46}},

	{0x39, 0xE6, 16, {0x02,0x61,0x02,0x7D,0x02,0x92,0x02,0xAB,0x02,0xB9,0x02,0xD3,0x02,0xE4,0x02,0xFF}},

	{0x39, 0xE7, 4, {0x03,0x44,0x03,0xFF}},

	{0x39, 0xE8, 16, {0x00,0x00,0x00,0x01,0x00,0x03,0x00,0x09,0x00,0x12,0x00,0x2F,0x00,0x59,0x00,0x9F}},

	{0x39, 0xE9, 16, {0x00,0xD6,0x01,0x25,0x01,0x5D,0x01,0xAB,0x01,0xE1,0x01,0xE2,0x02,0x15,0x02,0x46}},

	{0x39, 0xEA, 16, {0x02,0x61,0x02,0x7D,0x02,0x92,0x02,0xAB,0x02,0xB9,0x02,0xD3,0x02,0xE4,0x02,0xFF}},

	{0x39, 0xEB, 4, {0x03,0x44,0x03,0xFF}},

	{0x15, 0xC0, 1, {0xC0}},
	
	{0x15, 0xC2, 1, {0x20}},

	{0x15, 0x35, 1, {0x00}},

	{0x39, 0xFF, 4, {0xAA,0x55,0x25,0x01}},

	{0x15, 0x6F, 1, {0x0B}},

	{0x39, 0xF4, 4, {0x12,0x12,0x56,0x13}},
	
	{0x05,0x11,0,{}},		
	{REGFLAG_ESCAPE_ID,REGFLAG_DELAY_MS_V3, 120, {}},
	{0x05,0x29,0,{}},
	{REGFLAG_ESCAPE_ID,REGFLAG_DELAY_MS_V3, 10, {}},

       
};




static void lcd_reset(unsigned char enabled)
{    
	#ifdef BUILD_LK
		printf("%s,  %d LK \n", __func__, enabled);
	#else
		printk("%s,  %d kernel \n", __func__, enabled);
	#endif
    if (enabled)
    {
        mt_set_gpio_mode(GPIO_LCM_RST, GPIO_MODE_00);
	    mt_set_gpio_dir(GPIO_LCM_RST, GPIO_DIR_OUT);
        mt_set_gpio_out(GPIO_LCM_RST, GPIO_OUT_ONE);
    }
    else
    {	
        mt_set_gpio_mode(GPIO_LCM_RST, GPIO_MODE_00);
	    mt_set_gpio_dir(GPIO_LCM_RST, GPIO_DIR_OUT);
        mt_set_gpio_out(GPIO_LCM_RST, GPIO_OUT_ZERO);    	
    }
}

 
static void lcd_power_en(unsigned char enabled)
{
    #ifdef BUILD_LK
		printf("%s,  %d LK \n", __func__, enabled);
	#else
		printk("%s, %d kernel", __func__, enabled);
	#endif

   // dump_stack();
    
    if (enabled)
    {      

        //hwPowerOn(MT65XX_POWER_LDO_VGP6, VOL_3300, "LCM");

    }
    else
    {      

        //hwPowerDown(MT65XX_POWER_LDO_VGP6, "LCM");
        //mt_set_gpio_out(GPIO_LCM_PWR, GPIO_OUT_ZERO);
    }
}

// ---------------------------------------------------------------------------
//  LCM Driver Implementations
// ---------------------------------------------------------------------------

static void lcm_set_util_funcs(const LCM_UTIL_FUNCS *util)
{
	memcpy(&lcm_util, util, sizeof(LCM_UTIL_FUNCS));
}

static void lcm_get_params(LCM_PARAMS *params)
{
		memset(params, 0, sizeof(LCM_PARAMS));
	
		params->type   = LCM_TYPE_DSI;

		params->width  = FRAME_WIDTH;
		params->height = FRAME_HEIGHT;
		
	    // enable tearing-free
	    //params->dbi.te_mode 				= LCM_DBI_TE_MODE_VSYNC_ONLY;
	    //params->dbi.te_edge_polarity		= LCM_POLARITY_RISING;
	
        #if (LCM_DSI_CMD_MODE)
		params->dsi.mode   = CMD_MODE;
        #else
		params->dsi.mode   = SYNC_EVENT_VDO_MODE; //SYNC_PULSE_VDO_MODE;//BURST_VDO_MODE; 
        #endif
	
		// DSI
		/* Command mode setting */
		//1 Three lane or Four lane
		params->dsi.LANE_NUM				= LCM_TWO_LANE;
		//The following defined the fomat for data coming from LCD engine.
		params->dsi.data_format.format      = LCM_DSI_FORMAT_RGB888;

		// Video mode setting		
		params->dsi.PS=LCM_PACKED_PS_24BIT_RGB888;
		
		params->dsi.vertical_sync_active				= 0x05;// 3    2
		params->dsi.vertical_backporch					= 14;// 20   1
		params->dsi.vertical_frontporch					= 12; // 1  12
		params->dsi.vertical_active_line				= FRAME_HEIGHT; 

		params->dsi.horizontal_sync_active				= 0x16;// 50  2
		params->dsi.horizontal_backporch				= 80;//30; //80;
		params->dsi.horizontal_frontporch				= 50;
		params->dsi.horizontal_active_pixel				= FRAME_WIDTH;

	    //params->dsi.LPX=8; 

		// Bit rate calculation
		//1 Every lane speed
		//params->dsi.pll_select=1;
		//params->dsi.PLL_CLOCK  = LCM_DSI_6589_PLL_CLOCK_377;
		//params->dsi.PLL_CLOCK=200;//247;
		params->dsi.PLL_CLOCK=240;
		//params->dsi.ssc_disable = TRUE;
	 	//params->dsi.pll_div1=0;		// div1=0,1,2,3;div1_real=1,2,4,4 ----0: 546Mbps  1:273Mbps
	 //	params->dsi.pll_div2=0;		// div2=0,1,2,3;div1_real=1,2,4,4	
//#if (LCM_DSI_CMD_MODE)
	 //	params->dsi.fbk_div =9;
//#else
	// 	params->dsi.fbk_div =9;    // fref=26MHz, fvco=fref*(fbk_div+1)*2/(div1_real*div2_real)	
//#endif

}

/*static unsigned int lcm_compare_id(void)
{

	unsigned int id=0;
	unsigned char buffer[2];
	unsigned int array[16];  

	//Do reset here
	SET_RESET_PIN(1);
	SET_RESET_PIN(0);
	MDELAY(10);
	
	SET_RESET_PIN(1);
	MDELAY(10);  
	    
	LCM_DBG();
	
	array[0]=0x00063902;
	array[1]=0x52aa55f0;
	array[2]=0x00000108;
	dsi_set_cmdq(array, 3, 1);
	MDELAY(10);

	array[0] = 0x00083700;
	dsi_set_cmdq(array, 1, 1);

	//read_reg_v2(0x04, buffer, 3);//if read 0x04,should get 0x008000,that is both OK.
	read_reg_v2(0xc5, buffer,2);

	id = buffer[0]<<8 |buffer[1];
	     
	LCM_DBG("id = 0x%x \n", id);

    if(id == LCM_ID_NT35517)
    	return 1;
    else
    	return 0;
}*/

static void lcm_init(void)
{

		LCM_DBG();
		#ifdef BUILD_LK
		printf("%s, LK \n", __func__);
	#else
		printk("%s, kernel", __func__);
	#endif
		//lcm_compare_id();
		//SET_RESET_PIN(0);

	#ifdef BUILD_LK
             upmu_set_rg_vgp6_vosel(0x7);
             upmu_set_rg_vgp6_sw_en(0x1);
	#else
		hwPowerOn(MT65XX_POWER_LDO_VGP6, VOL_3300, "LCM");  //lcd_power_en(1);
	#endif
		MDELAY(80);
		lcd_reset(1);
		MDELAY(5);
		lcd_reset(0);
		MDELAY(5); 
		lcd_reset(1);
		MDELAY(50); 
		dsi_set_cmdq_V3(lcm_initialization_setting,sizeof(lcm_initialization_setting)/sizeof(lcm_initialization_setting[0]),1);		
}

static void lcm_suspend(void)
{
	unsigned int data_array[16];

	//data_array[0]=0x00280500; // Display Off
	//dsi_set_cmdq(data_array, 1, 1);
	#ifdef BUILD_LK
		printf("%s, LK \n", __func__);
	#else
		printk("%s, kernel", __func__);
	#endif
	data_array[0] = 0x00110500; // Sleep In
	dsi_set_cmdq(data_array, 1, 1);
	MDELAY(100); 

#ifdef BUILD_LK

	lcd_reset(0);
	MDELAY(10); // 1ms
	//
	//SET_RESET_PIN(1);

	//lcd_reset(1);
	MDELAY(120); 

	
	MDELAY(50);

#else
	//SET_RESET_PIN(1);	
    //
	//SET_RESET_PIN(0);
	//lcd_reset(1);
	lcd_reset(0);
	MDELAY(10); // 1ms
	//
	//SET_RESET_PIN(1);

	//lcd_reset(1);
	MDELAY(120); 

if(fgisFirst == TRUE)
{
     fgisFirst = FALSE;
        hwPowerOn(MT65XX_POWER_LDO_VGP6, VOL_3300, "LCM");
}
	
        hwPowerDown(MT65XX_POWER_LDO_VGP6, "LCM");
	MDELAY(50);
#endif
	
}

static void lcm_resume(void)
{
	LCM_DBG();
	#ifdef BUILD_LK
		printf("%s, LK \n", __func__);
	#else
		printk("%s, kernel", __func__);
	#endif
#ifdef BUILD_LK
    		upmu_set_rg_vgp6_vosel(0x7);
   		upmu_set_rg_vgp6_sw_en(0x1);
		MDELAY(80);
		lcd_reset(1);
		MDELAY(5);
		lcd_reset(0);
		MDELAY(5); 
		lcd_reset(1);
		MDELAY(50); 
		dsi_set_cmdq_V3(lcm_initialization_setting,sizeof(lcm_initialization_setting)/sizeof(lcm_initialization_setting[0]),1);		
    MDELAY(50);


#else
		hwPowerOn(MT65XX_POWER_LDO_VGP6, VOL_3300, "LCM");
		MDELAY(80);
		lcd_reset(1);
		MDELAY(5);
		lcd_reset(0);
		MDELAY(5); 
		lcd_reset(1);
		MDELAY(50); 
		dsi_set_cmdq_V3(lcm_initialization_setting,sizeof(lcm_initialization_setting)/sizeof(lcm_initialization_setting[0]),1);		
    MDELAY(50);
#endif
}

/*static unsigned int lcm_esd_check(void)
{
	#ifndef BUILD_LK

	char  buffer[5];
	int   array[4];
 
	array[0] = 0x00043700;
	dsi_set_cmdq(array, 1, 1);
 
	read_reg_v2(0x0A,buffer, 4);

	if(buffer[0]==0x9C)
	{
		return FALSE;
	}
	else
	{ 
		return TRUE;
	}
	#else
	
	return FALSE;

	#endif
}*/

/*static unsigned int lcm_esd_recover(void)
{
	lcm_init();
	return TRUE;
}*/


LCM_DRIVER nt35517_qhd_dsi_vdo_lcm_drv = 
{
	.name		= "nt35517_qhd_dsi_vdo",
	.set_util_funcs = lcm_set_util_funcs,
	.get_params     = lcm_get_params,
	.init           = lcm_init,
	.suspend        = lcm_suspend,
	.resume         = lcm_resume,
	//.compare_id    = lcm_compare_id,
	//.esd_check = lcm_esd_check,
	//.esd_recover = lcm_esd_recover,
#if (LCM_DSI_CMD_MODE)	
	.update         = lcm_update,
#endif
};
