#include "cust_color.h"


const DISP_PQ_PARAM pqparam_standard =
{
    u4SHPGain:4,
    u4SatGain:0,
    u4HueAdj:{0,0,0,0},
    u4SatAdj:{0,0,0,0}, 
    u4Contrast:0,
    u4Brightness:4
};

const DISP_PQ_PARAM pqparam_vivid =
{
    u4SHPGain:4,
    u4SatGain:0,
    u4HueAdj:{0,0,0,0},
    u4SatAdj:{0,0,0,0}, 
    u4Contrast:0,
    u4Brightness:4
};


const DISP_PQ_PARAM pqparam_camera =
{
    u4SHPGain:0,
    u4SatGain:0,
    u4HueAdj:{9,9,9,9},
    u4SatAdj:{2,2,2,2}, 
    u4Contrast:0,
    u4Brightness:4
};


//For 飽和度 0 / CE off
const DISP_PQ_PARAM pqparam_Sat0 =
{
    u4SHPGain:0,
    u4SatGain:0,
    u4HueAdj:{9,9,9,9},
    u4SatAdj:{2,2,2,2}, 
    u4Contrast:0,
    u4Brightness:4
};

//For 飽和度 1
const DISP_PQ_PARAM pqparam_Sat1 =
{
    u4SHPGain:4,
    u4SatGain:0,
    u4HueAdj:{0,0,0,0},
    u4SatAdj:{3,3,3,3}, 
    u4Contrast:0,
    u4Brightness:4
};

//For 飽和度 2
const DISP_PQ_PARAM pqparam_Sat2 =
{
    u4SHPGain:4,
    u4SatGain:0,
    u4HueAdj:{0,0,0,0},
    u4SatAdj:{4,4,4,4}, 
    u4Contrast:0,
    u4Brightness:4
};

//For 飽和度 3
const DISP_PQ_PARAM pqparam_Sat3 =
{
    u4SHPGain:4,
    u4SatGain:0,
    u4HueAdj:{0,0,0,0},
    u4SatAdj:{5,5,5,5}, 
    u4Contrast:0,
    u4Brightness:4
};

//For 飽和度 4
const DISP_PQ_PARAM pqparam_Sat4 =
{
    u4SHPGain:4,
    u4SatGain:0,
    u4HueAdj:{0,0,0,0},
    u4SatAdj:{6,6,6,6}, 
    u4Contrast:0,
    u4Brightness:4
};

//For 飽和度 5
const DISP_PQ_PARAM pqparam_Sat5 =
{
    u4SHPGain:4,
    u4SatGain:0,
    u4HueAdj:{0,0,0,0},
    u4SatAdj:{7,7,7,7}, 
    u4Contrast:0,
    u4Brightness:4
};

//For 飽和度 6
const DISP_PQ_PARAM pqparam_Sat6=
{
    u4SHPGain:4,
    u4SatGain:0,
    u4HueAdj:{0,0,0,0},
    u4SatAdj:{8,8,8,8}, 
    u4Contrast:0,
    u4Brightness:4
};

//For 飽和度 7
const DISP_PQ_PARAM pqparam_Sat7=
{
    u4SHPGain:4,
    u4SatGain:0,
    u4HueAdj:{0,0,0,0},
    u4SatAdj:{9,9,9,9}, 
    u4Contrast:0,
    u4Brightness:4
};

//For 飽和度 8
const DISP_PQ_PARAM pqparam_Sat8 =
{
    u4SHPGain:4,
    u4SatGain:0,
    u4HueAdj:{0,0,0,0},
    u4SatAdj:{10,10,10,10}, 
    u4Contrast:0,
    u4Brightness:4
};

//For 飽和度 9 (最強)
const DISP_PQ_PARAM pqparam_Sat9 =
{
    u4SHPGain:4,
    u4SatGain:0,
    u4HueAdj:{0,0,0,0},
    u4SatAdj:{11,11,11,11}, 
    u4Contrast:0,
    u4Brightness:4
};


const DISPLAY_PQ_T pqindex =
{
GLOBAL_SAT   :
{0x80,0x84,0x88,0x8C,0x90,0x92,0x94,0x96,0x98,0xA0}, //0~9

CONTRAST   :
{0x80,0x84,0x88,0x8C,0x90,0x92,0x94,0x96,0x98,0xA0}, //0~9

BRIGHTNESS   :
{0x3C0,0x3D0,0x3E0,0x3F0,0x400,0x410,0x420,0x430,0x440,0x450}, //0~9

PARTIAL_Y    :
{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},

PURP_TONE_S  :
{//hue 0~10
    {//0  default
        {0x80, 0x80, 0x80},
        {0xb7, 0xb2, 0xb0},
        {0x63, 0x6e, 0x77},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {//1  
        {0xb8, 0xae, 0xa7},
        {0xc1, 0xb2, 0xa7},
        {0x80, 0x80, 0x80},
        {0x1e, 0x1e, 0x1e},
        {0x3c, 0x3c, 0x3c}
    },


    {//2 CE off for sat0
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {//3 for sat1
        {0x80, 0x80, 0x80},
        {0x85, 0x85, 0x85},
        {0x7e, 0x7e, 0x7e},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {//4 for sat2
        {0x80, 0x80, 0x80},
        {0x8C, 0x8C, 0x8C},
        {0x7b, 0x7b, 0x7b},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 5 for sat3
        {0x80, 0x80, 0x80},
        {0x93, 0x93, 0x93},
        {0x78, 0x78, 0x78},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 6 for sat4
        {0x80, 0x80, 0x80},
        {0x9A, 0x9A, 0x9A},
        {0x75, 0x75, 0x75},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },
    // 7 for sat5
    {
        {0x80, 0x80, 0x80},
        {0xA1, 0xA1, 0xA1},
        {0x72, 0x72, 0x72},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 8 for sat6
        {0x80, 0x80, 0x80},
        {0xA8, 0xA8, 0xA8},
        {0x6f, 0x6f, 0x6f},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 9 for sat7
        {0x80, 0x80, 0x80},
        {0xAF, 0xAF, 0xAF},
        {0x6c, 0x6c, 0x6c},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 10 for sat8
        {0x80, 0x80, 0x80},
        {0xb6, 0xb6, 0xb6},
        {0x69, 0x69, 0x69},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 11 for sat9
        {0x80, 0x80, 0x80},
        {0xbd, 0xbd, 0xbd},
        {0x66, 0x66, 0x66},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 12
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    },

    {// 13
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    },

    {// 14
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    },

    {// 15
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    },

    {// 16
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    },
    
    {// 17
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    },
    
    {// 18
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    }
    
},
SKIN_TONE_S:
{


    {//0  default
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xa7, 0x9f, 0x91, 0x8b, 0x86, 0x88, 0x8d, 0x96},
        {0x77, 0x72, 0x75, 0x79, 0x7d, 0x7b, 0x77, 0x74},
		    {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//1
        {0xa5, 0x98, 0x97, 0x9a, 0x95, 0x93, 0x9c, 0xa3},
        {0xa2, 0x97, 0x97, 0x97, 0x88, 0x88, 0x88, 0x8b},
        {0x7f, 0x75, 0x73, 0x7a, 0x78, 0x6e, 0x72, 0x72},
        {0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//2  CE off for sat0
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//3  for sat1
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85},
        {0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },
    {//4 for sat2
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x8C, 0x8C, 0x8C, 0x8a, 0x86, 0x8a, 0x8C, 0x8C},
        {0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//5 for sat3
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x93, 0x93, 0x90, 0x8c, 0x88, 0x8c, 0x90, 0x93},
        {0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//6 for sat4
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x9A, 0x9A, 0x94, 0x8e, 0x8A, 0x8e, 0x94, 0x9A},
        {0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//7 for sat5
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xA1, 0xA1, 0x98, 0x90, 0x8c, 0x90, 0x98, 0xA1},
        {0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//8 for sat6
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xA8, 0xA8, 0x9c, 0x92, 0x8e, 0x92, 0x9c, 0xA8},
        {0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x6f},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//9 for sat7
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xAF, 0xAF, 0xa0, 0x94, 0x90, 0x94, 0xa0, 0xAF},
        {0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//10 for sat8
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xb6, 0xb6, 0xa4, 0x96, 0x92, 0x96, 0xa4, 0xb6},
        {0x69, 0x69, 0x69, 0x69, 0x69, 0x69, 0x69, 0x69},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//11 for sat9
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xbd, 0xbd, 0xa8, 0x98, 0x94, 0x98, 0xa8, 0xbd},
        {0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//12
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xa0, 0xab, 0xb1, 0xb1, 0xb1, 0xb1, 0xa7, 0x80},
        {0x67, 0x60, 0x5e, 0x5e, 0x5e, 0x5e, 0x5e, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//13
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xa0, 0xb0, 0xb5, 0xb5, 0xb5, 0xb5, 0xa7, 0x80},
        {0x66, 0x5f, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//14
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xa3, 0xb3, 0xb9, 0xb9, 0xb9, 0xb9, 0xa9, 0x80},
        {0x60, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//15
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xa7, 0xb6, 0xbd, 0xbd, 0xbd, 0xbd, 0xa9, 0x80},
        {0x5f, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//16
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xa7, 0xb6, 0xc0, 0xc0, 0xc0, 0xc0, 0xa9, 0x80},
        {0x5f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//17
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xa7, 0xb6, 0xc3, 0xc3, 0xc3, 0xc3, 0xa9, 0x80},
        {0x5f, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//18
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xa7, 0xb6, 0xc6, 0xc6, 0xc6, 0xc6, 0xa9, 0x80},
        {0x5f, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    }


},
GRASS_TONE_S:
{


    {//0 default
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x9c, 0xa5, 0xa5, 0xa9, 0xb2, 0xb7},
        {0x72, 0x6c, 0x6c, 0x69, 0x67, 0x65},
	    	{0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//1
        {0xa7, 0xa7, 0xa9, 0xb0, 0xb4, 0xba},
        {0xa7, 0xa7, 0xa9, 0xb0, 0xb4, 0xba},
        {0x6a, 0x57, 0x50, 0x50, 0x5d, 0x6a},
        {0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//2 CE off for sat0
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//3  for sat1
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x85, 0x85, 0x85, 0x85, 0x85, 0x85},
        {0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },
    {//4 for sat2
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C},
        {0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//5 for sat3
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x93, 0x93, 0x93, 0x93, 0x93, 0x93},
        {0x78, 0x78, 0x78, 0x78, 0x78, 0x78},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//6 for sat4
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A},
        {0x75, 0x75, 0x75, 0x75, 0x75, 0x75},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//7 for sat5
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xA1, 0xA1, 0xA1, 0xA1, 0xA1, 0xA1},
        {0x72, 0x72, 0x72, 0x72, 0x72, 0x72},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//8 for sat6
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8},
        {0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x6f},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//9 for sat7
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xAF, 0xAF, 0xAF, 0xAF, 0xAF, 0xAF},
        {0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//10 for sat8
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6},
        {0x69, 0x69, 0x69, 0x69, 0x69, 0x69},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//11 for sat9
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd},
        {0x66, 0x66, 0x66, 0x66, 0x66, 0x66},
        {0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//12
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xa9, 0xb1, 0xb1, 0xac, 0xa0, 0x80},
        {0x62, 0x5e, 0x5e, 0x65, 0x6c, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//13
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xad, 0xb5, 0xb5, 0xb1, 0xa4, 0x80},
        {0x60, 0x5c, 0x5c, 0x63, 0x6c, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//14
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xb0, 0xb9, 0xb9, 0xb3, 0xa7, 0x80},
        {0x5d, 0x5a, 0x5a, 0x61, 0x6a, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//15
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xb2, 0xbd, 0xbd, 0xb6, 0xab, 0x80},
        {0x5c, 0x57, 0x57, 0x5f, 0x6a, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },

    {//16
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xb2, 0xc0, 0xc0, 0xb9, 0xab, 0x80},
        {0x5a, 0x55, 0x55, 0x5a, 0x6a, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },
    
    
    {//17
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xb2, 0xc3, 0xc3, 0xbc, 0xab, 0x80},
        {0x58, 0x53, 0x53, 0x55, 0x6a, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    },


    {//18
        {0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
        {0xb2, 0xc6, 0xc6, 0xbf, 0xab, 0x80},
        {0x56, 0x51, 0x51, 0x51, 0x6a, 0x80},
        {0x14, 0x14, 0x14, 0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c}
    }
        

},
SKY_TONE_S:
{

    {//0 default
        {0x80, 0x80, 0x80},
        {0xbb, 0xbb, 0xbb},
        {0x63, 0x63, 0x63},
		    {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {//1
        {0xbb, 0xba, 0xbb},
        {0xa7, 0xb0, 0xb2},
        {0x75, 0x80, 0x80},
        {0x1e, 0x1e, 0x1e},
        {0x3c, 0x3c, 0x3c}
    },
    {//2 CE off for sat0
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x80, 0x80, 0x80},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

   {//3 for sat1
        {0x80, 0x80, 0x80},
        {0x85, 0x85, 0x85},
        {0x7e, 0x7e, 0x7e},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {//4 for sat2
        {0x80, 0x80, 0x80},
        {0x8C, 0x8C, 0x8C},
        {0x7b, 0x7b, 0x7b},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 5 for sat3
        {0x80, 0x80, 0x80},
        {0x93, 0x93, 0x93},
        {0x78, 0x78, 0x78},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 6 for sat4
        {0x80, 0x80, 0x80},
        {0x9A, 0x9A, 0x9A},
        {0x75, 0x75, 0x75},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },
    // 7 for sat5
    {
        {0x80, 0x80, 0x80},
        {0xA1, 0xA1, 0xA1},
        {0x72, 0x72, 0x72},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 8 for sat6
        {0x80, 0x80, 0x80},
        {0xA8, 0xA8, 0xA8},
        {0x6f, 0x6f, 0x6f},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 9 for sat7
        {0x80, 0x80, 0x80},
        {0xAF, 0xAF, 0xAF},
        {0x6c, 0x6c, 0x6c},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 10 for sat8
        {0x80, 0x80, 0x80},
        {0xb6, 0xb6, 0xb6},
        {0x69, 0x69, 0x69},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {// 11 for sat9
        {0x80, 0x80, 0x80},
        {0xbd, 0xbd, 0xbd},
        {0x66, 0x66, 0x66},
        {0x0f, 0x0f, 0x0f},
        {0x3c, 0x3c, 0x3c}
    },

    {//12
        {0x80, 0x80, 0x80},
        {0xa3, 0xb1, 0xa3},
        {0x67, 0x5e, 0x67},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    },

    {//13
        {0x80, 0x80, 0x80},
        {0xa8, 0xb5, 0xa8},
        {0x65, 0x5c, 0x65},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    },

    {//14
        {0x80, 0x80, 0x80},
        {0xad, 0xb9, 0xaf},
        {0x63, 0x5a, 0x63},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    },

    {//15
        {0x80, 0x80, 0x80},
        {0xb2, 0xbd, 0xb4},
        {0x60, 0x57, 0x60},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    },

    {//16
        {0x80, 0x80, 0x80},
        {0xb2, 0xc0, 0xb4},
        {0x5f, 0x55, 0x5f},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    },
    
    {//17
        {0x80, 0x80, 0x80},
        {0xb2, 0xc3, 0xb4},
        {0x5e, 0x53, 0x5e},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    },
  
    {//18
        {0x80, 0x80, 0x80},
        {0xb2, 0xc6, 0xb4},
        {0x5d, 0x51, 0x5d},
        {0x14, 0x14, 0x14},
        {0x3c, 0x3c, 0x3c}
    }    
    
    
},

PURP_TONE_H :
{
//hue 0~2
    {0x80, 0x80, 0x80},//0
    {0x82, 0x83, 0x83},//1
    {0x80, 0x80, 0x80},//2
    {0x80, 0x80, 0x80},//3
    {0x80, 0x80, 0x80},//4
    {0x80, 0x80, 0x80},//5
    {0x80, 0x80, 0x80},//6
    {0x80, 0x80, 0x80},//7
    {0x80, 0x80, 0x80},//8
    {0x80, 0x80, 0x80},//9
    {0x80, 0x80, 0x80},//10
    {0x80, 0x80, 0x80},//11
    {0x80, 0x80, 0x80},//12
    {0x80, 0x80, 0x80},//13
    {0x80, 0x80, 0x80},//14
    {0x80, 0x80, 0x80},//15
    {0x80, 0x80, 0x80},//16
    {0x80, 0x80, 0x80},//17
    {0x80, 0x80, 0x80} //18
},

SKIN_TONE_H:
{
//hue 3~10
    {0x80, 0x80, 0x7f, 0x7d, 0x7c, 0x7b, 0x7e,  0x82},//0  -9
    {0x80, 0x80, 0x7f, 0x7d, 0x7c, 0x7c, 0x7f,  0x82},//1  -9
    {0x80, 0x80, 0x75, 0x6b, 0x69, 0x6b,  0x72, 0x80},//2  -7
    {0x80, 0x80, 0x76, 0x6e, 0x6c, 0x6d,  0x73, 0x80},//3  -6
    {0x80, 0x80, 0x77, 0x70, 0x70, 0x70,  0x76, 0x80},//4  -5
    {0x80, 0x80, 0x79, 0x73, 0x73, 0x73,  0x77, 0x80},//5  -4
    {0x80, 0x80, 0x7a, 0x76, 0x76, 0x76,  0x79, 0x80},//6  -3
    {0x80, 0x80, 0x7b, 0x79, 0x79, 0x79,  0x7a, 0x80},//7  -2
    {0x80, 0x80, 0x7c, 0x7c, 0x7c, 0x7c,  0x7d, 0x80},//8  -1
    {0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  0x80, 0x80},//9  +0
    {0x83, 0x83, 0x83, 0x83, 0x83, 0x83,  0x83, 0x80},//10 +1
    {0x84, 0x85, 0x86, 0x86, 0x86, 0x86,  0x86, 0x80},//11 +2
    {0x84, 0x87, 0x8a, 0x8a, 0x8a, 0x8a,  0x8a, 0x80},//12 +3
    {0x86, 0x8a, 0x8d, 0x8d, 0x8d, 0x8d,  0x8b, 0x80},//13 +4
    {0x87, 0x8c, 0x90, 0x90, 0x90, 0x90,  0x8c, 0x80},//14 +5
    {0x88, 0x90, 0x93, 0x93, 0x93, 0x93,  0x8d, 0x80},//15 +6
    {0x89, 0x91, 0x96, 0x96, 0x96, 0x96,  0x8e, 0x80},//16 +7
    {0x8a, 0x93, 0x99, 0x99, 0x99, 0x98,  0x8f, 0x80},//17 +8
    {0x8b, 0x96, 0x9c, 0x9c, 0x9c, 0x99,  0x90, 0x80} //18 +9
},

GRASS_TONE_H :
{
    // hue 11~16
    {0x86, 0x88, 0x89, 0x88, 0x84, 0x83},//0 -9
  	{0x87, 0x8b, 0x8b, 0x89, 0x88, 0x88},//1 -9
    {0x78,0x6d, 0x69, 0x6d, 0x75, 0x80},//2 -7
    {0x79,0x6f, 0x6d, 0x70, 0x76, 0x80},//3 -6
    {0x79,0x71, 0x70, 0x71, 0x77, 0x80},//4 -5
    {0x7a,0x73, 0x73, 0x73, 0x78, 0x80},//5 -4
    {0x7b,0x76, 0x76, 0x76, 0x7a, 0x80},//6 -3
    {0x7c,0x7a, 0x7a, 0x7a, 0x7b, 0x80},//7 -2
    {0x7d,0x7d, 0x7d, 0x7d, 0x7d, 0x80},//8  -1
    {0x80,0x80, 0x80, 0x80, 0x80, 0x80},//9  +0
    {0x83,0x83, 0x83, 0x83, 0x83, 0x80},//10 +1
    {0x86,0x86, 0x86, 0x86, 0x85, 0x80},//11 +2
    {0x8a,0x8a, 0x8a, 0x8a, 0x86, 0x80},//12 +3
    {0x8b,0x8d, 0x8d, 0x8d, 0x88, 0x80},//13 +4
    {0x8d,0x90, 0x90, 0x8f, 0x8a, 0x80},//14 +5
    {0x8f,0x93, 0x93, 0x91, 0x8b, 0x80},//15 +6
    {0x90,0x96, 0x96, 0x93, 0x8c, 0x80},//16 +7
    {0x91,0x99, 0x99, 0x96, 0x8d, 0x80},//17 +8
    {0x92,0x9c, 0x9c, 0x98, 0x8e, 0x80}//18  +9
},

SKY_TONE_H:
{   //17 ~ 19
    {0x85, 0x86, 0x85},//0   -9
	  {0x89, 0x88, 0x87},//1	 -9
    {0x73, 0x69, 0x72},//2   -7
    {0x75, 0x6d, 0x74},//3   -6
    {0x77, 0x70, 0x76},//4   -5
    {0x7a, 0x73, 0x79},//5   -4
    {0x7b, 0x76, 0x7b},//6   -3
    {0x7c, 0x79, 0x7c},//7   -2
    {0x7e, 0x7c, 0x7e},//8    -1
    {0x80, 0x80, 0x80},//9    +0
    {0x83, 0x83, 0x83},//10   +1
    {0x85, 0x86, 0x85},//11   +2
    {0x86, 0x8a, 0x86},//12   +3
    {0x89, 0x8d, 0x89},//13   +4
    {0x8b, 0x90, 0x8b},//14   +5
    {0x8e, 0x93, 0x8e},//15   +6
    {0x91, 0x96, 0x91},//16   +7
    {0x93, 0x99, 0x93},//17   +8
    {0x95, 0x9c, 0x95}//18    +9
}

};

const unsigned int g_ccorr_matrix[DISP_CCORR_TOTAL][3][3] =
{
    {{1024, 0, 0}, 
     {0, 1024, 0},
     {0, 0, 1024}},

    {{1024, 0, 0}, 
     {0, 1024, 0},
     {0, 0, 1024}}
};
