#include <utils/Log.h>                                                                                   
#include <fcntl.h>                                                                                       
#include <math.h>                                                                                        
                                                                                                         
#include "camera_custom_nvram.h"                                                                         
#include "camera_custom_sensor.h"                                                                        
#include "image_sensor.h"                                                                                
#include "kd_imgsensor_define.h"                                                                         
#include "camera_AE_PLineTable_imx214mipiraw.h"                                                    
#include "camera_info_imx214mipiraw.h"                                                             
#include "camera_custom_AEPlinetable.h"                                                                  
#include "camera_custom_tsf_tbl.h"                                                                             
                                                                                                         
const NVRAM_CAMERA_ISP_PARAM_STRUCT CAMERA_ISP_DEFAULT_VALUE =                                           
{{                                                                                                       
    //Version                                                                                            
    Version: NVRAM_CAMERA_PARA_FILE_VERSION,                                                             
                                                                                                         
    //SensorId                                                                                           
    SensorId: SENSOR_ID,                                                                                 
    ISPComm:{                                                                                            
        {                                                                                                
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                                              
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                                              
            0, 0, 1819238756, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                                              
    	}                                                                                                   
    },                                                                                                   
    ISPPca: {                                                                                            
        #include INCLUDE_FILENAME_ISP_PCA_PARAM                                                          
    },                                                                                                   
    ISPRegs:{                                                                                            
        #include INCLUDE_FILENAME_ISP_REGS_PARAM                                                         
    },                                                                                                   
    ISPMfbMixer:{{                                                                                       
            0x01FF0001, // MIX3_CTRL_0
            0x00FF0000, // MIX3_CTRL_1
            0xFFFF0000  // MIX3_SPARE
    }},                                                                                                  
    ISPMulitCCM:{                                                                                       
            Poly22:{
        82850,    // i4R_AVG
        18635,    // i4R_STD
        105950,    // i4B_AVG
        26362,    // i4B_STD
        {  // i4P00[9]
            7845000, -2335000, -395000, -1310000, 6915000, -487500, -80000, -2885000, 8085000
        },
        {  // i4P10[9]
            2872785, -3138305, 249315, -245797, -511948, 740253, 200407, 1160947, -1380133
        },
        {  // i4P01[9]
            2307215, -2335412, 20237, -510655, -452844, 954523, 59544, 197000, -266536
        },                                                                                               
        { // i4P20[9]                                                                                    
            0,  0,   0,  0,   0,  0, 0,  0,  0              
        },                                                                                               
        { // i4P11[9]                                                                                    
            0,  0,  0,  0,   0, 0, 0,  0,  0              
        },                                                                                               
        { // i4P02[9]                                                                                    
            0,    0,  0,  0,   0, 0,  0,    0,  0             
        }                                                                                                
            },
            AWBGain:{
                // Strobe						                        
		           {						                                
          512,    // i4R
          512,    // i4G
          512,    // i4B
        },
        // A
        {
          585,    // i4R
          512,    // i4G
          1348,    // i4B
        },
        // TL84
        {
          810,    // i4R
          512,    // i4G
          1075,    // i4B
        },
        // CWF
        {
          888,    // i4R
          512,    // i4G
          1106,    // i4B
        },
        // D65
        {
          1031,    // i4R
          512,    // i4G
          709,    // i4B
        },
        // Reserved 1
        {
          512,    // i4R
          512,    // i4G
          512,    // i4B
        },
        // Reserved 2
        {
          512,    // i4R
          512,    // i4G
          512,    // i4B
        },
        // Reserved 3
        {
          512,    // i4R
          512,    // i4G
          512,    // i4B
		           } 						                              
            },
            Weight:{
    1, // Strobe
    1, // A
    1, // TL84
    1, // CWF
    1, // D65
    1, // Reserved 1
    1, // Reserved 2
    1  // Reserved 3
}
    }                                                                                                    
}};                                                                                                      
                                                                                                         
const NVRAM_CAMERA_3A_STRUCT CAMERA_3A_NVRAM_DEFAULT_VALUE =                                             
{                                                                                                        
    NVRAM_CAMERA_3A_FILE_VERSION, // u4Version                                                           
    SENSOR_ID, // SensorId                                                                               
                                                                                                         
    // AE NVRAM                                                                                          
    {                                                                                                    
        // rDevicesInfo                                                                                  
        {                                                                                                
            1144,    // u4MinGain, 1024 base = 1x
            8192,    // u4MaxGain, 16x
            99,//33,    // u4MiniISOGain, ISOxx  
            128,    // u4GainStepUnit, 1x/8 
            20593,    // u4PreExpUnit 
            30,    // u4PreMaxFrameRate
            10434,    // u4VideoExpUnit  
            30,    // u4VideoMaxFrameRate 
            1024,    // u4Video2PreRatio, 1024 base = 1x 
            10434,    // u4CapExpUnit 
            29,    // u4CapMaxFrameRate
            1024,    // u4Cap2PreRatio, 1024 base = 1x
            12935,    // u4Video1ExpUnit
            60,    // u4Video1MaxFrameRate
            1024,    // u4Video12PreRatio, 1024 base = 1x
            12935,    // u4Video2ExpUnit
            60,    // u4Video2MaxFrameRate
            1024,    // u4Video22PreRatio, 1024 base = 1x
            22,    // u4LensFno, Fno = 2.8
            350    // u4FocusLength_100x                                                                 
         },                                                                                              
         // rHistConfig                                                                                  
        {                                                                                                
            4, // 2,   // u4HistHighThres                                                                
            40,  // u4HistLowThres                                                                       
            2,   // u4MostBrightRatio                                                                    
            1,   // u4MostDarkRatio                                                                      
            160, // u4CentralHighBound                                                                   
            20,  // u4CentralLowBound                                                                    
            {240, 230, 220, 210, 200}, // u4OverExpThres[AE_CCT_STRENGTH_NUM]                            
            {62, 72, 82, 98, 141},  // u4HistStretchThres[AE_CCT_STRENGTH_NUM]                        
            {18, 22, 26, 30, 34}       // u4BlackLightThres[AE_CCT_STRENGTH_NUM]                         
        },                                                                                               
        // rCCTConfig                                                                                    
        {                                                                                                
            TRUE,            // bEnableBlackLight                                                        
            TRUE,            // bEnableHistStretch                                                       
            TRUE,           // bEnableAntiOverExposure                                                  
            TRUE,            // bEnableTimeLPF                                                           
            FALSE,    // bEnableCaptureThres
            TRUE,            // bEnableVideoThres                                                        
            TRUE,            // bEnableStrobeThres                                                       
            52,//50,                // u4AETarget                                                             
            47,                // u4StrobeAETarget                                                       
                                                                                                         
            50,                // u4InitIndex                                                            
            4,                 // u4BackLightWeight                                                      
            32,                // u4HistStretchWeight                                                    
            4,                 // u4AntiOverExpWeight                                                    
            2,                 // u4BlackLightStrengthIndex                                              
            2,                 // u4HistStretchStrengthIndex                                       
            2,                 // u4AntiOverExpStrengthIndex                                             
            2,                 // u4TimeLPFStrengthIndex                                                 
            {1, 3, 5, 7, 8}, // u4LPFConvergeTable[AE_CCT_STRENGTH_NUM]                                  
            90,                // u4InDoorEV = 9.0, 10 base                                              
            -17,    // i4BVOffset delta BV = value/10 
            64,                 // u4PreviewFlareOffset                                                  
            80,                 // u4CaptureFlareOffset                                                  
            4,    // u4CaptureFlareThres
            64,                 // u4VideoFlareOffset                                                    
            4,    // u4VideoFlareThres
            64,                 // u4StrobeFlareOffset                                                   
            3,                 // u4StrobeFlareThres                                                     
            160,                 // u4PrvMaxFlareThres                                                   
            0,                 // u4PrvMinFlareThres                                                     
            160,                 // u4VideoMaxFlareThres                                                 
            0,                 // u4VideoMinFlareThres                                                   
            23,                // u4FlatnessThres              // 10 base for flatness condition.        
            53,//75,                // u4FlatnessStrength                                                     
                        //rMeteringSpec
                        {
                                //rHS_Spec
                                {
                                        TRUE,//bEnableHistStretch           // enable histogram stretch
                                        1024,//u4HistStretchWeight          // Histogram weighting value
                                        40,//u4Pcent                      // 1%=10, 0~1000
                                        150,//130,//135,//160,//u4Thd                        // 0~255
                                        55,//55,//58,//56,//51,//54,//58,//75,//u4FlatThd                    // 0~255

                                        120,//u4FlatBrightPcent
                                        120,//u4FlatDarkPcent
                                        //sFlatRatio
                                        {
                                            1000, //i4X1
                                            1024,  //i4Y1
                                            2400, //i4X2
                                            0     //i4Y2
                                        },
                    TRUE, //bEnableGreyTextEnhance
                    1800, //u4GreyTextFlatStart, > sFlatRatio.i4X1, < sFlatRatio.i4X2
                    {
                        10,     //i4X1
                        1024,   //i4Y1
                        80,     //i4X2
                        0       //i4Y2
                    }
                                },
                                //rAOE_Spec
                                {
                                        TRUE,//bEnableAntiOverExposure
                                        1024,//u4AntiOverExpWeight
                                        10,//u4Pcent
                                        220,//200,//u4Thd
                                        TRUE,//bEnableCOEP
                                        1,//u4COEPcent
                                        115,//106,//u4COEThd
                                        0,  // u4BVCompRatio
                                        //sCOEYRatio;     // the outer y ratio
                                        {
                                               23,   //i4X1
                                                1024,  //i4Y1
                                                47,   //i4X2
                                                0     //i4Y2
                                        },
                                       //sCOEDiffRatio;  // inner/outer y difference ratio
                                        {
                                                1500, //i4X1
                                                0,    //i4Y1
                                                2100, //i4X2
                                                1024   //i4Y2
                                        }
                                },
                                //rABL_Spec
                                {
                                        TRUE,//bEnableBlackLigh
                                        1024,//u4BackLightWeigh
                                        400,//u4Pcent
                                        22,//u4Thd,
                                        255, // center luminance
                                        256, // final target limitation, 256/128 = 2x
                                        //sFgBgEVRatio
                                        {
                                                2200, //i4X1
                                                0,    //i4Y1
                                                4000, //i4X2
                                                1024   //i4Y2
                                        },
                                        //sBVRatio
                                        {
                                                3800,//i4X1
                                                0,   //i4Y1
                                                5000,//i4X2
                                                1024  //i4Y2
                                        }
                                },
                                //rNS_Spec
                                {
                                        TRUE, // bEnableNightScene
                                        5,    //u4Pcent
                                        174,//170,//174,  //u4Thd
                                        55,//55,//58,//56,//51,//54,//72,   //u4FlatThd
                                        200,  //u4BrightTonePcent
                                        95,//90,   //u4BrightToneThdMul;      // bright tone THD 1x=1024, m_u4AETarget*u4BrightToneThdMul/1024
                                        500,  //u4LowBndPcent
                                        5,    //u4LowBndThdMul, <1024, u4AETarget*u4LowBndThdMul/1024
                                        26,//37,    //u4LowBndThdLimitMul, <1024, u4AETarget*u4LowBndThdLimitMul/1024

                                        50,  //u4FlatBrightPcent;
                                        300,   //u4FlatDarkPcent;
                                        //sFlatRatio
                                        {
                                                1200, //i4X1
                                                1024, //i4Y1
                                                2400,//2800,//i4X2
                                                0    //i4Y2
                                        },
                                        //sBVRatio
                                        {
                                                -500, //i4X1
                                                1024,  //i4Y1
                                                3000,//2000, //i4X2
                                                0     //i4Y2
                                        },
                                        TRUE, // bEnableNightSkySuppresion
                                        //sSkyBVRatio
                                        {
                        -4000,  //i4X1
                        1024,  //i4Y1
                        -2000,  //i4X2
                                                0     //i4Y2
                                        }
                            },
                            // rTOUCHFD_Spec
                            {
                    40, //uMeteringYLowBound;
                    50, //uMeteringYHighBound;
                    40, //uFaceYLowBound;
                    50, //uFaceYHighBound;
                    3, //uFaceCentralWeight;
                    120, //u4MeteringStableMax;
                    80, //u4MeteringStableMin;
                            }
                        }, //End rMeteringSpec
                        // rFlareSpec
                        {
                {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, //uPrvFlareWeightArr[16];
                {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, //uVideoFlareWeightArr[16];
                96,                                               //u4FlareStdThrHigh;
                48,                                               //u4FlareStdThrLow;
                0,                                               //u4PrvCapFlareDiff;
                4,                                               //u4FlareMaxStepGap_Fast;
                0,                                               //u4FlareMaxStepGap_Slow;
                1800,                                               //u4FlarMaxStepGapLimitBV;
                0,                                               //u4FlareAEStableCount;
                        },
                        //rAEMoveRatio =
                        {
                            100, //u4SpeedUpRatio
                            100, //u4GlobalRatio
                            190, //u4Bright2TargetEnd
                            20,   //u4Dark2TargetStart
                            90, //u4B2TEnd
                            70,  //u4B2TStart
                            60,  //u4D2TEnd
                            90,  //u4D2TStart
                        },

                        //rAEVideoMoveRatio =
                        {
                            100, //u4SpeedUpRatio
                            100, //u4GlobalRatio
                            150,  //u4Bright2TargetEnd
                            20,    //u4Dark2TargetStart
                            90, //u4B2TEnd
                            10,//40,  //u4B2TStart
                            10,//40,  //u4D2TEnd
                            90,  //u4D2TStart
                        },

                        //rAEFaceMoveRatio =
                        {
                            100, //u4SpeedUpRatio
                            100, //u4GlobalRatio
                            190,  //u4Bright2TargetEnd
                            10,    //u4Dark2TargetStart
                            80, //u4B2TEnd
                            30,//40,  //u4B2TStart
                            20,//30,  //u4D2TEnd
                            60,  //u4D2TStart
                        },

                        //rAETrackingMoveRatio =
                        {
                            100, //u4SpeedUpRatio
                            100, //u4GlobalRatio
                            190,  //u4Bright2TargetEnd
                            10,    //u4Dark2TargetStart
                            80, //u4B2TEnd
                            30,//40,  //u4B2TStart
                            20,//30,  //u4D2TEnd
                            60,  //u4D2TStart
                        },
            //rAEAOENVRAMParam =
            {
                1,      // i4AOEStrengthIdx: 0 / 1 / 2
                130,//128,    // u4BVCompRatio
                {
                {
                     47,  //u4Y_Target
                     25,//10,  //u4AOE_OE_percent
                     210,//160,  //u4AOE_OEBound
                     10,//15,    //u4AOE_DarkBound
                     950,    //u4AOE_LowlightPrecent
                     1,//5,    //u4AOE_LowlightBound
                     145,//100,    //u4AOESceneLV_L
                     180,//170,    //u4AOESceneLV_H
                     40,    //u4AOE_SWHdrLE_Bound
                },
                {
                     47,  //u4Y_Target
                     25,//10,  //u4AOE_OE_percent
                     210,//180,  //u4AOE_OEBound
                     15,//20,    //u4AOE_DarkBound
                     950,    //u4AOE_LowlightPrecent
                     3,//10,    //u4AOE_LowlightBound
                     145,//100,    //u4AOESceneLV_L
                     180,//170,    //u4AOESceneLV_H
                     40,    //u4AOE_SWHdrLE_Bound
                },
                {
                     47,  //u4Y_Target
                     25,//10,  //u4AOE_OE_percent
                     210,//200,  //u4AOE_OEBound
                     25,    //u4AOE_DarkBound
                     950,    //u4AOE_LowlightPrecent
                     8,//15,    //u4AOE_LowlightBound
                     145,//100,    //u4AOESceneLV_L
                     180,//170,    //u4AOESceneLV_H
                     40,    //u4AOE_SWHdrLE_Bound
                }
              }
          }
        }
    },                                                                                                   
    // AWB NVRAM
   {	
	// AWB calibration data							
	{		
		// rUnitGain (unit gain: 1.0 = 512)						
		{						
			0,	// i4R		
			0,	// i4G				
			0	// i4B				
		},			
		// rGoldenGain (golden sample gain: 1.0 = 512)					
		{						
			0,	// i4R				
			0,	// i4G				
			0	// i4B				
		},						
		// rTuningUnitGain (Tuning sample unit gain: 1.0 = 512)						
		{						
			0,	// i4R				
			0,	// i4G				
			0	// i4B				
		},						
		// rD65Gain (D65 WB gain: 1.0 = 512)		
		{						
                1075,    // i4R
                512,    // i4G
                693    // i4B
		}						
	},							
	// Original XY coordinate of AWB light source				
	{							
		// Strobe			
		{		
			0,	// i4X	
			0	// i4Y		
		},	
		// Horizon		
		{		
                -427,    // i4X
                -402    // i4Y
            },
            // A
            {
                -287,    // i4X
                -409    // i4Y
            },
            // TL84
            {
                -94,    // i4X
                -451    // i4Y
            },
            // CWF
            {
                -56,    // i4X
                -492    // i4Y
            },
            // DNP
            {
                7,    // i4X
                -412    // i4Y
            },
            // D65
            {
                162,    // i4X
                -386    // i4Y
            },
            // DF
            {
                            0, // OriX_DF
                            0 // OriY_DF
            }
	},
	// Rotated XY coordinate of AWB light source	
        {
            // Strobe
            {
                0,    // i4X
                0    // i4Y
            },
            // Horizon
            {
                -447,    // i4X
                -380    // i4Y
            },
            // A
            {
                -308,    // i4X
                -394    // i4Y
            },
            // TL84
            {
                -117,    // i4X
                -446    // i4Y
            },
            // CWF
            {
                -81,    // i4X
                -489    // i4Y
            },
            // DNP
            {
                -14,    // i4X
                -412    // i4Y
            },
            // D65
            {
                142,    // i4X
                -394    // i4Y
            },
            // DF
            {
                            120, // RotX_DF
                            -478 // RotY_DF
            }
        },
        // AWB gain of AWB light source
        {
            // Strobe 
            {
                512,    // i4R
                512,    // i4G
                512    // i4B
            },
            // Horizon 
            {
                512,    // i4R
                530,    // i4G
                1625    // i4B
            },
            // A 
            {
                604,    // i4R
                512,    // i4G
                1314    // i4B
            },
            // TL84 
            {
                831,    // i4R
                512,    // i4G
                1070    // i4B
            },
            // CWF 
            {
                923,    // i4R
                512,    // i4G
                1075    // i4B
            },
            // DNP 
            {
                903,    // i4R
                512,    // i4G
                885    // i4B
            },
            // D65 
            {
                1075,    // i4R
                512,    // i4G
                693    // i4B
            },
            // DF 
            {
                1142,    // i4R
                512,    // i4G
                808    // i4B
            }
        },
	// Rotation matrix parameter							    
        {
            3,    // i4RotationAngle
            256,    // i4Cos
            13    // i4Sin
        },
	// Daylight locus parameter							      
	{							                                
            -143,    // i4SlopeNumerator
		128	// i4SlopeDenominator		
	},							                              
 // Predictor gain
 {
                        141, // i4PrefRatio100
                        // DaylightLocus_L
                        {
                            900,//1150,//1075, //1108, // i4R
                            512, // i4G
                            750,//600,//693 //677, // i4B
                        },
                        // DaylightLocus_H
                        {
                            774, // i4R
                            512, // i4G
                            998, // i4B
                        },
                        // Temporal General
                        {
                            1150,//1075, // i4R
                            512, // i4G
                            600,//693, // i4B
                        }
 },
	// AWB light area							                
	{							                                
		// Strobe						                        
		{						                                
			0,	// StrobeRightBound				            
			0,	// StrobeLeftBound				          
			0,	// StrobeUpperBound				          
			0	// StrobeLowerBound				          
		},						                              
		// Tungsten						                      
		{						                                
            -167,    // i4RightBound
           -847,//-817,//-687,//-547,//-617,// -817,    // i4LeftBound
            -250,//-345,//-227,//-307,    // i4UpperBound
            -420//-437    // i4LowerBound
            },
            // Warm fluorescent
            {
            -167,    // i4RightBound
            -847,//-817,//-687,//-567,//-617,//-817,    // i4LeftBound
            -420,//-437,    // i4UpperBound
            -519,//-557    // i4LowerBound
            },
            // Fluorescent
            {
            -64,    // i4RightBound
            -167,    // i4LeftBound
            -325,    // i4UpperBound
            -467    // i4LowerBound
            },
            // CWF
            {
            -32,    // i4RightBound
            -167,    // i4LeftBound
            -467,    // i4UpperBound
            -539    // i4LowerBound
            },
            // Daylight
            {
            167,    // i4RightBound
            -64,    // i4LeftBound
            -314,    // i4UpperBound
            -467    // i4LowerBound
            },
            // Shade
            {
            527,    // i4RightBound
            167,    // i4LeftBound
            -294,//-314,    // i4UpperBound
            -539//-467    // i4LowerBound
            },
            // Daylight Fluorescent
            {
            167,//148,//158,//172,    // i4RightBound
            -32,    // i4LeftBound
            -467,    // i4UpperBound
            -584//-514//-534//-564    // i4LowerBound
		}						                                
	},							                              
	// PWB light area							                
	{							                                
		// Reference area						                
		{						                                
            527,    // i4RightBound
            -817,    // i4LeftBound
            0,    // i4UpperBound
            -564    // i4LowerBound
            },
            // Daylight
            {
            192,    // i4RightBound
            -64,    // i4LeftBound
            -314,    // i4UpperBound
            -467    // i4LowerBound
            },
            // Cloudy daylight
            {
            292,    // i4RightBound
            117,    // i4LeftBound
            -314,    // i4UpperBound
            -467    // i4LowerBound
            },
            // Shade
            {
            392,    // i4RightBound
            117,    // i4LeftBound
            -314,    // i4UpperBound
            -467    // i4LowerBound
            },
            // Twilight
            {
            -64,    // i4RightBound
            -224,    // i4LeftBound
            -314,    // i4UpperBound
            -467    // i4LowerBound
            },
            // Fluorescent
            {
            192,    // i4RightBound
            -217,    // i4LeftBound
            -344,    // i4UpperBound
            -539    // i4LowerBound
            },
            // Warm fluorescent
            {
            -208,    // i4RightBound
            -408,    // i4LeftBound
            -344,    // i4UpperBound
            -539    // i4LowerBound
            },
            // Incandescent
            {
            -208,    // i4RightBound
            -408,    // i4LeftBound
            -314,    // i4UpperBound
            -467    // i4LowerBound
		},						                              
		// Gray World						                    
		{						                                
			5000,	// PGWRightBound				            
			-5000,	// PGWLeftBound				            
			5000,	// PGWUpperBound				            
			-5000	// PGWLowerBound				            
		}						                                
	},							                              
	// PWB default gain							              
	{							                                
		// Daylight						                      
		{						                                
            967,    // i4R
            512,    // i4G
            771    // i4B
            },
            // Cloudy daylight
            {
            1158,    // i4R
            512,    // i4G
            632    // i4B
            },
            // Shade
            {
            1235,    // i4R
            512,    // i4G
            589    // i4B
            },
            // Twilight
            {
            741,    // i4R
            512,    // i4G
            1036    // i4B
            },
            // Fluorescent
            {
            943,    // i4R
            512,    // i4G
            918    // i4B
            },
            // Warm fluorescent
            {
            645,    // i4R
            512,    // i4G
            1396    // i4B
            },
            // Incandescent
            {
            600,    // i4R
            512,    // i4G
            1307    // i4B
            },
            // Gray World
            {
            512,    // i4R
            512,    // i4G
            512    // i4B
		}						                                
	},							                              
	// AWB preference color							          
	{							                                
            // Tungsten
            {
                            60, // TUNG_SLIDER
                            4372//5000//3837 //3537 // TUNG_OFFS
                        },
                        // Warm fluorescent
                        {
                            50, // WFluo_SLIDER
                            4572//3837 //3537 // WFluo_OFFS
                        },
                        // Shade
                        {
                            50, // Shade_SLIDER
                            909 // Shade_OFFS
                        },
            // Preference gain: strobe
            {
                                512,    // i4R
                                512,    // i4G
                                512    // i4B
            },
            // Preference gain: tungsten
            {
            515,//512,//550,//542,//530,    // i4R
            512,    // i4G
            512//515 //512//500    // i4B
                        },
            // Preference gain: warm fluorescent
            {
            518,//512,    // i4R
            512,    // i4G
            512    // i4B
            },
            // Preference gain: fluorescent
            {
                                514,    // i4R
                                512,    // i4G
                                512    // i4B
                        },
                        // Preference gain: CWF
                        {
                                512,    // i4R
                                512,    // i4G
                                490    // i4B
            },
            // Preference gain: daylight
            {
            504,//500,//504    // i4R
            512,    // i4G
            514//508//514//514    // i4B
            },
            // Preference gain: shade
            {
            512,    // i4R
            512,    // i4G
                                512    // i4B
                        },
            // Preference gain: daylight fluorescent
            {
            516,//512,    // i4R
            512,    // i4G
            508//512    // i4B
            }
	},							                              

                // Algorithm Tuning Paramter
                {
                    // AWB Backup Enable
                    0,

                    // AWB LSC Gain
                    {
                        774,  // i4R
                        512,  // i4G
                        998,  // i4B
                    },
                    // Parent block weight parameter
                    {
                        1,      // bEnable
                        6           // i4ScalingFactor: [6] 1~12, [7] 1~6, [8] 1~3, [9] 1~2, [>=10]: 1
                    },
                    // AWB LV threshold for predictor
                    {
                            115, //100,    // i4InitLVThr_L
                            155, //140,    // i4InitLVThr_H
                            100 //80      // i4EnqueueLVThr
                    },
                    // AWB number threshold for temporal predictor
                    {
                            65,     // i4Neutral_ParentBlk_Thr
                        //LV0   1    2    3    4    5    6    7    8    9    10   11   12   13   14   15   16   17   18
                        { 100,  100,  100,  100,  100,  100,  100,  100,  100,  50,  25,  2,  2,  2,  2,  2,  2,  2,  2}  // (%) i4CWFDF_LUTThr
                    },
                    // AWB light neutral noise reduction for outdoor
                    {
                        //LV0  1    2    3    4    5    6    7    8    9    10   11   12   13   14   15   16   17   18
                        // Non neutral
		                { 3,   3,   3,   3,   3,   3,   3,   3,    3,   3,   5,  10,  10,  10,  10,  10,  10,  10,  10},  // (%)
		                // Flurescent
		                { 0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   5,  10,  10,  10,  10,  10,  10,  10,  10},  // (%)
		                // CWF
		                { 5,   5,   5,   5,   5,   10,   10,   10,    10,   10,   10,  10,  10,  10,  10,  10,  10,  10,  10},  // (%)
		                // Daylight
		                { 0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2},  // (%)
		                // DF
		                { 5,   5,   5,   5,   5,   10,   10,   10,    10,   10,   10,  10,  10,  10,  10,  10,  10,  10,  10},  // (%)
                    },
                    // AWB feature detection
                    {
                        // Sunset Prop
                        {
                            1,          // i4Enable
                            140,        // i4LVThr
                            {
                                -12, //64,   // i4Sunset_BoundXr_Thr
                                -412 //-463     // i4Sunset_BoundYr_Thr
                            },
                            10,         // i4SunsetCountThr
                            0,          // i4SunsetCountRatio_L
                            171         // i4SunsetCountRatio_H
                        },

                        // Shade F Detection
                        {
                            1,          // i4Enable
                            115, //105,        // i4LVThr
                            {

                                -167,//-91, //-82,   // i4BoundXrThr
                                -415,//-394 //-415    // i4BoundYrThr
                            },
                            128         // i4DaylightProb
                        },

                        // Shade CWF Detection
                        {
                            1,        // i4Enable
                            0,//95,         // i4LVThr
                            {
                                -92,//-81,   // i4BoundXrThr
                                -489,//-499,//-509//-499//-81     // i4BoundYrThr
                            },
                            208//128         // i4DaylightProb
                        },
										
                        // Low CCT
                        {
                            0,          // i4Enable
                            384,        // i4SpeedRatio
                            {
                                -501, //-450,       // i4BoundXrThr
                                500         // i4BoundYrThr
                            }
                        }
                    },

                    // AWB Gain Limit
                    {
                        // rNormalLowCCT
                        {
                            1,      // Gain Limit Enable
                            2560 //845 //819//768//717     // Gain ratio
                        },
                        // rPrefLowCCT
                        {
                            1,      // Gain Limit Enable
                            2560     // Gain ratio
                        }

                    },

                    // AWB non-neutral probability for spatial and temporal weighting look-up table (Max: 100; Min: 0)
                    {
                        //LV0   1    2    3    4    5    6    7    8    9    10   11   12   13   14   15   16   17   18
                        { 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,  70,  30,  20,  10,   0,   0,   0,   0}
                    },

                    // AWB daylight locus probability look-up table (Max: 100; Min: 0)
                    {   //LV0    1     2     3      4     5     6     7     8      9      10     11    12   13     14    15   16    17    18
                        {100, 100, 100, 100, 100, 100, 100, 100, 100, 100,  100,  100, 100,  50,  25,   0,  0,   0,   0}, // Strobe
                        {100, 100, 100, 100, 100, 100, 100, 100, 100, 100,  100,  100, 100, 100,  50,  25,  0,   0,   0}, // Tungsten
                        {100, 100, 100, 100, 100, 100, 100, 100, 100, 100,  100,  100, 100, 100,  50,  25,  0,   0,   0}, // Warm fluorescent
                        {100, 100, 100, 100, 100, 100, 100, 100, 100, 100,  100,  75, 50,  25,  25,  25,  0,   0,   0}, // Fluorescent
		                { 90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  80,  55,  30, 30,  30,  30,  0,  0,  0}, // CWF
		                { 100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  75,  50,  40,  30,  20}, // Daylight
                        {100, 100, 100, 100, 100, 100, 100, 100, 100, 100,  100,  100, 75,  50,  25,   0,  0,   0,   0}, // Shade
		                { 90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  80,  55,  30,  30,  30,  30,  0,  0,  0} // Daylight fluorescent

    		        }
                },

	// CCT estimation							                
	{							                                
		// CCT						                          
		{						                                
                2300,    // i4CCT[0]
                2850,    // i4CCT[1]
                3750,    // i4CCT[2]
                5100,    // i4CCT[3]
                6500    // i4CCT[4]
            },
            {// Rotated X coordinate
                -589,    // i4RotatedXCoordinate[0]
                -450,    // i4RotatedXCoordinate[1]
                -259,    // i4RotatedXCoordinate[2]
                -156,    // i4RotatedXCoordinate[3]
			0  // RotatedXCoordinate4				        
		}						                                
	}							                                
},
        // Flash AWB NVRAM
        {
            #include INCLUDE_FILENAME_FLASH_AWB_PARA
        },
                                               
	{0}  //FIXED                                  
};                                             

#include INCLUDE_FILENAME_ISP_LSC_PARAM                                                                        
//};  //  namespace                                                                                            
const CAMERA_TSF_TBL_STRUCT CAMERA_TSF_DEFAULT_VALUE =                                                         
{
        {
                1,  // isTsfEn
                2,  // tsfCtIdx
                {20, 2000, -110, -110, 512, 512, 512, 0}    // rAWBInput[8]
        },
    #include INCLUDE_FILENAME_TSF_PARA                                                                         
    #include INCLUDE_FILENAME_TSF_DATA                                                                         
}; 
const NVRAM_CAMERA_FEATURE_STRUCT CAMERA_FEATURE_DEFAULT_VALUE =
{
#include INCLUDE_FILENAME_FEATURE_PARA
};

typedef NSFeature::RAWSensorInfo<SENSOR_ID> SensorInfoSingleton_T;                                             
                                                                                                               
                                                                                                               
namespace NSFeature {                                                                                          
template <>                                                                                                    
UINT32                                                                                                         
SensorInfoSingleton_T::                                                                                        
impGetDefaultData(CAMERA_DATA_TYPE_ENUM const CameraDataType, VOID*const pDataBuf, UINT32 const size) const    
{                                                                                                              
    UINT32 dataSize[CAMERA_DATA_TYPE_NUM] = {sizeof(NVRAM_CAMERA_ISP_PARAM_STRUCT),                            
                                             sizeof(NVRAM_CAMERA_3A_STRUCT),                                   
                                             sizeof(NVRAM_CAMERA_SHADING_STRUCT),                              
                                             sizeof(NVRAM_LENS_PARA_STRUCT),                                   
                                             sizeof(AE_PLINETABLE_T),                                           
                                             0,                                                                
                                             sizeof(CAMERA_TSF_TBL_STRUCT),                                    
                                             0,
                                             sizeof(NVRAM_CAMERA_FEATURE_STRUCT)
                                            };
                                                                                                               
    if (CameraDataType > CAMERA_NVRAM_DATA_FEATURE || NULL == pDataBuf || (size < dataSize[CameraDataType]))   
    {                                                                                                          
        return 1;                                                                                              
    }                                                                                                          
                                                                                                               
    switch(CameraDataType)                                                                                     
    {                                                                                                          
        case CAMERA_NVRAM_DATA_ISP:                                                                            
            memcpy(pDataBuf,&CAMERA_ISP_DEFAULT_VALUE,sizeof(NVRAM_CAMERA_ISP_PARAM_STRUCT));                  
            break;                                                                                             
        case CAMERA_NVRAM_DATA_3A:                                                                             
            memcpy(pDataBuf,&CAMERA_3A_NVRAM_DEFAULT_VALUE,sizeof(NVRAM_CAMERA_3A_STRUCT));                    
            break;                                                                                             
        case CAMERA_NVRAM_DATA_SHADING:                                                                        
            memcpy(pDataBuf,&CAMERA_SHADING_DEFAULT_VALUE,sizeof(NVRAM_CAMERA_SHADING_STRUCT));                
            break;                                                                                             
        case CAMERA_DATA_AE_PLINETABLE:                                                                        
            memcpy(pDataBuf,&g_PlineTableMapping,sizeof(AE_PLINETABLE_T));                                     
            break;                                                                                             
        case CAMERA_DATA_TSF_TABLE:                                                                            
            memcpy(pDataBuf,&CAMERA_TSF_DEFAULT_VALUE,sizeof(CAMERA_TSF_TBL_STRUCT));                          
            break;                                                                                             
        case CAMERA_NVRAM_DATA_FEATURE:                                                                            
            memcpy(pDataBuf,&CAMERA_FEATURE_DEFAULT_VALUE,sizeof(NVRAM_CAMERA_FEATURE_STRUCT));                          
            break;                                                                                             
        default:                                                                                               
            return 1;
    }                                                                                                          
    return 0;                                                                                                  
}};  //  NSFeature                                                                                             
