#ifndef _CFG_ISP_TUNING_IDX_CAPTURE_H_
#define _CFG_ISP_TUNING_IDX_CAPTURE_H_


#include <mtkcam/metadata/mtk_metadata_tag.h>

#define CAPTURE_SCENE_MODE_CONFIG(sensor, scene)\
    IDX_MODE_Capture(sensor, scene, eIDX_ISO_100)\
    IdxSet<EIspProfile_Capture, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100>::idx;\
    IDX_MODE_Capture(sensor, scene, eIDX_ISO_200)\
    IdxSet<EIspProfile_Capture, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200>::idx;\
    IDX_MODE_Capture(sensor, scene, eIDX_ISO_400)\
    IdxSet<EIspProfile_Capture, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400>::idx;\
    IDX_MODE_Capture(sensor, scene, eIDX_ISO_800)\
    IdxSet<EIspProfile_Capture, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800>::idx;\
    IDX_MODE_Capture(sensor, scene, eIDX_ISO_1200)\
    IdxSet<EIspProfile_Capture, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200>::idx;\
    IDX_MODE_Capture(sensor, scene, eIDX_ISO_1600)\
    IdxSet<EIspProfile_Capture, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600>::idx;\
    IDX_MODE_Capture(sensor, scene, eIDX_ISO_2000)\
    IdxSet<EIspProfile_Capture, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000>::idx;\
    IDX_MODE_Capture(sensor, scene, eIDX_ISO_2400)\
    IdxSet<EIspProfile_Capture, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400>::idx;\
    IDX_MODE_Capture(sensor, scene, eIDX_ISO_2800)\
    IdxSet<EIspProfile_Capture, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800>::idx;\
    IDX_MODE_Capture(sensor, scene, eIDX_ISO_3200)\
    IdxSet<EIspProfile_Capture, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200>::idx;\

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Capture> <Sensor Mode: Preview>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Capture( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:20, BPC:30, NR1:30, CFA:100, GGM:0, ANR:100, CCR:0, EE:100, NR3D:0, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Capture( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:20, BPC:31, NR1:31, CFA:101, GGM:0, ANR:101, CCR:1, EE:101, NR3D:0, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Capture( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:20, BPC:31, NR1:31, CFA:102, GGM:0, ANR:102, CCR:2, EE:102, NR3D:0, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Capture( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:21, BPC:32, NR1:32, CFA:103, GGM:0, ANR:103, CCR:3, EE:103, NR3D:0, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Capture( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:21, BPC:32, NR1:32, CFA:104, GGM:0, ANR:104, CCR:4, EE:104, NR3D:0, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Capture( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:21, BPC:32, NR1:32, CFA:105, GGM:0, ANR:105, CCR:5, EE:105, NR3D:0, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Capture( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:21, BPC:32, NR1:32, CFA:106, GGM:0, ANR:106, CCR:6, EE:106, NR3D:0, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Capture( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:21, BPC:32, NR1:32, CFA:107, GGM:0, ANR:107, CCR:7, EE:107, NR3D:0, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Capture( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:21, BPC:32, NR1:32, CFA:108, GGM:0, ANR:108, CCR:8, EE:108, NR3D:0, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Capture( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:21, BPC:32, NR1:32, CFA:109, GGM:0, ANR:109, CCR:9, EE:109, NR3D:0, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_NORMAL)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_ACTION)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_PORTRAIT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_NIGHT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_THEATRE)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_BEACH)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_SNOW)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_SUNSET)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_FIREWORKS)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_SPORTS)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_PARTY)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_HDR)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_BARCODE)

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Capture> <Sensor Mode: Capture>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Capture( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:22, BPC:33, NR1:33, CFA:110, GGM:0, ANR:110, CCR:0, EE:110, NR3D:0, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Capture( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:22, BPC:34, NR1:34, CFA:111, GGM:0, ANR:111, CCR:1, EE:111, NR3D:0, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Capture( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:22, BPC:34, NR1:34, CFA:112, GGM:0, ANR:112, CCR:2, EE:112, NR3D:0, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Capture( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:23, BPC:35, NR1:35, CFA:113, GGM:0, ANR:113, CCR:3, EE:113, NR3D:0, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Capture( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:23, BPC:35, NR1:35, CFA:114, GGM:0, ANR:114, CCR:4, EE:114, NR3D:0, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Capture( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:23, BPC:35, NR1:35, CFA:115, GGM:0, ANR:115, CCR:5, EE:115, NR3D:0, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Capture( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:23, BPC:35, NR1:35, CFA:116, GGM:0, ANR:116, CCR:6, EE:116, NR3D:0, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Capture( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:23, BPC:35, NR1:35, CFA:117, GGM:0, ANR:117, CCR:7, EE:117, NR3D:0, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Capture( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:23, BPC:35, NR1:35, CFA:118, GGM:0, ANR:118, CCR:8, EE:118, NR3D:0, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Capture( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:23, BPC:35, NR1:35, CFA:119, GGM:0, ANR:119, CCR:9, EE:119, NR3D:0, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_NORMAL)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_ACTION)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_PORTRAIT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_NIGHT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_THEATRE)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_BEACH)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_SNOW)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_SUNSET)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_FIREWORKS)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_SPORTS)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_PARTY)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_HDR)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_BARCODE)


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Capture> <Sensor Mode: Video>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Capture( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:24, BPC:36, NR1:36, CFA:120, GGM:0, ANR:120, CCR:0, EE:120, NR3D:0, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Capture( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:24, BPC:37, NR1:37, CFA:121, GGM:0, ANR:121, CCR:1, EE:121, NR3D:0, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Capture( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:24, BPC:37, NR1:37, CFA:122, GGM:0, ANR:122, CCR:2, EE:122, NR3D:0, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Capture( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:25, BPC:38, NR1:38, CFA:123, GGM:0, ANR:123, CCR:3, EE:123, NR3D:0, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Capture( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:25, BPC:38, NR1:38, CFA:124, GGM:0, ANR:124, CCR:4, EE:124, NR3D:0, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Capture( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:25, BPC:38, NR1:38, CFA:125, GGM:0, ANR:125, CCR:5, EE:125, NR3D:0, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Capture( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:25, BPC:38, NR1:38, CFA:126, GGM:0, ANR:126, CCR:6, EE:126, NR3D:0, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Capture( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:25, BPC:38, NR1:38, CFA:127, GGM:0, ANR:127, CCR:7, EE:127, NR3D:0, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Capture( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:25, BPC:38, NR1:38, CFA:128, GGM:0, ANR:128, CCR:8, EE:128, NR3D:0, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Capture( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:25, BPC:38, NR1:38, CFA:129, GGM:0, ANR:129, CCR:9, EE:129, NR3D:0, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_NORMAL)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_ACTION)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_PORTRAIT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_NIGHT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_THEATRE)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_BEACH)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_SNOW)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_SUNSET)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_FIREWORKS)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_SPORTS)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_PARTY)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_HDR)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_BARCODE)


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Capture> <Sensor Mode: SlimVideo1>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Capture( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:26, BPC:39, NR1:39, CFA:130, GGM:0, ANR:130, CCR:0, EE:130, NR3D:0, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Capture( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:26, BPC:40, NR1:40, CFA:131, GGM:0, ANR:131, CCR:1, EE:131, NR3D:0, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Capture( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:26, BPC:40, NR1:40, CFA:132, GGM:0, ANR:132, CCR:2, EE:132, NR3D:0, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Capture( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:27, BPC:41, NR1:41, CFA:133, GGM:0, ANR:133, CCR:3, EE:133, NR3D:0, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Capture( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:27, BPC:41, NR1:41, CFA:134, GGM:0, ANR:134, CCR:4, EE:134, NR3D:0, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Capture( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:27, BPC:41, NR1:41, CFA:135, GGM:0, ANR:135, CCR:5, EE:135, NR3D:0, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Capture( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:27, BPC:41, NR1:41, CFA:136, GGM:0, ANR:136, CCR:6, EE:136, NR3D:0, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Capture( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:27, BPC:41, NR1:41, CFA:137, GGM:0, ANR:137, CCR:7, EE:137, NR3D:0, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Capture( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:27, BPC:41, NR1:41, CFA:138, GGM:0, ANR:138, CCR:8, EE:138, NR3D:0, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Capture( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:27, BPC:41, NR1:41, CFA:139, GGM:0, ANR:139, CCR:9, EE:139, NR3D:0, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_NORMAL)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_ACTION)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_PORTRAIT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_NIGHT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_THEATRE)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_BEACH)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_SNOW)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_SUNSET)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_FIREWORKS)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_SPORTS)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_PARTY)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_HDR)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_BARCODE)

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Capture> <Sensor Mode: SlimVideo2>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Capture( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:28, BPC:42, NR1:42, CFA:140, GGM:0, ANR:140, CCR:0, EE:140, NR3D:0, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Capture( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:28, BPC:43, NR1:43, CFA:141, GGM:0, ANR:141, CCR:1, EE:141, NR3D:0, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Capture( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:28, BPC:43, NR1:43, CFA:142, GGM:0, ANR:142, CCR:2, EE:142, NR3D:0, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Capture( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:29, BPC:44, NR1:44, CFA:143, GGM:0, ANR:143, CCR:3, EE:143, NR3D:0, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Capture( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:29, BPC:44, NR1:44, CFA:144, GGM:0, ANR:144, CCR:4, EE:144, NR3D:0, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Capture( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:29, BPC:44, NR1:44, CFA:145, GGM:0, ANR:145, CCR:5, EE:145, NR3D:0, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Capture( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:29, BPC:44, NR1:44, CFA:146, GGM:0, ANR:146, CCR:6, EE:146, NR3D:0, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Capture( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:29, BPC:44, NR1:44, CFA:147, GGM:0, ANR:147, CCR:7, EE:147, NR3D:0, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Capture( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:29, BPC:44, NR1:44, CFA:148, GGM:0, ANR:148, CCR:8, EE:148, NR3D:0, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Capture( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:29, BPC:44, NR1:44, CFA:149, GGM:0, ANR:149, CCR:9, EE:149, NR3D:0, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_NORMAL)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_ACTION)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_PORTRAIT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_NIGHT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_THEATRE)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_BEACH)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_SNOW)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_SUNSET)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_FIREWORKS)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_SPORTS)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_PARTY)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_HDR)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
CAPTURE_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_BARCODE)


#endif //  _CFG_ISP_TUNING_IDX_CAPTURE_H_

