#ifndef _CFG_ISP_TUNING_IDX_VIDEO_H_
#define _CFG_ISP_TUNING_IDX_VIDEO_H_

#include <mtkcam/metadata/mtk_metadata_tag.h>

#define VIDEO_SCENE_MODE_CONFIG(sensor, scene)\
    IDX_MODE_Video(sensor, scene, eIDX_ISO_100)\
    IdxSet<EIspProfile_Video, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100>::idx;\
    IDX_MODE_Video(sensor, scene, eIDX_ISO_200)\
    IdxSet<EIspProfile_Video, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200>::idx;\
    IDX_MODE_Video(sensor, scene, eIDX_ISO_400)\
    IdxSet<EIspProfile_Video, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400>::idx;\
    IDX_MODE_Video(sensor, scene, eIDX_ISO_800)\
    IdxSet<EIspProfile_Video, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800>::idx;\
    IDX_MODE_Video(sensor, scene, eIDX_ISO_1200)\
    IdxSet<EIspProfile_Video, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200>::idx;\
    IDX_MODE_Video(sensor, scene, eIDX_ISO_1600)\
    IdxSet<EIspProfile_Video, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600>::idx;\
    IDX_MODE_Video(sensor, scene, eIDX_ISO_2000)\
    IdxSet<EIspProfile_Video, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000>::idx;\
    IDX_MODE_Video(sensor, scene, eIDX_ISO_2400)\
    IdxSet<EIspProfile_Video, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400>::idx;\
    IDX_MODE_Video(sensor, scene, eIDX_ISO_2800)\
    IdxSet<EIspProfile_Video, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800>::idx;\
    IDX_MODE_Video(sensor, scene, eIDX_ISO_3200)\
    IdxSet<EIspProfile_Video, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200>::idx;\

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Video> <Sensor Mode: Preview>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Video( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:10, BPC:15, NR1:15, CFA:50, GGM:0, ANR:50, CCR:0, EE:50, NR3D:50, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Video( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:10, BPC:16, NR1:16, CFA:51, GGM:0, ANR:51, CCR:1, EE:51, NR3D:51, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Video( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:10, BPC:16, NR1:16, CFA:52, GGM:0, ANR:52, CCR:2, EE:52, NR3D:52, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Video( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:11, BPC:17, NR1:17, CFA:53, GGM:0, ANR:53, CCR:3, EE:53, NR3D:53, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Video( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:11, BPC:17, NR1:17, CFA:54, GGM:0, ANR:54, CCR:4, EE:54, NR3D:54, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Video( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:11, BPC:17, NR1:17, CFA:55, GGM:0, ANR:55, CCR:5, EE:55, NR3D:55, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Video( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:11, BPC:17, NR1:17, CFA:56, GGM:0, ANR:56, CCR:6, EE:56, NR3D:56, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Video( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:11, BPC:17, NR1:17, CFA:57, GGM:0, ANR:57, CCR:7, EE:57, NR3D:57, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Video( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:11, BPC:17, NR1:17, CFA:58, GGM:0, ANR:58, CCR:8, EE:58, NR3D:58, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Video( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:11, BPC:17, NR1:17, CFA:59, GGM:0, ANR:59, CCR:9, EE:59, NR3D:59, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_NORMAL)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_ACTION)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_PORTRAIT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_NIGHT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_THEATRE)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_BEACH)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_SNOW)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_SUNSET)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_FIREWORKS)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_SPORTS)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_PARTY)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_HDR)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_BARCODE)


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Video> <Sensor Mode: Capture>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Video( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:12, BPC:18, NR1:18, CFA:60, GGM:0, ANR:60, CCR:0, EE:60, NR3D:60, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Video( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:12, BPC:19, NR1:19, CFA:61, GGM:0, ANR:61, CCR:1, EE:61, NR3D:61, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Video( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:12, BPC:19, NR1:19, CFA:62, GGM:0, ANR:62, CCR:2, EE:62, NR3D:62, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Video( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:13, BPC:20, NR1:20, CFA:63, GGM:0, ANR:63, CCR:3, EE:63, NR3D:63, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Video( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:13, BPC:20, NR1:20, CFA:64, GGM:0, ANR:64, CCR:4, EE:64, NR3D:64, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Video( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:13, BPC:20, NR1:20, CFA:65, GGM:0, ANR:65, CCR:5, EE:65, NR3D:65, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Video( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:13, BPC:20, NR1:20, CFA:66, GGM:0, ANR:66, CCR:6, EE:66, NR3D:66, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Video( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:13, BPC:20, NR1:20, CFA:67, GGM:0, ANR:67, CCR:7, EE:67, NR3D:67, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Video( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:13, BPC:20, NR1:20, CFA:68, GGM:0, ANR:68, CCR:8, EE:68, NR3D:68, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Video( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:13, BPC:20, NR1:20, CFA:69, GGM:0, ANR:69, CCR:9, EE:69, NR3D:69, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_NORMAL)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_ACTION)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_PORTRAIT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_NIGHT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_THEATRE)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_BEACH)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_SNOW)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_SUNSET)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_FIREWORKS)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_SPORTS)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_PARTY)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_HDR)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_BARCODE)

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Video> <Sensor Mode: Video>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Video( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:14, BPC:21, NR1:21, CFA:70, GGM:0, ANR:70, CCR:0, EE:70, NR3D:70, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Video( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:14, BPC:22, NR1:22, CFA:71, GGM:0, ANR:71, CCR:1, EE:71, NR3D:71, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Video( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:14, BPC:22, NR1:22, CFA:72, GGM:0, ANR:72, CCR:2, EE:72, NR3D:72, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Video( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:15, BPC:23, NR1:23, CFA:73, GGM:0, ANR:73, CCR:3, EE:73, NR3D:73, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Video( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:15, BPC:23, NR1:23, CFA:74, GGM:0, ANR:74, CCR:4, EE:74, NR3D:74, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Video( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:15, BPC:23, NR1:23, CFA:75, GGM:0, ANR:75, CCR:5, EE:75, NR3D:75, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Video( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:15, BPC:23, NR1:23, CFA:76, GGM:0, ANR:76, CCR:6, EE:76, NR3D:76, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Video( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:15, BPC:23, NR1:23, CFA:77, GGM:0, ANR:77, CCR:7, EE:77, NR3D:77, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Video( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:15, BPC:23, NR1:23, CFA:78, GGM:0, ANR:78, CCR:8, EE:78, NR3D:78, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Video( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:15, BPC:23, NR1:23, CFA:79, GGM:0, ANR:79, CCR:9, EE:79, NR3D:79, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_NORMAL)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_ACTION)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_PORTRAIT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_NIGHT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_THEATRE)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_BEACH)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_SNOW)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_SUNSET)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_FIREWORKS)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_SPORTS)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_PARTY)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_HDR)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_BARCODE)

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Video> <Sensor Mode: SimVideo1>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Video( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:16, BPC:24, NR1:24, CFA:80, GGM:0, ANR:80, CCR:0, EE:80, NR3D:80, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Video( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:16, BPC:25, NR1:25, CFA:81, GGM:0, ANR:81, CCR:1, EE:81, NR3D:81, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Video( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:16, BPC:25, NR1:25, CFA:82, GGM:0, ANR:82, CCR:2, EE:82, NR3D:82, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Video( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:17, BPC:26, NR1:26, CFA:83, GGM:0, ANR:83, CCR:3, EE:83, NR3D:83, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Video( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:17, BPC:26, NR1:26, CFA:84, GGM:0, ANR:84, CCR:4, EE:84, NR3D:84, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Video( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:17, BPC:26, NR1:26, CFA:85, GGM:0, ANR:85, CCR:5, EE:85, NR3D:85, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Video( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:17, BPC:26, NR1:26, CFA:86, GGM:0, ANR:86, CCR:6, EE:86, NR3D:86, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Video( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:17, BPC:26, NR1:26, CFA:87, GGM:0, ANR:87, CCR:7, EE:87, NR3D:87, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Video( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:17, BPC:26, NR1:26, CFA:88, GGM:0, ANR:88, CCR:8, EE:88, NR3D:88, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Video( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:17, BPC:26, NR1:26, CFA:89, GGM:0, ANR:89, CCR:9, EE:89, NR3D:89, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_NORMAL)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_ACTION)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_PORTRAIT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_NIGHT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_THEATRE)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_BEACH)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_SNOW)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_SUNSET)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_FIREWORKS)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_SPORTS)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_PARTY)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_HDR)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_BARCODE)

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Video> <Sensor Mode: SlimVideo2>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Video( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:18, BPC:27, NR1:27, CFA:90, GGM:0, ANR:90, CCR:0, EE:90, NR3D:90, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Video( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:18, BPC:28, NR1:28, CFA:91, GGM:0, ANR:91, CCR:1, EE:91, NR3D:91, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Video( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:18, BPC:28, NR1:28, CFA:92, GGM:0, ANR:92, CCR:2, EE:92, NR3D:92, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Video( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:19, BPC:29, NR1:29, CFA:93, GGM:0, ANR:93, CCR:3, EE:93, NR3D:93, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Video( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:19, BPC:29, NR1:29, CFA:94, GGM:0, ANR:94, CCR:4, EE:94, NR3D:94, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Video( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:19, BPC:29, NR1:29, CFA:95, GGM:0, ANR:95, CCR:5, EE:95, NR3D:95, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Video( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:19, BPC:29, NR1:29, CFA:96, GGM:0, ANR:96, CCR:6, EE:96, NR3D:96, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Video( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:19, BPC:29, NR1:29, CFA:97, GGM:0, ANR:97, CCR:7, EE:97, NR3D:97, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Video( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:19, BPC:29, NR1:29, CFA:98, GGM:0, ANR:98, CCR:8, EE:98, NR3D:98, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Video( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:19, BPC:29, NR1:29, CFA:99, GGM:0, ANR:99, CCR:9, EE:99, NR3D:99, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_NORMAL)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_ACTION)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_PORTRAIT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_NIGHT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_THEATRE)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_BEACH)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_SNOW)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_SUNSET)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_FIREWORKS)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_SPORTS)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_PARTY)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_HDR)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
VIDEO_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_BARCODE)

#endif //  _CFG_ISP_TUNING_IDX_VIDEO_H_

